package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.adx.rtbbid2.AdxConstant;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxBidReq;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxBidRet;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.IdeaUnitDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorBaseDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class AdxBid {

    private static final Logger logger = LoggerFactory.getLogger(AdxBid.class);

    public static AdxBidRet bid(AdxBidReq adxBidReq) {

        AdxBidRet ret = new AdxBidRet();

        try{
            if(!valid(adxBidReq) || (adxBidReq.getPriceType() != null && adxBidReq.getPriceType() == 2)) {
                printBidReq(adxBidReq);
            }

            //流量参数
            Integer bidMode = adxBidReq.getBidMode();
            int priceType = Optional.ofNullable(adxBidReq.getPriceType()).orElse(1);

            //维稳参数对象
            AdxFactorBaseDo factorBaseDo = Optional.ofNullable(adxBidReq.getAdxFactorBaseDo()).orElse(new AdxFactorBaseDo());    //不同的分组ID对应不同的维稳参数对象
            double factor = factorBaseDo.getFactor();
            Double cpm = factorBaseDo.getCpm();
            cpm = Optional.ofNullable(cpm).orElse(AdxConstant.DEFAULT_CPM);

            //创意参数
            Double preCtr = adxBidReq.getPreCtr();
            Double statCtr = factorBaseDo.getStatCtr();
            Double ctr = MathUtil.mean(preCtr, statCtr, 0.9);
            ctr = Optional.ofNullable(ctr).orElse(AdxConstant.DEFAULT_CTR);

            Double preLaunchPv = adxBidReq.getPreLaunchPv();
            Double statLaunchPv = factorBaseDo.getLaunchPv();
            Double launchPv = MathUtil.mean(preLaunchPv, statLaunchPv, 0.9);
            launchPv = Optional.ofNullable(launchPv).orElse(AdxConstant.DEFAULT_LAUNCHPV);

            Double arpu = factorBaseDo.getArpu();
            arpu = Optional.ofNullable(arpu).orElse(AdxConstant.DEFAULT_ARPU);


            Double cpc = priceType == 1 ? adxBidReq.getCpc() : adxBidReq.getDirectCpc();
            Double roi = MathUtil.division(adxBidReq.getRoi(), 100L, 3);

            Double price;
            if(priceType == 1) {    //互动出价
                price = bidMode == 1 ?
                        getRoiPrice(ctr, factor, launchPv, arpu, roi) :
                        getCpcPrice(ctr, cpc, factor);
            }else if (priceType == 2){
                price = getDirectPrice(ctr, cpc, factor, roi);  //直投出价
            }else {
                price = adxBidReq.getPrice();
            }


            price = Math.min(price, 50 * cpm);

            ret.setAdxAlgoPrice(Math.round(price));
            ret.setArpu(arpu);
            ret.setCtr(ctr);
            ret.setPreCtr(preCtr);
            ret.setStatCtr(statCtr);
            ret.setLaunchPv(launchPv);
            ret.setPreLaunchPv(preLaunchPv);
            ret.setStatLaunchPv(statLaunchPv);
            ret.setFactor(factor);
            ret.setIdeaId(adxBidReq.getIdeaId());
            ret.setIdeaUnitId(adxBidReq.getIdeaUnitId());
        }catch (Exception e) {
            logger.error("RtbBidAlg.getRtbBidding error", e);
        }
        return ret;
    }

    public static List<AdxBidReq> buildAdxBidReq(AdIdeaDo adIdeaDo, AdxFactorBaseDo factorBaseDo, String appId) {

        List<AdxBidReq> adxBidReqs = new ArrayList<>();
        List<IdeaUnitDo> ideaUnitDos = adIdeaDo.getIdeaUnitDos();

        for(IdeaUnitDo ideaUnitDo : ideaUnitDos) {
            AdxBidReq adxBidReq = new AdxBidReq();
            adxBidReq.setAdxFactorBaseDo(factorBaseDo);
            adxBidReq.setAppId(appId);
            BeanUtils.copy(adIdeaDo, adxBidReq);
            BeanUtils.copy(ideaUnitDo, adxBidReq);
            adxBidReqs.add(adxBidReq);
        }

        return adxBidReqs;

    }

    public static Double getCpcPrice(Double ctr, Double cpc, double factor) {
        return ctr * cpc * factor * 1000 * 100;
    }

    public static Double getDirectPrice(Double ctr, Double algoCpcPrice, double factor, Double roi) {
        return DataUtil.division(ctr * algoCpcPrice * factor * 1000, roi, 3);
    }

    public static Double getRoiPrice(Double ctr, double factor, Double launchPv, Double arpu, Double roi) {
        return ctr * launchPv * arpu * factor / roi * 1000;
    }

    public static boolean valid(AdxBidReq adxBidReq) {
        boolean ret = true;

        if(AssertUtil.isAnyEmpty(adxBidReq, adxBidReq.getPreCtr(), adxBidReq.getPriceType())) {
            return false;
        }
        if(adxBidReq.getPriceType() == 1) {
            if (adxBidReq.getBidMode() == null) {
                return false;
            }else if(adxBidReq.getBidMode() == 1) {
                ret = adxBidReq.getRoi() != null && adxBidReq.getPreLaunchPv() != null;
            }else {
                ret = adxBidReq.getCpc() == null ? false : true;
            }
        }else if(adxBidReq.getPriceType() == 2) {
            ret = adxBidReq.getDirectCpc() != null && adxBidReq.getRoi() != null;
        }

        return ret;

    }

    public static void printBidReq(AdxBidReq adxBidReq) {

        if(Math.random() < 0.1) {
            logger.info("bidRequestDo2 is not valid, groupId:{}, resourceId:{}, ideaId:{}, appId:{}, priceType:{}, bidMode:{}, preCtr:{}, roi:{}, preLaunchPv:{}, cpc:{}, directCpc:{}",
                     adxBidReq.getGroupId(), adxBidReq.getResId(), adxBidReq.getIdeaId(), adxBidReq.getAppId(), adxBidReq.getPriceType(), adxBidReq.getBidMode(), adxBidReq.getPreCtr(), adxBidReq.getRoi()
                    , adxBidReq.getPreLaunchPv(), adxBidReq.getCpc(), adxBidReq.getDirectCpc());
        }

    }
}
