package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

@Data
public class Model {

    private IModel ctrModel;
    private IModel launchPvCoder;
    private LocalTFModel localTFModel;

    public Map<FeatureIndex, Double> predictCtr(Map<FeatureIndex, FeatureMapDo> featureMap) throws Exception {
        Map<FeatureIndex, Double>  ret;
        ret = ctrModel.predictsNew(featureMap);
        return ret;
    }

    public Map<FeatureIndex, Double> predictLaunchPv(Map<FeatureIndex, FeatureMapDo> featureMap) throws Exception {
        Map<FeatureIndex, Double>  ret;
        ret = launchPvCoder.predictWithLocalTFNew(featureMap, localTFModel);
        return ret;
    }


}
