package cn.com.duiba.nezha.alg.alg.vo;

/**
 * 拓量/冷启动对非定向广告扶持结果
 */
public class NdAdvertResultV3Do {
    /**
     * 广告ID
     */
    private Long advertId;

    /**
     * 配置ID
     */
    private Long planId;

    /**
     * 广告位ID
     */
    private Long slotId;

    /**
     * 媒体ID
     */
    private Long appId;

    /**
     * 当前广告类型=>1:新广告;2:普通非定向广告;
     */
    private String advertType;

    /**
     * 调权因子
     */
    private Double adjustFactor;

    /**
     * ctr纠偏因子
     */
    private Double ctrRectifyFactor;

    /**
     * cvr纠偏因子
     */
    private Double cvrRectifyFactor;

    /**
     * 预估ctr
     */
    private Double preCtr;

    /**
     * 预估cvr
     */
    private Double preCvr;

    /**
     * 纠偏后的ctr
     */
    private Double rectifyCtr;

    /**
     * 纠偏后的cvr
     */
    private Double rectifyCvr;

    /**
     * 曝光加权因子
     */
    private Double exposureFactor;

    /**
     * 参竞的非定向广告的个数
     */
    private Integer numOfBidNd;

    /**
     * 当前非定向广告在Candis中的序
     */
    private Integer rankOfCurNdInCandis;

    /**
     * 当前非定向广告根据历史点击所处分层
     */
    private String level;

    /**
     * 正常投放组合标识(托管跑出的+拓量跑完的)
     */
    private String matchType;   // 1-正常 0-拓量新增及二次提权

    /**
     * 拓量组合标识
     */
    private String adExplore;  // 1-拓量 0-非拓量


    /**
     * 拓量结束标识
     */
    private String endExplore; // 0-提权未结束 1-一次提权结束 2-二次提权结束 3-非拓量流量

    /**
     * 拓量所处阶段标识
     */
    private String exploreStage; // 0-提权结束 1-一次提权阶段 2-二次提权阶段 3-非拓量流量


    public Long getAdvertId() { return advertId; }

    public void setAdvertId(Long advertId) { this.advertId = advertId; }

    public Long getPlanId() { return planId; }

    public void setPlanId(Long planId) { this.planId = planId; }

    public Long getAppId() { return appId; }

    public void setAppId(Long appId) { this.appId = appId; }

    public Long getSlotId() { return slotId; }

    public void setSlotId(Long slotId) { this.slotId = slotId; }

    public Double getAdjustFactor() { return adjustFactor; }

    public void setAdjustFactor(Double adjustFactor) { this.adjustFactor = adjustFactor; }

    public Double getCtrRectifyFactor() { return ctrRectifyFactor; }

    public void setCtrRectifyFactor(Double ctrRectifyFactor) { this.ctrRectifyFactor = ctrRectifyFactor; }

    public Double getCvrRectifyFactor() { return cvrRectifyFactor; }

    public void setCvrRectifyFactor(Double cvrRectifyFactor) { this.cvrRectifyFactor = cvrRectifyFactor; }

    public Double getPreCvr() { return preCvr; }

    public void setPreCvr(Double preCvr) { this.preCvr = preCvr; }

    public Double getPreCtr() { return preCtr; }

    public void setPreCtr(Double preCtr) { this.preCtr = preCtr; }

    public Double getRectifyCtr() { return rectifyCtr; }

    public void setRectifyCtr(Double rectifyCtr) { this.rectifyCtr = rectifyCtr; }

    public Double getRectifyCvr() { return rectifyCvr; }

    public void setRectifyCvr(Double rectifyCvr) { this.rectifyCvr = rectifyCvr; }

    public String getAdvertType() { return advertType; }

    public void setAdvertType(String advertType) { this.advertType = advertType; }

    public Double getExposureFactor() { return exposureFactor; }

    public void setExposureFactor(Double exposureFactor) { this.exposureFactor = exposureFactor; }

    public Integer getNumOfBidNd() { return numOfBidNd; }

    public void setNumOfBidNd(Integer numOfBidNd) { this.numOfBidNd = numOfBidNd; }

    public Integer getRankOfCurNdInCandis() { return rankOfCurNdInCandis; }

    public void setRankOfCurNdInCandis(Integer rankOfCurNdInCandis) { this.rankOfCurNdInCandis = rankOfCurNdInCandis; }

    public String getLevel() { return level; }

    public void setLevel(String level) { this.level = level; }

    public String getAdExplore() { return adExplore; }

    public String getEndExplore() { return endExplore; }

    public String getExploreStage() { return exploreStage; }

    public String getMatchType() { return matchType; }

    public void setAdExplore(String adExplore) { this.adExplore = adExplore; }

    public void setEndExplore(String endExplore) { this.endExplore = endExplore; }

    public void setExploreStage(String exploreStage) { this.exploreStage = exploreStage; }

    public void setMatchType(String matchType) { this.matchType = matchType; }
}
