package cn.com.duiba.nezha.alg.alg.vo.adx.pd;

import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import lombok.Data;

import static cn.com.duiba.nezha.alg.alg.adx.AdxStatData.getAdxTimeIndex;


/**
 * adx统计数据（时间维度）
 */
@Data
public class AdxStatsDo {

    /**
     * 近20分钟统计数据
     */
    private AdxIndexStatDo last20MinStat;

    /**
     * 近1小时统计数据
     */
    private AdxIndexStatDo last1HourStat;

    /**
     * 近1天统计数据
     */
    private AdxIndexStatDo last1DayStat;

    /**
     * 近3天统计数据
     */
    private AdxIndexStatDo last3DayStat;

    /**
     * 历史7天统计数据
     */
    private AdxIndexStatDo last7DayStat;

    /**
     * 计算创意维度历史平均CPM--融合实时和全天累计值
     * @param ideaStats
     * @return
     */
    public static Long getMergeAvgPrice(AdxStatsDo ideaStats) {
        Long ret = 200L;

        if(ideaStats != null) {

            //创意维度CPM均值
            AdxIndexStatsDo adxIndexStatsDoDay = getAdxTimeIndex(ideaStats, "1day");
            AdxIndexStatsDo adxIndexStatsDoDayMin = getAdxTimeIndex(ideaStats, "20min");

            Long price1 = getAvgPrice(adxIndexStatsDoDay);
            Long price2 = getAvgPrice(adxIndexStatsDoDayMin);

            if(price1 == null) {
                ret = price2;
            }else if(price2 == null) {
                ret = price1;
            }else{
                ret = (long) (0.2 * price1 + 0.8 * price2);
            }
        }
        if(ret == null) {ret = 400L;}

        ret = (long)MathUtil.stdwithBoundary(ret, 400, 800);

        return ret;
    }

    public static Long getAvgPrice(AdxIndexStatsDo adxIndexStatsDo) {
        Long ret = null;
        if(adxIndexStatsDo != null && adxIndexStatsDo.getExpCnt() != null && adxIndexStatsDo.getExpCnt() > 100) {
            ret = MathUtil.division(adxIndexStatsDo.getAdxConsume() * 1000, adxIndexStatsDo.getExpCnt());
        }
        return ret;
    }

    public AdxIndexStatDo getLast20MinStat() {
        return last20MinStat;
    }

    public void setLast20MinStat(AdxIndexStatDo last20MinStat) {
        this.last20MinStat = last20MinStat;
    }

    public AdxIndexStatDo getLast1HourStat() {
        return last1HourStat;
    }

    public void setLast1HourStat(AdxIndexStatDo last1HourStat) {
        this.last1HourStat = last1HourStat;
    }

    public AdxIndexStatDo getLast1DayStat() {
        return last1DayStat;
    }

    public void setLast1DayStat(AdxIndexStatDo last1DayStat) {
        this.last1DayStat = last1DayStat;
    }
}
