package cn.com.duiba.nezha.alg.alg.vo.ocpxControl;

import lombok.Data;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Data
public class OcpxControlSubModel {

    /**
     * 配置维度 abtest参数对象
     */
//    ABTestParams abTestParams = new ABTestParams();


    /**
     * 维稳 常规模式 type =1
     */


    // 配置维度 参数对象
    OcpxControlParams ocpxControlParams = new OcpxControlParams();


    //配置维度 参数对象 拓展流量
    OcpxControlParams atOcpxControlParams = new OcpxControlParams();

    //广告位维度 参数对象
    Map<Long, OcpxControlParams> ocpxControlParamsMap = new ConcurrentHashMap<>();


    /**
     * 维稳 跑量模式 type=2
     */

    //配置维度 参数对象  跑量模式
    OcpxControlParams ocpx2ControlParams = new OcpxControlParams();

    // 配置维度 参数对象 拓展流量   跑量模式
    OcpxControlParams atOcpx2ControlParams = new OcpxControlParams();

    //广告位维度 参数对象   跑量模式
    Map<Long, OcpxControlParams> ocpx2ControlParamsMap = new ConcurrentHashMap<>();


    /**
     * 维稳 双出价模式 type =3
     */

    //配置维度 参数对象  跑量模式
    OcpxControlParams ocpx3ControlParams = new OcpxControlParams();

    // 配置维度 参数对象 拓展流量   跑量模式
    OcpxControlParams atOcpx3ControlParams = new OcpxControlParams();

    //广告位维度 参数对象   跑量模式
    Map<Long, OcpxControlParams> ocpx3ControlParamsMap = new ConcurrentHashMap<>();



    /**
     * 深度双出价 对比组 type=1
     */
    //深度双出价控制参数
    DeepControlParams deepControlParams = new DeepControlParams();

    //广告位维度 深度双出价控制参数
    Map<Long, DeepControlParams> deepControlParamsMap = new ConcurrentHashMap<>();


    /**
     * 深度双出价 实验组 type=2
     */
    //深度双出价控制参数
    DeepControlParams deepControl2Params = new DeepControlParams();

    //广告位维度 深度双出价控制参数
    Map<Long, DeepControlParams> deepControl2ParamsMap = new ConcurrentHashMap<>();


    private String updateTime;

    public OcpxControlParams getOcpxControlParams(int type) {
        if (type == 2) {
            return ocpx2ControlParams;
        }
        if (type == 3) {
            return ocpx3ControlParams;
        }
        return ocpxControlParams;
    }

    public OcpxControlParams getAtOcpxControlParams(int type) {
        if (type == 2) {
            return atOcpx2ControlParams;
        }
        if (type == 3) {
            return atOcpx3ControlParams;
        }
        return atOcpxControlParams;
    }


    public Map<Long, OcpxControlParams> getOcpxControlParamsMap(int type) {
        if (type == 2) {
            return ocpx2ControlParamsMap;
        }
        if (type == 3) {
            return ocpx3ControlParamsMap;
        }
        return ocpxControlParamsMap;
    }

    public OcpxControlParams getOcpxControlParams(int type, Long slotId) {
        // 12.1 注释
        if(slotId==null){
            slotId=-1L;
        }
        if (getOcpxControlParamsMap(type).get(slotId) == null) {
            getOcpxControlParamsMap(type).put(slotId, new OcpxControlParams());
        }
        return getOcpxControlParamsMap(type).get(slotId);
    }

    public void putOcpxControlParams(int type, Long slotId, OcpxControlParams ocpxControlParams) {
        if(slotId==null){
            slotId=-1L;
        }
        getOcpxControlParamsMap(type).put(slotId, ocpxControlParams);
    }

    public void putOcpxControlParams(int type, OcpxControlParams params) {
        if (type == 1) {
            ocpxControlParams = params;
        }
        if (type == 2) {
            ocpx2ControlParams = params;
        }
        if (type == 3) {
            ocpx3ControlParams = params;
        }

    }

    public void putAtOcpxControlParams(int type, OcpxControlParams params) {

        if (type == 1) {
            atOcpxControlParams = params;
        }
        if (type == 2) {
            atOcpx2ControlParams = params;
        }
        if (type == 3) {
            atOcpx3ControlParams = params;
        }
    }
//
//    public OcpxControlParams getOcpxControlParams(Long slotId) {
//        if (ocpxControlParamsMap.get(slotId) == null) {
//            ocpxControlParamsMap.put(slotId, new OcpxControlParams());
//        }
//        return ocpxControlParamsMap.get(slotId);
//    }

//    public void putOcpxControlParams(Long slotId, OcpxControlParams ocpxControlParams) {
//        ocpxControlParamsMap.put(slotId, ocpxControlParams);
//    }


//    public OcpxControlParams getOcpx2ControlParams(Long slotId) {
//        if (ocpx2ControlParamsMap.get(slotId) == null) {
//            ocpx2ControlParamsMap.put(slotId, new OcpxControlParams());
//        }
//        return ocpx2ControlParamsMap.get(slotId);
//    }

//    public void putOcpx2ControlParams(Long slotId, OcpxControlParams ocpxControlParams) {
//        ocpx2ControlParamsMap.put(slotId, ocpxControlParams);
//    }


//    public OcpxControlParams getOcpx3ControlParams(Long slotId) {
//        if (ocpx3ControlParamsMap.get(slotId) == null) {
//            ocpx3ControlParamsMap.put(slotId, new OcpxControlParams());
//        }
//        return ocpx3ControlParamsMap.get(slotId);
//    }
//
//    public void putOcpx3ControlParams(Long slotId, OcpxControlParams ocpxControlParams) {
//        ocpx3ControlParamsMap.put(slotId, ocpxControlParams);
//    }


//    public DeepControlParams getDeepControlParams(Long slotId) {
//        if(slotId==null){
//            slotId=-1L;
//        }
//        if (deepControlParamsMap.get(slotId) == null) {
//            deepControlParamsMap.put(slotId, new DeepControlParams());
//        }
//        return deepControlParamsMap.get(slotId);
//    }
//
//    public void putDeepControlParams(Long slotId, DeepControlParams deepControlParams) {
//        if(slotId==null){
//            slotId=-1L;
//        }
//        deepControlParamsMap.put(slotId, deepControlParams);
//    }

    public DeepControlParams getDeepControlParams(int type) {
        if (type == 2 ) {
            return deepControl2Params;
        }
        return deepControlParams;
    }

    public Map<Long, DeepControlParams> getDeepControlParamsMap(int type) {
        if (type == 2) {
            return deepControl2ParamsMap;
        }
        return deepControlParamsMap;
    }

    public DeepControlParams getDeepControlParams(int type, Long slotId) {
        if(slotId==null){
            slotId = -1L;
        }
        if (getDeepControlParamsMap(type).get(slotId) == null) {
            getDeepControlParamsMap(type).put(slotId, new DeepControlParams());
        }
        return getDeepControlParamsMap(type).get(slotId);
    }

    public void putDeepControlParams(int type, Long slotId, DeepControlParams params) {
        if(slotId==null){
            slotId=-1L;
        }
        getDeepControlParamsMap(type).put(slotId, params);
    }

    public void putDeepControlParams(int type, DeepControlParams params) {
        if (type == 1) {
            deepControlParams = params;
        }
        if (type == 2) {
            deepControl2Params = params;
        }
    }

}
