package cn.com.duiba.nezha.alg.alg.plugins;

import cn.com.duiba.nezha.alg.alg.vo.plug.ResPlugInRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.plug.ResPlugInStatDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;

import java.io.DataOutput;
import java.io.Serializable;
import java.util.List;

/**
 * 响应插件-统计对象
 */
public class ResPlugInStatModel implements Serializable {


    /**
     * 统计对象融合
     *
     * @param historyStatDo
     * @param hourStatDo
     * @return
     */
    public static ResPlugInStatDo merge2(ResPlugInStatDo historyStatDo, ResPlugInStatDo hourStatDo) {

        ResPlugInStatDo ret = new ResPlugInStatDo();
        if (historyStatDo == null) {
            historyStatDo = new ResPlugInStatDo();
        }

        if (hourStatDo == null) {
            hourStatDo = new ResPlugInStatDo();
        }

        if (historyStatDo.getCostFee() != null && historyStatDo.getCostFee() > 100000000) {
            historyStatDo.setVisitPv(0L);
            historyStatDo.setJoinPv(0L);
            historyStatDo.setLaunchCnt(0L);
            historyStatDo.setClickPv(0L);
            historyStatDo.setCostFee(0L);
            historyStatDo.setConvertPv(0L);
        }
        Long days = LocalDateUtil.getIntervalDays("2020-01-10", DateStyle.YYYY_MM_DD);
        if (days < 2 && historyStatDo.getResPlugInId() != null) {
            if (historyStatDo.getResPlugInId().equals(2041L) ||
                    historyStatDo.getResPlugInId().equals(2176L) ||
                    historyStatDo.getResPlugInId().equals(2112L) ||
                    historyStatDo.getResPlugInId().equals(2277L)
                    ) {

                historyStatDo.setVisitPv(0L);
                historyStatDo.setJoinPv(0L);
                historyStatDo.setLaunchCnt(0L);
                historyStatDo.setClickPv(0L);
                historyStatDo.setCostFee(0L);
                historyStatDo.setConvertPv(0L);

            }
        }


        Double decayFactorHis = getDecayFactorHistory(historyStatDo.getVisitPv(), 1000L);
        Double decayFactorCur = getDecayFactorCurrent(hourStatDo.getMainVisitPv(), 1000L);


        Long visitPv = mergeNew(historyStatDo.getVisitPv(), hourStatDo.getMainVisitPv(), hourStatDo.getResPlugVisitPv(), decayFactorHis, decayFactorCur);
        Long joinPv = mergeNew(historyStatDo.getJoinPv(), hourStatDo.getMainJoinPv(), hourStatDo.getResPlugJoinPv(), decayFactorHis, decayFactorCur);
        Long launchCnt = mergeNew(historyStatDo.getLaunchCnt(), hourStatDo.getMainLaunchCnt(), hourStatDo.getResPlugLaunchCnt(), decayFactorHis, decayFactorCur);
        Long clickPv = mergeNew(historyStatDo.getClickPv(), hourStatDo.getMainClickPv(), hourStatDo.getResPlugClickPv(), decayFactorHis, decayFactorCur);
        Long costFee = mergeNew(historyStatDo.getCostFee(), hourStatDo.getMainCostFee(), hourStatDo.getResPlugCostFee(), decayFactorHis, decayFactorCur);
        Long convertPv = mergeNew(historyStatDo.getConvertPv(), hourStatDo.getMainConvertPv(), hourStatDo.getResPlugConvertPv(), decayFactorHis, decayFactorCur);


        ret.setSlotId(hourStatDo.getSlotId());
        ret.setDsm2A(historyStatDo.getDsm2A());
        ret.setResPlugInId(hourStatDo.getResPlugInId());
        ret.setResPlugInIndex(hourStatDo.getResPlugInIndex());


        ret.setVisitPv(visitPv);
        ret.setJoinPv(joinPv);
        ret.setLaunchCnt(launchCnt);
        ret.setClickPv(clickPv);
        ret.setCostFee(costFee);
        ret.setConvertPv(convertPv);
        ret.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS));

        return ret;
    }

    /**
     * 统计对象融合
     *
     * @param historyStatDo
     * @param hourStatDo
     * @return
     */
    public static ResPlugInStatDo merge(ResPlugInStatDo historyStatDo, ResPlugInStatDo hourStatDo) {

        ResPlugInStatDo ret = new ResPlugInStatDo();
        if (historyStatDo == null) {
            historyStatDo = new ResPlugInStatDo();
        }

        if (hourStatDo == null) {
            hourStatDo = new ResPlugInStatDo();
        }

        if (historyStatDo.getCostFee() != null && historyStatDo.getCostFee() > 100000000) {
            historyStatDo.setVisitPv(0L);
            historyStatDo.setJoinPv(0L);
            historyStatDo.setLaunchCnt(0L);
            historyStatDo.setClickPv(0L);
            historyStatDo.setCostFee(0L);
            historyStatDo.setConvertPv(0L);
        }


        Double decayFactorHis = getDecayFactorHistory(historyStatDo.getVisitPv(), 1500L);
        Double decayFactorCur = getDecayFactorCurrent(hourStatDo.getMainVisitPv(), 500L);
        Long visitPv = mergeNew(historyStatDo.getVisitPv(), hourStatDo.getMainVisitPv(), hourStatDo.getResPlugVisitPv(), decayFactorHis, decayFactorCur);
        Long joinPv = mergeNew(historyStatDo.getJoinPv(), hourStatDo.getMainJoinPv(), hourStatDo.getResPlugJoinPv(), decayFactorHis, decayFactorCur);
        Long launchCnt = mergeNew(historyStatDo.getLaunchCnt(), hourStatDo.getMainLaunchCnt(), hourStatDo.getResPlugLaunchCnt(), decayFactorHis, decayFactorCur);
        Long clickPv = mergeNew(historyStatDo.getClickPv(), hourStatDo.getMainClickPv(), hourStatDo.getResPlugClickPv(), decayFactorHis, decayFactorCur);
        Long costFee = mergeNew(historyStatDo.getCostFee(), hourStatDo.getMainCostFee(), hourStatDo.getResPlugCostFee(), decayFactorHis, decayFactorCur);
        Long convertPv = mergeNew(historyStatDo.getConvertPv(), hourStatDo.getMainConvertPv(), hourStatDo.getResPlugConvertPv(), decayFactorHis, decayFactorCur);


        ret.setSlotId(hourStatDo.getSlotId());
        ret.setDsm2A(historyStatDo.getDsm2A());
        ret.setResPlugInId(hourStatDo.getResPlugInId());
        ret.setResPlugInIndex(hourStatDo.getResPlugInIndex());


        ret.setVisitPv(visitPv);
        ret.setJoinPv(joinPv);
        ret.setLaunchCnt(launchCnt);
        ret.setClickPv(clickPv);
        ret.setCostFee(costFee);
        ret.setConvertPv(convertPv);
        ret.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS));

        return ret;
    }

    /**
     * 多数据融合
     *
     * @param statDoList
     * @return
     */
    public static ResPlugInStatDo mergeIndexList(List<ResPlugInRcmdDo> statDoList) {
        ResPlugInStatDo ret = new ResPlugInStatDo();

        Long visitPv = 0L;
        Long costFee = 0L;
        Long convertPv = 0L;


        if (AssertUtil.isNotEmpty(statDoList)) {
            for (int i = 0; i < statDoList.size(); i++) {
                ResPlugInRcmdDo resPlugInRcmdDo = statDoList.get(i);

                if (resPlugInRcmdDo != null && resPlugInRcmdDo.getResPlugInStatDo() != null) {
                    ResPlugInStatDo resPlugInStatDo = resPlugInRcmdDo.getResPlugInStatDo();
                    visitPv = DataUtil.addLong(visitPv, resPlugInStatDo.getVisitPv());
                    costFee = DataUtil.addLong(costFee, resPlugInStatDo.getCostFee());
                    convertPv = DataUtil.addLong(convertPv, resPlugInStatDo.getConvertPv());
                }
            }

        }
        ret.setVisitPv(visitPv);
        ret.setCostFee(costFee);
        ret.setConvertPv(convertPv);
        ret.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS));
        return ret;

    }

    public static ResPlugInStatDo mergeIdList(List<ResPlugInRcmdDo> statDoList) {
        ResPlugInStatDo ret = new ResPlugInStatDo();

        Long visitPv = 0L;
        Long costFee = 0L;
        Long convertPv = 0L;


        if (AssertUtil.isNotEmpty(statDoList)) {
            for (int i = 0; i < statDoList.size(); i++) {
                ResPlugInRcmdDo resPlugInRcmdDo = statDoList.get(i);

                if (resPlugInRcmdDo != null && resPlugInRcmdDo.getResPlugInStatDo() != null) {
                    ResPlugInStatDo resPlugInStatDo = resPlugInRcmdDo.getResPlugInStatDo();
                    visitPv = DataUtil.addLong(visitPv, resPlugInStatDo.getVisitPv());
                    costFee = DataUtil.addLong(costFee, resPlugInStatDo.getCostFee());
                    convertPv = DataUtil.addLong(convertPv, resPlugInStatDo.getConvertPv());
                }
            }

        }
        ret.setVisitPv(visitPv);
        ret.setCostFee(costFee);
        ret.setConvertPv(convertPv);
        ret.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS));
        return ret;

    }


    public static Double getRpm(ResPlugInStatDo historyStatDo) {
        Double ret = null;
        if (historyStatDo != null) {
            if (historyStatDo.getVisitPv() != null &&
                    historyStatDo.getVisitPv() > 500 &&
                    historyStatDo.getCostFee() != null &&
                    historyStatDo.getCostFee() > 500) {
                ret = DataUtil.division(historyStatDo.getCostFee(), historyStatDo.getVisitPv() + 1, 5);
            }
        }
        return ret;
    }

    public static Double getRoi(ResPlugInStatDo historyStatDo) {
        Double ret = null;
        if (historyStatDo != null) {
            if (historyStatDo.getVisitPv() != null &&
                    historyStatDo.getVisitPv() > 500 &&
                    historyStatDo.getClickPv() != null &&
                    historyStatDo.getClickPv() > 5) {
                ret = DataUtil.division(historyStatDo.getClickPv(), historyStatDo.getVisitPv() + 1, 5);
            }
        }
        return ret;
    }

    public static Long merge(Long v1, Long v2, Long v3, Double decayFactor) {

        if (v1 == null) {
            v1 = 0L;
        }
        if (v2 == null) {
            v2 = 0L;
        }
        if (v3 == null) {
            v3 = 0L;
        }
        return DataUtil.double2Long(decayFactor * v1 + (v2 + v3));

    }

    /**
     * 融合-去除误差
     *
     * @param v1
     * @param v2
     * @param v3
     * @param decayFactor1
     * @return
     */
    public static Long mergeNew(Long v1, Long v2, Long v3, Double decayFactor1, Double decayFactor2) {

        if (v1 == null) {
            v1 = 0L;
        }
        if (v2 == null) {
            v2 = 0L;
        }
        if (v3 == null) {
            v3 = 0L;
        }
        return DataUtil.double2Long(decayFactor1 * v1 + decayFactor2 * (v2 + v3));

    }

    public static Double getDecayFactor(Long visitPv, Long basePv) {
        Double ret = 1.0;
        if (visitPv != null) {
            ret = 1.0 - 0.3 * Math.min((visitPv + 0.0) / basePv, 1.0);
        }
        return ret;
    }

    public static Double getDecayFactorHistory(Long visitPv, Long basePv) {
        Double ret = 1.0;
        if (visitPv != null) {
            ret = Math.min((basePv + 0.0) / (visitPv), 1.0);
        }
        return ret;
    }

    public static Double getDecayFactorCurrent(Long visitPv, Long basePv) {
        Double ret = 1.0;
        if (visitPv != null) {

            ret = Math.min(1.0, (basePv + 0.0) / visitPv);
//            if (visitPv > 200 && visitPv < 500) {
//                ret = 2.0;
//            }

        }
        return ret;
    }
}
