package cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2;

import lombok.Data;

import java.util.Map;

@Data
public class AdxPriceExploreDo {

    /**
     * slot ID
     */
    private String slotId;

    /**
     * 因子表({分level：小数})
     * 初始化：{"base": 1.0, "exp1": 0.5, "exp2": 1.0, "exp3": 1.5, "exp4": 2.0}，配置在阿波罗
     */
    private Map<String, Double> factorExploreMap;

    /**
     * 因子对应流量比例表({分level：小数})
     * 初始化：{"base": 0.6*0.1, "exp1": 0.1*0.1, "exp2": 0.1*0.1, "exp3": 0.1*0.1, "exp4": 0.1*0.1}，配置在阿波罗
     */
    private Map<String, Double> factorFlowRateMap;

    /**
     * 探价流量比例表({分level：小数})
     * 初始化：{"base": 0.9, "explore": 0.1}
     */
    private Map<String, Double> exploreFlowRateMap;


}
