/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.AdxBid;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.FeatureIndex;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.Model;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.PredictType;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxBidRet;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxIdeaAdFeatureDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxIdeaFeatureDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxIdeaMaterialFeatureDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxMaterialFeatureDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxRecallDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.IdeaUnitDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorBaseDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.AdxFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxRecommend {
    private static final Logger logger = LoggerFactory.getLogger(AdxRecommend.class);

    public static void needPreIdeaId(List<AdIdeaDo> adIdeaDos, Map<Long, AdxRecallDo> recallDoMap, Map<Long, AdxRecallDo> dpaRecallDoMap) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{adIdeaDos, recallDoMap, dpaRecallDoMap})) {
            logger.info("AdxRecommend.needPreIdeaId params not valid");
            return;
        }
        for (AdIdeaDo adIdeaDo : adIdeaDos) {
            if (adIdeaDo == null || adIdeaDo.getUnitPutType() == 1) continue;
            Long styleId = adIdeaDo.getStyleId();
            AdxRecallDo adxRecallDo = adIdeaDo.isDpa() ? dpaRecallDoMap.get(styleId) : recallDoMap.get(styleId);
            Set<Long> recallSet = AdxRecallDo.getRecallSet(adxRecallDo);
            List<IdeaUnitDo> ideaUnitDos = adIdeaDo.getIdeaUnitDos().stream().filter(s -> recallSet.contains(s.getIdeaUnitId())).collect(Collectors.toList());
            adIdeaDo.setIdeaUnitDos(ideaUnitDos);
        }
    }

    public static Map<FeatureIndex, FeatureMapDo> getFeatureMap(List<AdxIdeaFeatureDo> adxIdeaFeatureDos, AdxFeatureDo adxFeatureDo, Map<Long, AdxStatsDo> ideaAppStatsList, AdxStatsDo resoAppStats) {
        HashMap<FeatureIndex, FeatureMapDo> featureMap = new HashMap<FeatureIndex, FeatureMapDo>();
        ideaAppStatsList = Optional.ofNullable(ideaAppStatsList).orElse(new HashMap());
        AdxIndexStatsDo resoApp1HourInfo = AdxStatData.getAdxTimeIndex(resoAppStats, "1hour");
        adxFeatureDo.setResoAppExpCntDay(resoApp1HourInfo.getExpCnt());
        adxFeatureDo.setResoAppClickCntDay(resoApp1HourInfo.getClickCnt());
        adxFeatureDo.setResoAppAdCostDay(resoApp1HourInfo.getAdvertConsume());
        Map staticFeatureMap = AdxFeatureParse.generateFeatureMapStatic((AdxFeatureDo)adxFeatureDo);
        if (AssertUtil.isEmpty(adxIdeaFeatureDos)) {
            return featureMap;
        }
        for (AdxIdeaFeatureDo ideaDo : adxIdeaFeatureDos) {
            AdxIdeaAdFeatureDo adxIdeaAdFeatureDo = ideaDo.getAdxIdeaAdFeatureDo();
            Long ideaId = adxIdeaAdFeatureDo.getIdeaId();
            AdxStatsDo ideaAppStats = (AdxStatsDo)ideaAppStatsList.get(ideaId);
            AdxIndexStatsDo ideaApp1DayInfo = AdxStatData.getAdxTimeIndex(ideaAppStats, "1day");
            List<AdxIdeaMaterialFeatureDo> adxIdeaMaterialFeatureDos = ideaDo.getAdxIdeaMaterialFeatureDos();
            for (AdxIdeaMaterialFeatureDo featureDo : adxIdeaMaterialFeatureDos) {
                AdxFeatureDo dynamicDo = new AdxFeatureDo();
                Long ideaUnitId = featureDo.getIdeaUnitId();
                FeatureIndex featureIndex = new FeatureIndex(ideaId, ideaUnitId);
                dynamicDo.setIdeaAppExpCntDay(ideaApp1DayInfo.getExpCnt());
                dynamicDo.setIdeaAppClickCntDay(ideaApp1DayInfo.getClickCnt());
                dynamicDo.setIdeaAppAdCostDay(ideaApp1DayInfo.getAdvertConsume());
                BeanUtils.copy((Object)adxIdeaAdFeatureDo, (Object)dynamicDo);
                BeanUtils.copy((Object)featureDo, (Object)dynamicDo);
                dynamicDo.setIdeaType(featureDo.getStyleType());
                List<AdxMaterialFeatureDo> adxMaterialFeatureDos = featureDo.getAdxMaterialFeatureDos();
                AdxMaterialFeatureDo adxMaterialFeatureDo = adxMaterialFeatureDos.get(0);
                dynamicDo.setMaterialId(adxMaterialFeatureDo.getMaterialId());
                dynamicDo.setIdeaPicH1(adxMaterialFeatureDo.getIdeaPicH());
                dynamicDo.setIdeaPicW1(adxMaterialFeatureDo.getIdeaPicH());
                dynamicDo.setIdeaPicNum(Integer.valueOf(featureDo.getAdxMaterialFeatureDos().size()));
                Map dynamicFeatureMap = AdxFeatureParse.generateFeatureMapDynamic2((AdxFeatureDo)dynamicDo, (AdxFeatureDo)adxFeatureDo);
                FeatureMapDo featureMapDo = new FeatureMapDo();
                featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
                featureMapDo.setStaticFeatureMap(staticFeatureMap);
                featureMap.put(featureIndex, featureMapDo);
            }
        }
        return featureMap;
    }

    public static Map<FeatureIndex, Double> predict(Map<FeatureIndex, FeatureMapDo> featureMap, Model model, PredictType predictType) throws Exception {
        Map<FeatureIndex, Double> ret = new HashMap<FeatureIndex, Double>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{featureMap, model, predictType})) {
            logger.warn("AdxRecommend.predict params is not valid");
            return ret;
        }
        if (predictType == PredictType.CTR) {
            ret = model.predictCtr(featureMap);
        } else if (predictType == PredictType.PVLAUNCH) {
            ret = model.predictLaunchPv(featureMap);
        }
        return ret;
    }

    public static void rawRank(List<AdIdeaDo> adIdeaDos, Map<FeatureIndex, Double> preCtrMap, Integer limitSize) {
        try {
            for (AdIdeaDo adIdeaDo : adIdeaDos) {
                Long adIdeaId = adIdeaDo.getIdeaId();
                List<IdeaUnitDo> ideaUnitDos = adIdeaDo.getIdeaUnitDos().stream().sorted(Comparator.comparing(ideaUnitDo -> {
                    Long ideaUnitId = ((IdeaUnitDo)ideaUnitDo).getIdeaUnitId();
                    FeatureIndex featureIndex = new FeatureIndex(adIdeaId, ideaUnitId);
                    Double preCtr = preCtrMap.getOrDefault(featureIndex, 0.0);
                    return preCtr;
                }).reversed()).limit(limitSize.intValue()).collect(Collectors.toList());
                adIdeaDo.setIdeaUnitDos(ideaUnitDos);
            }
        }
        catch (Exception e) {
            logger.error("AdxRecommend.rawRank error", (Throwable)e);
        }
    }

    public static List<AdxBidRet> bidding(List<AdIdeaDo> adIdeaDos, AdxFactorDo adxFactorDo, String appId, Map<Long, AdxStatsDo> adxStatsDoMap) {
        List adxBidRets = null;
        try {
            adxBidRets = adIdeaDos.stream().map(adIdeaDo -> {
                Long ideaId = adIdeaDo.getIdeaId();
                Long resId = adIdeaDo.getResId();
                AdxFactorBaseDo factorBaseDo = adxFactorDo.getFactorBaseDo(resId, ideaId, appId);
                return AdxBid.buildAdxBidReq(adIdeaDo, factorBaseDo, appId, adxStatsDoMap);
            }).flatMap(Collection::stream).map(AdxBid::bid).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error("AdxRecommend.bidding", (Throwable)e);
        }
        return adxBidRets;
    }

    public static List<AdxBidRet> fineRank(List<AdxBidRet> adxBidRets) {
        return adxBidRets.stream().sorted(Comparator.comparing(AdxBidRet::getAdxAlgoPrice).reversed()).collect(Collectors.toList());
    }
}

