package cn.com.duiba.nezha.alg.alg.adx.rcmd;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.params.AdxIdeaRcmdParam;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxIdeaRcmdRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxIdeaRcmdResultDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.*;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.*;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.CODER2;
import cn.com.duiba.nezha.alg.model.FM;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IdeaRcmdAlg {

    private static final Logger logger = LoggerFactory.getLogger(IdeaRcmdAlg.class);

    static double[] weight = {100, 20, 10, 5, 2, 1, 0.5};


    /**
     * 创意推荐
     *
     * @param rcmdRequestDo
     * @return
     */
    public static AdxIdeaRcmdResultDo getIdeaRcmd(AdxIdeaRcmdRequestDo rcmdRequestDo) {

        AdxIdeaRcmdResultDo ret = new AdxIdeaRcmdResultDo();

        /**
         *
         * 步骤：
         * 步骤1、统计创意CTR，点击价值
         * 步骤2、预估创意CTR，点击价值
         * 步骤3、创意挑选
         *
         * 备注：putType = 0依次, 1比例, 2算法1.0, 3算法2.0，4算法3.0
         *
         */

        try {


            //判断异常原因
            Long giveUpType = getGiveUpType(rcmdRequestDo);
            rcmdRequestDo = Optional.ofNullable(rcmdRequestDo).orElse(new AdxIdeaRcmdRequestDo());
            Integer putType = Optional.ofNullable(rcmdRequestDo.getPutType()).orElse(3);


            /* 步骤1、统计创意CTR，点击价值 */
            //1.1 创意维度
            Map<Long, AdxStatsDo> ideaStatsList = Optional.ofNullable(rcmdRequestDo.getIdeaStatsList()).orElse(new HashMap<>());
            Map<Long, Double> ideaStatCtrMap = new HashMap<>(), ideaStatDayCtrMap = new HashMap<>();
            Map<Long, Double> ideaStatCvaMap = new HashMap<>(), ideaStatDayCvaMap = new HashMap<>();
            ideaStatsList.forEach((k, v) -> {
                AdxStatsDo ideaStats = Optional.ofNullable(v).orElse(new AdxStatsDo());
                AdxIndexStatsDo idea20MinInfo = AdxStatData.getAdxTimeIndex(ideaStats, "20min");
                AdxIndexStatsDo idea1DayInfo = AdxStatData.getAdxTimeIndex(ideaStats, "1day");
                ideaStatCtrMap.put(k, idea20MinInfo.getCtr());
                ideaStatDayCtrMap.put(k, idea1DayInfo.getCtr());
                ideaStatCvaMap.put(k, idea20MinInfo.getClickValue());
                ideaStatDayCvaMap.put(k, idea1DayInfo.getClickValue());
            });

            //1.2 创意+百度app维度
            Map<Long, AdxStatsDo> ideaAppStatsList = Optional.ofNullable(rcmdRequestDo.getIdeaAppStatsList()).orElse(new HashMap<>());
            Map<Long, Double> ideaAppStatCtrMap = new HashMap<>(), ideaAppStatCvaMap = new HashMap<>();
            ideaAppStatsList.forEach((k, v) -> {
                AdxStatsDo ideaAppStats = Optional.ofNullable(v).orElse(new AdxStatsDo());
                AdxIndexStatsDo ideaAppConInfo = AdxStatData.getConTimeIndex(ideaAppStats);
                ideaAppStatCtrMap.put(k, ideaAppConInfo.getCtr());
                ideaAppStatCvaMap.put(k, ideaAppConInfo.getClickValue());
            });

            //1.3 资源位维度
            AdxStatsDo resoStats = Optional.ofNullable(rcmdRequestDo.getResoStats()).orElse(new AdxStatsDo());
            AdxIndexStatsDo reso20MinInfo = AdxStatData.getAdxTimeIndex(resoStats, "20min");
            Double resoStatCtr = reso20MinInfo.getCtr();
            Double resoStatCva = reso20MinInfo.getClickValue();

            //1.4 资源位+百度app维度
            AdxStatsDo resoAppStats = Optional.ofNullable(rcmdRequestDo.getResoAppStats()).orElse(new AdxStatsDo());
            AdxIndexStatsDo resoApp1HourInfo = AdxStatData.getAdxTimeIndex(resoAppStats, "1hour");
            AdxIndexStatsDo ideaAppConInfo = AdxStatData.getConTimeIndex(resoAppStats);
            Double resoAppStatCtr = ideaAppConInfo.getCtr();
            Double resoAppStatCva = ideaAppConInfo.getClickValue();



            /* 步骤2、预估创意CTR，点击价值 */
            List<AdxIdeaFeatureDo> ideaList;
            List<AdxIdeaMaterialId> ideaMaterialList = new ArrayList<>();
            Map<AdxIdeaMaterialId, FeatureMapDo> featureMap = new HashMap<>();
            Map<AdxIdeaMaterialId, Double> preCtrMap = new HashMap<>();
            Map<AdxIdeaMaterialId, Double> preCvaMap = new HashMap<>();
            if (AssertUtil.isEmpty(giveUpType)) {

                //2.1 特征解析
                ideaList = putType.equals(4) ?
                        getIdeaList(rcmdRequestDo.getStaticIdeaFeatureList(), rcmdRequestDo.getDynamicIdeaFeatureList())
                        : getIdeaList(rcmdRequestDo.getStaticIdeaFeatureList(), null);

                AdxFeatureDo adxFeatureDo = Optional.ofNullable(rcmdRequestDo.getAdxFeatureDo()).orElse(new AdxFeatureDo());
                adxFeatureDo.setResoAppExpCntDay(resoApp1HourInfo.getExpCnt());
                adxFeatureDo.setResoAppClickCntDay(resoApp1HourInfo.getClickCnt());
                adxFeatureDo.setResoAppAdCostDay(resoApp1HourInfo.getAdvertConsume());

                featureMap = getFeatureMap(adxFeatureDo, ideaList, ideaAppStatsList);
                ideaMaterialList = new ArrayList<>(featureMap.keySet());

                //2.2 预估创意ctr
                FM fmModel = rcmdRequestDo.getFmModel();
                preCtrMap = fmModel.predictsNew(featureMap);

                //2.3 预估创意点击价值(创意推荐3.0不预估)
                if (!putType.equals(4)) {
                    CODER2 coderModel = rcmdRequestDo.getCoderModel();
                    LocalTFModel ltfModel = rcmdRequestDo.getLtfModel();
                    if (AssertUtil.isAllNotEmpty(coderModel, ltfModel)) {
                        preCvaMap = coderModel.predictWithLocalTFNew(featureMap, ltfModel);
                    }
                }
            }



            /* 步骤3、创意挑选 */
            Long bestIdeaId = null, bestMaterialId = -1L;
            if (putType.equals(0) || putType.equals(1)) {
                //按依次/比例投放
                bestIdeaId = rcmdRequestDo.getManualIdeaId();
                bestMaterialId = rcmdRequestDo.getStaticIdeaFeatureList().get(0).getMaterialId();


            } else if (putType.equals(2)) {
                //按创意推荐1.0投放
                Map<Long, Double> preExpValueMap = getPreExpValue(ideaMaterialList, resoStatCtr, resoStatCva, preCtrMap, preCvaMap,
                        ideaStatCtrMap, ideaStatDayCtrMap, ideaStatCvaMap, ideaStatDayCvaMap);
                bestIdeaId = getBestIdeaId(ideaMaterialList, preExpValueMap);
                Long ideaId = bestIdeaId;
                List<AdxIdeaMaterialId> adxIdeaMaterialId = ideaMaterialList.stream().filter(s -> s.getIdeaId().equals(ideaId)).collect(Collectors.toList());
                if (AssertUtil.isNotEmpty(adxIdeaMaterialId)) {
                    bestMaterialId = adxIdeaMaterialId.get(0).getMaterialId();
                }
                ret.setIdeaScoreMap(JSONObject.toJSONString(preExpValueMap));


            } else if (putType.equals(3)) {
                //按创意推荐2.0投放
                AdxIdeaRcmdParam adxIdeaRcmdParam = new AdxIdeaRcmdParam();
                adxIdeaRcmdParam.setIdeaFeatureList(rcmdRequestDo.getStaticIdeaFeatureList());
                adxIdeaRcmdParam.setAdxFeatureDo(rcmdRequestDo.getAdxFeatureDo());
                adxIdeaRcmdParam.setAdxResourceRcmdDo(rcmdRequestDo.getAdxResourceRcmdDo());
                AdxIdeaFeatureDo result = AdxIdeaRcmdAlg.ideaRcmd(adxIdeaRcmdParam);
                if (AssertUtil.isNotEmpty(result)) {
                    bestIdeaId = result.getIdeaId();
                    bestMaterialId = result.getMaterialId();
                    Double mergeRpm = result.getMergeRpm(), pRpm = result.getPRpm(), sRpm = result.getSRpm();
                    ret.setMergeRpm(mergeRpm); ret.setPRpm(pRpm); ret.setSRpm(sRpm);
                    //创意推荐2.0不推荐
                    if (AssertUtil.isAllEmpty(giveUpType, bestIdeaId)) {
                        giveUpType = 7L;
                    }
                }


            } else if (putType.equals(4)) {
                //按创意推荐3.0投放
                Map<AdxIdeaMaterialId, AdxStatsDo> ideaMaStatsList = Optional.ofNullable(rcmdRequestDo.getIdeaMaterialStatInfo()).orElse(new HashMap<>());
                Map<Long, AdxStatsDo> resoMaStatInfo = Optional.ofNullable(rcmdRequestDo.getResoMaterialStatInfo()).orElse(new HashMap<>());
                Map<Long, AdxStatsDo> userResoMaStatInfo = Optional.ofNullable(rcmdRequestDo.getUserResoMaterialStatInfo()).orElse(new HashMap<>());

                AdxMaterialRecallDo maRecallInfo = rcmdRequestDo.getMaterialRecallList();
                List<Long> manualMaterialList = rcmdRequestDo.getManualMaterialList();
                List<AdxIdeaMaterialId> recallList = getRecallList(ideaMaterialList, manualMaterialList, maRecallInfo);
                List<AdxIdeaMaterialId> rawList = getRawList(ideaMaterialList, maRecallInfo, ideaMaStatsList);

                AdxIdeaMaterialRankInfo rankResult = getRank(recallList, preCtrMap, ideaMaStatsList, resoMaStatInfo, userResoMaStatInfo);

                AdxIdeaMaterialId bestResult = getBestIdeaMaterial(ideaMaterialList, rankResult.getIdeaMaterial(), rawList);

                bestIdeaId = bestResult.getIdeaId();
                bestMaterialId = bestResult.getMaterialId();
                ret.setIdeaScoreMap(JSONObject.toJSONString(rankResult));
            }


            //组装推荐结果相关信息
            Map<String, String> combineFeatureMap = new HashMap<String, String>();
            AdxIdeaMaterialId bestIdeaMaterial = new AdxIdeaMaterialId(bestIdeaId, bestMaterialId);
            FeatureMapDo bestFeature = featureMap.get(bestIdeaMaterial);
            if (AssertUtil.isNotEmpty(bestFeature) && AssertUtil.isAllNotEmpty(bestFeature.getStaticFeatureMap(), bestFeature.getDynamicFeatureMap())) {
                combineFeatureMap.putAll(bestFeature.getStaticFeatureMap());
                combineFeatureMap.putAll(bestFeature.getDynamicFeatureMap());
            }

            ret.setIdeaId(bestIdeaId);
            ret.setMaterialId(bestMaterialId);
            ret.setGiveUpType(giveUpType);
            ret.setIdeaFeatureMap(combineFeatureMap);

            ret.setPreCtr(preCtrMap.get(bestIdeaMaterial));
            ret.setPreClickValue(preCvaMap.get(bestIdeaMaterial));
            ret.setStatCtr(ideaStatCtrMap.get(bestIdeaId));
            ret.setStatClickValue(ideaStatCvaMap.get(bestIdeaId));
            ret.setStatCtrResource(resoStatCtr);
            ret.setStatClickValueResource(resoStatCva);

            ret.setIdeaAppStatCtr(ideaAppStatCtrMap.get(bestIdeaId));
            ret.setIdeaAppStatCva(ideaAppStatCvaMap.get(bestIdeaId));
            ret.setResoAppStatCtr(resoAppStatCtr);
            ret.setResoAppStatCva(resoAppStatCva);

            ret.setFeatureMapDo(bestFeature);


        } catch (Exception e) {

            logger.error("IdeaRcmdAlg.getIdeaRcmd error", e);
        }
        return ret;
    }


    /**
     * 校验基础信息是否合法
     *
     * @param rcmdRequestDo
     * @return
     */
    private static Long getGiveUpType(AdxIdeaRcmdRequestDo rcmdRequestDo) {

        Long ret = null;

        if (rcmdRequestDo == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params adxIdeaRcmdRequestDo is null");
            return 1L;
        }

        if (rcmdRequestDo.getPutType() == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params putType is null");
            return 1L;
        }

        if (rcmdRequestDo.getFmModel() == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params fmModel is null");
            return 2L;
        }

        if (rcmdRequestDo.getPutType() != 4 && rcmdRequestDo.getCoderModel() == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params putType is {}, params coderModel is null", rcmdRequestDo.getPutType());
            return null;
        }

        if (rcmdRequestDo.getPutType() != 4 && rcmdRequestDo.getLtfModel() == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params putType is {}, params ltfModel is null", rcmdRequestDo.getPutType());
            return null;
        }

        if (rcmdRequestDo.getPutType() != 4
                && CollectionUtils.isEmpty(rcmdRequestDo.getStaticIdeaFeatureList())) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params putType is {}, params staticIdeaFeatureList is empty", rcmdRequestDo.getPutType());
            return 5L;
        }

        if (rcmdRequestDo.getPutType() == 4
                && CollectionUtils.isEmpty(rcmdRequestDo.getStaticIdeaFeatureList())
                && CollectionUtils.isEmpty(rcmdRequestDo.getDynamicIdeaFeatureList())
        ) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params putType is {}, params staticIdeaFeatureList and dynamicIdeaFeatureList are empty", rcmdRequestDo.getPutType());
            return 5L;
        }

        if (rcmdRequestDo.getAdxFeatureDo() == null) {
            logger.error("IdeaRcmdAlg.getIdeaRcmd() input params valid, params adxFeatureDo is null");
            return 6L;
        }

        return ret;
    }


    /**
     * 预估曝光价值-创意推荐1.0
     *
     * @param
     * @return
     */
    public static Map<Long, Double> getPreExpValue(List<AdxIdeaMaterialId> ideaMaList, Double resoStatCtr, Double resoStatCva,
                                                   Map<AdxIdeaMaterialId, Double> preCtrMap, Map<AdxIdeaMaterialId, Double> preCvaMap,
                                                   Map<Long, Double> ideaStatCtrMap, Map<Long, Double> ideaStatDayCtrMap,
                                                   Map<Long, Double> ideaStatCvaMap, Map<Long, Double> ideaStatDayCvaMap) {

        double preCtrWeight = 0.8, preCvaWeight = 0.2; //模型预估权重

        Map<Long, Double> preExpValueMap = new HashMap<>();
        if (CollectionUtils.isEmpty(ideaMaList)) {
            return preExpValueMap;
        }

        for (AdxIdeaMaterialId key : ideaMaList) {
            Long ideaId = key.getIdeaId();

            Double pCtr = preCtrMap.get(key);
            Double sCtr = AdxStatData.nullToDefault(AdxStatData.nullToDefault(ideaStatCtrMap.get(ideaId), ideaStatDayCtrMap.get(ideaId)), resoStatCtr);
            Double conCtr = AdxStatData.getConCtr(pCtr, sCtr, preCtrWeight, 0.0, 4.0, 0.02);

            Double pCva = preCvaMap.get(key);
            Double sCva = AdxStatData.nullToDefault(AdxStatData.nullToDefault(ideaStatCvaMap.get(ideaId), ideaStatDayCvaMap.get(ideaId)), resoStatCva);
            Double conCva = AdxStatData.getConValue(pCva, sCva, preCvaWeight, 0.0, 2.0, 1.0);

            //预估创意曝光价值
            Double preExpValue = AdxStatData.nullToMinDefault(conCtr * conCva, 0.0);
            preExpValueMap.put(ideaId, DataUtil.formatDouble(preExpValue, 6));
        }

        return preExpValueMap;
    }


    /**
     * 选择最优创意-创意推荐1.0
     *
     * @param valueMap
     * @return
     */
    public static Long getBestIdeaId(List<AdxIdeaMaterialId> ideaMaList, Map<Long, Double> valueMap) {

        Long ret = null;
        if (AssertUtil.isEmpty(ideaMaList)) {
            return ret;
        }

        if (ideaMaList.size() == 1) {
            ret = ideaMaList.get(0).getIdeaId();

        } else {

            if (AssertUtil.isNotEmpty(valueMap) && !valueMap.isEmpty()) {

                //按降序排列
                Map<Long, Double> sortedMap = AdxStatData.sortMapByValueDescend(valueMap);
                List<Long> sortedKeyList = new ArrayList<>(sortedMap.keySet());
                List<Double> sortedValueList = new ArrayList<>(sortedMap.values());

                List<Double> flowRateList = new ArrayList<>(ideaMaList.size());
                Double maxExpValue = sortedValueList.get(0);
                Double minExpValue = sortedValueList.get(ideaMaList.size() - 1);
                for (int ind = 0; ind < ideaMaList.size(); ind++) {

                    if (maxExpValue.equals(minExpValue)) {
                        flowRateList.add(weight[0]);

                    } else {

                        if (ind < weight.length) {
                            flowRateList.add(weight[ind]);
                        } else {
                            flowRateList.add(weight[weight.length - 1]);
                        }

                        if (ind >= 1 && sortedValueList.get(ind).equals(sortedValueList.get(ind - 1))) {
                            flowRateList.set(ind, flowRateList.get(ind - 1));
                        }
                    }
                }

                Integer retIndex = AdxStatData.flowSplit(flowRateList);
                ret = sortedKeyList.get(retIndex);
            }
        }

        return ret;
    }


    /**
     * 获取可投放创意素材集合
     *
     * @param staticIdeaList  静态创意素材
     * @param dynamicIdeaList 动态创意素材
     * @return
     */
    public static List<AdxIdeaFeatureDo> getIdeaList(List<AdxIdeaFeatureDo> staticIdeaList,
                                                     List<AdxIdeaFeatureDo> dynamicIdeaList) {

        List<AdxIdeaFeatureDo> ret = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(staticIdeaList)) {
            ret = staticIdeaList;
        }
        if (CollectionUtils.isNotEmpty(dynamicIdeaList)) {
            ret = Stream.of(ret, dynamicIdeaList).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        }

        return ret;

    }


    /**
     * 解析特征map
     *
     * @param adxFeatureDo 静态特征
     * @param ideaList     动态特征
     * @return
     */
    public static Map<AdxIdeaMaterialId, FeatureMapDo> getFeatureMap(AdxFeatureDo adxFeatureDo,
                                                                     List<AdxIdeaFeatureDo> ideaList,
                                                                     Map<Long, AdxStatsDo> ideaAppStatsList) {

        Map<AdxIdeaMaterialId, FeatureMapDo> featureMap = new HashMap<>();

        //1 非创意特征：静态特征解析
        Map<String, String> staticFeatureMap = AdxFeatureParse.generateFeatureMapStatic(adxFeatureDo);

        //2 创意特征：动态特征解析
        if (AssertUtil.isEmpty(ideaList)) {
            return featureMap;
        }
        for (AdxIdeaFeatureDo ideaDo : ideaList) {
            Long ideaId = ideaDo.getIdeaId();
            Long materialId = AdxStatData.nullToDefault(ideaDo.getMaterialId(), -1L);
            AdxIdeaMaterialId ideaMaterial = new AdxIdeaMaterialId(ideaId, materialId);

            AdxFeatureDo dynamicDo = new AdxFeatureDo();
            dynamicDo.setIdeaId(ideaId); // 创意ID f3010010
            dynamicDo.setButtonText(ideaDo.getButtonText()); // 按钮文字 f3010020
            dynamicDo.setIconH(ideaDo.getIconH()); // 创意图标高 f3010030
            dynamicDo.setIconW(ideaDo.getIconW()); // 创意图标宽 f3010040
            dynamicDo.setMjPicType(ideaDo.getMjPicType()); // 规格类型 f3010050
            dynamicDo.setIdeaPicH1(ideaDo.getIdeaPicH1()); // 创意图片高1 f3010060
            dynamicDo.setIdeaPicW1(ideaDo.getIdeaPicW1()); // 创意图片宽1 f3010070
            dynamicDo.setIdeaPicH2(ideaDo.getIdeaPicH2()); // 创意图片高2 f3010080
            dynamicDo.setIdeaPicW2(ideaDo.getIdeaPicW2()); // 创意图片宽2 f3010090
            dynamicDo.setIdeaPicH3(ideaDo.getIdeaPicH3()); // 创意图片高3 f3010100
            dynamicDo.setIdeaPicW3(ideaDo.getIdeaPicW3()); // 创意图片宽3 f3010110
            dynamicDo.setIdeaPicNum(ideaDo.getIdeaPicNum()); // 创意图片个数 f3010120
            dynamicDo.setStyleStandard(String.valueOf(ideaDo.getStyleStandard())); // 广告样式规格 f3010130
            dynamicDo.setIdeaType(ideaDo.getIdeaType()); // 互动创意类型 f3010140
            dynamicDo.setPictureType(ideaDo.getPictureType()); //素材图片类型（1=图片 3=视频）f3030000
            dynamicDo.setMaterialId(materialId);
            dynamicDo.setPictureMaterialDo(ideaDo.getPictureMaterialDo()); //创意图片素材特征
            dynamicDo.setVideoMaterialDo(ideaDo.getVideoMaterialDo()); //创意视频素材特征

            //创意活动参与数据
            dynamicDo.setIdeaActAccCntDay(ideaDo.getIdeaActAccCntDay());
            dynamicDo.setIdeaActJoinCntDay(ideaDo.getIdeaActJoinCntDay());
            dynamicDo.setIdeaActAccCntWeek(ideaDo.getIdeaActAccCntWeek());
            dynamicDo.setIdeaActJoinCntWeek(ideaDo.getIdeaActJoinCntWeek());

            dynamicDo.setActIdeaActAccCntDay(ideaDo.getActIdeaActAccCntDay());
            dynamicDo.setActIdeaActJoinCntDay(ideaDo.getActIdeaActJoinCntDay());
            dynamicDo.setActIdeaActAccCntWeek(ideaDo.getActIdeaActAccCntWeek());
            dynamicDo.setActIdeaActJoinCntWeek(ideaDo.getActIdeaActJoinCntWeek());

            //创意+分媒体行为特征
            AdxStatsDo ideaAppStats = ideaAppStatsList.get(ideaId);
            AdxIndexStatsDo ideaApp1DayInfo = AdxStatData.getAdxTimeIndex(ideaAppStats, "1day");
            dynamicDo.setIdeaAppExpCntDay(ideaApp1DayInfo.getExpCnt()); //创意+百度appId 当天曝光次数
            dynamicDo.setIdeaAppClickCntDay(ideaApp1DayInfo.getClickCnt()); //创意+百度appId 当天点击次数
            dynamicDo.setIdeaAppAdCostDay(ideaApp1DayInfo.getAdvertConsume()); //创意+百度appId 当天广告消耗
            Map<String, String> dynamicFeatureMap = AdxFeatureParse.generateFeatureMapDynamic(dynamicDo, adxFeatureDo);

            //3 封装创意素材特征集合
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMap.put(ideaMaterial, featureMapDo);
        }

        return featureMap;
    }


    /**
     * 根据召回素材集，取交集后的候选集
     *
     * @param
     * @return
     */
    public static List<AdxIdeaMaterialId> getRecallList(List<AdxIdeaMaterialId> ideaMaList,
                                                        List<Long> manualMaterialList,
                                                        AdxMaterialRecallDo recallInfo) {

        if (CollectionUtils.isEmpty(ideaMaList)) {
            return null;
        }

        if (AssertUtil.isEmpty(recallInfo) || CollectionUtils.isEmpty(recallInfo.getRecallList())) {
            return ideaMaList;
        }

        List<AdxIdeaMaterialId> ret = new ArrayList<>();
        Set<Long> recallList = recallInfo.getRecallList();
        // todo:zhixiong
        recallList.addAll(manualMaterialList);//增加人工配置素材id
//        recallList.add(-1L); //增加人工配置素材id
        ideaMaList.forEach(ideaMaterial -> {
            boolean isPresent = recallList.stream().anyMatch(materialId -> materialId.equals(ideaMaterial.getMaterialId()));
            if (isPresent) {
                ret.add(ideaMaterial);
            }
        });

        return ret;
    }



    /**
     * 新创意素材试投池-创意推荐3.0
     *
     * @param
     * @return
     */
    public static List<AdxIdeaMaterialId> getRawList(List<AdxIdeaMaterialId> ideaMaList,
                                                     AdxMaterialRecallDo recallInfo,
                                                     Map<AdxIdeaMaterialId, AdxStatsDo> ideaMaStatsList) {

        long expLimit = 20L; //创意+素材 近1天曝光阈值

        if (CollectionUtils.isEmpty(ideaMaList)) {
            return null;
        }

        if (AssertUtil.isEmpty(recallInfo) || CollectionUtils.isEmpty(recallInfo.getRawList())) {
            return null;
        }

        Set<AdxIdeaMaterialId> ret = new HashSet<>();
        Set<Long> rawList = recallInfo.getRawList();
        ideaMaList.forEach(ideaMaterial -> {
            boolean isPresent = rawList.stream().anyMatch(materialId -> materialId.equals(ideaMaterial.getMaterialId()));
            if (isPresent) {
                ret.add(ideaMaterial);
            }

            AdxStatsDo ideaMaStats = Optional.ofNullable(ideaMaStatsList.get(ideaMaterial)).orElse(new AdxStatsDo());
            AdxIndexStatsDo ma1DayInfo = AdxStatData.getAdxTimeIndex(ideaMaStats, "1day");
            if (ma1DayInfo.getExpCnt() < expLimit) {
                ret.add(ideaMaterial);
            }

        });

        List<AdxIdeaMaterialId> uniqueRet = ret.stream().collect(Collectors.toList());
        return uniqueRet;
    }




    /**
     * 创意素材排序-创意推荐3.0
     *
     * @param
     * @return
     */
    public static AdxIdeaMaterialRankInfo getRank(List<AdxIdeaMaterialId> ideaMaList,
                                                  Map<AdxIdeaMaterialId, Double> preCtrMap,
                                                  Map<AdxIdeaMaterialId, AdxStatsDo> ideaMaStatsList,
                                                  Map<Long, AdxStatsDo> resoMaStatInfo,
                                                  Map<Long, AdxStatsDo> userResoMaStatInfo) {

        AdxIdeaMaterialRankInfo ret = new AdxIdeaMaterialRankInfo();

        double preWeight = 0.8; //模型预估权重
        double ctrWeight = 0.9; //ctr得分占比
        long expLimit = 10L; //用户+资源位+素材 当天曝光阈值

        double tmpScore = -1000000.0;

//        boolean flag = false;
//        if(ideaMaList.stream().anyMatch(idea -> idea.getIdeaId()==20263L)) {
//            flag = true;
//        }
        for (AdxIdeaMaterialId ideaMaterial : ideaMaList) {

            Long materialId = ideaMaterial.getMaterialId();

            AdxStatsDo ideaMaStats = Optional.ofNullable(ideaMaStatsList.get(ideaMaterial)).orElse(new AdxStatsDo());
            AdxIndexStatsDo ma20MinInfo = AdxStatData.getAdxTimeIndex(ideaMaStats, "20min");
            AdxIndexStatsDo ma1DayInfo = AdxStatData.getAdxTimeIndex(ideaMaStats, "1day");

            AdxStatsDo resoMaStats = Optional.ofNullable(resoMaStatInfo.get(materialId)).orElse(new AdxStatsDo());
            AdxIndexStatsDo resoMa20MinInfo = AdxStatData.getAdxTimeIndex(resoMaStats, "20min");

            AdxStatsDo userResoMaStats = Optional.ofNullable(userResoMaStatInfo.get(materialId)).orElse(new AdxStatsDo());
            AdxIndexStatsDo userResoMa1DayInfo = AdxStatData.getAdxTimeIndex(userResoMaStats, "1day");

            Double pCtr = preCtrMap.get(ideaMaterial);
            Double sCtr = AdxStatData.nullToDefault(AdxStatData.nullToDefault(ma20MinInfo.getCtr(), ma1DayInfo.getCtr()), resoMa20MinInfo.getCtr());
            Double ctrScore = AdxStatData.getConCtr(pCtr, sCtr, preWeight, 0.0, 4.0, 0.02);
            Double roiScore = AdxStatData.nullToDefault(AdxStatData.nullToDefault(ma20MinInfo.getRoi(), ma1DayInfo.getRoi()), resoMa20MinInfo.getRoi());
            Double rpmScore = AdxStatData.nullToDefault(AdxStatData.nullToDefault(ma20MinInfo.getRpm(), ma1DayInfo.getRpm()), resoMa20MinInfo.getRpm());

            // 精排得分：ctr与rpm/roi融合
            //Double rankScore = ctrWeight * ctrScore + (1 - ctrWeight) * AdxStatData.nullToDefault(roiScore, 1.0);
            Double rankScore = ctrWeight * ctrScore + (1 - ctrWeight) * AdxStatData.nullToDefault(rpmScore, 0.0);

            // 重排得分：多次曝光降权
            //Double reRankScore = rankScore * DataUtil.division(expLimit, (expLimit + userResoMa1DayInfo.getExpCnt()));
            Double reRankScore = rankScore >= 0
                    ? rankScore * DataUtil.division(expLimit, (expLimit + userResoMa1DayInfo.getExpCnt()))
                    : rankScore * (2 - DataUtil.division(expLimit, (expLimit + userResoMa1DayInfo.getExpCnt())));

            if (reRankScore > tmpScore) {
                tmpScore = reRankScore;
                ret.setIdeaMaterial(ideaMaterial);

                ret.setCtrScore(DataUtil.formatDouble(ctrScore, 6));
                ret.setRoiScore(DataUtil.formatDouble(roiScore, 6));
                ret.setRankScore(DataUtil.formatDouble(rankScore, 6));
                ret.setReRankScore(DataUtil.formatDouble(reRankScore, 6));
            }

//            if(flag) {
//                logger.info("rmcd badcase ideaId:{}, rankScore:{}, ctrScore:{}, rpmScore:{}", ideaMaterial.getIdeaId(), rankScore, ctrScore, rpmScore);
//            }
        }

        if (AssertUtil.isEmpty(ret.getIdeaMaterial()) && ideaMaList.size() > 0) {
            int randomInd = ThreadLocalRandom.current().nextInt(0, ideaMaList.size());
            ret.setIdeaMaterial(ideaMaList.get(randomInd));
        }

        return ret;
    }




    /**
     * 获取推荐结果-创意推荐3.0
     *
     * @param
     * @return
     */
    public static AdxIdeaMaterialId getBestIdeaMaterial(List<AdxIdeaMaterialId> ideaMaList,
                                                        AdxIdeaMaterialId rankResult,
                                                        List<AdxIdeaMaterialId> rawList) {

        double rawRate = 0.05; //试投比例

        if (AssertUtil.isAllEmpty(ideaMaList, rawList)) {
            return null;
        }

        if (AssertUtil.isEmpty(rankResult) && AssertUtil.isNotEmpty(rawList)) {
            Random random1 = new Random();
            int n1 = random1.nextInt(rawList.size());
            rankResult = ideaMaList.get(n1);
        }

        if (CollectionUtils.isEmpty(rawList)) {
            return rankResult;
        }

        Random random2 = new Random();
        int n2 = random2.nextInt(rawList.size());
        AdxIdeaMaterialId ret = Math.random() < rawRate ? rawList.get(n2) : rankResult;
        return ret;
    }
}
