package cn.com.duiba.nezha.alg.alg.kaihu;


import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import com.alibaba.fastjson.JSON;

import java.util.HashMap;
import java.util.Map;

public class KaiHuConvertFilterAlg {

    /**
     * 券点击
     *
     * @param advertId     广告计划ID
     * @param fee          券点击计费 单位：分
     * @param convertType  广告投放目标类型
     * @param chargeType   广告是否开启OCPC， 1-cpc、2-ocpc
//     * @param subType      当前获取的转化类型  0-落地页点击（注意点）、3-注册 ...等
     * @param appTargetFee 开户媒体上目标转化成本   单位：分
     * @param roi          目标ROI
     * @return 返回需要回传的次数  0-回传、1-回传1次、2-回传2次、依此类推，最大回传3次（）
     */
    public static int getFilterResult2(Long advertId, Integer fee, Integer convertType, Integer chargeType,
                                      Integer appTargetFee, Double roi) {
        int ret = 0;

        /**
         * 策略
         *
         * 1、判断是否需要回传，当前获取的转化类型 与 广告投放目标类型一致时，按概率回传
         * 2、计算回传概率，回传概率 =  广告投放目标成本/（开户媒体上目标转化成本 * roi)
         * 3、计算回传次数，根据回传概率计算
         * }
         */

        //roi缺失处理，默认值1.25
        if (roi == null) {
            roi = 1.25;
        }

        if (AssertUtil.isAllNotEmpty(fee, convertType, chargeType, appTargetFee)) {

            //cpc广告回传1次
            if (chargeType == 1) {
                return 1;
            }

            //ocpc广告
            if (fee > 1 && appTargetFee > 1) {
                double p = fee / (0.01 + appTargetFee * roi);

                ret = getRepeatTimes(p);
            }

        }

        //范围约束 不大于3

        if (ret > 3) {
            ret = 3;
        }

        return ret;
    }


    /**
     * @param advertId     广告计划ID
     * @param aFee         广告投放目标成本 单位：分
     * @param convertType  广告投放目标类型
     * @param chargeType   广告是否开启OCPC， 1-cpc、2-ocpc
     * @param subType      当前获取的转化类型  0-落地页点击（注意点）、3-注册 ...等
     * @param appTargetFee 开户媒体上目标转化成本   单位：分
     * @param roi          目标ROI
     * @return 返回需要回传的次数  0-回传、1-回传1次、2-回传2次、依此类推，最大回传3次（）
     */
    public static int getFilterResult(Long advertId, Integer aFee, Integer convertType, Integer chargeType,
                                      Integer subType,
                                      Integer appTargetFee, Double roi) {
        int ret = 0;

        /**
         * 策略
         *
         * 1、判断是否需要回传，当前获取的转化类型 与 广告投放目标类型一致时，按概率回传
         * 2、计算回传概率，回传概率 =  广告投放目标成本/（开户媒体上目标转化成本 * roi)
         * 3、计算回传次数，根据回传概率计算
         * }
         */

        //roi缺失处理，默认值1.25
        if (roi == null) {
            roi = 1.25;
        }

        if (AssertUtil.isAllNotEmpty(aFee, convertType, chargeType, subType, appTargetFee)) {

            //cpc广告回传1次
            if (chargeType == 1) {
                return 1;
            }

            //ocpc广告
            if (aFee > 1 && appTargetFee > 1 && (convertType == subType)) {
                double p = aFee / (0.01 + appTargetFee * roi);

                ret = getRepeatTimes(p);
            }


        }

        //范围约束 不大于3

        if (ret > 3) {
            ret = 3;
        }

        return ret;
    }


    public static int getRepeatTimes(double p) {
        int ret = 0;

        int p1 = (int) Math.floor(p);
        ret += p1;

        double p2 = p - p1;
        if (Math.random() < p2) {
            ret += 1;
        }
        return ret;
    }


    /**
     * test
     *
     * @param args
     */
    public static void main(String[] args) {

        Map<Integer, Integer> retMap = new HashMap<>();
        for (int i = 0; i < 10000; i++) {
            int ret = getFilterResult(74603L, 4000, 4, 2, 3, 2000, 1.2);
            retMap.put(ret, 1 + retMap.getOrDefault(ret, 0));
        }

        System.out.println(JSON.toJSONString(retMap));

    }


}
