package cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorBaseDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorDo;
import lombok.Data;

import java.util.Map;

@Data
public class AdxBidReq {

    /**
     * 分流标志
     */
    private Integer groupTag;

    /**
     * 推广组ID
     */
    private Long groupId;

    /**
     * 资源位ID
     */
    private Long resId;

    /**
     * 创意计划ID
     */
    private Long ideaId;

    /**
     * 创意素材ID
     */
    private Long ideaUnitId;

    /**
     * app ID
     */
    private String appId;

    /**
     * 出价方式：1-roi出价、2-cpc出价
     */
    private Integer bidMode;

    /**
     * 创意设置的目标roi
     */
    private Double roi;

    /**
     * 创意设置的目标cpc
     */
    private Double cpc;

    /**
     * 直投cpc
     */
    private Double directCpc;

    /**
     * 预估ctr
     */
    private Double preCtr;

    /**
     * 统计ctr
     */
    private Double statCtr;

    /**
     * 统计每pv发券
     */
    private Double statLaunchPv;

    /**
     * 预估每pv发券
     */
    private Double preLaunchPv;

    /**
     * 维稳参数对象
     */
    private AdxFactorBaseDo adxFactorBaseDo;

    /**
     * 出价类型：0-人工、1-算法、2-直投
     */
    private Integer priceType;

    private Double price;

    private boolean isConfidence;

    /**
     * slot ID：联盟广告位id
     */
    private String slotId;

    /**
     * 探价因子表({分组：小数})
     * 初始化：{"1": 1.5, "2": 1.0, "3": 1.5, "4": 2.0, "5": 2.5, "6": 3.0}
     */
    private Map<String, Double> factorExploreMap;

    /**
     * 探价策略流量比例，初始化：0.1
     */
    private Double exploreFlowRate;

    /**
     * AB实验分流字段，只针对命中探价白名单的媒体
     * 原逻辑：0，对照组：1，实验组：2
     */
    private Integer expTag;

    /**
     * 空跑开关，默认为false，当为true时，实验组与对照组逻辑一致
     */
    private Boolean expSwitch;

}
