package cn.com.duiba.nezha.alg.alg.vo.ocpxControl;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import lombok.Data;

@Data
public class DeepControlParams {

    /**
     * 深度 双出价 控制参数
     */
    private Double deepFactor; //深度目标调价因子

    private Double limitDeepFactor; //限流释放媒体-深度目标调价因子

    private Double confWeight;//预估置信权重

    private Double preMergeWeight;//预估融合权重

    private Double preMergeDiffU;//预估偏离统计上限 1.2
    private Double preMergeDiffL;//预估偏离统计下限 0.9

    private Long controlType; //实际控制类型 1：成本优先  2：消耗优先  3：延迟类型处理

    private Double slotStatDcvr; //配置+广告位，离线统计转化率
    private Double pkStatDcvr; //配置，离线统计转化率


    private String updateTime;// 更新时间


    /**
     * 获取深度调价因子 流量调价
     *
     * @param params
     * @return
     */
    public static Double getDeepFactor(DeepControlParams params) {

        Double ret = null;

        if (params != null) {
            ret = params.getDeepFactor();
        }

        return ret;
    }


    /**
     * 获取深度调价因子 流量调价
     *
     * @param params
     * @return
     */
    public static DeepControlFactors getDeepFactor(DeepControlParams params, Long deepFee, Long aFee, Double preDcvr, Integer appLimitReleaseMark) {

        DeepControlFactors retDto = new DeepControlFactors();
        Double ret = null;

        if (params == null || params.getDeepFactor() == null) {
            return retDto;
        }

        ret = params.getDeepFactor();
        Double statFactor = params.getDeepFactor();

        ////限流释放媒体-深度目标调价因子
        if (appLimitReleaseMark != null && appLimitReleaseMark.equals(1) && params.getLimitDeepFactor() != null) {
            ret = params.getLimitDeepFactor();
            statFactor = params.getLimitDeepFactor();
        }

        Long controlType = params.getControlType();
        Double confWeight = params.getConfWeight();

        Double preMergeWeight = params.getPreMergeWeight();

        Double preMergeDiffU = params.getPreMergeDiffU();
        Double preMergeDiffL = params.getPreMergeDiffL();

        if (AssertUtil.isAllNotEmpty(confWeight, controlType, preDcvr, deepFee, aFee, preMergeWeight, preMergeDiffU, preMergeDiffL)) {
            //由于统计因子瞄准目标有1.15变成了1.05，预估因子这边也从1.25降至1.18，先少降点
            Double preFactor = 1.18 * deepFee * preDcvr / aFee ;

            preFactor = MathUtil.stdwithBoundary(preFactor, 0.1, 1.8);
            Double conFactor = (confWeight * preMergeWeight) * preFactor + (1 - confWeight * preMergeWeight) * statFactor;
            //根据离线数据取来的，当预估因子大于1.6时还有8%的加价空间，利用preMergeWeight实现对照组不生效
            Double goodFactor=preMergeWeight>0.1?1.08:1.0;

           if (preFactor < 1.0) {
                ret = statFactor;
           } else if (preFactor > 1.6) {
               ret = Math.max(goodFactor*conFactor, statFactor);
           } else {
                ret = Math.max(conFactor, statFactor);
            }

            ret = MathUtil.formatDouble(MathUtil.stdwithBoundary(ret, 0.5, 1.8), 5);
            retDto.setPreDeepFactor(MathUtil.formatDouble(preFactor, 5));

        }

        retDto.setDeepFactor(ret);
        retDto.setStatDeepFactor(statFactor);
        return retDto;
    }


    public static void main(String args){

        DeepControlParams params =new DeepControlParams();
    }

}
