package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.adx.rtbbid2.AdxConstant;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.*;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorBaseDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

public class AdxBid {

    private static final Logger logger = LoggerFactory.getLogger(AdxBid.class);

    public static AdxBidRet bid(AdxBidReq adxBidReq) {

        AdxBidRet ret = new AdxBidRet();

        try{
            if(!valid(adxBidReq) || (adxBidReq.getPriceType() != null && adxBidReq.getPriceType() == 2)) {
                printBidReq(adxBidReq);
            }

            //流量参数
            Integer bidMode = adxBidReq.getBidMode();
            int priceType = Optional.ofNullable(adxBidReq.getPriceType()).orElse(1);

            //维稳参数对象
            AdxFactorBaseDo factorBaseDo = Optional.ofNullable(adxBidReq.getAdxFactorBaseDo()).orElse(new AdxFactorBaseDo());    //不同的分组ID对应不同的维稳参数对象
            double factor = factorBaseDo.getFactor();
            Double cpm = factorBaseDo.getCpm();
            cpm = Optional.ofNullable(cpm).orElse(AdxConstant.DEFAULT_CPM);

            //创意参数
            Double preCtr = adxBidReq.getPreCtr();
            Double statCtr = Optional.ofNullable(adxBidReq.getStatCtr()).orElse(factorBaseDo.getStatCtr());
            Double ctr = MathUtil.mean(preCtr, statCtr, 0.9);
            ctr = Optional.ofNullable(ctr).orElse(AdxConstant.DEFAULT_CTR);

            Double preLaunchPv = adxBidReq.getPreLaunchPv();
            Double statLaunchPv = Optional.ofNullable(adxBidReq.getStatLaunchPv()).orElse(factorBaseDo.getLaunchPv());;
            Double launchPv = MathUtil.mean(preLaunchPv, statLaunchPv, 0.9);
            launchPv = Optional.ofNullable(launchPv).orElse(AdxConstant.DEFAULT_LAUNCHPV);

            Double arpu = factorBaseDo.getArpu();
            arpu = Optional.ofNullable(arpu).orElse(AdxConstant.DEFAULT_ARPU);


            Double cpc = priceType == 1 ? adxBidReq.getCpc() : adxBidReq.getDirectCpc();
            Double roi = MathUtil.division(adxBidReq.getRoi(), 100L, 3);

            Integer expTag = adxBidReq.getAdxExploreDo().getExpTag();
            boolean expSwitch = adxBidReq.getAdxExploreDo().isExpSwitch();

            // 如果是探价流量，则根据比例随机选择探价分桶，实验桶的比例固定为全局流量的2%
            if (expTag == 2 && !expSwitch) {
                getPriceExploreFactor(adxBidReq, ret);
            }

            Double price;
            if(priceType == 1) {    //互动出价
                price = bidMode == 1 ?
                        getRoiPrice(ctr, factor, launchPv, arpu, roi, expTag, ret.getPriceFactor(), expSwitch) :
                        getCpcPrice(ctr, cpc, factor, expTag, ret.getPriceFactor(), expSwitch);
            }else if (priceType == 2) {
                price = getDirectPrice(ctr, cpc, factor, roi, expTag, ret.getPriceFactor(), expSwitch);  //直投出价
            }else {
                price = adxBidReq.getPrice();
            }


            logger.info("priceExploreExpTag{} ,level{}, price{}, appId{}, slotId{}, expSwitch{}, factorExploreMap{}", expTag, ret.getLevel(), price, adxBidReq.getAppId(), adxBidReq.getSlotId(), expSwitch, adxBidReq.getAdxExploreDo().getFactorExploreMap());


            price = Math.min(price, 50 * cpm);
            Double rankScore = !adxBidReq.isConfidence()  ? price * 2 : price;


            ret.setAdxAlgoPrice(Math.round(price));
            ret.setArpu(arpu);
            ret.setCtr(ctr);
            ret.setPreCtr(preCtr);
            ret.setStatCtr(statCtr);
            ret.setLaunchPv(launchPv);
            ret.setPreLaunchPv(preLaunchPv);
            ret.setStatLaunchPv(statLaunchPv);
            ret.setFactor(factor);
            ret.setIdeaId(adxBidReq.getIdeaId());
            ret.setIdeaUnitId(adxBidReq.getIdeaUnitId());
            ret.setRankScore(rankScore);
        }catch (Exception e) {
            logger.error("AdxBid.bid error", e);
        }
        return ret;
    }

    public static List<AdxBidReq> buildAdxBidReq(AdIdeaDo adIdeaDo, AdxFactorBaseDo factorBaseDo, AdxAppReqDo adxAppReqDo, Map<Long, AdxStatsDo> adxStatsDoMap) {

        List<AdxBidReq> adxBidReqs = new ArrayList<>();
        List<IdeaUnitDo> ideaUnitDos = adIdeaDo.getIdeaUnitDos();

        for(IdeaUnitDo ideaUnitDo : ideaUnitDos) {
            AdxBidReq adxBidReq = new AdxBidReq();
            adxBidReq.setAdxFactorBaseDo(factorBaseDo);
            BeanUtils.copy(adxAppReqDo, adxBidReq);
            BeanUtils.copy(adIdeaDo, adxBidReq);
            BeanUtils.copy(ideaUnitDo, adxBidReq);

            if(adxStatsDoMap != null) {
                AdxStatsDo adxStatsDo = adxStatsDoMap.get(ideaUnitDo.getIdeaUnitId());
                AdxIndexStatDo adxIndexStatDo = adxStatsDo.getLast1DayStat();
                adxBidReq.setStatCtr(AdxIndexStatDo.getStatCtr(adxIndexStatDo));
                adxBidReq.setStatLaunchPv(AdxIndexStatDo.getStatLaunchPv(adxIndexStatDo));
                adxBidReq.setConfidence(AdxIndexStatDo.isConfidence(adxIndexStatDo));
            }


            adxBidReqs.add(adxBidReq);
        }

        return adxBidReqs;

    }

    public static void getPriceExploreFactor(AdxBidReq adxBidReq, AdxBidRet ret) {
        Double exploreFlowRate = adxBidReq.getAdxExploreDo().getExploreFlowRate();
        if (exploreFlowRate == null) {
            logger.info("priceExploreExpTag{} ,exploreFlowRate is null", adxBidReq.getAdxExploreDo().getExpTag());
            exploreFlowRate = 0.1;
        }
        // 如果是探价流量，则根据比例随机选择探价分桶，实验桶的比例固定为全局流量的2%
        double expRate = 0.02 / exploreFlowRate; // 实验桶流量比例
        double baseRate = Math.max(1.0 - 5 * expRate, 0.0); // 基准桶流量比例
        double rand = Math.random();
        double priceFactor;
        if (rand < baseRate) {
            priceFactor = adxBidReq.getAdxExploreDo().getFactorExploreMap().getOrDefault("1", 1.5);
            ret.setPriceFactor(priceFactor);
            ret.setLevel("1");
        } else if (rand < baseRate + expRate) {
            priceFactor = adxBidReq.getAdxExploreDo().getFactorExploreMap().getOrDefault("2", 1.0);
            ret.setPriceFactor(priceFactor);
            ret.setLevel("2");
        } else if (rand < baseRate + 2 * expRate) {
            priceFactor = adxBidReq.getAdxExploreDo().getFactorExploreMap().getOrDefault("3", 1.5);
            ret.setPriceFactor(priceFactor);
            ret.setLevel("3");
        } else if (rand < baseRate + 3 * expRate) {
            priceFactor = adxBidReq.getAdxExploreDo().getFactorExploreMap().getOrDefault("4", 2.0);
            ret.setPriceFactor(priceFactor);
            ret.setLevel("4");
        } else if (rand < baseRate + 4 * expRate) {
            priceFactor = adxBidReq.getAdxExploreDo().getFactorExploreMap().getOrDefault("5", 2.5);
            ret.setPriceFactor(priceFactor);
            ret.setLevel("5");
        } else {
            priceFactor = adxBidReq.getAdxExploreDo().getFactorExploreMap().getOrDefault("6", 3.0);
            ret.setPriceFactor(priceFactor);
            ret.setLevel("6");
        }

        logger.info("priceExploreExpTag{} ,level{}, priceFactor{}, exploreFlowRate{}, appId{}, slotId{}, factorExploreMap{}, rand{}", adxBidReq.getAdxExploreDo().getExpTag(), ret.getLevel(), priceFactor, exploreFlowRate, adxBidReq.getAppId(), adxBidReq.getSlotId(), adxBidReq.getAdxExploreDo().getFactorExploreMap(), rand);
    }

    public static Double getCpcPrice(Double ctr, Double cpc, double factor, Integer expTag, double exploreFactor, boolean expSwitch) {
        if (expTag == 2 && !expSwitch) {
            return ctr * cpc * exploreFactor * 1000 * 100;
        }
        else {
            return ctr * cpc * factor * 1000 * 100;
        }
    }

    public static Double getDirectPrice(Double ctr, Double algoCpcPrice, double factor, Double roi, Integer expTag, double exploreFactor, boolean expSwitch) {
        if (expTag == 2 && !expSwitch) {
            return DataUtil.division(ctr * algoCpcPrice * exploreFactor * 1000, roi, 3);
        }
        else {
            return DataUtil.division(ctr * algoCpcPrice * factor * 1000, roi, 3);
        }
    }

    public static Double getRoiPrice(Double ctr, double factor, Double launchPv, Double arpu, Double roi, Integer expTag, double exploreFactor, boolean expSwitch) {
        if (expTag == 2 && !expSwitch) {
            return ctr * launchPv * arpu * exploreFactor / roi * 1000;
        }
        else {
            return ctr * launchPv * arpu * factor / roi * 1000;
        }
    }

    public static boolean valid(AdxBidReq adxBidReq) {
        boolean ret = true;

        if(AssertUtil.isAnyEmpty(adxBidReq, adxBidReq.getPreCtr(), adxBidReq.getPriceType())) {
            return false;
        }
        if(adxBidReq.getPriceType() == 1) {
            if (adxBidReq.getBidMode() == null) {
                return false;
            }else if(adxBidReq.getBidMode() == 1) {
                ret = adxBidReq.getRoi() != null && adxBidReq.getPreLaunchPv() != null;
            }else {
                ret = adxBidReq.getCpc() == null ? false : true;
            }
        }else if(adxBidReq.getPriceType() == 2) {
            ret = adxBidReq.getDirectCpc() != null && adxBidReq.getRoi() != null;
        }

        return ret;

    }

    public static void printBidReq(AdxBidReq adxBidReq) {

        if(Math.random() < 0.1) {
            logger.info("bidRequestDo2 is not valid, groupId:{}, resourceId:{}, ideaId:{}, appId:{}, priceType:{}, bidMode:{}, preCtr:{}, roi:{}, preLaunchPv:{}, cpc:{}, directCpc:{}",
                     adxBidReq.getGroupId(), adxBidReq.getResId(), adxBidReq.getIdeaId(), adxBidReq.getAppId(), adxBidReq.getPriceType(), adxBidReq.getBidMode(), adxBidReq.getPreCtr(), adxBidReq.getRoi()
                    , adxBidReq.getPreLaunchPv(), adxBidReq.getCpc(), adxBidReq.getDirectCpc());
        }

    }
}
