package cn.com.duiba.nezha.alg.alg.adx.rtbbid2;

import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.*;
import cn.com.duiba.nezha.alg.common.model.ocpxControl.PidController;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Map;
import java.util.Optional;

public class AdxRoiFactor {

    private static final Logger logger = LoggerFactory.getLogger(AdxRoiFactor.class);


    /**
     * 维稳定时任务，10 mins执行一次
     * 1.获取上一时刻，维稳因子对象
     * 2.获取创意+APP统计数据
     * 3.获取当前可投创意的设置数据
     * 4.更新维稳因子
     *
     * 注意：不同实验分组分别调用
     */
    public static AdxFactorDo run(AdxFactorReqDo adxFactorReqDo) {
        //上一时段维稳因子
        AdxFactorDo adxFactorDo = Optional.ofNullable(adxFactorReqDo.getAdxFactorDo()).orElse(new AdxFactorDo());

        try{
            //创意设置数据
            Map<Long, Map<Long, AdxIdeaDo>> resIdeaDoMap = adxFactorReqDo.getResIdeaDoMap();

            resIdeaDoMap.forEach((resId, adxIdeaDoMap) -> {

                String prefix1 = "resId" + resId;
                AdxFactorSubDo resFactorSubDo = adxFactorDo.getFactorSubDo(resId, 1);
                AdxStatDo resStatDo = adxFactorReqDo.getStatDo(resId, 1);
                runFactor(resFactorSubDo, resStatDo, new AdxIdeaDo(), prefix1);
                adxFactorDo.putFactorSubDo(resId, resFactorSubDo, 1);

                adxIdeaDoMap.forEach((ideaId, adxIdeaDo) -> {

                    String prefix2 = "ideaId" + ideaId;
                    AdxFactorSubDo ideaFactorSubDo = adxFactorDo.getFactorSubDo(ideaId, 0);
                    AdxStatDo ideaStatDo = adxFactorReqDo.getStatDo(ideaId, 0);

                    runFactor(ideaFactorSubDo, ideaStatDo, adxIdeaDo, prefix2);
                    adxFactorDo.putFactorSubDo(ideaId, ideaFactorSubDo, 0);

                });

            });
        }catch (Exception e) {
            logger.error("AdxRoiFactor.run error:" , e);
        }


        return adxFactorDo;
    }

    public static void runFactor(AdxFactorSubDo adxFactorSubDo,AdxStatDo adxStatDo, AdxIdeaDo adxIdeaDo, String prefix) {

        try{

            if(AssertUtil.isAnyEmpty(adxFactorSubDo, adxStatDo, adxIdeaDo)) {
                return;
            }

            /**
             * 获取目标roi/cpc
             */
            if(adxIdeaDo == null) {adxIdeaDo = new AdxIdeaDo();}
            Integer bidMode = adxIdeaDo.getBidMode();
            Double target = AdxIdeaDo.getTarget(adxIdeaDo);
            //是否重置
            boolean reset = false;
            if(bidMode != null && target != null && adxFactorSubDo.getAdxIdeaDo() != null && !adxIdeaDo.equals(adxFactorSubDo.getAdxIdeaDo())) {
                reset = true;
            }

            /**
             * 获取统计数据
             */
            //20分钟
            AdxStatSubDo statSubDoMins = adxStatDo.getStatSubDo1();
            AdxStatBaseDo statBaseDoMins = statSubDoMins.getAdxStatBaseDo();

            //当日
            AdxStatSubDo statSubDoDay = adxStatDo.getStatSubDo2();
            AdxStatBaseDo statBaseDoDay = statSubDoDay.getAdxStatBaseDo();

            //近三日
            AdxStatSubDo statSubDo3Day = adxStatDo.getStatSubDo3();
            AdxStatBaseDo statBaseDo3Days = statSubDo3Day.getAdxStatBaseDo();

            AdxFactorBaseDo factorBaseDo = adxFactorSubDo.getFactorBaseDo();

            prefix = prefix + ",bidMode" + bidMode + ",target" + target;

            getFactor(prefix,target, factorBaseDo, null, bidMode,statBaseDoMins, statBaseDoDay, statBaseDo3Days, reset);

            /**
             * 获取创意 + 媒体维度统计数据
             */
            Map<String, AdxStatBaseDo> adxStatBaseDoMap = statSubDoMins.getAdxStatBaseDoMap();

            if(AssertUtil.isNotEmpty(adxStatBaseDoMap)) {
                boolean finalReset = reset;
                String finalPrefix = prefix;
                adxStatBaseDoMap.forEach((appId, appStatBaseDo) -> {
                    String prefix1 = finalPrefix + ",appId" + appId;
                    AdxFactorBaseDo appFactor = adxFactorSubDo.getAppFactor(appId);
                    AdxStatBaseDo appStatBaseDoDay = statSubDoDay.getStatBaseDo(appId);
                    AdxStatBaseDo appStatBaseDo3Days = statSubDo3Day.getStatBaseDo(appId);

                    getFactor(prefix1, target, appFactor, factorBaseDo, bidMode, appStatBaseDo, appStatBaseDoDay, appStatBaseDo3Days, finalReset);
                    adxFactorSubDo.putAppFactor(appId, appFactor);
                });
            }


            adxFactorSubDo.setAdxIdeaDo(adxIdeaDo);
            adxFactorSubDo.setFactorBaseDo(factorBaseDo);
        }catch (Exception e) {
            logger.error("AdxRoiFactor.runFactor error:" , e);
        }


    }

    public static void getFactor(String prefix, Double target, AdxFactorBaseDo factorBaseDo, AdxFactorBaseDo factorBaseDo2, Integer bidMode, AdxStatBaseDo adxStatBaseDo, AdxStatBaseDo statBaseDoDay, AdxStatBaseDo statBaseDo3Days, boolean reset) {

        if(target != null && bidMode != null) {
            updateFactor(prefix, target, factorBaseDo, bidMode, adxStatBaseDo, statBaseDoDay, statBaseDo3Days, reset);
        }
        updateStatValue(factorBaseDo, factorBaseDo2, adxStatBaseDo, statBaseDoDay);

    }

    public static void updateFactor(String prefix, Double target, AdxFactorBaseDo factorBaseDo, Integer bidMode, AdxStatBaseDo adxStatBaseDo, AdxStatBaseDo statBaseDoDay, AdxStatBaseDo statBaseDo3Days, boolean reset) {

        try {

            if(factorBaseDo == null) {factorBaseDo = new AdxFactorBaseDo();}
            double factor = factorBaseDo.getFactor();

            //重置
            if(reset) {
                factor = 1.;
                factorBaseDo.setConfidence(true);
                factorBaseDo.setFactor(factor);
                logger.info("reset prefix{}",prefix);
                return;
            }

            //数据不置信，因子衰减
            if(!AdxStatBaseDo.isCostConfidence(statBaseDoDay) && !AdxStatBaseDo.isImpConfidence(adxStatBaseDo)) {

                factor = factor + (1 - factor) * 0.1;
                factorBaseDo.setConfidence(false);
                factorBaseDo.setFactor(factor);
                return;
            }
            //20分钟
            Double realValueMins = AdxRoiFactor.getRealValue(adxStatBaseDo, bidMode, target);

            //当日
            Double realValueDay = AdxRoiFactor.getRealValue(statBaseDoDay, bidMode, target);

            //近三日
            Double realValue3Days = AdxRoiFactor.getRealValue(statBaseDo3Days, bidMode, target);

            Double costWeigh = AdxRoiFactor.getCostWeigh(adxStatBaseDo, statBaseDoDay);
            boolean winRateStatus = AdxRoiFactor.getWinRateStatus(adxStatBaseDo, statBaseDoDay);


            /**
             * pid控制器
             */
            PidController pidController = new PidController();
            double signal = pidController.runPid2(target, realValueMins, realValueDay, realValue3Days, costWeigh);
            factor = factor + signal;

            factor = limitFactor(factor, realValueDay, target, statBaseDoDay.getAdxConsume2(), winRateStatus, prefix);
            factor = MathUtil.stdwithBoundary(factor, 0.2, 3);


            factorBaseDo.setConfidence(true);
            factorBaseDo.setFactor(factor);

            logger.info("roitask prefix{}, 20mins{}, day{}, 3days{}, factorDo{}", prefix, adxStatBaseDo, statBaseDoDay, statBaseDo3Days, factorBaseDo);

        }catch (Exception e) {
            logger.error("AdxRoiFactor.updateFactor error:", e);
        }


    }

    public static double limitFactor(double factor, Double realValueDay, Double target, Double adxCost, boolean winRateStatus, String prefix) {
        double ret = factor;
        if (AssertUtil.isAnyEmpty(realValueDay, target, adxCost)) {
            return ret;
        }

        //兜底逻辑处理
        if(realValueDay > 3 && adxCost > 50000. ) {
            ret = factor + (0.2 - factor) * 0.1;
        }else if(realValueDay/target - 1 > 0.2 && adxCost > 10000.) {
            factor = factor + (0.2 - factor) * 0.01;
            ret = Math.min(factor, 1);
        }else if(realValueDay/target - 1 < -0.05) {
            ret = factor + (3 - factor) * 0.03;
        }

        if(realValueDay/target - 1 < 0.05 || winRateStatus) {
            ret = Math.max(ret, 1);
        }

        return ret;
    }




    /**
     * 更新统计值
     * 数据不置信，继承base参数
     */
    public static void updateStatValue(AdxFactorBaseDo factorBaseDo, AdxFactorBaseDo factorBaseDo2, AdxStatBaseDo adxStatBaseDo, AdxStatBaseDo statBaseDoDay) {
        try{
            Double arpu = factorBaseDo.getArpu();
            Double launchPv = factorBaseDo.getLaunchPv();
            Double statCtr = factorBaseDo.getStatCtr();
            Double cpm = factorBaseDo.getCpm();
            Double clickValue = factorBaseDo.getClickValue();

            if(AdxStatBaseDo.isCostConfidence(statBaseDoDay)) {

                arpu = getArpu(arpu, adxStatBaseDo, statBaseDoDay);
                launchPv = getLaunchPv(launchPv, adxStatBaseDo, statBaseDoDay);
                statCtr = getStatCtr(statCtr, adxStatBaseDo, statBaseDoDay);
                cpm = getStatCpm(cpm, adxStatBaseDo, statBaseDoDay);
                clickValue = getStatClickValue(clickValue, adxStatBaseDo, statBaseDoDay);
            } else if(factorBaseDo2 != null){

                arpu = MathUtil.mean(arpu, factorBaseDo2.getArpu(), 0.9);
                launchPv = MathUtil.mean(launchPv, factorBaseDo2.getLaunchPv(), 0.9);
                statCtr = MathUtil.mean(statCtr, factorBaseDo2.getStatCtr(), 0.9);
                cpm = MathUtil.mean(cpm, factorBaseDo2.getCpm(), 0.9);
                clickValue = MathUtil.mean(clickValue, factorBaseDo2.getClickValue(), 0.9);
            }

            factorBaseDo.setArpu(arpu);
            factorBaseDo.setLaunchPv(launchPv);
            factorBaseDo.setStatCtr(statCtr);
            factorBaseDo.setCpm(cpm);
            factorBaseDo.setClickValue(clickValue);
        }catch (Exception e) {
            logger.info("AdxRoiFactor.updateStatValue:", e);
        }

    }

    /**
     * 计算统计arpu值
     * @param arpu
     * @param adxStatBaseDo
     * @param statBaseDoDay
     */
    public static Double getArpu(Double arpu, AdxStatBaseDo adxStatBaseDo, AdxStatBaseDo statBaseDoDay) {

        Double arpu1 = AdxStatBaseDo.getStatArpu(adxStatBaseDo);
        Double arpu2 = AdxStatBaseDo.getStatArpu(statBaseDoDay);
        Double statArpu = MathUtil.mean(arpu1, arpu2, 0.8);

        arpu = MathUtil.mean(arpu, statArpu, 0.8);

        return arpu;
    }

    /**
     * 计算统计每pv发券
     */
    public static Double getLaunchPv(Double launchPv, AdxStatBaseDo adxStatBaseDo, AdxStatBaseDo statBaseDoDay) {

        Double launchPv1 = AdxStatBaseDo.getStatLaunchPv(adxStatBaseDo);
        Double launchPv2 = AdxStatBaseDo.getStatLaunchPv(statBaseDoDay);
        Double statlaunchPv = MathUtil.mean(launchPv1, launchPv2, 0.8);

        launchPv = MathUtil.mean(launchPv, statlaunchPv, 0.8);

        return launchPv;
    }

    /**
     * 计算统计ctr
     */
    public static Double getStatCtr(Double ctr, AdxStatBaseDo adxStatBaseDo, AdxStatBaseDo statBaseDoDay) {

        Double ctr1 = AdxStatBaseDo.getStatCtr(adxStatBaseDo);
        Double ctr2 = AdxStatBaseDo.getStatCtr(statBaseDoDay);
        Double statCtr = MathUtil.mean(ctr1, ctr2, 0.8);

        ctr = MathUtil.mean(ctr, statCtr, 0.8);

        if(ctr != null) {
            ctr = MathUtil.stdwithBoundary(ctr, 0., 0.2);   //限制ctr范围
        }

        return ctr;
    }

    /**
     * 计算统计cpm
     */
    public static Double getStatCpm(Double cpm, AdxStatBaseDo adxStatBaseDo, AdxStatBaseDo statBaseDoDay) {
        Double cpm1 = AdxStatBaseDo.getStatCpm(adxStatBaseDo);
        Double cpm2 = AdxStatBaseDo.getStatCpm(statBaseDoDay);
        Double statCpm = MathUtil.mean(cpm1, cpm2, 0.8);

        cpm = MathUtil.mean(cpm, statCpm, 0.2);

        cpm = MathUtil.stdwithBoundary(cpm,30, 3000);

        return cpm;
    }

    /**
     * 计算统计点击价值
     */
    public static Double getStatClickValue(Double clickValue, AdxStatBaseDo adxStatBaseDo, AdxStatBaseDo statBaseDoDay) {
        Double cv1 = AdxStatBaseDo.getStatClickValue(adxStatBaseDo);
        Double cv2 = AdxStatBaseDo.getStatClickValue(statBaseDoDay);
        Double statCv = MathUtil.mean(cv1, cv2, 0.8);

        clickValue = MathUtil.mean(clickValue, statCv, 0.8);

        return clickValue;
    }



    /**
     * 计算实际roi(分成)
     * @return
     */
    public static Double getRoi(AdxStatBaseDo adxStatBaseDo) {

        Double ret = null;
        if(adxStatBaseDo != null) {
            Long advertConsume = adxStatBaseDo.getAdvertConsume();
            Double adxConsume = adxStatBaseDo.getAdxConsume2(); //注意单位
            if(adxConsume != null && adxConsume > 1000) {
                ret = DataUtil.division(adxConsume,advertConsume,3);
            }
        }
        return ret;

    }

    /**
     * 计算实际cpc
     */
    public static Double getCpc(AdxStatBaseDo adxStatBaseDo) {

        Double ret = null;
        if(adxStatBaseDo != null) {
            Long click = adxStatBaseDo.getClick();
            Double adxConsume = adxStatBaseDo.getAdxConsume2(); //注意单位
            if(adxConsume != null && adxConsume > 1000) {
                ret = DataUtil.division(adxConsume, click,3);
            }
        }
        return ret;
    }

    public static boolean getWinRateStatus(AdxStatBaseDo adxStatBaseDoMin, AdxStatBaseDo adxStatBaseDoDay) {
        boolean ret = false;

        Double winRate = AdxRoiFactor.getWinRate(adxStatBaseDoMin);
        Double winRateDay = AdxRoiFactor.getWinRate(adxStatBaseDoDay);

        if(AssertUtil.isAllNotEmpty(winRate, winRateDay)) {
            if(winRate < winRateDay * 0.5 && Math.random() < 0.3) {
                ret = true;
            }
        }
        return ret;

    }

    /**
     * 计算当日累计消耗、实时消耗比值
     * @param adxStatBaseDoMin
     * @param adxStatBaseDoDay
     * @return
     */
    public static double getCostWeigh(AdxStatBaseDo adxStatBaseDoMin, AdxStatBaseDo adxStatBaseDoDay) {
        Double ret = null;
        if(AssertUtil.isAllNotEmpty(adxStatBaseDoMin, adxStatBaseDoDay)) {
            ret = MathUtil.division(adxStatBaseDoDay.getAdxConsume3(), adxStatBaseDoMin.getAdxConsume3() , 3);
            ret = MathUtil.log(ret);
        }

        if(ret == null) {
            ret = 1.;
        }

        ret = MathUtil.stdwithBoundary(ret, 1, 10);

        return ret;
    }

    /**
     * 根据出价类型，计算实际指标
     */
    public static Double getRealValue(AdxStatBaseDo adxStatBaseDo, Integer bidMode, Double defaultValue) {
        Double ret = null;
        if(AssertUtil.isAllNotEmpty(adxStatBaseDo, bidMode)) {
            ret = bidMode == 2 ? AdxRoiFactor.getCpc(adxStatBaseDo) :AdxRoiFactor.getRoi(adxStatBaseDo) ;
        }

        if(ret == null) {
            ret = defaultValue;
        }
        return ret;
    }

    /**
     * 统计值融合: 实时、当日、近三日
     */
    public static Double getStatValue(Double... values) {

        Double ret = null;

        double sum = 0.;
        int cnt = 0;
        for(Double v : values) {
            if(v != null) {
                sum += v;
                cnt++;
            }
        }
        ret = MathUtil.division(sum, cnt, 3);

        return ret;
    }

    /**
     * 获取竞价成功率
     */
    public static Double getWinRate(AdxStatBaseDo adxStatBaseDo) {
        Double ret = null;
        if(adxStatBaseDo != null) {
            ret = DataUtil.division(adxStatBaseDo.getExp(), adxStatBaseDo.getBid(), 3);
        }
        return ret;
    }

}
