package cn.com.duiba.nezha.alg.alg.cpcautobidding;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import org.slf4j.LoggerFactory;

public class CpcAutoBidding {

    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(CpcAutoBidding.class);

    /**
     * 设置目标出价的配置，根据成本和排序分提价；没有设置目标转化出价的配置，根据排序分和AE设置的提价空间提价
     * @param cpcAutoBiddingInfo
     * @param cpcAutoBiddingParams:nezha读redis的数据
     * @return
     */

    public static CpcAutoBiddingResult cpcAutoBiddingFactor(CpcAutoBiddingInfo cpcAutoBiddingInfo,
                                                      Double lastCpcAutoBiddingFactor,
                                                      CpcAutoBiddingParams cpcAutoBiddingParams){

        CpcAutoBiddingResult ret = new CpcAutoBiddingResult();
        if (AssertUtil.isEmpty(cpcAutoBiddingInfo)) {
            return ret;
        }

        if (Math.random()<0.0001) {
            logger.info("params cpcAutoBiddingParams:{}", cpcAutoBiddingParams);
        }

        // 排序分占比和成本F
        try {

            ret = getRankScroreRatio(cpcAutoBiddingInfo);

        } catch (Exception e) {
            logger.warn("getRankScroreRatio happend error,cpcAutoBiddingInfo={}", JSON.toJSONString(cpcAutoBiddingInfo), e);
        }


        //
        if (lastCpcAutoBiddingFactor != null && lastCpcAutoBiddingFactor != 0) {
            ret.setCpcAutoBiddingFactor(lastCpcAutoBiddingFactor);
        }
        if (cpcAutoBiddingInfo.autoBiddingType != null && cpcAutoBiddingInfo.autoBiddingType == 1) {
            updateFactor1(ret,cpcAutoBiddingParams);}
        if (cpcAutoBiddingInfo.autoBiddingType != null &&  cpcAutoBiddingInfo.autoBiddingType == 2) {
            updateFactor2(ret,cpcAutoBiddingParams);}

        if (Math.random()<0.00001) {
            logger.info("cpcAutoBidding cpcAutoBiddingFactor:{}", ret);
        }


        return ret;

    }


    /**
     *
     * @param cpcAutoBiddingInfo
     * @return
     */
    public static CpcAutoBiddingResult getRankScroreRatio(CpcAutoBiddingInfo cpcAutoBiddingInfo){

        CpcAutoBiddingResult ret = new CpcAutoBiddingResult();

        Double rankScoreRatio = 0.01;
        Double costConvert = 1.0;

        //计算成本偏差和排序分比例
        Double orientCostConvertToday = (cpcAutoBiddingInfo.orientConvertToday!= 0) ? ((double)cpcAutoBiddingInfo.orientCostToday / (double)cpcAutoBiddingInfo.orientConvertToday) : (double)cpcAutoBiddingInfo.orientCostToday;
        Double orientCostConvertBias = (cpcAutoBiddingInfo.target!= 0) ? orientCostConvertToday / cpcAutoBiddingInfo.target : 1.0;

        Double orientCostConvertHour = (cpcAutoBiddingInfo.orientConvertHour!= 0) ? ((double)cpcAutoBiddingInfo.orientCostHour / (double)cpcAutoBiddingInfo.orientConvertHour) : (double)cpcAutoBiddingInfo.orientCostHour;
        Double orientCostConvertHourBias = (cpcAutoBiddingInfo.target!= 0) ? orientCostConvertHour / cpcAutoBiddingInfo.target : 1.0;

        Double orientAppCostConvertToday = (cpcAutoBiddingInfo.orientAppConvertToday!= 0) ? ((double)cpcAutoBiddingInfo.orientAppCostToday / (double)cpcAutoBiddingInfo.orientAppConvertToday) : (double)cpcAutoBiddingInfo.orientAppCostToday;
        Double orientAppCostConvertBias = (cpcAutoBiddingInfo.target!= 0) ? orientAppCostConvertToday / cpcAutoBiddingInfo.target : 1.0;

        Double orientAppCostConvertHour = (cpcAutoBiddingInfo.orientAppConvertHour!= 0) ? ((double)cpcAutoBiddingInfo.orientAppCostHour / (double)cpcAutoBiddingInfo.orientAppConvertHour) : (double)cpcAutoBiddingInfo.orientAppCostHour;
        Double orientAppCostConvertHourBias = (cpcAutoBiddingInfo.target!= 0) ? orientAppCostConvertHour / cpcAutoBiddingInfo.target : 1.0;


        Double orientRankScoreRatio = (cpcAutoBiddingInfo.orientRankScore10!= 0) ? cpcAutoBiddingInfo.orientRankScore9 / cpcAutoBiddingInfo.orientRankScore10 : 10*cpcAutoBiddingInfo.orientRankScore9;

        Double orientHourRankScoreRatio = (cpcAutoBiddingInfo.orientHourRankScore10!= 0) ? cpcAutoBiddingInfo.orientHourRankScore9 / cpcAutoBiddingInfo.orientHourRankScore10 : 10*cpcAutoBiddingInfo.orientHourRankScore9;

        Double orientAppRankScoreRatio = (cpcAutoBiddingInfo.orientAppRankScore10!= 0) ? cpcAutoBiddingInfo.orientAppRankScore9 / cpcAutoBiddingInfo.orientAppRankScore10 : 10*cpcAutoBiddingInfo.orientAppRankScore9;

        Double orientAppHourRankScoreRatio = (cpcAutoBiddingInfo.orientAppHourRankScore10!= 0) ? cpcAutoBiddingInfo.orientAppHourRankScore9 / cpcAutoBiddingInfo.orientAppHourRankScore10 : 10*cpcAutoBiddingInfo.orientAppHourRankScore9;

        //付费和完成的成本偏查
        Double orientCostConvert7day = (cpcAutoBiddingInfo.orientConvert7day!= 0) ? ((double)cpcAutoBiddingInfo.orientCost7day / (double)cpcAutoBiddingInfo.orientConvert7day) : (double)cpcAutoBiddingInfo.orientCost7day;
        Double orientCostConvert7Bias = (cpcAutoBiddingInfo.target!= 0) ? orientCostConvert7day / cpcAutoBiddingInfo.target : 1.0;

        Double orientAppCostConvert7day = (cpcAutoBiddingInfo.orientAppConvert7day!= 0) ? ((double)cpcAutoBiddingInfo.orientAppCost7day / (double)cpcAutoBiddingInfo.orientAppConvert7day) : (double)cpcAutoBiddingInfo.orientAppCost7day;
        Double orientAppCostConvert7Bias = (cpcAutoBiddingInfo.target!= 0) ? orientAppCostConvert7day / cpcAutoBiddingInfo.target : 1.0;


        if(cpcAutoBiddingInfo.orientAppBiddingCntToday > 1000) {
            costConvert = 0.8 * orientAppCostConvertBias + 0.2 * orientCostConvertBias;
            if (cpcAutoBiddingInfo.orientAppBiddingCntHour > 1000) {
                costConvert = 0.8 * orientAppCostConvertHourBias + 0.2 * orientAppCostConvertBias;
                rankScoreRatio = 0.8 * orientAppHourRankScoreRatio + 0.2 * orientAppRankScoreRatio;
            } else if (cpcAutoBiddingInfo.orientBiddingCntHour > 1000) {
                rankScoreRatio = 0.8 * orientHourRankScoreRatio + 0.2 * orientAppRankScoreRatio;
            } else {
                rankScoreRatio = orientAppRankScoreRatio;
            }
        }
        else  {
            costConvert = orientCostConvertBias;
            if (cpcAutoBiddingInfo.orientBiddingCntHour > 1000) {
                costConvert = orientCostConvertHourBias;
                rankScoreRatio = 0.8 * orientHourRankScoreRatio + 0.2 * orientRankScoreRatio;
            } else {
                rankScoreRatio = orientRankScoreRatio;
            }
        }

        if(cpcAutoBiddingInfo.convertType == 6 || cpcAutoBiddingInfo.convertType == 8 ) {
            if(cpcAutoBiddingInfo.orientAppConvert7day > 40L) {
                costConvert = orientAppCostConvert7Bias;
            } else {
                costConvert = orientCostConvert7Bias;
            }
            if (Math.random()<0.01) {
                logger.info("cpcAutoBidding converttype68:{}", costConvert);
            }
        }

        ret.setRankScroreRatio(rankScoreRatio);
        ret.setCostConvert(costConvert);

        return ret;
    }


    /**
     * 更新提价因子：深度优化模式
     * @param cpcAutoBiddingResult
     * @param cpcAutoBiddingParams
     */
    public static void updateFactor1(CpcAutoBiddingResult cpcAutoBiddingResult,CpcAutoBiddingParams cpcAutoBiddingParams){

        Double ret = 1.0;

        Double totalLearnRate = cpcAutoBiddingParams.totalLearnRate1;//0.85
        Double factorLowerLimit = cpcAutoBiddingParams.fatorLowerLimit1;//1.05;
        Double factorUpperLimit = cpcAutoBiddingParams.fatorUpperLimit1;//1.25;

        Double rankScroreRatioLimit = cpcAutoBiddingParams.rankScroreRatioLimit1;//;
        Double costConvertLimit = cpcAutoBiddingParams.costConvertLimit;//;0.95

        if (cpcAutoBiddingResult == null) {
            return;
        }

        Double cpcAutoBiddingFactor = cpcAutoBiddingResult.getCpcAutoBiddingFactor();
        if (cpcAutoBiddingFactor == null) {
            cpcAutoBiddingFactor = 1.0;
        }

        Double rankScroreRatio = cpcAutoBiddingResult.rankScroreRatio;
        Double costConvert = cpcAutoBiddingResult.costConvert;

        if ((costConvert > 0 && costConvert < 1.15 && rankScroreRatio >= rankScroreRatioLimit)
                || (costConvert > 0 && costConvert < costConvertLimit) ){

            Double totalFactor1 = MathBase.noiseSmoother(rankScroreRatio/(costConvert*costConvert), 0.15, 0.4);

            Double totalFactor = totalLearnRate + totalFactor1;
            ret = cpcAutoBiddingFactor * totalFactor;
            ret = MathBase.noiseSmoother(ret, factorLowerLimit, factorUpperLimit);
        }

        if ((rankScroreRatio > 0 && rankScroreRatio < rankScroreRatioLimit) && (costConvert > 0 && costConvert > costConvertLimit)){
//        if (rankScroreRatio < rankScroreRatioLimit || costConvert > costConvertLimit){

            Double totalFactor1 = MathBase.noiseSmoother(rankScroreRatio/(costConvert*costConvert), 0.08, 0.15);

            Double totalFactor = totalLearnRate + totalFactor1;
            ret = cpcAutoBiddingFactor * totalFactor;
            if (costConvert > 1.3) {
                ret = 1.0;
            }
            ret = MathBase.noiseSmoother(ret, 1.0, 1.05);
        }

        ret = DataUtil.formatDouble(ret,4);

        cpcAutoBiddingResult.setCpcAutoBiddingFactor(ret);


    }


    /**
     * 更新提价因子：溢价模式
     * @param cpcAutoBiddingResult
     * @param cpcAutoBiddingParams
     */
    public static void updateFactor2(CpcAutoBiddingResult cpcAutoBiddingResult,CpcAutoBiddingParams cpcAutoBiddingParams){



        Double ret = 1.0;

        Double totalLearnRate = cpcAutoBiddingParams.totalLearnRate2;//0.85
        Double factorLowerLimit = cpcAutoBiddingParams.fatorLowerLimit2;//1.0;
        Double factorUpperLimit = cpcAutoBiddingParams.fatorUpperLimit2;//1.15;

        Double rankScroreRatioLimit = cpcAutoBiddingParams.rankScroreRatioLimit2;//1.5;

        if (cpcAutoBiddingResult == null) {
            return;
        }

        Double cpcAutoBiddingFactor = cpcAutoBiddingResult.getCpcAutoBiddingFactor();
        if (cpcAutoBiddingFactor == null) {
            cpcAutoBiddingFactor = 1.0;
        }

        Double rankScroreRatio = cpcAutoBiddingResult.rankScroreRatio;


        if (rankScroreRatio >= rankScroreRatioLimit){

            Double totalFactor1 = MathBase.noiseSmoother(rankScroreRatio, 0.15, 0.4);

            Double totalFactor = totalLearnRate + totalFactor1;
            ret = cpcAutoBiddingFactor * totalFactor;
            ret = MathBase.noiseSmoother(ret, factorLowerLimit, factorUpperLimit);

        }


        if (rankScroreRatio > 0 && rankScroreRatio < rankScroreRatioLimit){

            Double totalFactor1 = MathBase.noiseSmoother(rankScroreRatio, 0.08, 0.15);

            Double totalFactor = totalLearnRate + totalFactor1;
            ret = cpcAutoBiddingFactor * totalFactor;
            ret = MathBase.noiseSmoother(ret, 1.0, 1.05);
        }

        ret = DataUtil.formatDouble(ret,4);

        cpcAutoBiddingResult.setCpcAutoBiddingFactor(ret);


    }

}
