/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.vo.adx.AdxPriceExploreDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxStatData {
    private static final Logger logger = LoggerFactory.getLogger(AdxStatData.class);

    public static Map<String, Double> updatePriceExploreList(List<AdxPriceExploreDo> priceExploreDoList, List<AdxPriceExploreDo> priceExploreAppDoList, Map<String, Double> lastPriceExploreMap, Double minStepSize) {
        double stepSize;
        Double effect;
        String key;
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        if (minStepSize == null) {
            minStepSize = 0.1;
        }
        double upper = 5.0;
        double lower = 0.5;
        double bestEffect = Double.NEGATIVE_INFINITY;
        String bestKey = "-1";
        double random = Math.random();
        for (AdxPriceExploreDo levelDo : priceExploreDoList.subList(0, 5)) {
            if (!AssertUtil.isNotEmpty((Object)levelDo) || levelDo.getLevel().equals("1")) continue;
            levelDo.setRandom(random);
            key = levelDo.getLevel();
            effect = AdxPriceExploreDo.getEffect(levelDo);
            if (!AssertUtil.isNotEmpty((Object)effect) || !(effect > bestEffect)) continue;
            bestEffect = effect;
            bestKey = key;
        }
        if (bestKey.equals("-1")) {
            for (AdxPriceExploreDo levelDo : priceExploreAppDoList.subList(0, 5)) {
                if (!AssertUtil.isNotEmpty((Object)levelDo) || levelDo.getLevel().equals("1")) continue;
                levelDo.setRandom(random);
                key = levelDo.getLevel();
                effect = AdxPriceExploreDo.getEffect(levelDo);
                if (!AssertUtil.isNotEmpty((Object)effect) || !(effect > bestEffect)) continue;
                bestEffect = effect;
                bestKey = key;
            }
            if (priceExploreDoList.get(0).getSlotId().equals("7330181")) {
                logger.info("updatePriceExploreList, slot_data no confidence {}, {}", priceExploreDoList.subList(0, 5), lastPriceExploreMap);
            } else if (Math.random() < 0.01) {
                logger.info("updatePriceExploreList, slot_data no confidence {}, {}", priceExploreDoList.subList(0, 5), lastPriceExploreMap);
            }
        }
        if (bestKey.equals("-1")) {
            if (priceExploreDoList.get(0).getSlotId().equals("7330181")) {
                logger.info("updatePriceExploreList, app_data no confidence {}, {}", priceExploreAppDoList.subList(0, 5), lastPriceExploreMap);
            } else if (Math.random() < 0.01) {
                logger.info("updatePriceExploreList, app_data no confidence {}, {}", priceExploreAppDoList.subList(0, 5), lastPriceExploreMap);
            }
            return lastPriceExploreMap;
        }
        double bestFactor = MathUtil.stdwithBoundary((double)lastPriceExploreMap.getOrDefault(bestKey, -98.0), (double)lower, (double)upper);
        double oldBase = lastPriceExploreMap.getOrDefault("1", -99.0);
        double idx = lastPriceExploreMap.getOrDefault("idx", 0.0);
        double idx1 = lastPriceExploreMap.getOrDefault("idx1", 0.0);
        idx = bestFactor == oldBase ? (idx += 1.0) : 0.0;
        if (idx >= 4.0) {
            if (bestFactor >= 3.0) {
                stepSize = 5.0 * minStepSize;
                bestFactor -= 2.0 * stepSize;
                idx = 0.0;
            } else {
                stepSize = 2.0 * minStepSize;
            }
        } else {
            stepSize = MathUtil.stdwithBoundary((double)Math.abs(bestFactor - oldBase), (double)minStepSize, (double)((bestFactor - lower) / 2.0));
        }
        retMap.put("1", bestFactor);
        retMap.put("2", bestFactor - 2.0 * stepSize);
        retMap.put("3", bestFactor - stepSize);
        retMap.put("4", bestFactor);
        retMap.put("5", bestFactor + stepSize);
        retMap.put("6", bestFactor + 2.0 * stepSize);
        retMap.put("idx", idx);
        retMap.put("7", bestFactor);
        retMap.put("8", bestFactor - 2.0 * stepSize);
        retMap.put("9", bestFactor - stepSize);
        retMap.put("10", bestFactor);
        retMap.put("11", bestFactor + stepSize);
        retMap.put("12", bestFactor + 2.0 * stepSize);
        retMap.put("idx1", idx1);
        logger.info("updatePriceExploreList, curPriceMap {}, lastPriceMap{}, bestFactor{}, oldBase{}, stepSize{}, priceDoList{}", new Object[]{retMap, lastPriceExploreMap, bestFactor, oldBase, stepSize, priceExploreDoList});
        return retMap;
    }
}

