/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rtbbid2;

import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorBaseDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxIdeaDo;
import cn.com.duiba.nezha.alg.common.model.ocpxControl.PidController;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxRoiFactor {
    private static final Logger logger = LoggerFactory.getLogger(AdxRoiFactor.class);

    public static AdxFactorBaseDo run(AdxFactorReqDo adxFactorReqDo) {
        String prefix;
        if (!AdxRoiFactor.valid(adxFactorReqDo)) {
            return null;
        }
        AdxIdeaDo adxIdeaDo = adxFactorReqDo.getAdxIdeaDo();
        AdxFactorBaseDo factorBaseDo = adxFactorReqDo.getFactorBaseDo();
        AdxStatsDo adxStatsDo = adxFactorReqDo.getAdxStatsDo();
        Integer bidMode = adxIdeaDo.getBidMode();
        Double target = AdxIdeaDo.getTarget(adxIdeaDo);
        AdxIndexStatDo last20MinStat = adxStatsDo.getLast20MinStat();
        AdxIndexStatDo last1DayStat = adxStatsDo.getLast1DayStat();
        AdxIndexStatDo last3DayStat = adxStatsDo.getLast3DayStat();
        String appId = adxFactorReqDo.getAppId();
        String string = prefix = appId == null ? "ideaId" + adxIdeaDo.getIdeaId() + ",bidMode" + bidMode + ",target" + target : "ideaId" + adxIdeaDo.getIdeaId() + ",appId" + appId + ",bidMode" + bidMode + ",target" + target;
        if (!AdxIndexStatDo.isCostConfidence(last1DayStat)) {
            if (Math.random() < 0.002) {
                logger.info("AdxFactorBaseDo.run adxIndexStatDo is not Confidence, ideaId{}", (Object)adxIdeaDo.getIdeaId());
            }
            return null;
        }
        boolean reset = false;
        if (factorBaseDo == null) {
            factorBaseDo = new AdxFactorBaseDo();
        } else if (factorBaseDo.getAdxIdeaDo() != null) {
            reset = !adxIdeaDo.equals(factorBaseDo.getAdxIdeaDo());
        }
        AdxRoiFactor.updateFactor(prefix, target, factorBaseDo, bidMode, last20MinStat, last1DayStat, last3DayStat, reset);
        AdxRoiFactor.updateStatValue(factorBaseDo, last20MinStat, last1DayStat);
        factorBaseDo.setAdxIdeaDo(adxIdeaDo);
        return factorBaseDo;
    }

    public static void updateFactor(String prefix, Double target, AdxFactorBaseDo factorBaseDo, Integer bidMode, AdxIndexStatDo adxStatBaseDo, AdxIndexStatDo statBaseDoDay, AdxIndexStatDo statBaseDo3Days, boolean reset) {
        try {
            double factor = factorBaseDo.getFactor();
            if (reset) {
                logger.warn("roitask reset prefix{}, factorBaseDo{}", (Object)prefix, (Object)factorBaseDo);
                factorBaseDo.setFactor(1.0);
                return;
            }
            Double realValueMins = AdxRoiFactor.getRealValue(adxStatBaseDo, bidMode, target);
            Double realValueDay = AdxRoiFactor.getRealValue(statBaseDoDay, bidMode, target);
            Double realValue3Days = AdxRoiFactor.getRealValue(statBaseDo3Days, bidMode, target);
            Double costWeigh = AdxIndexStatDo.getCostWeigh(adxStatBaseDo, statBaseDoDay);
            boolean winRateStatus = AdxIndexStatDo.getWinRateStatus(adxStatBaseDo, statBaseDoDay);
            PidController pidController = new PidController();
            double signal = pidController.runPid2(target.doubleValue(), realValueMins.doubleValue(), realValueDay.doubleValue(), realValue3Days.doubleValue(), costWeigh.doubleValue());
            factor += signal;
            factor = AdxRoiFactor.limitFactor(factor, realValueDay, target, statBaseDoDay.getAdxConsume2(), winRateStatus);
            factor = MathUtil.stdwithBoundary((double)factor, (double)0.2, (double)3.0);
            factorBaseDo.setFactor(factor);
            logger.info("roitask prefix{}, 20mins{}, day{}, 3days{}, factorDo{}", new Object[]{prefix, adxStatBaseDo, statBaseDoDay, statBaseDo3Days, factorBaseDo});
        }
        catch (Exception e) {
            logger.error("AdxRoiFactor.updateFactor error:", (Throwable)e);
        }
    }

    public static double limitFactor(double factor, Double realValueDay, Double target, Double adxCost, boolean winRateStatus) {
        double ret = factor;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{realValueDay, target, adxCost})) {
            return ret;
        }
        if (realValueDay > 3.0 && adxCost > 50000.0) {
            ret = factor + (0.2 - factor) * 0.1;
        } else if (realValueDay / target - 1.0 > 0.2 && adxCost > 10000.0) {
            factor += (0.2 - factor) * 0.01;
            ret = Math.min(factor, 1.0);
        } else if (realValueDay / target - 1.0 < -0.05) {
            ret = factor + (3.0 - factor) * 0.03;
        }
        if (realValueDay / target - 1.0 < 0.05 || winRateStatus) {
            ret = Math.max(ret, 1.0);
        }
        return ret;
    }

    public static void updateStatValue(AdxFactorBaseDo factorBaseDo, AdxIndexStatDo adxStatBaseDo, AdxIndexStatDo statBaseDoDay) {
        if (factorBaseDo == null) {
            factorBaseDo = new AdxFactorBaseDo();
        }
        try {
            Double arpu = factorBaseDo.getArpu();
            Double launchPv = factorBaseDo.getLaunchPv();
            Double statCtr = factorBaseDo.getStatCtr();
            Double cpm = factorBaseDo.getCpm();
            Double clickValue = factorBaseDo.getClickValue();
            if (AdxIndexStatDo.isCostConfidence(statBaseDoDay)) {
                arpu = AdxIndexStatDo.getArpu(arpu, adxStatBaseDo, statBaseDoDay);
                launchPv = AdxIndexStatDo.getLaunchPv(launchPv, adxStatBaseDo, statBaseDoDay);
                statCtr = AdxIndexStatDo.getStatCtr(statCtr, adxStatBaseDo, statBaseDoDay);
                cpm = AdxIndexStatDo.getStatCpm(cpm, adxStatBaseDo, statBaseDoDay);
                clickValue = AdxIndexStatDo.getStatClickValue(clickValue, adxStatBaseDo, statBaseDoDay);
            }
            factorBaseDo.setArpu(arpu);
            factorBaseDo.setLaunchPv(launchPv);
            factorBaseDo.setStatCtr(statCtr);
            factorBaseDo.setCpm(cpm);
            factorBaseDo.setClickValue(clickValue);
        }
        catch (Exception e) {
            logger.info("AdxRoiFactor.updateStatValue:", (Throwable)e);
        }
    }

    public static Double getRealValue(AdxIndexStatDo adxStatBaseDo, Integer bidMode, Double defaultValue) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{adxStatBaseDo, bidMode})) {
            Double d = ret = bidMode == 2 ? AdxIndexStatDo.getCpc(adxStatBaseDo) : AdxIndexStatDo.getRoi(adxStatBaseDo);
        }
        if (ret == null) {
            ret = defaultValue;
        }
        return ret;
    }

    public static boolean valid(AdxFactorReqDo adxFactorReqDo) {
        if (adxFactorReqDo == null) {
            logger.error("AdxRoiFactor.run params is invalid");
            return false;
        }
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{adxFactorReqDo.getAdxIdeaDo(), adxFactorReqDo.getAdxStatsDo()})) {
            logger.error("AdxRoiFactor.run params is invalid, adxIdeaDo or adxStatsDo is null");
            return false;
        }
        AdxIdeaDo adxIdeaDo = adxFactorReqDo.getAdxIdeaDo();
        Integer bidMode = adxIdeaDo.getBidMode();
        Double target = AdxIdeaDo.getTarget(adxIdeaDo);
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{bidMode, target})) {
            logger.error("AdxRoiFactor.run params is invalid, bidMode or target is null");
            return false;
        }
        return true;
    }
}

