/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.io.Serializable;

public class AdxIndexStatDo
implements Serializable {
    private static final long serialVersionUID = 4481088624505592801L;
    private Long bid;
    private Long bidSuc;
    private Long exp;
    private Long click;
    private Long adxConsume;
    private Long advertConsume;
    private Long advertLaunch;
    private Long activityRequest;
    private Long activiyJoin;
    private Long advertExposure;
    private Long advertClick;
    private Double preClickValue;

    public static Double getStatCtr(AdxIndexStatDo adxIndexStatDo) {
        Double ret = null;
        if (adxIndexStatDo != null && adxIndexStatDo.getExp() != null && adxIndexStatDo.getExp() > 100L) {
            ret = DataUtil.division((Long)adxIndexStatDo.getClick(), (Long)adxIndexStatDo.getExp(), (int)3);
        }
        return ret;
    }

    public static Double getStatLaunchPv(AdxIndexStatDo adxIndexStatDo) {
        Double ret = null;
        if (adxIndexStatDo != null && adxIndexStatDo.getClick() != null && adxIndexStatDo.getClick() > 10L) {
            ret = DataUtil.division((Long)adxIndexStatDo.getAdvertLaunch(), (Long)adxIndexStatDo.getClick(), (int)3);
        }
        return ret;
    }

    public static Double getStatEcpm(AdxIndexStatDo adxIndexStatDo) {
        Double ret = null;
        if (adxIndexStatDo != null && adxIndexStatDo.getExp() != null && adxIndexStatDo.getExp() > 1000L && adxIndexStatDo.getAdvertConsume() != null) {
            ret = DataUtil.division((Long)(adxIndexStatDo.getAdvertConsume() * 1000L), (Long)adxIndexStatDo.getExp(), (int)3);
        }
        return ret;
    }

    public static double getCostWeigh(AdxIndexStatDo adxStatBaseDoMin, AdxIndexStatDo adxStatBaseDoDay) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{adxStatBaseDoMin, adxStatBaseDoDay})) {
            ret = MathUtil.division((Double)adxStatBaseDoDay.getAdxConsume3(), (Double)adxStatBaseDoMin.getAdxConsume3(), (int)3);
            ret = MathUtil.log((Double)ret);
        }
        if (ret == null) {
            ret = 1.0;
        }
        ret = MathUtil.stdwithBoundary((double)ret, (double)1.0, (double)10.0);
        return ret;
    }

    public static boolean isCostConfidence(AdxIndexStatDo adxStatBaseDo) {
        boolean ret = false;
        if (adxStatBaseDo != null && adxStatBaseDo.getAdxConsume() != null && adxStatBaseDo.getAdxConsume2() > 3000.0) {
            ret = true;
        }
        return ret;
    }

    public static boolean isImpConfidence(AdxIndexStatDo adxStatBaseDo) {
        boolean ret = false;
        if (adxStatBaseDo != null && adxStatBaseDo.getExp() != null && adxStatBaseDo.getExp() > 1000L) {
            ret = true;
        }
        return ret;
    }

    public static Double getWinRate(AdxIndexStatDo adxStatBaseDo) {
        Double ret = null;
        if (adxStatBaseDo != null) {
            ret = DataUtil.division((Long)adxStatBaseDo.getExp(), (Long)adxStatBaseDo.getBid(), (int)3);
        }
        return ret;
    }

    public static boolean getWinRateStatus(AdxIndexStatDo adxStatBaseDoMin, AdxIndexStatDo adxStatBaseDoDay) {
        Double winRateDay;
        boolean ret = false;
        Double winRate = AdxIndexStatDo.getWinRate(adxStatBaseDoMin);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{winRate, winRateDay = AdxIndexStatDo.getWinRate(adxStatBaseDoDay)}) && winRate < winRateDay * 0.5 && Math.random() < 0.2) {
            ret = true;
        }
        return ret;
    }

    public Double getAdxConsume2() {
        return MathUtil.division((Long)this.adxConsume, (Double)1.0E7, (int)3);
    }

    public Double getAdxConsume3() {
        return MathUtil.division((Long)this.adxConsume, (Double)10000.0, (int)3);
    }

    public static Double getStatArpu(AdxIndexStatDo adxStatBaseDo) {
        Double ret = null;
        if (AdxIndexStatDo.isCostConfidence(adxStatBaseDo)) {
            ret = MathUtil.division((Long)adxStatBaseDo.getAdvertConsume(), (Long)adxStatBaseDo.getAdvertLaunch(), (int)3);
        }
        return ret;
    }

    public static Double getStatCpm(AdxIndexStatDo adxStatBaseDo) {
        Double ret = null;
        if (AdxIndexStatDo.isCostConfidence(adxStatBaseDo)) {
            ret = MathUtil.division((Double)adxStatBaseDo.getAdxConsume3(), (Long)adxStatBaseDo.getExp(), (int)3);
        }
        return ret;
    }

    public static Double getLaunchPv(Double launchPv, AdxIndexStatDo adxStatBaseDo, AdxIndexStatDo statBaseDoDay) {
        Double launchPv1 = AdxIndexStatDo.getStatLaunchPv(adxStatBaseDo);
        Double launchPv2 = AdxIndexStatDo.getStatLaunchPv(statBaseDoDay);
        Double statlaunchPv = MathUtil.mean((Double)launchPv1, (Double)launchPv2, (Double)0.8);
        launchPv = MathUtil.mean((Double)launchPv, (Double)statlaunchPv, (Double)0.8);
        return launchPv;
    }

    public static Double getStatCtr(Double ctr, AdxIndexStatDo adxStatBaseDo, AdxIndexStatDo statBaseDoDay) {
        Double ctr2;
        Double ctr1 = AdxIndexStatDo.getStatCtr(adxStatBaseDo);
        Double statCtr = MathUtil.mean((Double)ctr1, (Double)(ctr2 = AdxIndexStatDo.getStatCtr(statBaseDoDay)), (Double)0.8);
        if ((ctr = MathUtil.mean((Double)ctr, (Double)statCtr, (Double)0.8)) != null) {
            ctr = MathUtil.stdwithBoundary((double)ctr, (double)0.0, (double)0.2);
        }
        return ctr;
    }

    public static Double getStatCpm(Double cpm, AdxIndexStatDo adxStatBaseDo, AdxIndexStatDo statBaseDoDay) {
        Double cpm1 = AdxIndexStatDo.getStatCpm(adxStatBaseDo);
        Double cpm2 = AdxIndexStatDo.getStatCpm(statBaseDoDay);
        Double statCpm = MathUtil.mean((Double)cpm1, (Double)cpm2, (Double)0.8);
        cpm = MathUtil.mean((Double)cpm, (Double)statCpm, (Double)0.2);
        cpm = MathUtil.stdwithBoundary((double)cpm, (double)30.0, (double)3000.0);
        return cpm;
    }

    public static Double getArpu(Double arpu, AdxIndexStatDo adxStatBaseDo, AdxIndexStatDo statBaseDoDay) {
        Double arpu1 = AdxIndexStatDo.getStatArpu(adxStatBaseDo);
        Double arpu2 = AdxIndexStatDo.getStatArpu(statBaseDoDay);
        Double statArpu = MathUtil.mean((Double)arpu1, (Double)arpu2, (Double)0.8);
        arpu = MathUtil.mean((Double)arpu, (Double)statArpu, (Double)0.8);
        return arpu;
    }

    public static Double getStatClickValue(Double clickValue, AdxIndexStatDo adxStatBaseDo, AdxIndexStatDo statBaseDoDay) {
        Double cv1 = AdxIndexStatDo.getStatClickValue(adxStatBaseDo);
        Double cv2 = AdxIndexStatDo.getStatClickValue(statBaseDoDay);
        Double statCv = MathUtil.mean((Double)cv1, (Double)cv2, (Double)0.8);
        clickValue = MathUtil.mean((Double)clickValue, (Double)statCv, (Double)0.8);
        return clickValue;
    }

    public static Double getStatClickValue(AdxIndexStatDo adxStatBaseDo) {
        Double ret = null;
        if (AdxIndexStatDo.isCostConfidence(adxStatBaseDo)) {
            ret = MathUtil.division((Long)adxStatBaseDo.getAdvertConsume(), (Long)adxStatBaseDo.getClick(), (int)3);
        }
        return ret;
    }

    public static Double getCpc(AdxIndexStatDo adxStatBaseDo) {
        Double ret = null;
        if (adxStatBaseDo != null) {
            Long click = adxStatBaseDo.getClick();
            Double adxConsume = adxStatBaseDo.getAdxConsume2();
            if (AdxIndexStatDo.isCostConfidence(adxStatBaseDo)) {
                ret = DataUtil.division((Double)adxConsume, (Long)click, (int)3);
            }
        }
        return ret;
    }

    public static Double getRoi(AdxIndexStatDo adxStatBaseDo) {
        Double ret = null;
        if (adxStatBaseDo != null) {
            Long advertConsume = adxStatBaseDo.getAdvertConsume();
            Double adxConsume = adxStatBaseDo.getAdxConsume2();
            if (AdxIndexStatDo.isCostConfidence(adxStatBaseDo)) {
                ret = DataUtil.division((Double)adxConsume, (Long)advertConsume, (int)3);
            }
        }
        return ret;
    }

    public Long getBid() {
        return this.bid;
    }

    public Long getBidSuc() {
        return this.bidSuc;
    }

    public Long getExp() {
        return this.exp;
    }

    public Long getClick() {
        return this.click;
    }

    public Long getAdxConsume() {
        return this.adxConsume;
    }

    public Long getAdvertConsume() {
        return this.advertConsume;
    }

    public Long getAdvertLaunch() {
        return this.advertLaunch;
    }

    public Long getActivityRequest() {
        return this.activityRequest;
    }

    public Long getActiviyJoin() {
        return this.activiyJoin;
    }

    public Long getAdvertExposure() {
        return this.advertExposure;
    }

    public Long getAdvertClick() {
        return this.advertClick;
    }

    public Double getPreClickValue() {
        return this.preClickValue;
    }

    public void setBid(Long bid) {
        this.bid = bid;
    }

    public void setBidSuc(Long bidSuc) {
        this.bidSuc = bidSuc;
    }

    public void setExp(Long exp) {
        this.exp = exp;
    }

    public void setClick(Long click) {
        this.click = click;
    }

    public void setAdxConsume(Long adxConsume) {
        this.adxConsume = adxConsume;
    }

    public void setAdvertConsume(Long advertConsume) {
        this.advertConsume = advertConsume;
    }

    public void setAdvertLaunch(Long advertLaunch) {
        this.advertLaunch = advertLaunch;
    }

    public void setActivityRequest(Long activityRequest) {
        this.activityRequest = activityRequest;
    }

    public void setActiviyJoin(Long activiyJoin) {
        this.activiyJoin = activiyJoin;
    }

    public void setAdvertExposure(Long advertExposure) {
        this.advertExposure = advertExposure;
    }

    public void setAdvertClick(Long advertClick) {
        this.advertClick = advertClick;
    }

    public void setPreClickValue(Double preClickValue) {
        this.preClickValue = preClickValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdxIndexStatDo)) {
            return false;
        }
        AdxIndexStatDo other = (AdxIndexStatDo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$bid = this.getBid();
        Long other$bid = other.getBid();
        if (this$bid == null ? other$bid != null : !((Object)this$bid).equals(other$bid)) {
            return false;
        }
        Long this$bidSuc = this.getBidSuc();
        Long other$bidSuc = other.getBidSuc();
        if (this$bidSuc == null ? other$bidSuc != null : !((Object)this$bidSuc).equals(other$bidSuc)) {
            return false;
        }
        Long this$exp = this.getExp();
        Long other$exp = other.getExp();
        if (this$exp == null ? other$exp != null : !((Object)this$exp).equals(other$exp)) {
            return false;
        }
        Long this$click = this.getClick();
        Long other$click = other.getClick();
        if (this$click == null ? other$click != null : !((Object)this$click).equals(other$click)) {
            return false;
        }
        Long this$adxConsume = this.getAdxConsume();
        Long other$adxConsume = other.getAdxConsume();
        if (this$adxConsume == null ? other$adxConsume != null : !((Object)this$adxConsume).equals(other$adxConsume)) {
            return false;
        }
        Long this$advertConsume = this.getAdvertConsume();
        Long other$advertConsume = other.getAdvertConsume();
        if (this$advertConsume == null ? other$advertConsume != null : !((Object)this$advertConsume).equals(other$advertConsume)) {
            return false;
        }
        Long this$advertLaunch = this.getAdvertLaunch();
        Long other$advertLaunch = other.getAdvertLaunch();
        if (this$advertLaunch == null ? other$advertLaunch != null : !((Object)this$advertLaunch).equals(other$advertLaunch)) {
            return false;
        }
        Long this$activityRequest = this.getActivityRequest();
        Long other$activityRequest = other.getActivityRequest();
        if (this$activityRequest == null ? other$activityRequest != null : !((Object)this$activityRequest).equals(other$activityRequest)) {
            return false;
        }
        Long this$activiyJoin = this.getActiviyJoin();
        Long other$activiyJoin = other.getActiviyJoin();
        if (this$activiyJoin == null ? other$activiyJoin != null : !((Object)this$activiyJoin).equals(other$activiyJoin)) {
            return false;
        }
        Long this$advertExposure = this.getAdvertExposure();
        Long other$advertExposure = other.getAdvertExposure();
        if (this$advertExposure == null ? other$advertExposure != null : !((Object)this$advertExposure).equals(other$advertExposure)) {
            return false;
        }
        Long this$advertClick = this.getAdvertClick();
        Long other$advertClick = other.getAdvertClick();
        if (this$advertClick == null ? other$advertClick != null : !((Object)this$advertClick).equals(other$advertClick)) {
            return false;
        }
        Double this$preClickValue = this.getPreClickValue();
        Double other$preClickValue = other.getPreClickValue();
        return !(this$preClickValue == null ? other$preClickValue != null : !((Object)this$preClickValue).equals(other$preClickValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdxIndexStatDo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $bid = this.getBid();
        result = result * 59 + ($bid == null ? 43 : ((Object)$bid).hashCode());
        Long $bidSuc = this.getBidSuc();
        result = result * 59 + ($bidSuc == null ? 43 : ((Object)$bidSuc).hashCode());
        Long $exp = this.getExp();
        result = result * 59 + ($exp == null ? 43 : ((Object)$exp).hashCode());
        Long $click = this.getClick();
        result = result * 59 + ($click == null ? 43 : ((Object)$click).hashCode());
        Long $adxConsume = this.getAdxConsume();
        result = result * 59 + ($adxConsume == null ? 43 : ((Object)$adxConsume).hashCode());
        Long $advertConsume = this.getAdvertConsume();
        result = result * 59 + ($advertConsume == null ? 43 : ((Object)$advertConsume).hashCode());
        Long $advertLaunch = this.getAdvertLaunch();
        result = result * 59 + ($advertLaunch == null ? 43 : ((Object)$advertLaunch).hashCode());
        Long $activityRequest = this.getActivityRequest();
        result = result * 59 + ($activityRequest == null ? 43 : ((Object)$activityRequest).hashCode());
        Long $activiyJoin = this.getActiviyJoin();
        result = result * 59 + ($activiyJoin == null ? 43 : ((Object)$activiyJoin).hashCode());
        Long $advertExposure = this.getAdvertExposure();
        result = result * 59 + ($advertExposure == null ? 43 : ((Object)$advertExposure).hashCode());
        Long $advertClick = this.getAdvertClick();
        result = result * 59 + ($advertClick == null ? 43 : ((Object)$advertClick).hashCode());
        Double $preClickValue = this.getPreClickValue();
        result = result * 59 + ($preClickValue == null ? 43 : ((Object)$preClickValue).hashCode());
        return result;
    }

    public String toString() {
        return "AdxIndexStatDo(bid=" + this.getBid() + ", bidSuc=" + this.getBidSuc() + ", exp=" + this.getExp() + ", click=" + this.getClick() + ", adxConsume=" + this.getAdxConsume() + ", advertConsume=" + this.getAdvertConsume() + ", advertLaunch=" + this.getAdvertLaunch() + ", activityRequest=" + this.getActivityRequest() + ", activiyJoin=" + this.getActiviyJoin() + ", advertExposure=" + this.getAdvertExposure() + ", advertClick=" + this.getAdvertClick() + ", preClickValue=" + this.getPreClickValue() + ")";
    }
}

