package cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

@Data
public class AdxDirecrtlyPriceReqDo {

    /**
     * 计费类型（0:CPC 1:CPM）
     */
    private Integer billType;

    /**
     * 广告位ID
     */
    private Long slotId;

    /**
     * 分流标识, 0:原逻辑, 1:实验组, 2:对照组1, 3:对照组2
     */
    private Integer groupTag;

    /**
     * 广告位维度设置的目标分成比例
     */
    private Double slotShareRate;

    /**
     * 底价
     */
    private Double floorPrice;

    /**
     * 配置的真实底价，如果出价高于该底价但低于30，则以一定概率强制提价至30分
     */
    private Double realFloorPrice = 27.0;

    /**
     * 需要返回给媒体的广告个数 可配置
     */
    private Integer advertCnt;

    /**
     * 广告券出价信息
     */
    private  List<AdxDirecetlyPriceDo> adxDirecetlyPriceDos = new ArrayList<>();

    /**
     * 维稳因子
     */
    private AdxMeiTuanFactorDo adxMeiTuanFactorDo = new AdxMeiTuanFactorDo();

    /**
     *用户当日在美团的竞价请求次数
     */
    private Long reqCnt;

    /**
     * 竞价请求次数阈值
     */
    private Long reqThreshold;

    public static double getShareRate(AdxDirecrtlyPriceReqDo adxDirecrtlyPriceReqDo) {
        double ret = 1.;
        if(adxDirecrtlyPriceReqDo != null && adxDirecrtlyPriceReqDo.getSlotShareRate() != null) {
            ret = adxDirecrtlyPriceReqDo.getSlotShareRate() / 100;
        }
        return ret;
    }
}
