package cn.com.duiba.nezha.alg.alg.advertexploitbak;

import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class ExploitParams {

    // 单个通道最大召回数量
    private int maxNumPerMatcher = 30;

    // 3天数据权重
    private double data3dayWeight = 0.2;

    // 当天数据权重
    private double dataTodayWeight = 0.5;

    // 上个小时数据权重
    private double dataLastHourWeight = 0.3;

    // 通道最小置信消耗
    private long confidentConsume = 3000;

    // 通道最小置信曝光
    private long confidentExposure = 1000;

    // 实验最小置信消耗
    private long expConfidentConsume = 3000000;

    // 实验最小置信曝光
    private long expConfidentExposure = 100000;

    // 通道最小权重
    private double matcherWeightLowerBound = 0.1;

    // 默认通道权重
    private double matcherDefaultWeight = 0.2;

    // 新广告权重
    private double newAdvertFactor = 1.1;

    // 默认成本权重（初始）
    private double costDefaultWeight = 0.5;

    // 默认CPM权重（初始）
    private double cpmDefaultWeight = 0.5;

    // 成本权重参数
    private double costWeightUpperBound = 0.9;  // 最大权重
    private double costWeightLowerBound = 0.1;  // 最小权重
    private double thetaCost = 12.0;   // 线性函数参数
    private double betaCost = 0.0;    // 偏移参数

}
