package cn.com.duiba.nezha.alg.alg.coldstartandexplore.util;

import cn.com.duiba.nezha.alg.alg.vo.strongtargetexplore.STEInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.strongtargetexplore.STEParams;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

/**
 * 获取CVR值
 */
public class GetCvr {
    private static final Logger logger= LoggerFactory.getLogger(GetCvr.class);

    /**
     * 求取数据充分的最小粒度维度上统计CVR值
     */
    public static Double getMinDimsStatCvr(STEParams steParams, List<Long> clickList, List<Double> cvrList, String paramType) {
        Double minDimsStatCvr = 0.0;

        if (clickList.get(clickList.size() -1) <= (paramType.equals("secondSet") ? steParams.getClickConfidenceThresholdSet2() : steParams.getClickConfidenceThreshold())) {
            minDimsStatCvr = cvrList.get(clickList.size() -1);
        }else {
            for (int index=0; index<clickList.size(); index++) {
                if (clickList.get(index) >= (paramType.equals("secondSet") ? steParams.getClickConfidenceThresholdSet2() : steParams.getClickConfidenceThreshold())) {
                    minDimsStatCvr = cvrList.get(index);
                    break;
                }
            }
        }

        return minDimsStatCvr;
    }

    /**
     * 获取修正后的CVR值
     */
    public static Map<String, Object> getAdjustCVR(STEParams steParams, STEInfoDo steInfo){
        Map<String, Object> res = new HashMap<>();
        if (AssertUtil.isAnyEmpty(steParams, steInfo)) {
            return null;
        }

        // 获取统计信息
        Double preCvr = steInfo.getPreCvr();
        Long hisClick = steInfo.getHisClick();
        Long hisConvert = steInfo.getHisConvert();
        Double staCvr = Optional.ofNullable(MathUtil.division(hisConvert, hisClick, 6)).orElse(0.0);
        Long advTradeSlotDayClick = steInfo.getAdvTradeSlotDayStats().getClick();
        Long advTradeAppDayClick = steInfo.getAdvTradeAppDayStats().getClick();
        Long advTradeAppTradeDayClick = steInfo.getAdvTradeAppTradeDayStats().getClick();
        Long advTradeSlotTriDayClick = steInfo.getAdvTradeSlotTriDayStats().getClick();
        Long advTradeAppTriDayClick = steInfo.getAdvTradeAppTriDayStats().getClick();
        Long advTradeAppTradeTriDayClick = steInfo.getAdvTradeAppTradeTriDayStats().getClick();
        Long advTradeSlotDayConvert = steInfo.getAdvTradeSlotDayStats().getConvert();
        Long advTradeAppDayConvert = steInfo.getAdvTradeAppDayStats().getConvert();
        Long advTradeAppTradeDayConvert = steInfo.getAdvTradeAppTradeDayStats().getConvert();
        Long advTradeSlotTriDayConvert = steInfo.getAdvTradeSlotTriDayStats().getConvert();
        Long advTradeAppTriDayConvert = steInfo.getAdvTradeAppTriDayStats().getConvert();
        Long advTradeAppTradeTriDayConvert = steInfo.getAdvTradeAppTradeTriDayStats().getConvert();
        // 计算各统计维度CVR
        Double advTradeSlotDayCvr = Optional.ofNullable(MathUtil.division(advTradeSlotDayConvert, advTradeSlotDayClick, 6)).orElse(0.0);
        Double advTradeAppDayCvr = Optional.ofNullable(MathUtil.division(advTradeAppDayConvert, advTradeAppDayClick, 6)).orElse(0.0);
        Double advTradeAppTradeDayCvr = Optional.ofNullable(MathUtil.division(advTradeAppTradeDayConvert, advTradeAppTradeDayClick, 6)).orElse(0.0);
        Double advTradeSlotTriDayCvr = Optional.ofNullable(MathUtil.division(advTradeSlotTriDayConvert, advTradeSlotTriDayClick, 6)).orElse(0.0);
        Double advTradeAppTriDayCvr = Optional.ofNullable(MathUtil.division(advTradeAppTriDayConvert, advTradeAppTriDayClick, 6)).orElse(0.0);
        Double advTradeAppTradeTriDayCvr = Optional.ofNullable(MathUtil.division(advTradeAppTradeTriDayConvert, advTradeAppTradeTriDayClick, 6)).orElse(0.0);

        List<Long> clickList = Arrays.asList(advTradeSlotDayClick, advTradeAppDayClick, advTradeAppTradeDayClick, advTradeSlotTriDayClick,
                advTradeAppTriDayClick, advTradeAppTradeTriDayClick);
        List<Double> cvrList = Arrays.asList(advTradeSlotDayCvr, advTradeAppDayCvr, advTradeAppTradeDayCvr, advTradeSlotTriDayCvr,
                advTradeAppTriDayCvr, advTradeAppTradeTriDayCvr);

        // 确认走哪套扶持参数,并求取相应的CVR调整系数
        double adjustWeight = 1.0;
        String paramType = "firstSet";
        if (Collections.max(cvrList) < steParams.getMinDimStatsCvrThreshold()) {     // CVR较低行业，需要使用第二套扶持参数
            paramType = "secondSet";
        }else {     // 用第一套扶持参数
            paramType = "firstSet";
        }
        HashMap<String, Object> AdjustWeightRes = WeightingFunction.getAdjustWeight(steParams, clickList, cvrList, paramType, hisClick, staCvr);
        adjustWeight = (double) AdjustWeightRes.get("adjustWeight");
        double minDimsStatCvr = (double) AdjustWeightRes.get("minDimsStatCvr");

        double adjustCvr = preCvr;
        if (hisClick >= (paramType.equals("firstSet") ? steParams.getSepStageThreshold() : steParams.getSepStageThresholdSet2()) && staCvr >= Math.pow(10, -8)) {    // 根据CVR调整系数计算得到调整后的adjustCvr
            adjustCvr = adjustWeight * preCvr + (1 - adjustWeight) * minDimsStatCvr;
        } else { adjustCvr *= adjustWeight; }

        res.put("adjustWeight", adjustWeight);
        res.put("adjustCvr", adjustCvr);
        res.put("paramType", (paramType.equals("firstSet") ? 1.0 : 2.0));   //1.0表示使用的是第一套扶持参数；2.0表示使用的是第二套扶持参数；

        return res;
    }

}
