package cn.com.duiba.nezha.alg.alg.vo.kaihu;

import lombok.Data;

@Data
public class KaiHuInputDo {

    /**
     * 计划ID
     */
    private Long advertId;

    /**
     * 媒体ID
     */
    private Long appId;

    /**
     * 广告位ID
     */
    private Long slotId;

    /**
     * 媒体开户投放场景
     *  (1-点券直接上报，2-转化概率多O，3-点券概率多O，4-转化直接上报)
     */
    private Integer scene;

    /**
     * 券点击计费
     * 单位：分(仅点券多O回传场景，其余为null)
     */
    private Integer fee;

    /**
     * 广告投放目标成本
     * 单位：分(仅广告转化多O回传场景，其余为null)
     */
    private Integer aFee;

    /**
     * 广告是否开启OCPC
     * 1-cpc、2-ocpc
     */
    private Integer chargeType;

    /**
     * 广告投放目标类型
     * (仅ocpc广告，其余为null)
     */
    private Integer convertType;

    /**
     * 开户媒体回传转化类型
     * -1-点券、0-落地页点击...等
     */
    private Integer subType;

    /**
     * 开户媒体上目标转化成本
     * 单位：分
     */
    private Integer appTargetFee;

    /**
     * 目标ROI
     *（单位：小数，1.5）
     */
    private Double roi;

    /**
     * 媒体唯一键 上报累计次数(当前累计前)
     * 0-不上报，1～n-上报累计次数
     */
    private Long mcbIdTag;

    /**
     * 广告订单Id+转化类型 打印次数(当前累计后)
     */
    private Long orderSubTypeTag;

}
