package cn.com.duiba.nezha.alg.alg.adx.adxegtest;

import org.apache.commons.collections.CollectionUtils;

import java.util.*;
import java.util.function.Function;

public class RatioShunt {


    public static final Random RANDOM = new Random();
    private static final int DEF_FULL_RATIO = 100;

    /**
     * 随机分流
     * @param fullRatio
     * @param ratioShuntTree
     * @param <T>
     * @return
     */
    public static <T> Optional<T> randomRatioShunt(int fullRatio, TreeMap<Integer,T> ratioShuntTree){
        fullRatio= switchFullRatio(fullRatio);
        return ratioShunt(RANDOM.nextInt(fullRatio),fullRatio,ratioShuntTree);
    }

    /**
     * 按制定数值分流
     * @param shuntVal
     * @param fullRatio
     * @param ratioShuntTree
     * @param <T>
     * @return
     */
    public static  <T> Optional<T> ratioShunt(int shuntVal, int fullRatio, TreeMap<Integer,T> ratioShuntTree){
        if(isEmpty(ratioShuntTree)){
            return Optional.empty();
        }

        shuntVal = Math.abs(shuntVal);
        fullRatio= switchFullRatio(fullRatio);

        int shuntNum = shuntVal % fullRatio;

        /**
         * 在当没有匹配到key时，就取下一个key的值返回回来
         */
        Map.Entry<Integer,T> entry = ratioShuntTree.ceilingEntry(shuntNum);

        return  Objects.isNull(entry) ? Optional.empty() : Optional.ofNullable(entry.getValue());
    }

    private static int switchFullRatio(int fullRatio){
        return fullRatio <= 0 ? DEF_FULL_RATIO : fullRatio;
    }



    public static boolean isEmpty(Map<?, ?> map) {
        return (map == null || map.isEmpty());
    }


    /**
     * 创建分流投放树
     * @param shuntEntrys
     * @param getRatioFuc
     * @param <T>
     * @return
     */
    public static <U,T> TreeMap<Integer,T>  createRatioShuntTree(Collection<U> shuntEntrys, Function<U,Integer> getRatioFuc , Function<U,T> getValueFuc){
        if(CollectionUtils.isEmpty(shuntEntrys)){
            return new TreeMap<>();
        }

        int currentKey = -1;
        TreeMap<Integer,T> ratioTree = new TreeMap<>();
        for(U entry: shuntEntrys){
            Integer ratio = getRatioFuc.apply(entry);

            if(Objects.nonNull(ratio) && ratio > 0){
                currentKey += ratio;
                ratioTree.put(currentKey,getValueFuc.apply(entry));
            }
        }

        return ratioTree;
    }

    /**
     * 创建分流投放树
     * @param shuntEntrys
     * @param getRatioFuc
     * @param <T>
     * @return
     */
    public static <T> TreeMap<Integer,T>  createRatioShuntTree(Collection<T> shuntEntrys, Function<T,Integer> getRatioFuc){
        return createRatioShuntTree(shuntEntrys,getRatioFuc,entry -> entry);
    }

}
