package cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2;

import lombok.Data;

@Data
public class AdxBidRet {

    /**
     * 创意计划ID
     */
    private Long ideaId;

    /**
     * 创意素材ID
     */
    private Long ideaUnitId;

    /**
     * 算法出价
     */
    private Long adxAlgoPrice;

    /**
     * 维稳因子
     */
    private Double factor;

    /**
     * 预估ctr
     */
    private Double preCtr;

    /**
     * 统计ctr
     */
    private Double statCtr;

    /**
     * 融合ctr
     */
    private Double ctr;

    /**
     * 预估每pv发券
     */
    private Double preLaunchPv;

    /**
     * 统计每pv发券
     */
    private Double statLaunchPv;

    /**
     * 融合每pv发券
     */
    private Double launchPv;

    /**
     * 点击价值
     */
    private Double clickValue;

    /**
     * 统计arpu值
     */
    private Double arpu;

    /**
     * 预估arpu值
     */
    private Double preArpu;

    /**
     * 融合arpu值
     */
    private Double mixArpu;

    /**
     * 精排排序分
     */
    private Double rankScore;

    /**
     * 探价因子分桶标记
     */
    private String level;

    /**
     * 探价因子
     */
    private double priceFactor;

    /**
     * 投放状态：1=正常投放，2=广告位探量投放，3=计划冷启动探价
     */
    private Integer exploreType;

    /**
     * 底价/分
     */
    private Double basePrice;

    /**
     * 算法判断--计划创意来源池：true-冷启动池，false-优选池
     */
    private Boolean isNew;

}
