/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.material;

import cn.com.duiba.nezha.alg.alg.vo.material.MaterialCostMatchDo;
import cn.com.duiba.nezha.alg.alg.vo.material.MaterialExtractDo;
import cn.com.duiba.nezha.alg.alg.vo.material.MaterialMatchDo;
import cn.com.duiba.nezha.alg.alg.vo.material.MaterialRecallDo;
import cn.com.duiba.nezha.alg.alg.vo.material.MaterialStatInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterialMatch {
    private static final Logger logger = LoggerFactory.getLogger(MaterialMatch.class);

    public static MaterialExtractDo match(MaterialRecallDo materialRecallDo) {
        return MaterialMatch.onlineVersion(materialRecallDo);
    }

    private static MaterialExtractDo randomStrategy(List<MaterialStatInfo> materialList) {
        MaterialExtractDo materialExtractDo = new MaterialExtractDo();
        ArrayList<MaterialMatchDo> rawMaterialMatchDoList = new ArrayList<MaterialMatchDo>(materialList.size() + 10);
        ArrayList<Long> materialExposeDoList = new ArrayList<Long>();
        materialList.forEach(materialStatInfo -> {
            MaterialMatchDo materialMatchDo = new MaterialMatchDo(materialStatInfo.getMaterialId(), 0.0);
            rawMaterialMatchDoList.add(materialMatchDo);
        });
        materialExtractDo.setMaterialMatchDoList(rawMaterialMatchDoList);
        materialExtractDo.setMaterialExposeDoList(materialExposeDoList);
        return materialExtractDo;
    }

    private static MaterialExtractDo onlineVersion(MaterialRecallDo materialRecallDo) {
        int shortCutSize;
        List<MaterialStatInfo> materialList = materialRecallDo.getMaterialList();
        ArrayList<MaterialMatchDo> rawMaterialMatchDoList = new ArrayList<MaterialMatchDo>(600);
        ArrayList<Long> materialExposeDoList = new ArrayList<Long>(200);
        MaterialExtractDo materialExtractDo = new MaterialExtractDo();
        double exposeMaxCount = 500.0;
        int materialSize = materialList.size();
        if (materialSize <= (shortCutSize = 100)) {
            materialList.forEach(materialStatInfo -> {
                MaterialMatchDo materialMatchDo = new MaterialMatchDo(materialStatInfo.getMaterialId(), 0.0);
                rawMaterialMatchDoList.add(materialMatchDo);
            });
            materialExtractDo.setMaterialMatchDoList(rawMaterialMatchDoList);
            materialExtractDo.setMaterialExposeDoList(materialExposeDoList);
            materialExtractDo.setMaterialCostMatchDoList(new ArrayList<MaterialCostMatchDo>());
            return materialExtractDo;
        }
        for (MaterialStatInfo materialStatInfo2 : materialList) {
            double wilsonScore = MaterialMatch.calWilsonScore(materialStatInfo2.getExposeCnt(), materialStatInfo2.getClickCnt());
            MaterialMatchDo materialMatchDo = new MaterialMatchDo(materialStatInfo2.getMaterialId(), wilsonScore);
            rawMaterialMatchDoList.add(materialMatchDo);
            if (!((double)materialStatInfo2.getExposeCnt().longValue() <= exposeMaxCount)) continue;
            materialExposeDoList.add(materialStatInfo2.getMaterialId());
        }
        int ctrSize = shortCutSize / 2;
        List<MaterialMatchDo> filterMaterialMatchDoList = rawMaterialMatchDoList.stream().sorted(Comparator.comparing(MaterialMatchDo::getCtr).reversed()).limit(ctrSize).collect(Collectors.toList());
        materialExtractDo.setMaterialMatchDoList(filterMaterialMatchDoList);
        materialExtractDo.setMaterialExposeDoList(materialExposeDoList);
        materialExtractDo.setMaterialCostMatchDoList(materialRecallDo.getMaterialCostMatchDoList());
        return materialExtractDo;
    }

    private static double calWilsonScore(long exposeCnt, long clickCnt) {
        if (exposeCnt == 0L) {
            return 0.0;
        }
        double ratio = (double)clickCnt * 1.0 / (double)exposeCnt;
        double faithLevel = 0.99;
        double faithSquare = faithLevel * faithLevel;
        return (ratio + faithSquare / (double)(2L * exposeCnt) - faithLevel * Math.sqrt((double)(4L * exposeCnt) * ratio * (1.0 - ratio) + faithSquare) / (double)(2L * exposeCnt)) / (1.0 + faithSquare / (double)exposeCnt);
    }
}

