package cn.com.duiba.nezha.alg.alg.alg;

import cn.com.duiba.nezha.alg.alg.advert.AdBidControl;
import cn.com.duiba.nezha.alg.alg.advert.BidControl;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidInputDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidInputVo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidResultDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdFeeDo;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlModel;

import java.util.Map;


/**
 * 广告出价控制模块
 */
public class AdBidControlAlg {


    /**
     * 竞价控制
     * 描述：
     * 包含所有算法出价、提权调节策略
     * 控本策略
     * 1、出价维稳调节
     * 2、价格保护
     * 3、底价放弃
     *
     * 跑量策略
     * 4、冷启动
     * 5、一键复苏
     * 6、一键起量
     * 7、一键继承
     *
     *
     * 备注：不包含：预算平滑、广告扶持、预估纠偏
     * 输入说明：
     * 1、所有配置集合
     * 2、算法控制参数对象

     * 输出说明：
     * 1、出价
     * 2、是否放弃
     * 3、控制参数
     */

    /**
     * @param advertMap   竞价广告列表
     * @param paramsModel 控制参数对象
     */
    public static Map<String, AdBidResultDo> bidControl(Map<String, AdBidInputVo> advertMap, OcpxControlModel paramsModel) {


        return AdBidControl.bidControl(advertMap, paramsModel);
    }


}
