package cn.com.duiba.nezha.alg.alg.adx.rtbbid;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxClickAndJoinDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxPredAdDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.ClickValueRectifyDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb.*;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;

public class RtbBidAlg {

    private static final Logger logger = LoggerFactory.getLogger(RtbBidAlg.class);

    private static int[] CLICK_VALUE_BUCKET = {1, 2, 3, 5, 7, 10, 20, 50, 100};

    /**
     * RTB互动算法出价
     *
     * @param bidRequestDo
     * @return
     */
    public static AdxRtbBidResultDo getRtbBidding(AdxRtbBidRequestDo bidRequestDo) {

        AdxRtbBidResultDo ret = new AdxRtbBidResultDo();

        try {

            if (valid(bidRequestDo)) {

                //预发券预估
                Double preAdClickValue = getPreAdClickValue(bidRequestDo);
                bidRequestDo.getAdxDoInfo().setPredClickValue(preAdClickValue);

                //点击价值纠偏(TF模型)
                Integer clickValueLevel = AdxStatData.bucket(bidRequestDo.getAdxDoInfo().getTfPreClickValue(), CLICK_VALUE_BUCKET);
                Double clickValueRectifyFactor = AdxStatData.getClickValueRectifyFactor(clickValueLevel, bidRequestDo.getClickValueRectify());
                Double recTfPreClickValue = DataUtil.division(bidRequestDo.getAdxDoInfo().getTfPreClickValue(), clickValueRectifyFactor);
                bidRequestDo.getAdxDoInfo().setRecTfPreClickValue(recTfPreClickValue);

                // 算法出价模式(1-按roi出价, 2-按cpc出价)
                Integer algoBidMode = bidRequestDo.getAdxDoInfo().getAlgoBidMode();

                if (AssertUtil.isNotEmpty(algoBidMode) && algoBidMode.equals(1)) {
                    ret = AdxRoiAlgoBid.getAdxAlgoPrice(bidRequestDo.getAdxDoInfo(), bidRequestDo.getAdxRoiControlInfo());

                } else if (AssertUtil.isNotEmpty(algoBidMode) && algoBidMode.equals(2)) {
                    ret = AdxCpcAlgoBid.getAdxAlgoPrice(bidRequestDo);

                }

                ret.setPredClickValue(preAdClickValue);
                ret.setClickValueLevel(clickValueLevel);
                ret.setClickValueRectifyFactor(clickValueRectifyFactor);

            }

        } catch (Exception e) {
            logger.error("RtbBidAlg.getRtbBidding error", e);
        }

        return ret;
    }


    /**
     * 校验基础信息是否合法
     *
     * @param bidRequestDo
     * @return
     */
    private static Boolean valid(AdxRtbBidRequestDo bidRequestDo) {

        Boolean ret = true;

        if (AssertUtil.isEmpty(bidRequestDo)) {
            ret = false;
            logger.error("RtbBidAlg.getRtbBidding() input params valid , params bidRequestDo is null");

        } else if (AssertUtil.isEmpty(bidRequestDo.getAdxDoInfo())) {
            ret = false;
            logger.error("RtbBidAlg.getRtbBidding() input params valid , params adxDoInfo is null");
        }

        return ret;
    }


    /**
     * 预估点击价值-预发券
     *
     * @param bidRequestDo
     * @return
     */
    private static Double getPreAdClickValue(AdxRtbBidRequestDo bidRequestDo) {

        Double ret = null;
        if (valid(bidRequestDo)) {
            Integer preLaunchSwitch = bidRequestDo.getAdxDoInfo().getPreLaunchSwitch();

            if (AssertUtil.isNotEmpty(preLaunchSwitch) && preLaunchSwitch.equals(1)) {
                AdxClickAndJoinDo mergeAdxClickAndJoinDo = bidRequestDo.getMergeAdxClickAndJoinDo();
                List<AdxPredAdDo> adxPredAdDoList = bidRequestDo.getAdxPredAdDoList();
                ret = AdxClickValuePredictAlg.getPredClickValue(mergeAdxClickAndJoinDo, adxPredAdDoList);
            }
        }
        return ret;
    }






}