package cn.com.duiba.nezha.alg.alg.vo.advert;

import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlSubModel;
import lombok.Data;

import java.util.Map;

@Data
public class AdBidInputVo {


    String key;//


    /**
     * 1 基础信息
     */
    Long newTradeTagId;//行业

    Long advertId;//计划ID

    Long packageId;//配置ID

    Long materialId;//素材ID


    Long appId;//媒体ID

    Long slotId;//广告位ID


    Double preCtr;// 预估ctr

    Double preCvr;// 预估cvr

    Double preDcvr;// 预估dcvr-- 2021.1.19

    Double ctr;// 融合ctr

    Double cvr;// 融合cvr

    Double dcvr;// 预估dcvr


    /**
     * 2 出价设置
     */

    Long fee;//cpc广告出价

    Long aFee;//ocpx 广告 转化目标出价（配置的）

    Long appAFee;//ocpx 广告 媒体 转化目标出价（******   新增 !!!! *******）

    Long deepFee;//深度目标成本（2020.11.12）





    /**
     * 3 定向类型
     */

    Integer targeType; //人工定向、自动定向

    Boolean isAutoTarget;// 是否自动定向流量


    /**
     * 4 控制策略
     */
    Integer releaseTarget;  //1-稳定投放，2-抢量优先(中)， 3-抢量优先(高)， 4-人工定向， 5-成本优先


    /**
     * 5 目标类型
     */
    Integer chargeType; //是否ocpc，1：cpc、2：ocpc

    Integer cvrType;//ocpx 转化目标类型，目前支持：0、2、3（2020.09.10）

    Integer deepCvrType;//ocpx 深度转化目标类型，目前支持：8（2020.09.10）

    Integer deepControlType;// 双出价模式： null：无 0-白名单测试  1-保后端成本   2-保消耗  3-优化后端成本（适合转化延迟情况）

    Integer deepDelayType;// 双出价后端延迟类型： null：无  1：10分钟内   2：10分钟以上

    Integer bidControlType;// 是否跑量测试白名单， null：无  1：无   2：是


    /**
     * 底价调节
     */
    Long reserveFee;//底价

    Boolean reservePriceWhite;//底价生效白名单，白名单内不触发

    /**
     * 策略因子,影响出价
     */

    Double specialAccountWeight;// 系统，特殊广告主调价权重，影响出价

    Double specialAdvertWeight;// 系统，特殊广告计划调价权重，影响排序

    Double discountWeight;// 系统，折扣权重，影响排序

    Double supportWeight;// 算法，扶持调价权重，影响排序



    /**
     * AB分流
     */

    Integer eeABTestId;// 跑量策略ab分流ID（null：无  1：无  2：是）2022.1.25

    Integer deepFeeABTestId;// 双出价AB分流 测试Id（1：默认组、2：实验组...）


    /**
     * 成本控制参数
     */

    OcpxControlSubModel ocpxControlSubModel;// 12.3分拆独立



    /**
     * 转化平均延迟时间
     */
    Map<String, Double> convertDelayTime;


}