package cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorBaseDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorDo;
import lombok.Data;

import java.util.*;

@Data
public class AdIdeaDo {

    /**
     * 创意计划ID
     */
    public Long ideaId;

    /**
     * 资源位ID
     */
    private Long resId;

    /**
     * 推广组ID
     */
    private Long groupId;

    /**
     * 出价
     * cpc计费：分/单次点击
     * cpm计费：分/千次曝光
     */
    private Double price;

    /**
     * 样式ID
     */
    private Long styleId;

    /**
     * 出价方式：1-roi出价、2-cpc出价
     */
    private Integer bidMode;

    /**
     * 目标roi
     */
    private Double roi;

    /**
     * 目标cpc
     */
    private Double cpc;

    /**
     * 直投cpc（仅直投set）
     */
    private Double directCpc;

    /**
     * 创意计划类型 0-人工 1-算法 2-直投
     */
    private Integer priceType;

    /**
     */
    private Integer billType;

    /**
     */
    private Integer bidType;

    /**
     * 创意素材投放类型 1-人工 2-算法
     */
    private Integer unitPutType;

    /**
     * 是否dpa计划
     */
    private boolean isDpa;

    /**
     * 创意素材列表
     */
    private List<IdeaUnitDo> ideaUnitDos;

    /**
     *维稳参数（仅互动需要set）
     */
    private AdxFactorBaseDo adxFactorBaseDo;

    /**
     *维稳参数-新（仅直投需要set）
     */
    private AdxFactorDo adxFactorDo;

    /**
     * 是否开启计划冷启动探价 0=关闭, 1-开启
     */
    private Boolean isColdStart;

    /**
     * 预估ctr
     */
    private Double preCtr;

    /**
     * 预估每pv发券（仅互动需要set）
     */
    private Double preLaunchPv;

    /**
     * 预估arpu（仅互动需要set）
     */
    private Double preArpu;

    /**
     * 计划统计数据（全场景1d,2d,7d）
     */
    private AdxStatsDo adxStatsDo;

    /**
     * 资源位统计数据（全场景1d,2d,7d）
     */
    private AdxStatsDo adxResourceStatDo;

    //首发券相关

    /**
     * 发券方式（0：传统发券，1：首发券）
     */
    private Integer adxLaunchType;

    /**
     * 首发券目标转化价格
     */
    private Long cpa;

    /**
     * 首发券广告ID
     */
    private Long flcAdvertId;

    /**
     * 预估CVR
     */
    private Double preCvr;

    /**
     * 预估clickPv（仅互动需要set）
     */
    private Double preClickPv;

    /**
     * 预估adCpc	（仅互动需要set）
     */
    private Double preAdCpc;

    /**
     * 用户打分模型打分
     */
    private Double userScore;

    /**
     * 用户打分模型打分v2
     */
    private Double userScoreV2;

    public List<IdeaUnitDo> getIdeaUnitDos() {
        return Optional.ofNullable(ideaUnitDos).orElse(new ArrayList<>());
    }

}
