package cn.com.duiba.nezha.alg.alg.vo.adx.rtb2;

import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.ColdStartFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.SlotFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorBaseDo;
import lombok.Data;
import org.apache.commons.collections.map.HashedMap;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@Data
public class AdxFactorDo implements Serializable {

    private static final long serialVersionUID = -3345356472023139396L;

    /**
     * 计划维度 控制参数
     */
    private AdxFactorBaseDo adFactorBaseDo = new AdxFactorBaseDo();

    /**
     * 计划+联盟媒体行业维度 控制参数
     */
    private AdxFactorBaseDo appFactorBaseDo = new AdxFactorBaseDo();

    /**
     * 计划+联盟媒体维度 控制参数
     */
    private AdxFactorBaseDo tradeFactorBaseDo = new AdxFactorBaseDo();

    /**
     * 计划冷启动探价 控制参数
     */
    private ColdStartFactorDo coldStartFactorDo = new ColdStartFactorDo();

    /**
     * 联盟广告位探量 控制参数
     */
    private SlotFactorDo slotFactorDo = new SlotFactorDo();

    /**
     * 日志打印
     */
    private String printStr;

    /**
     * 更新时间
     */
    private String updateTime;

    /**
     * 用户打分模型v2默认值map<推广组id，默认值>
     */
    private Map<Long, Double> userScoreDefaultMap = new HashMap<>();

}
