package cn.com.duiba.nezha.alg.alg.adx.directly2;

import cn.com.duiba.nezha.alg.alg.adx.rtbbid2.AdxRoiFactor;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly2.*;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

public class AdxPkExplore {

    private static final Logger logger = LoggerFactory.getLogger(AdxPkExplore.class);

    /**
     * 计算pk参数--定时任务、每20mins执行一次
     * @return
     */
    public static ExploreFactor getExploreFactor(AdxPkFactorReqDo adxPkFactorReqDo) {

        Map<Long, AdxDataDo> resDataDoMap = adxPkFactorReqDo.getResDataDoMap();

        Map<Long, AdxDataDo> ideaDataDoMap = adxPkFactorReqDo.getIdeaDataDoMap();

        ExploreFactor exploreFactor = adxPkFactorReqDo.getExploreFactor();

        try {
            resDataDoMap.forEach((resId, adxDataDo) -> {
                String pkPrefix = "resId"  + resId;

                AdxExpFactorDo eFactor = ExploreFactor.getEFactor(exploreFactor, resId);
                runEFactor(pkPrefix, adxDataDo, eFactor);
                exploreFactor.putResFactor(resId, eFactor);
            });


            ideaDataDoMap.forEach((ideaId, adxDataDo) -> {
                String pkPrefix = "ideaId"  + ideaId;

                AdxExpStatDo ideaStat = ExploreFactor.getIdeaStat(exploreFactor, ideaId);
                runStat(pkPrefix, adxDataDo, ideaStat);
                exploreFactor.putIdeaStatDo(ideaId, ideaStat);
            });

        }catch (Exception e) {
            logger.info("AdxPkExplore.getExploreFactor error", e);
        }

        return exploreFactor;
    }

    public static void runEFactor(String pkPrefix, AdxDataDo adxDataDo, AdxExpFactorDo eFactor) {

        if(AssertUtil.isAnyEmpty(pkPrefix, adxDataDo, eFactor)) {
            return;
        }

        try {
            Double resFactor = eFactor.getResFactor();
            AdxDataSubDo statSubDoDay = adxDataDo.getStatSubDo2();
            AdxDataBaseDo resDataBaseDo = statSubDoDay.getAdxDataBaseDo();
            resFactor = updateFactor(pkPrefix, resDataBaseDo, resFactor);
            eFactor.setResFactor(resFactor);



            Map<String, AdxDataBaseDo> adxDataBaseDoMap = statSubDoDay.getAdxDataBaseDoMap();
            adxDataBaseDoMap.forEach((appId, appDataBaseDo) -> {

                String prefix1 = pkPrefix + ",appId" + appId;
                Double appFactor = AdxExpFactorDo.getAppFactor(eFactor, appId);
                appFactor = updateFactor(prefix1, appDataBaseDo, appFactor);
                eFactor.putAppFactor(appId, appFactor);
            });
        }catch (Exception e) {
            logger.info("AdxPkExplore.runEFactor error", e);
        }


    }


    public static void runStat(String prefix, AdxDataDo adxDataDo, AdxExpStatDo ideaStat) {

        if(AssertUtil.isAnyEmpty(adxDataDo, ideaStat)) {
            return;
        }
        try {
            Double ideaEcpm = ideaStat.getIdeaEcpm();
            AdxDataSubDo statSubDoDay = adxDataDo.getStatSubDo2();
            AdxDataBaseDo resDataBaseDo = statSubDoDay.getAdxDataBaseDo();
            ideaEcpm = updateStat(prefix, resDataBaseDo, ideaEcpm);
            ideaStat.setIdeaEcpm(ideaEcpm);

            Map<String, AdxDataBaseDo> adxDataBaseDoMap = statSubDoDay.getAdxDataBaseDoMap();
            adxDataBaseDoMap.forEach((appId, appDataBaseDo) -> {
                String prefix1 = prefix + ",appId" + appId;

                Double appEcpm = AdxExpStatDo.getAppEcpm(ideaStat, appId);
                appEcpm = updateStat(prefix1, appDataBaseDo, appEcpm);
                ideaStat.putAppEcpm(appId, appEcpm);
            });
        }catch (Exception e) {
            logger.info("AdxPkExplore.runStat error", e);
        }


    }

    public static Double updateFactor(String pkPrefix, AdxDataBaseDo adxDataBaseDo, Double factor) {

        Double ret = factor;
        if(adxDataBaseDo == null) {
           return ret;
        }

        Double costDiff = AdxDataBaseDo.getCostDiff(adxDataBaseDo);
        ret = MathUtil.mean(factor, costDiff, 0.2);

        if(ret == null) {ret = 0.2;}
        ret = MathUtil.stdwithBoundary(ret, 0.2, 0.4);

        logger.info("pk{}, resFactor{}, lastFactor{}, costDiff{}", pkPrefix, ret, factor, costDiff);

        return ret;

    }

    public static Double updateStat(String prefix, AdxDataBaseDo adxDataBaseDo, Double ecpm) {

        Double ret = ecpm;
        if(adxDataBaseDo == null) {
            return ret;
        }

        Double statEcpm = AdxDataBaseDo.getIdeaEcpm(adxDataBaseDo);
        ret = MathUtil.mean(ecpm, statEcpm, 0.2);

        if(ret == null) {ret = 300.;}
        ret = MathUtil.stdwithBoundary(ret, 30, 3000);

        logger.info("pk{}, ecpm{}, lastEcpm{}, statEcpm{}", prefix, ret, ecpm, statEcpm);

        return ret;

    }




}
