/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.StrategyBidding;
import cn.com.duiba.nezha.alg.alg.vo.AdxDimension;
import cn.com.duiba.nezha.alg.alg.vo.AdxDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxFactorExplorationDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxPriceExplorationDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxAlgoBidding {
    public static String[] ADX_LEVEL = AdxDimension.ADX_LEVEL;
    private static final Logger logger = LoggerFactory.getLogger(AdxAlgoBidding.class);

    public static Map<String, String> getAdxAlgoPrice(AdxDo adxDoInfo, AdxRoiControlDo adxRoiControlDoInfo) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        try {
            Double minRoi = 1.0;
            Double defaultRoiFactor = 1.0;
            Double roiFactorLowerLimit = 0.7;
            Double roiFactorUpperLimit = 1.3;
            Double defaultPreCtr = 0.07;
            Double defaultStatClickValue = 10.0;
            Long advertDayConsumeLimit = 1000L;
            Long advertMsConsumeLimit = 200L;
            String level = "0";
            String isCompareGroup = "0";
            Long adxAlgoPrice = Math.round(Math.floor(defaultPreCtr * defaultStatClickValue * 1000.0 / (minRoi * defaultRoiFactor)));
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{adxDoInfo, adxRoiControlDoInfo})) {
                if (adxRoiControlDoInfo.getMinRoi() != null && adxRoiControlDoInfo.getMinRoi() > 1.0) {
                    minRoi = adxRoiControlDoInfo.getMinRoi();
                }
                if (adxRoiControlDoInfo.getBasePrice() != null && adxRoiControlDoInfo.getBasePrice() > 0.0) {
                    adxAlgoPrice = DataUtil.double2Long((Double)adxRoiControlDoInfo.getBasePrice());
                }
                Long defaultPrice = adxRoiControlDoInfo.getDefaultPrice();
                ArrayList<AdxStrategyDo> strategyDayDoList = adxRoiControlDoInfo.getStrategyDayDoList();
                List<AdxLevelDo> strategyFirDay = AdxAlgoBidding.getStrategyInfo(strategyDayDoList, "1");
                List<AdxLevelDo> strategySecDay = AdxAlgoBidding.getStrategyInfo(strategyDayDoList, "2");
                List<AdxLevelDo> strategyThiDay = AdxAlgoBidding.getStrategyInfo(strategyDayDoList, "3");
                ArrayList<AdxStrategyDo> strategyMsDoList = adxRoiControlDoInfo.getStrategyMsDoList();
                List<AdxLevelDo> strategyFirMs = AdxAlgoBidding.getStrategyInfo(strategyMsDoList, "1");
                List<AdxLevelDo> strategySecMs = AdxAlgoBidding.getStrategyInfo(strategyMsDoList, "2");
                List<AdxLevelDo> strategyThiMs = AdxAlgoBidding.getStrategyInfo(strategyMsDoList, "3");
                Map<String, Long> ideaMapInfo = adxRoiControlDoInfo.getIdeaIndexMap();
                Long ideaDayConsume = AdxAlgoBidding.nullToDefault(ideaMapInfo.get("advertConsume"), 0L);
                if (ideaDayConsume < advertMsConsumeLimit) {
                    isCompareGroup = "1";
                }
                String strategy = adxRoiControlDoInfo.getStrategy();
                AdxRoiFactorDo adxRoiFactor = adxRoiControlDoInfo.getAdxRoiFactorDo();
                AdxPriceExplorationDo priceExploration = adxRoiControlDoInfo.getPriceExplorationDo();
                AdxFactorExplorationDo factorExploration = adxRoiControlDoInfo.getFactorExplorationDo();
                Map<Object, Object> result = new HashMap();
                if (strategy.equals("1")) {
                    result = StrategyBidding.getStrategyFirBidding(adxDoInfo, defaultPrice, adxRoiFactor);
                }
                if (strategy.equals("2")) {
                    result = StrategyBidding.getStrategySecBidding(adxDoInfo, defaultPrice, priceExploration);
                }
                if (strategy.equals("3")) {
                    result = StrategyBidding.getStrategyThiBidding(adxDoInfo, defaultPrice, factorExploration);
                }
                level = (String)result.get("level");
                adxAlgoPrice = DataUtil.string2Long((String)((String)result.get("adxAlgoPrice")));
            }
            retMap.put("level", level);
            retMap.put("isCompareGroup", isCompareGroup);
            retMap.put("adxAlgoPrice", DataUtil.Long2String((Long)adxAlgoPrice));
        }
        catch (Exception e) {
            logger.error("AdxAlgoBidding.getAdxAlgoPrice error:" + e);
        }
        return retMap;
    }

    public static List<AdxLevelDo> getStrategyInfo(ArrayList<AdxStrategyDo> arrayListInfo, String strategyLabel) {
        List<AdxLevelDo> ret = new ArrayList<AdxLevelDo>();
        for (int i = 0; i < AdxDimension.STRATEGY.length; ++i) {
            AdxStrategyDo ind = arrayListInfo.get(i);
            if (!strategyLabel.equals(ind.getStrategy())) continue;
            ret = ind.getLevelDo();
        }
        return ret;
    }

    public static Long nullToDefault(Long value, Long defaultValue) {
        Long ret = defaultValue;
        if (value != null && value > 0L) {
            ret = value;
        }
        return ret;
    }

    public static Long addAllBucketMap(Map<String, Long> valueMap, Long defaultValue) {
        Long ret = 0L;
        for (int i = 0; i < ADX_LEVEL.length; ++i) {
            ret = AssertUtil.isEmpty(valueMap) || valueMap.get(ADX_LEVEL[i]) == null || valueMap.get(ADX_LEVEL[i]) < 0L ? Long.valueOf(ret + defaultValue) : Long.valueOf(ret + valueMap.get(ADX_LEVEL[i]));
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            HashMap<String, Long> advert1 = new HashMap<String, Long>();
            advert1.put("1", 5L);
            advert1.put("2", null);
            advert1.put("3", 573L);
            advert1.put("4", 2L);
            AdxDo adxDoInfo1 = new AdxDo();
            adxDoInfo1.setCurrentPreValue(0.083);
            adxDoInfo1.setStatCtr(0.063486);
            adxDoInfo1.setStatClickValue(20.050279);
            adxDoInfo1.setMinRoi(1.2);
            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();
            adxRoiControlDoInfo1.setMinPrice(1201L);
            adxRoiControlDoInfo1.setMinSuccessPrice(1300L);
            adxRoiControlDoInfo1.setDefaultPrice(1401L);
            adxRoiControlDoInfo1.setMaxPrice(2000L);
            adxRoiControlDoInfo1.setExpStatAllDayAdvertFee(1899L);
            adxRoiControlDoInfo1.setComStatAllDayAdvertFee(5L);
            adxRoiControlDoInfo1.setExpStatBucketAdvertFee(advert1);
            adxRoiControlDoInfo1.setComStatBucketAdvertFee(null);
            HashMap<String, Double> adxRoiFactor1 = new HashMap<String, Double>();
            adxRoiFactor1.put("1", 0.7);
            adxRoiFactor1.put("2", 1.0);
            adxRoiFactor1.put("3", 0.7);
            adxRoiFactor1.put("4", 1.05);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

