/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.AdxAlgoBidding;
import cn.com.duiba.nezha.alg.alg.adx.AdxBidding;
import cn.com.duiba.nezha.alg.alg.vo.AdxDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxAlgoBiddingOld {
    public static String[] adxPricelevel = new String[]{"1", "2", "3", "4"};
    private static final Logger logger = LoggerFactory.getLogger(AdxAlgoBidding.class);

    public static Map<String, String> getAdxAlgoPrice(AdxDo adxDoInfo, AdxRoiControlDo adxRoiControlDoInfo, Map<String, Double> adxRoiFactor) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        try {
            Double maxPrice;
            Double minPrice;
            Double defaultPrice;
            String adxValueLevel = "1";
            String isCompareGroup = "0";
            Double defaultPreCtr = 0.07;
            Double defaultStatClickValue = 10.0;
            Double defaultMinRoi = 1.0;
            Double defaultRoiFactor = 1.0;
            Double roiFactorLowerLimit = 0.7;
            Double roiFactorUpperLimit = 1.3;
            Long advertFeesDayLimit = 1500L;
            Long advertFeesLimit = 500L;
            Long adxAlgoPrice = Math.round(Math.floor(defaultPreCtr * defaultStatClickValue * 1000.0 / (defaultMinRoi * defaultRoiFactor)));
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{adxDoInfo, adxRoiControlDoInfo}) && AssertUtil.isAllNotEmpty((Object[])new Object[]{defaultPrice = DataUtil.toDouble((Long)adxRoiControlDoInfo.getDefaultPrice()), minPrice = DataUtil.toDouble((Long)adxRoiControlDoInfo.getMinPrice()), maxPrice = DataUtil.toDouble((Long)adxRoiControlDoInfo.getMaxPrice())})) {
                Double[] adxValueBucket = new Double[]{minPrice, defaultPrice, maxPrice};
                Double adxPrice = DataUtil.toDouble((Long)AdxBidding.getAdxParPrice(adxDoInfo, defaultRoiFactor));
                Double minRoi = adxDoInfo.getMinRoi();
                if (minRoi == null || minRoi < 1.0) {
                    minRoi = defaultMinRoi;
                }
                Double adxValue = adxPrice * minRoi;
                adxValueLevel = AdxAlgoBiddingOld.bucket(adxValue, adxValueBucket);
                Long expStatAllDayAdvertFee = AdxAlgoBiddingOld.nullToDefaultAdvertValue(adxRoiControlDoInfo.getExpStatAllDayAdvertFee(), 0L);
                Long comStatAllDayAdvertFee = AdxAlgoBiddingOld.nullToDefaultAdvertValue(adxRoiControlDoInfo.getComStatAllDayAdvertFee(), 0L);
                if (expStatAllDayAdvertFee + comStatAllDayAdvertFee < advertFeesDayLimit) {
                    isCompareGroup = "1";
                }
                Long expStatAdvertFee = AdxAlgoBiddingOld.addAllBucketMap(adxRoiControlDoInfo.getExpStatBucketAdvertFee(), 0L);
                Long comStatAdvertFee = AdxAlgoBiddingOld.addAllBucketMap(adxRoiControlDoInfo.getComStatBucketAdvertFee(), 0L);
                if (expStatAdvertFee + comStatAdvertFee < advertFeesLimit) {
                    isCompareGroup = "1";
                }
                Double roiFactor = defaultRoiFactor;
                if (adxRoiFactor != null) {
                    roiFactor = adxRoiFactor.get(adxValueLevel);
                }
                if (roiFactor == null) {
                    roiFactor = defaultRoiFactor;
                } else if (roiFactor < roiFactorLowerLimit) {
                    roiFactor = roiFactorLowerLimit;
                } else if (roiFactor > roiFactorUpperLimit) {
                    roiFactor = roiFactorUpperLimit;
                }
                adxAlgoPrice = adxRoiControlDoInfo.getDefaultPrice();
                if (isCompareGroup.equals("0")) {
                    adxAlgoPrice = AdxBidding.getAdxParPrice(adxDoInfo, roiFactor);
                }
            }
            retMap.put("adxPriceLevel", adxValueLevel);
            retMap.put("isCompareGroup", isCompareGroup);
            retMap.put("adxAlgoPrice", DataUtil.Long2String((Long)adxAlgoPrice));
        }
        catch (Exception e) {
            logger.error("AdxAlgoBidding.getAdxAlgoPrice error:" + e);
        }
        return retMap;
    }

    public static String bucket(Double value, Double[] bucketList) {
        int ret = 1;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                double bound = bucketList[i];
                if (!(value <= bound)) continue;
                ret = i + 1;
                break;
            }
        }
        return adxPricelevel[ret - 1];
    }

    public static Long nullToDefaultAdvertValue(Long value, Long defaultValue) {
        Long ret = defaultValue;
        if (value != null && value > 0L) {
            ret = value;
        }
        return ret;
    }

    public static Long addAllBucketMap(Map<String, Long> valueMap, Long defaultValue) {
        Long ret = 0L;
        for (int i = 0; i < adxPricelevel.length; ++i) {
            ret = AssertUtil.isEmpty(valueMap) || valueMap.get(adxPricelevel[i]) == null || valueMap.get(adxPricelevel[i]) < 0L ? Long.valueOf(ret + defaultValue) : Long.valueOf(ret + valueMap.get(adxPricelevel[i]));
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            Double value1 = 5000.0;
            Double[] list1 = new Double[]{1000.0, 1400.0, 2400.0};
            String level1 = AdxAlgoBiddingOld.bucket(value1, list1);
            HashMap<String, Long> advert1 = new HashMap<String, Long>();
            advert1.put("1", 5L);
            advert1.put("2", null);
            advert1.put("3", 573L);
            advert1.put("4", 2L);
            AdxDo adxDoInfo1 = new AdxDo();
            adxDoInfo1.setCurrentPreValue(0.083);
            adxDoInfo1.setStatCtr(0.063486);
            adxDoInfo1.setStatClickValue(20.050279);
            adxDoInfo1.setMinRoi(1.2);
            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();
            adxRoiControlDoInfo1.setMinPrice(1201L);
            adxRoiControlDoInfo1.setMinSuccessPrice(1300L);
            adxRoiControlDoInfo1.setDefaultPrice(1401L);
            adxRoiControlDoInfo1.setMaxPrice(2000L);
            adxRoiControlDoInfo1.setExpStatAllDayAdvertFee(1899L);
            adxRoiControlDoInfo1.setComStatAllDayAdvertFee(5L);
            adxRoiControlDoInfo1.setExpStatBucketAdvertFee(advert1);
            adxRoiControlDoInfo1.setComStatBucketAdvertFee(null);
            HashMap<String, Double> adxRoiFactor1 = new HashMap<String, Double>();
            adxRoiFactor1.put("1", 0.7);
            adxRoiFactor1.put("2", 1.0);
            adxRoiFactor1.put("3", 0.7);
            adxRoiFactor1.put("4", 1.05);
            Map<String, String> ret1 = AdxAlgoBiddingOld.getAdxAlgoPrice(adxDoInfo1, adxRoiControlDoInfo1, adxRoiFactor1);
            System.out.println("ret:" + JSON.toJSONString(ret1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

