/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.vo.AdxDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import com.alibaba.fastjson.JSON;

public class AdxBidding {
    public static Long getAdxParPrice(AdxDo adxDoInfo, Double adxBiddingRoiFactor) {
        Double minRoi = 1.0;
        Double defaultRoiFactor = 1.0;
        Double roiFactorLowerLimit = 0.7;
        Double roiFactorUpperLimit = 1.3;
        Double defaultPreCtr = 0.07;
        Double defaultStatClickValue = 10.0;
        if (adxBiddingRoiFactor == null) {
            adxBiddingRoiFactor = defaultRoiFactor;
        } else if (adxBiddingRoiFactor < roiFactorLowerLimit) {
            adxBiddingRoiFactor = roiFactorLowerLimit;
        } else if (adxBiddingRoiFactor > roiFactorUpperLimit) {
            adxBiddingRoiFactor = roiFactorUpperLimit;
        }
        Long parPrice = Math.round(Math.floor(defaultPreCtr * defaultStatClickValue * 1000.0 / (minRoi * adxBiddingRoiFactor)));
        if (AssertUtil.isNotEmpty((Object)adxDoInfo)) {
            Double preCtr;
            Double statCtr = adxDoInfo.getStatCtr();
            Double statCtrResource = adxDoInfo.getStatCtrResource();
            Double currentPreValue = adxDoInfo.getCurrentPreValue();
            Double statClickValue = adxDoInfo.getStatClickValue();
            Double statClickValueResource = adxDoInfo.getStatClickValueResource();
            if (adxDoInfo.getMinRoi() != null && adxDoInfo.getMinRoi() > 1.0) {
                minRoi = adxDoInfo.getMinRoi();
            }
            if ((preCtr = AdxBidding.getPreCtr(statCtr, statCtrResource, currentPreValue)) == null || preCtr <= 0.0 || preCtr > 1.0) {
                preCtr = defaultPreCtr;
            }
            Double preClickValue = AdxBidding.getReduceValue(statClickValue, statClickValueResource, defaultStatClickValue, 10000.0, 0.0);
            if (statClickValue == null || statClickValue <= 0.0) {
                statClickValue = defaultStatClickValue;
            }
            parPrice = Math.round(Math.floor(preCtr * statClickValue * 1000.0 / (minRoi * adxBiddingRoiFactor)));
        }
        return parPrice;
    }

    public static Double getReduceValue(Double value1, Double value2, Double defValue, Double uppLimit, Double lowLimit) {
        Double ret = defValue;
        if (value2 != null && value2 > lowLimit && value2 <= uppLimit) {
            ret = value2;
        }
        if (value1 != null && value1 > lowLimit && value1 <= uppLimit) {
            ret = value1;
        }
        return ret;
    }

    public static Double getPreCtr(Double statValue, Double statValueResource, Double modelPreValue) {
        Double ret = 0.07;
        Double preCtrFactor = 0.0;
        Double vUpperLimit = 0.9999;
        Double vLowerLimit = 0.0;
        Double fUpperLimit = 3.0;
        Double fLowerLimit = 0.2;
        if (statValue == null || statValue < vLowerLimit || statValue > vUpperLimit) {
            statValue = ret;
        }
        ret = modelPreValue == null || modelPreValue < vLowerLimit || modelPreValue > vUpperLimit ? statValue : (modelPreValue / statValue > fLowerLimit && modelPreValue / statValue < fUpperLimit ? Double.valueOf(preCtrFactor * modelPreValue + (1.0 - preCtrFactor) * statValue) : statValue);
        return ret;
    }

    public static void main(String[] args) {
        try {
            AdxDo adxDoInfo = new AdxDo();
            adxDoInfo.setCurrentPreValue(null);
            adxDoInfo.setStatCtr(0.0);
            adxDoInfo.setStatClickValue(0.0);
            adxDoInfo.setMinRoi(0.0);
            Double roiFactor = 0.0;
            Long testParPrice = AdxBidding.getAdxParPrice(adxDoInfo, roiFactor);
            System.out.println("testGetAdxParPrice:" + JSON.toJSONString((Object)testParPrice));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

