/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.vo.AdxDimension;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiFactorDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;

public class AdxRoiFactor {
    public static String[] ADX_LEVEL = AdxDimension.ADX_LEVEL;

    public static AdxRoiFactorDo getAdxRoiFactor(AdxRoiControlDo adxRoiControlDoInfo) {
        AdxRoiFactorDo ret = null;
        Long currentTime = DataUtil.string2Long((String)LocalDateUtil.getCurrentLocalDateTime((String)"HHmm"));
        return ret;
    }

    public static Map<String, Double> calculateMap(Map<String, Double> expAdxFeeMap, Map<String, Double> comAdxFeeMap, Map<String, Double> expAdvertFeeMap, Map<String, Double> comAdvertFeeMap) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        for (Map.Entry<String, Double> entry : expAdxFeeMap.entrySet()) {
            String key = entry.getKey();
            Double adx = expAdxFeeMap.get(key) + comAdxFeeMap.get(key);
            Double advert = expAdvertFeeMap.get(key) + comAdvertFeeMap.get(key);
            Double roi = DataUtil.division((Double)advert, (Double)adx, (int)6);
            retMap.put(key, roi);
        }
        return retMap;
    }

    public static Double nullToDefaultAdxValue(Long value, Double defaultValue) {
        Double ret = defaultValue;
        if (value != null && value > 0L) {
            ret = DataUtil.toDouble((Long)value) / 10000.0 / 1000.0;
        }
        return ret;
    }

    public static Double nullToDefaultAdvertValue(Long value, Double defaultValue) {
        Double ret = defaultValue;
        if (value != null && value > 0L) {
            ret = DataUtil.toDouble((Long)value);
        }
        return ret;
    }

    public static Map<String, Double> nullToDefaultAdxValue(Map<String, Long> valueMap, Double defaultValue) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        for (int i = 0; i < ADX_LEVEL.length; ++i) {
            if (AssertUtil.isEmpty(valueMap) || valueMap.get(ADX_LEVEL[i]) == null || valueMap.get(ADX_LEVEL[i]) < 0L) {
                retMap.put(ADX_LEVEL[i], defaultValue);
                continue;
            }
            retMap.put(ADX_LEVEL[i], DataUtil.toDouble((Long)valueMap.get(ADX_LEVEL[i])) / 10000.0 / 1000.0);
        }
        return retMap;
    }

    public static Map<String, Double> nullToDefaultAdvertValue(Map<String, Long> valueMap, Double defaultValue) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        for (int i = 0; i < ADX_LEVEL.length; ++i) {
            if (AssertUtil.isEmpty(valueMap) || valueMap.get(ADX_LEVEL[i]) == null || valueMap.get(ADX_LEVEL[i]) < 0L) {
                retMap.put(ADX_LEVEL[i], defaultValue);
                continue;
            }
            retMap.put(ADX_LEVEL[i], DataUtil.toDouble((Long)valueMap.get(ADX_LEVEL[i])));
        }
        return retMap;
    }

    public static Double addAllBucketAdxMap(Map<String, Long> valueMap, Double defaultValue) {
        Double ret = defaultValue;
        for (int i = 0; i < ADX_LEVEL.length; ++i) {
            ret = AssertUtil.isEmpty(valueMap) || valueMap.get(ADX_LEVEL[i]) == null || valueMap.get(ADX_LEVEL[i]) < 0L ? Double.valueOf(ret + defaultValue) : Double.valueOf(ret + DataUtil.toDouble((Long)valueMap.get(ADX_LEVEL[i])) / 10000.0 / 1000.0);
        }
        return ret;
    }

    public static Double addAllBucketAdvertMap(Map<String, Long> valueMap, Double defaultValue) {
        Double ret = defaultValue;
        for (int i = 0; i < ADX_LEVEL.length; ++i) {
            ret = AssertUtil.isEmpty(valueMap) || valueMap.get(ADX_LEVEL[i]) == null || valueMap.get(ADX_LEVEL[i]) < 0L ? Double.valueOf(ret + defaultValue) : Double.valueOf(ret + DataUtil.toDouble((Long)valueMap.get(ADX_LEVEL[i])));
        }
        return ret;
    }

    public static Double bucket(Double value, Double[] bucketList) {
        Double ret = 0.0;
        if (value != null && bucketList != null && bucketList.length > 0) {
            for (int i = 0; i < bucketList.length; ++i) {
                double bound = bucketList[i];
                if (!(value <= bound)) continue;
                ret = bound;
                break;
            }
            if (value > bucketList[bucketList.length - 1]) {
                ret = bucketList[bucketList.length - 1];
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            Double[] v1 = new Double[]{0.2, 0.5, 0.8, 1.0};
            HashMap<String, Double> lastAdxRoiFactor1 = new HashMap<String, Double>();
            lastAdxRoiFactor1.put("1", 1.3);
            lastAdxRoiFactor1.put("2", 1.3);
            lastAdxRoiFactor1.put("3", 1.277543885714286);
            lastAdxRoiFactor1.put("4", 1.3);
            lastAdxRoiFactor1.put("5", null);
            HashMap<String, Long> adx1 = new HashMap<String, Long>();
            adx1.put("1", 1107503120000L);
            adx1.put("2", 24207390000L);
            adx1.put("3", 79705700000L);
            adx1.put("4", 41989670000L);
            HashMap<String, Long> advert1 = new HashMap<String, Long>();
            advert1.put("1", 107986L);
            advert1.put("2", 2516L);
            advert1.put("3", 13042L);
            advert1.put("4", 6205L);
            HashMap<String, Long> adx2 = new HashMap<String, Long>();
            adx2.put("1", 48730890000L);
            adx2.put("2", 2602280000L);
            adx2.put("3", 44230000L);
            adx2.put("4", 65470000L);
            HashMap<String, Long> advert2 = new HashMap<String, Long>();
            advert2.put("1", 6758L);
            advert2.put("2", 19L);
            advert2.put("3", 3L);
            advert2.put("4", 26L);
            HashMap<String, Long> comAdx1 = new HashMap<String, Long>();
            comAdx1.put("1", 11286750000L);
            comAdx1.put("2", 0L);
            comAdx1.put("3", 0L);
            comAdx1.put("4", 22580000L);
            HashMap<String, Long> comAdvert1 = new HashMap<String, Long>();
            comAdvert1.put("1", 1372L);
            comAdvert1.put("2", 0L);
            comAdvert1.put("3", 0L);
            comAdvert1.put("4", 0L);
            HashMap<String, Long> comAdx2 = new HashMap<String, Long>();
            comAdx2.put("1", 0L);
            comAdx2.put("2", 0L);
            comAdx2.put("3", 0L);
            comAdx2.put("4", 0L);
            HashMap<String, Long> comAdvert2 = new HashMap<String, Long>();
            comAdvert2.put("1", 7570000L);
            comAdvert2.put("2", 0L);
            comAdvert2.put("3", 0L);
            comAdvert2.put("4", 0L);
            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();
            adxRoiControlDoInfo1.setExpStatAllDayAdxFee(1253394870000L);
            adxRoiControlDoInfo1.setExpStatAllDayAdvertFee(129749L);
            adxRoiControlDoInfo1.setExpStatBucketDayAdxFee(adx1);
            adxRoiControlDoInfo1.setExpStatBucketDayAdvertFee(advert1);
            adxRoiControlDoInfo1.setExpStatBucketAdxFee(adx2);
            adxRoiControlDoInfo1.setExpStatBucketAdvertFee(advert2);
            adxRoiControlDoInfo1.setComStatAllDayAdxFee(11309330000L);
            adxRoiControlDoInfo1.setComStatAllDayAdvertFee(1372L);
            adxRoiControlDoInfo1.setComStatBucketDayAdxFee(comAdx1);
            adxRoiControlDoInfo1.setComStatBucketDayAdvertFee(comAdvert1);
            adxRoiControlDoInfo1.setComStatBucketAdxFee(comAdx2);
            adxRoiControlDoInfo1.setComStatBucketAdvertFee(comAdvert2);
            AdxRoiFactorDo ret2 = AdxRoiFactor.getAdxRoiFactor(adxRoiControlDoInfo1);
            System.out.println("ret2:" + JSON.toJSONString((Object)ret2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

