/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.AdxAlgoBidding;
import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxFactorExplorationDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactorExploration {
    private static final Logger logger = LoggerFactory.getLogger(AdxAlgoBidding.class);

    public static AdxFactorExplorationDo getExploreFactor(AdxRoiControlDo adxRoiControlDoInfo) {
        AdxFactorExplorationDo ret = new AdxFactorExplorationDo();
        try {
            Double defaultFactor = 1.0;
            Double defaultMinRoi = 1.0;
            Double lowerLimit = 0.3;
            Double upperLimit = 1.7;
            Double[] stepList = new Double[]{-0.05, 0.0, 0.05};
            Double[] diffList = new Double[]{0.02, 0.05, 0.08, 0.1};
            Double baseValue = defaultFactor;
            Double[] baseFlowRate = new Double[]{0.2, 0.6, 0.2};
            Double[] lastRealRoi = new Double[]{0.0, 0.0, 0.0};
            Double[] lastRealSucRate = new Double[]{0.0, 0.0, 0.0};
            HashMap<String, Double> factorMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> flowRateMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> lastRoiMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> lastSucRateMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            Long tryLabel = 0L;
            Long bidCntMs = 0L;
            Long sucBidCntMs = 0L;
            Double roiDay = 0.0;
            Double sucRateDay = 0.0;
            Double adxConsumeDay = 0.0;
            Double advertConsumeMs = 0.0;
            Long bidCntDay = 0L;
            Long sucBidCntDay = 0L;
            Double roiMs = 0.0;
            Double sucRateMs = 0.0;
            Double adxConsumeMs = 0.0;
            Double advertConsumeDay = 0.0;
            if (AssertUtil.isNotEmpty((Object)adxRoiControlDoInfo)) {
                Object uppSuc;
                Double minRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinRoi(), defaultMinRoi);
                Long defaultCnt = 0L;
                Long defaultConsume = 0L;
                ArrayList<AdxStrategyDo> strategyMsDoList = adxRoiControlDoInfo.getStrategyMsDoList();
                List<AdxLevelDo> strategyThiMs = StrategyBid.getStrategyInfo(strategyMsDoList, AdxStrategy.ADX_STRATEGY_THI.getCode());
                ArrayList<AdxStrategyDo> strategyDayDoList = adxRoiControlDoInfo.getStrategyDayDoList();
                List<AdxLevelDo> strategyThiDay = StrategyBid.getStrategyInfo(strategyDayDoList, AdxStrategy.ADX_STRATEGY_THI.getCode());
                Map<String, Double> sucRateLevelMs = StrategyBid.getLevelSucRate(strategyThiMs);
                Map<String, Long> sucCntLevelMs = StrategyBid.getLevelIndex(strategyThiMs, AdxIndex.BID_SUC.getCode(), defaultCnt);
                Map<String, Long> adxConsumeLevelMs = StrategyBid.getLevelIndex(strategyThiMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume);
                Map<String, Long> advertConsumeLevelMs = StrategyBid.getLevelIndex(strategyThiMs, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume);
                Map<String, Double> roiRealLevelMs = StrategyBid.getLevelRoi(strategyThiMs, minRoi);
                Map<String, Double> roiLevelMs = StrategyBid.getRoiFactorRectify(roiRealLevelMs, adxConsumeLevelMs, adxRoiControlDoInfo);
                roiMs = StrategyBid.getRoi(strategyThiMs, minRoi);
                sucRateMs = StrategyBid.getSucRate(strategyThiMs);
                bidCntMs = StrategyBid.getSumLevelIndex(strategyThiMs, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntMs = StrategyBid.getSumLevelIndex(strategyThiMs, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeMs = DataUtil.division((Long)StrategyBid.getSumLevelIndex(strategyThiMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), (Long)10000000L, (int)2);
                advertConsumeMs = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategyThiMs, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));
                roiDay = StrategyBid.getRoi(strategyThiDay, minRoi);
                sucRateDay = StrategyBid.getSucRate(strategyThiDay);
                bidCntDay = StrategyBid.getSumLevelIndex(strategyThiDay, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntDay = StrategyBid.getSumLevelIndex(strategyThiDay, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeDay = DataUtil.division((Long)StrategyBid.getSumLevelIndex(strategyThiDay, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), (Long)10000000L, (int)2);
                advertConsumeDay = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategyThiDay, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));
                Double resoRoiMs = 0.0;
                Double resoSucRateMs = 0.0;
                Map<String, Long> resoMapInfo = adxRoiControlDoInfo.getResourceIndexMap();
                if (AssertUtil.isNotEmpty(resoMapInfo)) {
                    resoRoiMs = StrategyBid.getRoi(resoMapInfo, minRoi);
                    resoSucRateMs = StrategyBid.getSucRate(resoMapInfo);
                }
                if (sucRateMs < 0.05 && sucRateMs < resoSucRateMs * 0.2 && adxConsumeMs < 200.0) {
                    tryLabel = 1L;
                } else if (sucRateLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < 0.05 && sucRateLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < resoSucRateMs * 0.2 && adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < 2000000000L && roiLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()) < minRoi * 0.95) {
                    tryLabel = 1L;
                }
                baseValue = defaultFactor;
                Double lowValue = baseValue + 0.05;
                Double uppValue = baseValue - 0.05;
                Double diff = DataUtil.division((Double)roiMs, (Double)minRoi, (int)3);
                Double lastMinRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getLastMinRoi(), defaultMinRoi);
                Long currentTime = DataUtil.string2Long((String)LocalDateUtil.getCurrentLocalDateTime((String)"HHmm"));
                if (minRoi.compareTo(lastMinRoi) != 0 || currentTime == null || currentTime >= 0L && currentTime < 20L || bidCntDay == 0L) {
                    baseValue = defaultFactor;
                } else {
                    Double incre1 = 1.0;
                    AdxFactorExplorationDo lastFactorDoInfo = adxRoiControlDoInfo.getLastFactorExplorationDo();
                    if (AssertUtil.isNotEmpty((Object)lastFactorDoInfo)) {
                        Map<String, Double> lastFactorMap = lastFactorDoInfo.getFactorExploreMap();
                        String bestLevel = StrategyBid.selectBestLevel(minRoi, roiLevelMs, sucRateLevelMs);
                        if (AssertUtil.isNotEmpty(lastFactorMap)) {
                            if (lastFactorMap.get(AdxLevel.ADX_LEVEL_TWO.getCode()) != null) {
                                baseValue = lastFactorMap.get(AdxLevel.ADX_LEVEL_TWO.getCode());
                                lowValue = lastFactorMap.get(AdxLevel.ADX_LEVEL_THR.getCode());
                                uppValue = lastFactorMap.get(AdxLevel.ADX_LEVEL_ONE.getCode());
                            }
                            if (lastFactorMap.get(bestLevel) != null) {
                                incre1 = DataUtil.division((Double)lastFactorMap.get(bestLevel), (Double)baseValue, (int)3);
                            }
                        }
                    }
                    if (bidCntMs == 0L) {
                        Double baseDiff = baseValue - defaultFactor;
                        baseValue = baseValue - baseDiff * 0.2;
                    } else {
                        Double weight1 = 1.0;
                        weight1 = sucRateMs < 0.05 || sucRateMs < resoSucRateMs * 0.05 ? Double.valueOf(0.0) : Double.valueOf(diff < 0.6 ? 0.0 : (diff < 0.8 ? 0.5 : (diff < 0.9 ? 0.8 : 1.0)));
                        Double incre2 = 1.0;
                        if (roiMs > 0.0) {
                            incre2 = DataUtil.division((Double)(minRoi * 0.98), (Double)roiMs, (int)3);
                        }
                        Double weight2 = 1.0;
                        weight2 = sucRateMs < 0.05 || sucRateMs < resoSucRateMs * 0.05 ? Double.valueOf(0.0) : Double.valueOf(diff < 0.95 ? 0.7 : (diff < 1.05 ? 0.5 : 0.8));
                        Double remainStableLimit = StrategyBid.getRemainStableLimit(roiDay, minRoi, sucRateDay, resoSucRateMs, adxConsumeDay);
                        incre1 = StrategyBid.getNormalValue(incre1, 1.0, 0.9, 1.1);
                        incre2 = StrategyBid.getNormalValue(incre2, 1.0, 1.0 - remainStableLimit, 1.0 + remainStableLimit);
                        Double incre = 1.0 + (incre1 - 1.0) * weight1 * 0.5 + (incre2 - 1.0) * weight2 * 0.5;
                        if (weight1 == 0.0) {
                            incre = 1.0 + (incre2 - 1.0) * weight2;
                        }
                        Double coeff = StrategyBid.bucket(Math.abs(diff - 1.0), diffList);
                        if (tryLabel != 1L) {
                            baseValue = StrategyBid.getNormalValue(baseValue * incre, defaultFactor, baseValue * (1.0 - coeff), baseValue * (1.0 + coeff));
                        }
                        baseValue = DataUtil.formatDouble((Double)StrategyBid.getNormalValue(baseValue, defaultFactor, lowerLimit, upperLimit), (int)6);
                    }
                }
                if (tryLabel == 1L) {
                    stepList[2] = lowValue - baseValue;
                    uppSuc = DataUtil.division((Double)sucRateLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()), (Double)resoSucRateMs, (int)3);
                    Double stepSuc = (Double)uppSuc < 0.4 ? 0.15 : ((Double)uppSuc < 0.5 ? 0.08 : ((Double)uppSuc < 0.6 ? -0.08 : -0.15));
                    Double uppDiff = DataUtil.division((Double)roiLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()), (Double)minRoi, (int)3);
                    Double stepRoi = uppDiff < 0.8 ? -0.1 : (uppDiff < 0.95 ? -0.07 : (uppDiff < 1.05 ? 0.05 : (uppDiff < 1.2 ? 0.07 : 0.1)));
                    if (adxConsumeMs == 0.0) {
                        stepSuc = 0.15;
                        stepRoi = 0.15;
                    }
                    stepList[0] = uppValue - baseValue - (0.5 * stepSuc + 0.5 * stepRoi);
                } else {
                    uppSuc = stepList;
                    Double.valueOf(uppSuc[0] - (diff < 1.05 ? -0.03 : (diff < 1.1 ? -0.02 : (diff < 1.2 ? 0.0 : (diff < 1.3 ? 0.03 : 0.05)))));
                    uppSuc = stepList;
                    Double.valueOf((Double)uppSuc[2] + (diff < 0.7 ? 0.05 : (diff < 0.8 ? 0.03 : (diff < 0.9 ? 0.0 : (diff < 0.95 ? -0.02 : -0.03)))));
                }
                if (tryLabel == 1L) {
                    baseFlowRate[0] = 0.2;
                    baseFlowRate[2] = 0.2;
                } else if (diff < 0.9) {
                    baseFlowRate[0] = 0.1;
                    baseFlowRate[2] = diff < 0.8 ? 0.3 : 0.2;
                } else if (diff > 1.1) {
                    baseFlowRate[0] = diff < 1.2 ? 0.2 : 0.3;
                    baseFlowRate[2] = 0.1;
                } else if (diff > 0.95 && diff < 1.05) {
                    baseFlowRate[0] = 0.1;
                    baseFlowRate[2] = 0.1;
                } else {
                    baseFlowRate[0] = 0.15;
                    baseFlowRate[2] = 0.15;
                }
                baseFlowRate[1] = DataUtil.formatDouble((Double)(1.0 - baseFlowRate[2] - baseFlowRate[0]), (int)3);
                for (int i = 1; i < AdxLevel.values().length; ++i) {
                    lastRealRoi[i - 1] = roiLevelMs.get(DataUtil.Integer2String((Integer)i));
                    lastRealSucRate[i - 1] = sucRateLevelMs.get(DataUtil.Integer2String((Integer)i));
                }
            }
            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
                int i = DataUtil.toInt((Long)DataUtil.string2Long((String)key));
                Double factor = DataUtil.formatDouble((Double)(baseValue + stepList[i - 1]), (int)6);
                Double flowRate = baseFlowRate[i - 1];
                Double lastRoi = lastRealRoi[i - 1];
                Double lastSucRate = lastRealSucRate[i - 1];
                factorMap.put(key, factor);
                flowRateMap.put(key, flowRate);
                lastRoiMap.put(key, lastRoi);
                lastSucRateMap.put(key, lastSucRate);
            }
            ret.setFactorExploreMap(factorMap);
            ret.setFactorFlowRateMap(flowRateMap);
            ret.setLastRealRoiMap(lastRoiMap);
            ret.setLastSucRateMap(lastSucRateMap);
            ret.setTryLabel(tryLabel);
            ret.setRoiDay(roiDay);
            ret.setSucDay(sucRateDay);
            ret.setBidCntDay(bidCntDay);
            ret.setSucBidCntDay(sucBidCntDay);
            ret.setAdxConsumeDay(adxConsumeDay);
            ret.setAdvertConsumeDay(advertConsumeDay);
            ret.setRoiMs(roiMs);
            ret.setSucMs(sucRateMs);
            ret.setBidCntMs(bidCntMs);
            ret.setSucBidCntMs(sucBidCntMs);
            ret.setAdxConsumeMs(adxConsumeMs);
            ret.setAdvertConsumeMs(advertConsumeMs);
        }
        catch (Exception e) {
            logger.error("FactorExploration.getExploreFactor error:" + e);
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();
            adxRoiControlDoInfo1.setBasePrice(900.0);
            String str = "{\"adxRoiFactorDo\":{\"advertConsumeDay\":197.0,\"advertConsumeMs\":27.0,\"adxConsumeDay\":221.36,\"adxConsumeMs\":4.21,\"adxRoiFactor\":1.450009,\"bidCntDay\":556,\"bidCntMs\":288,\"lastRealRoi\":1.6881,\"roiDay\":0.889963,\"roiMs\":1.6881,\"sucBidCntDay\":173,\"sucBidCntMs\":2,\"sucDay\":0.311152,\"sucMs\":0.006945},\"basePrice\":1400.0,\"defaultPrice\":1401,\"factorExplorationDo\":{\"advertConsumeDay\":152.0,\"advertConsumeMs\":152.0,\"adxConsumeDay\":243.78,\"adxConsumeMs\":243.78,\"bidCntDay\":274,\"bidCntMs\":275,\"factorExploreMap\":{\"1\":1.080001,\"2\":1.100002,\"3\":1.200002},\"factorFlowRateMap\":{\"1\":0.1,\"2\":0.6,\"3\":0.3},\"lastRealRoiMap\":{\"1\":0.611059,\"2\":0.623529,\"3\":0.636001},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.68,\"3\":0.0},\"roiDay\":0.623529,\"roiMs\":0.623529,\"sucBidCntDay\":187,\"sucBidCntMs\":187,\"sucDay\":0.682482,\"sucMs\":0.68,\"tryLabel\":0},\"feeType\":1,\"ideaIndexMap\":{\"bidSuc\":21,\"advertConsume\":83,\"adxConsume\":308310000,\"bid\":735,\"exp\":22,\"click\":7},\"lastAdxRoiFactorDo\":{\"advertConsumeDay\":197.0,\"advertConsumeMs\":27.0,\"adxConsumeDay\":221.36,\"adxConsumeMs\":4.21,\"adxRoiFactor\":1.450009,\"bidCntDay\":556,\"bidCntMs\":288,\"lastRealRoi\":1.6881,\"roiDay\":0.889963,\"roiMs\":1.6881,\"sucBidCntDay\":173,\"sucBidCntMs\":2,\"sucDay\":0.311152,\"sucMs\":0.006945},\"lastFactorExplorationDo\":{\"advertConsumeDay\":152.0,\"advertConsumeMs\":152.0,\"adxConsumeDay\":243.78,\"adxConsumeMs\":243.78,\"bidCntDay\":274,\"bidCntMs\":275,\"factorExploreMap\":{\"1\":1.080001,\"2\":1.100002,\"3\":1.200002},\"factorFlowRateMap\":{\"1\":0.1,\"2\":0.6,\"3\":0.3},\"lastRealRoiMap\":{\"1\":0.611059,\"2\":0.623529,\"3\":0.636001},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.68,\"3\":0.0},\"roiDay\":0.623529,\"roiMs\":0.623529,\"sucBidCntDay\":187,\"sucBidCntMs\":187,\"sucDay\":0.682482,\"sucMs\":0.68,\"tryLabel\":0},\"lastMinRoi\":1.29,\"lastPriceExplorationDo\":{\"advertConsumeDay\":206.0,\"advertConsumeMs\":206.0,\"adxConsumeDay\":356.11,\"adxConsumeMs\":356.11,\"bidCntDay\":274,\"bidCntMs\":275,\"lastRealRoiMap\":{\"1\":0.612395,\"2\":0.600155,\"3\":0.588396},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.996213,\"3\":1.0},\"priceExploreMap\":{\"1\":1135,\"2\":1261,\"3\":1400},\"priceFlowRateMap\":{\"1\":0.3,\"2\":0.6,\"3\":0.1},\"roiDay\":0.57848,\"roiMs\":0.57848,\"sucBidCntDay\":273,\"sucBidCntMs\":274,\"sucDay\":0.996351,\"sucMs\":0.996364,\"tryLabel\":0,\"upLimitBidFee\":1401},\"maxPrice\":1901,\"minPrice\":1321,\"minRoi\":1.29,\"priceExplorationDo\":{\"advertConsumeDay\":206.0,\"advertConsumeMs\":206.0,\"adxConsumeDay\":356.11,\"adxConsumeMs\":356.11,\"bidCntDay\":274,\"bidCntMs\":275,\"lastRealRoiMap\":{\"1\":0.612395,\"2\":0.600155,\"3\":0.588396},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.996213,\"3\":1.0},\"priceExploreMap\":{\"1\":1135,\"2\":1261,\"3\":1400},\"priceFlowRateMap\":{\"1\":0.3,\"2\":0.6,\"3\":0.1},\"roiDay\":0.57848,\"roiMs\":0.57848,\"sucBidCntDay\":273,\"sucBidCntMs\":274,\"sucDay\":0.996351,\"sucMs\":0.996364,\"tryLabel\":0,\"upLimitBidFee\":1401},\"resourceIndexMap\":{\"bidSuc\":12731,\"advertConsume\":21454,\"adxConsume\":169874504000,\"bid\":14175,\"exp\":12111,\"click\":2043},\"strategyDayDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":173,\"advertConsume\":197,\"adxConsume\":2213580000,\"bid\":577,\"exp\":158,\"click\":22}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":264,\"advertConsume\":206,\"adxConsume\":3460470000,\"bid\":397,\"exp\":247,\"click\":24}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":31,\"advertConsume\":83,\"adxConsume\":408900000,\"bid\":31,\"exp\":29,\"click\":7}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":187,\"advertConsume\":152,\"adxConsume\":2437740000,\"bid\":422,\"exp\":174,\"click\":20}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"3\"}],\"strategyMsDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":2,\"advertConsume\":27,\"adxConsume\":42030000,\"bid\":288,\"exp\":3,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":1,\"advertConsume\":22,\"adxConsume\":28020000,\"bid\":134,\"exp\":2,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":20,\"advertConsume\":83,\"adxConsume\":280290000,\"bid\":20,\"exp\":20,\"click\":7}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":2,\"advertConsume\":23,\"adxConsume\":28020000,\"bid\":178,\"exp\":2,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"3\"}]}\n";
            AdxRoiControlDo adxRoiControlDoInfo3 = (AdxRoiControlDo)JSONObject.parseObject((String)str, AdxRoiControlDo.class);
            System.out.println("lastFactorExplorationDo:" + JSON.toJSONString((Object)adxRoiControlDoInfo3.getLastFactorExplorationDo()));
            AdxFactorExplorationDo ret3 = FactorExploration.getExploreFactor(adxRoiControlDoInfo3);
            System.out.println("ret3:" + JSON.toJSONString((Object)ret3));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

