/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.AdxBidding;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxFactorExplorationDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxPriceExplorationDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StrategyBid {
    public static Map<String, String> getStrategyFirBid(AdxDo adxDoInfo, AdxRoiFactorDo adxRoiFactorDoInfo, Map<String, Long> advertConsumeInfo) {
        Double defaultRoiFactor = 1.0;
        HashMap<String, String> retMap = new HashMap<String, String>();
        String level = AdxLevel.ADX_LEVEL_ZER.getCode();
        Long price = AdxBidding.getAdxParPrice(adxDoInfo, defaultRoiFactor, advertConsumeInfo);
        if (AssertUtil.isNotEmpty((Object)adxRoiFactorDoInfo)) {
            Double roiFactor = adxRoiFactorDoInfo.getAdxRoiFactor();
            price = AdxBidding.getAdxParPrice(adxDoInfo, roiFactor, advertConsumeInfo);
        }
        retMap.put("level", level);
        retMap.put("price", DataUtil.Long2String((Long)price));
        return retMap;
    }

    public static Map<String, String> getStrategySecBid(AdxPriceExplorationDo priceExplorationDoInfo, Long defaultPrice, Long minPrice) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        String level = AdxLevel.ADX_LEVEL_TWO.getCode();
        Long price = defaultPrice;
        if (AssertUtil.isNotEmpty((Object)priceExplorationDoInfo)) {
            Map<String, Long> priceMap = priceExplorationDoInfo.getPriceExploreMap();
            Map<String, Double> FlowRateMap = priceExplorationDoInfo.getPriceFlowRateMap();
            Map<String, String> result = StrategyBid.flowSplit(FlowRateMap, priceMap, defaultPrice);
            level = result.get("level");
            price = DataUtil.string2Long((String)result.get("price"));
        }
        retMap.put("level", level);
        retMap.put("price", DataUtil.Long2String((Long)price));
        return retMap;
    }

    public static Map<String, String> getStrategyThiBid(AdxDo adxDoInfo, AdxFactorExplorationDo factorExplorationDoInfo, Map<String, Long> advertConsumeInfo, Long minPrice) {
        Double defaultRoiFactor = 1.0;
        HashMap<String, String> retMap = new HashMap<String, String>();
        String level = AdxLevel.ADX_LEVEL_TWO.getCode();
        Long price = AdxBidding.getAdxParPrice(adxDoInfo, defaultRoiFactor, advertConsumeInfo);
        if (AssertUtil.isNotEmpty((Object)factorExplorationDoInfo)) {
            Map<String, Double> factorMap = factorExplorationDoInfo.getFactorExploreMap();
            Map<String, Double> FlowRateMap = factorExplorationDoInfo.getFactorFlowRateMap();
            Map<String, String> result = StrategyBid.flowSplit(FlowRateMap, factorMap, defaultRoiFactor);
            level = result.get("level");
            Double roiFactor = DataUtil.string2Double((String)result.get("factor"));
            price = AdxBidding.getAdxParPrice(adxDoInfo, roiFactor, advertConsumeInfo);
        }
        retMap.put("level", level);
        retMap.put("price", DataUtil.Long2String((Long)price));
        return retMap;
    }

    public static Map<String, String> flowSplit(Map<String, Double> flowRateMap, Map<String, Long> priceMap, Long defaultValue) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        String level = AdxLevel.ADX_LEVEL_TWO.getCode();
        Long price = defaultValue;
        Double sumRate = 0.0;
        Double[] sumRateList = new Double[AdxLevel.values().length - 1];
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{flowRateMap, priceMap})) {
            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
                int i = DataUtil.toInt((Long)DataUtil.string2Long((String)key));
                sumRateList[i - 1] = sumRate = Double.valueOf(sumRate + StrategyBid.nullToDefault(flowRateMap.get(key), (Double)0.0));
            }
            double random = Math.random();
            for (int i = 0; i < sumRateList.length; ++i) {
                double bound = sumRateList[i];
                if (!(random <= bound)) continue;
                level = DataUtil.Integer2String((Integer)(i + 1));
                price = priceMap.get(level);
                if (price != null) break;
                price = defaultValue;
                break;
            }
        }
        retMap.put("level", level);
        retMap.put("price", DataUtil.Long2String((Long)price));
        return retMap;
    }

    public static Map<String, String> flowSplit(Map<String, Double> flowRateMap, Map<String, Double> factorMap, Double defaultValue) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        String level = AdxLevel.ADX_LEVEL_TWO.getCode();
        Double factor = defaultValue;
        Double sumRate = 0.0;
        Double[] sumRateList = new Double[AdxLevel.values().length - 1];
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{flowRateMap, factorMap})) {
            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
                int i = DataUtil.toInt((Long)DataUtil.string2Long((String)key));
                sumRateList[i - 1] = sumRate = Double.valueOf(sumRate + StrategyBid.nullToDefault(flowRateMap.get(key), (Double)0.0));
            }
            double random = Math.random();
            for (int i = 0; i < sumRateList.length; ++i) {
                double bound = sumRateList[i];
                if (!(random <= bound)) continue;
                level = DataUtil.Integer2String((Integer)(i + 1));
                factor = factorMap.get(level);
                if (factor != null) break;
                factor = defaultValue;
                break;
            }
        }
        retMap.put("level", level);
        retMap.put("factor", DataUtil.double2String((Double)factor));
        return retMap;
    }

    public static List<AdxLevelDo> getStrategyInfo(ArrayList<AdxStrategyDo> arrayListInfo, String strategyLabel) {
        List<AdxLevelDo> ret = new ArrayList<AdxLevelDo>();
        if (AssertUtil.isNotEmpty(arrayListInfo)) {
            for (int i = 0; i < AdxStrategy.values().length; ++i) {
                AdxStrategyDo ind = arrayListInfo.get(i);
                if (!strategyLabel.equals(ind.getStrategy())) continue;
                ret = ind.getLevelDoList();
            }
        }
        return ret;
    }

    public static Long getSumLevelIndex(List<AdxLevelDo> levelListInfo, String indexLabel, Long defaultValue) {
        Long ret = 0L;
        if (AssertUtil.isNotEmpty(levelListInfo)) {
            for (AdxLevelDo levelDo : levelListInfo) {
                if (AssertUtil.isNotEmpty((Object)levelDo)) {
                    Map<String, Long> valueMap = levelDo.getValueMap();
                    if (!AssertUtil.isNotEmpty(valueMap) || valueMap.get(indexLabel) == null || valueMap.get(indexLabel) < 0L) continue;
                    ret = ret + valueMap.get(indexLabel);
                    continue;
                }
                ret = ret + defaultValue;
            }
        }
        return ret;
    }

    public static Map<String, Long> getLevelIndex(List<AdxLevelDo> levelListInfo, String indexLabel, Long defaultValue) {
        HashMap<String, Long> retMap = new HashMap<String, Long>();
        Long val = defaultValue;
        for (AdxLevel adxLevel : AdxLevel.values()) {
            Map<String, Long> indMap;
            int i;
            AdxLevelDo ind;
            String key = adxLevel.getCode();
            if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
            if (AssertUtil.isNotEmpty(levelListInfo) && AssertUtil.isNotEmpty((Object)(ind = levelListInfo.get(i = DataUtil.toInt((Long)DataUtil.string2Long((String)key))))) && AssertUtil.isNotEmpty(indMap = ind.getValueMap()) && indMap.get(indexLabel) != null && indMap.get(indexLabel) >= 0L) {
                val = indMap.get(indexLabel);
            }
            retMap.put(key, val);
        }
        return retMap;
    }

    public static Double getSucRate(List<AdxLevelDo> levelListInfo) {
        Double ret = 0.0;
        Long defaultValue = 0L;
        Long defaultCnt = 50L;
        if (AssertUtil.isNotEmpty(levelListInfo)) {
            Long bidCnt = StrategyBid.getSumLevelIndex(levelListInfo, AdxIndex.BID.getCode(), defaultValue);
            Long sucCnt = StrategyBid.getSumLevelIndex(levelListInfo, AdxIndex.BID_SUC.getCode(), defaultValue);
            if (bidCnt >= defaultCnt) {
                ret = StrategyBid.getNormalValue(DataUtil.division((Long)sucCnt, (Long)bidCnt, (int)6), 0.0, 0.0, 1.0);
            }
        }
        return ret;
    }

    public static Double getSucRate(Map<String, Long> mapInfo) {
        Double ret = 0.0;
        Long defaultValue = 0L;
        Long defaultCnt = 50L;
        if (AssertUtil.isNotEmpty(mapInfo)) {
            Long bidCnt = StrategyBid.nullToDefault(mapInfo.get(AdxIndex.BID.getCode()), defaultValue);
            Long sucCnt = StrategyBid.nullToDefault(mapInfo.get(AdxIndex.BID_SUC.getCode()), defaultValue);
            if (bidCnt >= defaultCnt) {
                ret = StrategyBid.getNormalValue(DataUtil.division((Long)sucCnt, (Long)bidCnt, (int)6), 0.0, 0.0, 1.0);
            }
        }
        return ret;
    }

    public static Map<String, Double> getLevelSucRate(List<AdxLevelDo> levelListInfo) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        Double ret = 0.0;
        Long defaultValue = 0L;
        Long defaultCnt = 10L;
        for (AdxLevel adxLevel : AdxLevel.values()) {
            String key = adxLevel.getCode();
            if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
            if (AssertUtil.isNotEmpty(levelListInfo)) {
                Map<String, Long> bidCnt = StrategyBid.getLevelIndex(levelListInfo, AdxIndex.BID.getCode(), defaultValue);
                Map<String, Long> sucCnt = StrategyBid.getLevelIndex(levelListInfo, AdxIndex.BID_SUC.getCode(), defaultValue);
                if (bidCnt.get(key) >= defaultCnt) {
                    ret = StrategyBid.getNormalValue(DataUtil.division((Long)sucCnt.get(key), (Long)bidCnt.get(key), (int)6), 0.0, 0.0, 1.0);
                    retMap.put(key, ret);
                    continue;
                }
                retMap.put(key, 0.0);
                continue;
            }
            retMap.put(key, 0.0);
        }
        return retMap;
    }

    public static Double getRoi(List<AdxLevelDo> levelListInfo, Double targetRoi) {
        Double ret = 0.0;
        Long defaultValue = 0L;
        Long defaultAdxConsume = 500000000L;
        if (AssertUtil.isNotEmpty(levelListInfo)) {
            Long adxConsume = StrategyBid.getSumLevelIndex(levelListInfo, AdxIndex.ADX_CONSUME.getCode(), defaultValue);
            Long advertConsume = StrategyBid.getSumLevelIndex(levelListInfo, AdxIndex.ADVERT_CONSUME.getCode(), defaultValue);
            ret = adxConsume >= defaultAdxConsume ? DataUtil.formatDouble((Double)(DataUtil.division((Long)advertConsume, (Long)adxConsume, (int)13) * 10000.0 * 1000.0), (int)6) : DataUtil.formatDouble((Double)(DataUtil.division((Double)((double)advertConsume.longValue() + (double)defaultAdxConsume.longValue() * targetRoi / 1000.0 / 10000.0), (Long)(adxConsume + defaultAdxConsume), (int)13) * 10000.0 * 1000.0), (int)6);
        }
        return ret;
    }

    public static Double getRoi(Map<String, Long> mapInfo, Double targetRoi) {
        Double ret = 0.0;
        Long defaultValue = 0L;
        Long defaultAdxConsume = 500000000L;
        if (AssertUtil.isNotEmpty(mapInfo)) {
            Long adxConsume = StrategyBid.nullToDefault(mapInfo.get(AdxIndex.ADX_CONSUME.getCode()), defaultValue);
            Long advertConsume = StrategyBid.nullToDefault(mapInfo.get(AdxIndex.ADVERT_CONSUME.getCode()), defaultValue);
            ret = adxConsume >= defaultAdxConsume ? DataUtil.formatDouble((Double)(DataUtil.division((Long)advertConsume, (Long)adxConsume, (int)13) * 10000.0 * 1000.0), (int)6) : DataUtil.formatDouble((Double)(DataUtil.division((Double)((double)advertConsume.longValue() + (double)defaultAdxConsume.longValue() * targetRoi / 1000.0 / 10000.0), (Long)(adxConsume + defaultAdxConsume), (int)13) * 10000.0 * 1000.0), (int)6);
        }
        return ret;
    }

    public static Map<String, Double> getLevelRoi(List<AdxLevelDo> levelListInfo, Double targetRoi) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        Double ret = 0.0;
        Long defaultValue = 0L;
        Long defaultAdxConsume = 250000000L;
        for (AdxLevel adxLevel : AdxLevel.values()) {
            String key = adxLevel.getCode();
            if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
            if (AssertUtil.isNotEmpty(levelListInfo)) {
                Map<String, Long> adxConsume = StrategyBid.getLevelIndex(levelListInfo, AdxIndex.ADX_CONSUME.getCode(), defaultValue);
                Map<String, Long> advertConsume = StrategyBid.getLevelIndex(levelListInfo, AdxIndex.ADVERT_CONSUME.getCode(), defaultValue);
                if (adxConsume.get(key) >= defaultAdxConsume) {
                    ret = DataUtil.formatDouble((Double)(DataUtil.division((Long)advertConsume.get(key), (Long)adxConsume.get(key), (int)13) * 10000.0 * 1000.0), (int)6);
                    retMap.put(key, ret);
                    continue;
                }
                ret = DataUtil.formatDouble((Double)(DataUtil.division((Double)((double)advertConsume.get(key).longValue() + (double)defaultAdxConsume.longValue() * targetRoi / 1000.0 / 10000.0), (Long)(adxConsume.get(key) + defaultAdxConsume), (int)13) * 10000.0 * 1000.0), (int)6);
                retMap.put(key, ret);
                continue;
            }
            retMap.put(key, 0.0);
        }
        return retMap;
    }

    public static Long nullToDefault(Long value, Long defaultValue) {
        Long ret = defaultValue;
        if (value != null && value > defaultValue) {
            ret = value;
        }
        return ret;
    }

    public static Double nullToDefault(Double value, Double defaultValue) {
        Double ret = defaultValue;
        if (value != null && value > defaultValue) {
            ret = value;
        }
        return ret;
    }

    public static Long nullToDefault(Long value, Double defaultValue) {
        Long ret = DataUtil.double2Long((Double)defaultValue);
        if (value != null && (double)value.longValue() > defaultValue) {
            ret = value;
        }
        return ret;
    }

    public static Double getNormalValue(Double value, Double defaultValue, Double lower, Double upper) {
        Double ret = defaultValue;
        if (value != null) {
            ret = value < lower ? lower : (value > upper ? upper : value);
        }
        return ret;
    }

    public static Double bucket(Double value, Double[] bucketList) {
        Double ret = 0.0;
        if (value != null && bucketList != null && bucketList.length > 0) {
            for (int i = 0; i < bucketList.length; ++i) {
                double bound = bucketList[i];
                if (!(value <= bound)) continue;
                ret = bound;
                break;
            }
            if (value > bucketList[bucketList.length - 1]) {
                ret = bucketList[bucketList.length - 1];
            }
        }
        return ret;
    }

    public static Long bucket(Double value, Double targetValue, Double[] bucketList) {
        long ret = 0L;
        if (value != null && targetValue != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length - 1;
            for (int i = 0; i < bucketList.length; ++i) {
                double bound = bucketList[i];
                if (!(value < targetValue * bound)) continue;
                ret = i - 1;
                break;
            }
        }
        return ret;
    }

    public static Double getConfidenceWeight(double value, double[] bucketList, double[] weightList) {
        double ret = 0.0;
        if (bucketList != null && bucketList.length > 0 && weightList != null && weightList.length == bucketList.length) {
            double lastWeight = weightList[0];
            double lastBound = bucketList[0];
            for (int i = 0; i < bucketList.length; ++i) {
                double bound = bucketList[i];
                if (value < bound) {
                    double curWeight = weightList[i];
                    double curBound = bucketList[i];
                    if (i > 0) {
                        ret = lastWeight + (curWeight - lastWeight) * (value - lastBound) / (curBound - lastBound);
                        break;
                    }
                    ret = curWeight;
                    break;
                }
                lastWeight = weightList[i];
                lastBound = bucketList[i];
            }
            if (value >= bucketList[bucketList.length - 1]) {
                ret = weightList[weightList.length - 1];
            }
        }
        return DataUtil.formatDouble((Double)ret, (int)3);
    }

    public static String selectBestLevel(Double targetRoi, Map<String, Double> realRoiLevel, Map<String, Double> realSucRateLevel) {
        Double roiLimit = 0.95;
        if (targetRoi != null && targetRoi > 1.0) {
            roiLimit = Math.min(DataUtil.division((Double)1.3, (Double)targetRoi), 0.95);
        }
        String ret = AdxLevel.ADX_LEVEL_TWO.getCode();
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{realRoiLevel, realSucRateLevel})) {
            Double tmpScore = -1.0;
            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
                Double roi = realRoiLevel.get(key);
                Double sucRate = realSucRateLevel.get(key);
                Double roiDiff = StrategyBid.nullToDefault(DataUtil.division((Double)roi, (Double)targetRoi), (Double)0.0);
                Double score = (roiDiff - roiLimit) * sucRate;
                if (!(sucRate > 0.01) || !(score > tmpScore)) continue;
                ret = key;
                tmpScore = score;
            }
        }
        return ret;
    }

    public static Long selectUpLimitFee(Map<String, Long> priceMap, Map<String, Double> sucRateMap, Long lastUpLimitPrice) {
        Long ret = lastUpLimitPrice;
        Double sucLimit = 0.95;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{priceMap, sucRateMap})) {
            for (AdxLevel adxLevel : AdxLevel.values()) {
                Long price;
                Double sucRate;
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode()) || AssertUtil.isAnyEmpty((Object[])new Object[]{sucRate = sucRateMap.get(key), price = priceMap.get(key)})) continue;
                if (sucRate < sucLimit && ret != null && price > ret) {
                    ret = null;
                }
                if (!(sucRate >= sucLimit)) continue;
                if (ret != null && price < ret) {
                    ret = price;
                }
                if (ret != null) continue;
                ret = price;
            }
        }
        return ret;
    }

    public static Map<String, Double> getRoiFactorRectify(Map<String, Double> roiMap, Map<String, Long> adxConsumeLevelMs, AdxRoiControlDo adxRoiControlDoInfo) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        Long adxConsumeLimit = 3000000000L;
        Long adxConsumeBaseLimit = 250000000L;
        Double baseRoi = StrategyBid.nullToDefault(roiMap.get(AdxLevel.ADX_LEVEL_TWO.getCode()), (Double)0.0);
        for (AdxLevel adxLevel : AdxLevel.values()) {
            String key = adxLevel.getCode();
            if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
            retMap.put(key, roiMap.get(key));
        }
        AdxFactorExplorationDo lastFactorDoInfo = adxRoiControlDoInfo.getLastFactorExplorationDo();
        if (AssertUtil.isNotEmpty((Object)lastFactorDoInfo)) {
            Map<String, Double> lastFactorMap = lastFactorDoInfo.getFactorExploreMap();
            Double baseFactor = StrategyBid.nullToDefault(lastFactorMap.get(AdxLevel.ADX_LEVEL_TWO.getCode()), (Double)0.0);
            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode()) || !AssertUtil.isNotEmpty(adxConsumeLevelMs) || adxConsumeLevelMs.get(key) >= adxConsumeLimit || adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < adxConsumeBaseLimit) continue;
                Double diff = DataUtil.division((Double)lastFactorMap.get(key), (Double)baseFactor);
                Double roi = baseRoi * diff;
                retMap.put(key, DataUtil.formatDouble((Double)roi, (int)6));
            }
        }
        return retMap;
    }

    public static Map<String, Double> getRoiPriceRectify(Map<String, Double> roiMap, Map<String, Long> adxConsumeLevelMs, AdxRoiControlDo adxRoiControlDoInfo) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        Long adxConsumeLimit = 3000000000L;
        Long adxConsumeBaseLimit = 250000000L;
        Double baseRoi = StrategyBid.nullToDefault(roiMap.get(AdxLevel.ADX_LEVEL_TWO.getCode()), (Double)0.0);
        for (AdxLevel adxLevel : AdxLevel.values()) {
            String key = adxLevel.getCode();
            if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
            retMap.put(key, roiMap.get(key));
        }
        AdxPriceExplorationDo lastPriceDoInfo = adxRoiControlDoInfo.getLastPriceExplorationDo();
        if (AssertUtil.isNotEmpty((Object)lastPriceDoInfo)) {
            Map<String, Long> lastPriceMap = lastPriceDoInfo.getPriceExploreMap();
            Long basePrice = StrategyBid.nullToDefault(lastPriceMap.get(AdxLevel.ADX_LEVEL_TWO.getCode()), (Double)0.0);
            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode()) || !AssertUtil.isNotEmpty(adxConsumeLevelMs) || adxConsumeLevelMs.get(key) >= adxConsumeLimit || adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < adxConsumeBaseLimit) continue;
                Double diff = DataUtil.division((Long)basePrice, (Long)lastPriceMap.get(key));
                Double roi = baseRoi * diff;
                retMap.put(key, DataUtil.formatDouble((Double)roi, (int)6));
            }
        }
        return retMap;
    }

    public static Long getBaseLevelConfident(Double resoSucRate, Map<String, Double> sucRateLevel, Map<String, Long> adxConsumeLevel) {
        Long ret = 0L;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{sucRateLevel, resoSucRate, adxConsumeLevel}) && sucRateLevel.get(AdxLevel.ADX_LEVEL_TWO.getCode()) > 0.05 && sucRateLevel.get(AdxLevel.ADX_LEVEL_TWO.getCode()) > resoSucRate * 0.2 && adxConsumeLevel.get(AdxLevel.ADX_LEVEL_TWO.getCode()) > 2000000000L) {
            ret = 1L;
        }
        return ret;
    }

    public static Double getMojiRoiLimit(Double roi, Double targetRoi, Double sucRate, Double resoSucRate, Double adxConsume) {
        Double ret = 0.98;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{roi, targetRoi, sucRate, resoSucRate, adxConsume}) && sucRate > 0.05 && sucRate > resoSucRate * 0.2 && adxConsume > 200.0) {
            Double diff = DataUtil.division((Double)roi, (Double)targetRoi);
            ret = diff > 1.05 ? 0.95 : (diff > 1.0 ? 0.97 : (diff > 0.95 ? 0.98 : 1.0));
        }
        return ret;
    }

    public static Double getRemainStableLimit(Double roi, Double targetRoi, Double sucRate, Double resoSucRate, Double adxConsume) {
        Double ret = 0.2;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{roi, targetRoi, sucRate, resoSucRate, adxConsume}) && sucRate > 0.05 && sucRate > resoSucRate * 0.2 && adxConsume > 200.0) {
            Double diff = DataUtil.division((Double)roi, (Double)targetRoi);
            ret = diff > 1.1 ? 0.3 : (diff > 1.0 ? 0.2 : 0.1);
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            HashMap<String, Double> roiLevel1 = new HashMap<String, Double>();
            roiLevel1.put("1", 1.99);
            roiLevel1.put("2", 1.05);
            roiLevel1.put("3", 1.1);
            HashMap<String, Long> priceMap = new HashMap<String, Long>();
            priceMap.put("1", 1320L);
            priceMap.put("2", 1370L);
            priceMap.put("3", 1400L);
            HashMap<String, Double> sucRateLevel1 = new HashMap<String, Double>();
            sucRateLevel1.put("1", 0.26);
            sucRateLevel1.put("2", 0.5);
            sucRateLevel1.put("3", 0.5);
            HashMap<String, Long> adxConsumeLevelMs = new HashMap<String, Long>();
            adxConsumeLevelMs.put("1", 13200000000L);
            adxConsumeLevelMs.put("2", 13700000000L);
            adxConsumeLevelMs.put("3", 14000000000L);
            Double targetRoi1 = 1.0;
            System.out.println("selectBestLevel:" + JSON.toJSONString((Object)StrategyBid.selectBestLevel(targetRoi1, roiLevel1, sucRateLevel1)));
            System.out.println("selectUpLimitFee:" + JSON.toJSONString((Object)StrategyBid.selectUpLimitFee(priceMap, sucRateLevel1, 1500L)));
            HashMap<String, Long> map1 = new HashMap<String, Long>();
            map1.put(AdxIndex.ADX_CONSUME.getCode(), 12000000000L);
            map1.put(AdxIndex.ADVERT_CONSUME.getCode(), 1400L);
            System.out.println("selectBestLevel:" + JSON.toJSONString((Object)StrategyBid.selectBestLevel(1.1, null, null)));
            System.out.println("flowSplit:" + JSON.toJSONString(StrategyBid.flowSplit(null, null, 1.0)));
            System.out.println("getSumLevelIndex:" + JSON.toJSONString((Object)StrategyBid.getSumLevelIndex(null, null, 1L)));
            System.out.println("getLevelIndex:" + JSON.toJSONString(StrategyBid.getLevelIndex(null, null, 0L)));
            System.out.println("getLevelSucRate:" + JSON.toJSONString(StrategyBid.getLevelSucRate(null)));
            System.out.println("getLevelRoi:" + JSON.toJSONString(StrategyBid.getLevelRoi(null, 1.2)));
            System.out.println("getRoi:" + JSON.toJSONString((Object)StrategyBid.getRoi(map1, (Double)1.2)));
            Double roiFactor = StrategyBid.getNormalValue(0.6, 1.0, 0.7, 1.4);
            System.out.println("getNormalValue:" + JSON.toJSONString((Object)roiFactor));
            Double roiLimit1 = -0.1;
            double[] roiIntervel1 = new double[]{0.0, 0.9, 1.1};
            double[] roiWeight1 = new double[]{1.0, 1.5, 4.0};
            System.out.println("getConfidenceWeight:" + JSON.toJSONString((Object)StrategyBid.getConfidenceWeight(roiLimit1, roiIntervel1, roiWeight1)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

