/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.directly;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDircetlyPriceDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxDirecetlyPriceDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxDirecrtlyPriceReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxMeiTuanFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxMeiTuanFactorSubDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxDirectlyBidding {
    private static final Logger logger = LoggerFactory.getLogger(AdxDirectlyBidding.class);

    public static List<AdxDirecetlyPriceDo> getAlgoPrice(AdxDirecrtlyPriceReqDo adxDirecrtlyPriceReqDo) {
        ArrayList<AdxDirecetlyPriceDo> ret = new ArrayList<AdxDirecetlyPriceDo>();
        try {
            Double sucFactor;
            Double priceThreshold = 60.0;
            int strategyId = adxDirecrtlyPriceReqDo.getStrategyId();
            Double floorPrice = Optional.ofNullable(adxDirecrtlyPriceReqDo.getFloorPrice()).orElse(0.0);
            Integer advertCnt = adxDirecrtlyPriceReqDo.getAdvertCnt();
            Double slotShareRate = AdxDirecrtlyPriceReqDo.getShareRate(adxDirecrtlyPriceReqDo);
            if (slotShareRate == null) {
                slotShareRate = 1.0;
            }
            List<AdxDirecetlyPriceDo> adxDirecetlyPriceDos = adxDirecrtlyPriceReqDo.getAdxDirecetlyPriceDos();
            AdxMeiTuanFactorDo adxMeiTuanFactorDo = Optional.ofNullable(adxDirecrtlyPriceReqDo.getAdxMeiTuanFactorDo()).orElse(new AdxMeiTuanFactorDo());
            AdxMeiTuanFactorSubDo slotFactorDo = adxMeiTuanFactorDo.getSlotFactorDo();
            Double slotFactor = slotFactorDo.getRoiFactor();
            if (slotFactor == null) {
                slotFactor = 1.0;
            }
            if ((sucFactor = slotFactorDo.getSucFactor()) == null) {
                sucFactor = 0.0;
            }
            AdxMeiTuanFactorSubDo advFactorDo = new AdxMeiTuanFactorSubDo();
            Double advFactor = 1.0;
            Double adAvgPrice = 30.0;
            Double advShareRate = null;
            if (advertCnt == null) {
                advertCnt = 5;
            }
            int count = 0;
            for (AdxDirecetlyPriceDo adxDirecetlyPriceDo : adxDirecetlyPriceDos) {
                if (count < advertCnt) {
                    Double price;
                    Long advertId = adxDirecetlyPriceDo.getAdvertId();
                    advShareRate = AdxDirecetlyPriceDo.getShareRate(adxDirecetlyPriceDo);
                    Double advPrice = adxDirecetlyPriceDo.getAdvPrice();
                    if (advPrice == null) continue;
                    advFactorDo = AdxMeiTuanFactorDo.getAdvFactorSubDo(adxMeiTuanFactorDo, advertId);
                    if (advFactorDo != null) {
                        advFactor = advFactorDo.getRoiFactor();
                        adAvgPrice = advFactorDo.getCpcPrice();
                    }
                    if (advShareRate == null || strategyId == 5 || strategyId == 4) {
                        advShareRate = slotShareRate;
                    }
                    if (advFactorDo == null || !advFactorDo.isConfident()) {
                        advFactor = slotFactor;
                    }
                    if (advFactor == null) {
                        advFactor = 1.0;
                    }
                    if (adAvgPrice == null) {
                        adAvgPrice = 30.0;
                    }
                    if ((price = Double.valueOf(advPrice * advShareRate * advFactor)) < floorPrice * 0.9) continue;
                    if (price >= floorPrice * 0.9 && Math.random() > 0.9 / advFactor) {
                        price = Math.max(price, floorPrice * 1.1);
                    }
                    if (price <= priceThreshold && sucFactor > 0.1) {
                        price = price + (priceThreshold - price) * sucFactor;
                    }
                    double minPrice = price;
                    double maxPrice = Math.max(advPrice * advShareRate, advPrice);
                    if (strategyId == 5) {
                        adAvgPrice = Math.max(0.75 * adAvgPrice, 40.0);
                        if (price < adAvgPrice) {
                            price = price + (adAvgPrice - price) * (advFactor - 0.5);
                        }
                        double weigh = DataUtil.division((Double)adAvgPrice, (Double)(adAvgPrice + price));
                        maxPrice = advPrice * advShareRate * Math.min(1.0 + 0.5 * weigh, 1.2);
                    }
                    if ((price = Double.valueOf(MathUtil.stdwithBoundary((double)price, (double)minPrice, (double)maxPrice))) < floorPrice) continue;
                    adxDirecetlyPriceDo.setAdxPrice(price);
                    adxDirecetlyPriceDo.setRoiFactor(advFactor);
                    ret.add(adxDirecetlyPriceDo);
                    ++count;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            logger.error("Meituan AdxDirectlyBidding.getAlgoPrice error" + e);
        }
        return ret;
    }

    public static AdxDircetlyPriceDo getAlgoPrice(AdxDirectlyIdeaDo directlyIdeaInfo, AdxDirectlyFactorDo directlyFactorInfo) {
        AdxDircetlyPriceDo ret = new AdxDircetlyPriceDo();
        try {
            Double roiFactor = 1.0;
            Double lowerLimit = 0.3;
            Double upperLimit = 1.7;
            Long algoPrice = 0L;
            String strategy = AdxStrategy.ADX_STRATEGY_FIR.getCode();
            String level = AdxLevel.ADX_LEVEL_TWO.getCode();
            Long ideaBidCntMs = 0L;
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{directlyIdeaInfo})) {
                AdxIndexStatsDo interIndexStatMs = AdxStatData.indexStatCompute(directlyIdeaInfo.getIdeaIndexMap());
                ideaBidCntMs = AdxStatData.nullToMinDefault(interIndexStatMs.getBidCnt(), 0L);
            }
            if (AssertUtil.isNotEmpty((Object)directlyFactorInfo) && ideaBidCntMs != 0L) {
                Map<String, Double> factorMap = directlyFactorInfo.getFactorExploreMap();
                Map<String, Double> FlowRateMap = directlyFactorInfo.getFactorFlowRateMap();
                Map<String, String> result = StrategyBid.flowSplit(FlowRateMap, factorMap, 1.0);
                level = result.get("level");
                roiFactor = AdxStatData.getNormalValue(DataUtil.string2Double((String)result.get("factor")), 1.0, lowerLimit, upperLimit);
            }
            if (AssertUtil.isNotEmpty((Object)directlyIdeaInfo)) {
                Double minRoi = AdxStatData.nullToMinDefault(directlyIdeaInfo.getMinRoi(), 1.0);
                Double cpcPrice = AdxStatData.nullToMinDefault(directlyIdeaInfo.getDirectlyCpcPrice(), 0.0);
                Double preCtr = AdxStatData.nullToMinDefault(directlyIdeaInfo.getDirectlyPreCtr(), 0.0);
                algoPrice = Math.round(Math.floor(DataUtil.division((Double)(cpcPrice * preCtr * 1000.0), (Double)(minRoi * roiFactor))));
            }
            ret.setAdxAlgoPrice(algoPrice);
            ret.setStrategy(strategy);
            ret.setLevel(level);
        }
        catch (Exception e) {
            logger.error("AdxDirectlyBidding.getAlgoPrice error:" + e);
        }
        return ret;
    }
}

