/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.pddecision;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxPdControlDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxPdControlRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdControlTask {
    private static final Logger logger = LoggerFactory.getLogger(PdControlTask.class);

    public static AdxPdControlDo getPdControl(AdxPdControlRequestDo pdControlRequestDo) {
        AdxPdControlDo ret = new AdxPdControlDo();
        try {
            Double controlFactor = 1.0;
            Double giveUpRate = 0.9;
            Double targetRoi = 1.1501;
            boolean isConfident = false;
            Double lowerLimit = 0.5;
            Double upperLimit = 1.5;
            if (AssertUtil.isNotEmpty((Object)pdControlRequestDo)) {
                AdxStatsDo ideaStats = pdControlRequestDo.getIdeaStats();
                AdxIndexStatDo last1DayStat = null;
                AdxIndexStatDo last20MinStat = null;
                if (AssertUtil.isNotEmpty((Object)ideaStats)) {
                    last1DayStat = ideaStats.getLast1DayStat();
                    last20MinStat = ideaStats.getLast20MinStat();
                }
                AdxIndexStatsDo ideaStatsDay = AdxStatData.adxIndexCompute(last1DayStat);
                AdxIndexStatsDo ideaStatsMin = AdxStatData.adxIndexCompute(last20MinStat);
                Double lastFactor = 1.0;
                Double lastGiveUpRate = 0.9;
                Double lastTargetRoi = 1.1501;
                AdxPdControlDo lastControlDo = pdControlRequestDo.getLastAdxPdControlInfo();
                if (AssertUtil.isNotEmpty((Object)lastControlDo)) {
                    lastFactor = AdxStatData.nullToDefault(lastControlDo.getControlFactor(), 1.0);
                    lastGiveUpRate = AdxStatData.nullToDefault(lastControlDo.getGiveUpRate(), 0.9);
                    lastTargetRoi = AdxStatData.nullToDefault(lastControlDo.getTargetRoi(), 1.1501);
                }
                Long currentTime = DataUtil.string2Long((String)LocalDateUtil.getCurrentLocalDateTime((String)"HHmm"));
                targetRoi = AdxStatData.nullToMinDefault(pdControlRequestDo.getTargetRoi(), 1.1501);
                if (ideaStatsDay.getConfident().booleanValue() && AdxStatData.isLarger(ideaStatsMin.getBidCnt(), 100L) && AdxStatData.isLarger(ideaStatsMin.getAdxConsume(), 50L)) {
                    isConfident = true;
                }
                if (targetRoi.compareTo(lastTargetRoi) != 0 || currentTime == null || currentTime >= 0L && currentTime < 20L || !isConfident) {
                    controlFactor = 1.0;
                    giveUpRate = 0.9;
                } else {
                    Double conRoi = AdxStatData.getConRoi(ideaStatsMin, ideaStatsDay);
                    Double actualRoi = ideaStatsMin.getRoi();
                    if (AssertUtil.isEmpty((Object)actualRoi) && AssertUtil.isEmpty((Object)(actualRoi = conRoi))) {
                        actualRoi = ideaStatsDay.getRoi();
                    }
                    controlFactor = PdControlTask.getFactorUpdate(lastFactor, actualRoi, targetRoi, lowerLimit, upperLimit);
                    giveUpRate = lastGiveUpRate;
                    if (AssertUtil.isNotEmpty((Object)actualRoi)) {
                        giveUpRate = actualRoi < 1.15 ? 0.95 : (actualRoi < targetRoi * 1.5 ? 0.9 : 0.8);
                    }
                }
                ret.setBidCntDay(ideaStatsDay.getBidCnt());
                ret.setBidCntMs(ideaStatsMin.getBidCnt());
                ret.setSucCntDay(ideaStatsDay.getSucCnt());
                ret.setSucCntMs(ideaStatsMin.getSucCnt());
                ret.setAdxCostDay(ideaStatsDay.getAdxConsume());
                ret.setAdxCostMs(ideaStatsMin.getAdxConsume());
                ret.setAdConsumeDay(ideaStatsDay.getAdvertConsume());
                ret.setAdConsumeMs(ideaStatsMin.getAdvertConsume());
                ret.setRoiDay(ideaStatsDay.getRoi());
                ret.setRoiMs(ideaStatsMin.getRoi());
                ret.setRpmDay(ideaStatsDay.getRpm());
                ret.setRpmMs(ideaStatsMin.getRpm());
                ret.setSucDay(ideaStatsDay.getSucRate());
                ret.setSucMs(ideaStatsMin.getSucRate());
            }
            ret.setControlFactor(controlFactor);
            ret.setGiveUpRate(giveUpRate);
            ret.setTargetRoi(targetRoi);
            ret.setConfidence(isConfident);
        }
        catch (Exception e) {
            logger.error("PdControlTask.getPdControl error", (Throwable)e);
        }
        return ret;
    }

    public static Double getFactorUpdate(Double lastValue, Double realRoi, Double targetRoi, Double lower, Double upper) {
        Double ret = AdxStatData.getNormalValue(lastValue, 1.0, lower, upper);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{realRoi, targetRoi})) {
            Double diff = Math.abs(DataUtil.division((Double)realRoi, (Double)targetRoi, (int)3));
            ret = diff < 0.85 ? Double.valueOf(ret + (0.04 + Math.min(1.0 - diff / 0.85, 1.0) * 0.03)) : (diff < 0.95 ? Double.valueOf(ret + (0.02 + Math.min(1.0 - (diff - 0.85) / 0.09999999999999998, 1.0) * 0.02)) : (diff < 1.0 ? Double.valueOf(ret + (0.01 + Math.min(1.0 - (diff - 0.95) / 0.050000000000000044, 1.0) * 0.01)) : (diff < 1.05 ? Double.valueOf(ret - (0.01 + Math.min((diff - 1.0) / 0.050000000000000044, 1.0) * 0.01)) : (diff < 1.15 ? Double.valueOf(ret - (0.02 + Math.min((diff - 1.05) / 0.09999999999999987, 1.0) * 0.02)) : Double.valueOf(ret - (0.04 + Math.min(diff / 1.15 - 1.0, 1.0) * 0.03))))));
            ret = AdxStatData.getNormalValue(ret, 1.0, lower, upper);
        }
        return DataUtil.formatDouble((Double)ret, (int)6);
    }
}

