/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxRoiFactor {
    private static final Logger logger = LoggerFactory.getLogger(AdxRoiFactor.class);

    public static AdxRoiFactorDo getAdxRoiFactor(AdxRoiControlDo adxRoiControlDoInfo) {
        AdxRoiFactorDo ret = new AdxRoiFactorDo();
        try {
            Double defaultFactor = 1.0;
            Double defaultMinRoi = 1.0;
            Double lowerLimit = 0.3;
            Double upperLimit = 1.7;
            Double tryStep = 0.02;
            Double sucAbsLowLimit = 0.05;
            Double sucAbsUppLimit = 0.95;
            Double sucOppLowLimit = 0.2;
            Double lastRoi = 0.0;
            Double factor = defaultFactor;
            Long bidCntMs = 0L;
            Long sucBidCntMs = 0L;
            Double roiDay = 0.0;
            Double sucRateDay = 0.0;
            Double adxConsumeDay = 0.0;
            Double advertConsumeMs = 0.0;
            Long bidCntDay = 0L;
            Long sucBidCntDay = 0L;
            Double roiMs = 0.0;
            Double sucRateMs = 0.0;
            Double adxConsumeMs = 0.0;
            Double advertConsumeDay = 0.0;
            if (AssertUtil.isNotEmpty((Object)adxRoiControlDoInfo)) {
                Double minRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinRoi(), defaultMinRoi);
                Integer feeType = adxRoiControlDoInfo.getFeeType();
                AdxRoiFactorDo lastRoiFactor = adxRoiControlDoInfo.getLastAdxRoiFactorDo();
                if (AssertUtil.isNotEmpty((Object)lastRoiFactor)) {
                    Double lastFactor = lastRoiFactor.getAdxRoiFactor();
                    factor = StrategyBid.getNormalValue(lastFactor, defaultFactor, lowerLimit, upperLimit);
                }
                Long defaultConsume = 0L;
                Long defaultCnt = 0L;
                ArrayList<AdxStrategyDo> strategyMsDoList = adxRoiControlDoInfo.getStrategyMsDoList();
                List<AdxLevelDo> strategyFirMs = StrategyBid.getStrategyInfo(strategyMsDoList, AdxStrategy.ADX_STRATEGY_FIR.getCode());
                ArrayList<AdxStrategyDo> strategyDayDoList = adxRoiControlDoInfo.getStrategyDayDoList();
                List<AdxLevelDo> strategyFirDay = StrategyBid.getStrategyInfo(strategyDayDoList, AdxStrategy.ADX_STRATEGY_FIR.getCode());
                roiMs = StrategyBid.getRoi(strategyFirMs, minRoi);
                sucRateMs = StrategyBid.getSucRate(strategyFirMs);
                bidCntMs = StrategyBid.getSumLevelIndex(strategyFirMs, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntMs = StrategyBid.getSumLevelIndex(strategyFirMs, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeMs = DataUtil.division((Long)StrategyBid.getSumLevelIndex(strategyFirMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), (Long)10000000L, (int)2);
                advertConsumeMs = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategyFirMs, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));
                roiDay = StrategyBid.getRoi(strategyFirDay, minRoi);
                sucRateDay = StrategyBid.getSucRate(strategyFirDay);
                bidCntDay = StrategyBid.getSumLevelIndex(strategyFirDay, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntDay = StrategyBid.getSumLevelIndex(strategyFirDay, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeDay = DataUtil.division((Long)StrategyBid.getSumLevelIndex(strategyFirDay, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), (Long)10000000L, (int)2);
                advertConsumeDay = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategyFirDay, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));
                Double resoRoiMs = 0.0;
                Double resoSucRateMs = 0.0;
                Map<String, Long> resoMapInfo = adxRoiControlDoInfo.getResourceIndexMap();
                if (AssertUtil.isNotEmpty(resoMapInfo)) {
                    resoRoiMs = StrategyBid.getRoi(resoMapInfo, minRoi);
                    resoSucRateMs = StrategyBid.getSucRate(resoMapInfo);
                }
                Double lastMinRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getLastMinRoi(), defaultMinRoi);
                Long currentTime = DataUtil.string2Long((String)LocalDateUtil.getCurrentLocalDateTime((String)"HHmm"));
                if (minRoi.compareTo(lastMinRoi) != 0 || currentTime == null || currentTime >= 0L && currentTime < 1L || bidCntMs == 0L) {
                    factor = defaultFactor;
                } else if (sucRateMs < sucAbsLowLimit || sucRateMs <= Math.max(resoSucRateMs, 0.1) * sucOppLowLimit) {
                    factor = factor + -tryStep.doubleValue();
                } else if (sucRateMs > sucAbsUppLimit) {
                    factor = factor + tryStep;
                } else if (feeType != null && feeType == 1) {
                    Double roiStable = StrategyBid.getRemainStableRoi(roiDay, roiMs, minRoi, 0.97);
                    factor = AdxRoiFactor.getFactorUpdate(factor, roiStable, minRoi, sucRateMs, Math.max(resoSucRateMs, 0.1));
                } else {
                    factor = AdxRoiFactor.getFactorUpdate(factor, roiMs, minRoi, sucRateMs, Math.max(resoSucRateMs, 0.1));
                }
                lastRoi = roiMs;
            }
            factor = DataUtil.formatDouble((Double)StrategyBid.getNormalValue(factor, defaultFactor, lowerLimit, upperLimit), (int)6);
            ret.setAdxRoiFactor(factor);
            ret.setLastRealRoi(lastRoi);
            ret.setRoiDay(roiDay);
            ret.setSucDay(sucRateDay);
            ret.setBidCntDay(bidCntDay);
            ret.setSucBidCntDay(sucBidCntDay);
            ret.setAdxConsumeDay(adxConsumeDay);
            ret.setAdvertConsumeDay(advertConsumeDay);
            ret.setRoiMs(roiMs);
            ret.setSucMs(sucRateMs);
            ret.setBidCntMs(bidCntMs);
            ret.setSucBidCntMs(sucBidCntMs);
            ret.setAdxConsumeMs(adxConsumeMs);
            ret.setAdvertConsumeMs(advertConsumeMs);
        }
        catch (Exception e) {
            logger.error("AdxRoiFactor.getAdxRoiFactor error:" + e);
        }
        return ret;
    }

    public static Double getFactorUpdate(Double lastValue, Double realRoi, Double targetRoi, Double realSucRate, Double targetSucRate) {
        Double ret = lastValue;
        Double roiLimit = 0.98;
        Double[] roiInterval = new Double[]{0.0, 0.9, 1.1};
        Double[] sucInterval = new Double[]{0.0, 0.8, 0.95};
        Double[] diffList = new Double[]{0.02, 0.05, 0.08, 0.1};
        Double[][] updateMatrix = new Double[][]{{0.03, 0.04, 0.05}, {-0.03, 0.01, 0.01}, {-0.03, -0.02, -0.01}};
        int i = DataUtil.toInt((Long)StrategyBid.bucket(realRoi, targetRoi, roiInterval));
        int j = DataUtil.toInt((Long)StrategyBid.bucket(realSucRate, targetSucRate, sucInterval));
        if (i == 1 && j == 1 || i == 1 && j == 2) {
            Double diff = Math.abs(DataUtil.division((Double)realRoi, (Double)targetRoi, (int)3) - 1.0);
            Double coeff = DataUtil.division((Double)diff, (Double)0.1, (int)3);
            if (realRoi > targetRoi * roiLimit) {
                ret = ret + -updateMatrix[i][j].doubleValue() * coeff;
            } else if (realRoi < targetRoi * roiLimit) {
                ret = ret + updateMatrix[i][j] * coeff;
            }
        } else {
            ret = ret + updateMatrix[i][j];
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            Double[] v1 = new Double[]{0.2, 0.5, 0.8, 1.0};
            System.out.println("ret1:" + JSON.toJSONString((Object)StrategyBid.bucket(0.0, v1)));
            Double v2 = 0.0;
            Double v3 = 1.0;
            Double[] v4 = new Double[]{0.0, 0.9, 1.1};
            System.out.println("bucket2:" + JSON.toJSONString((Object)StrategyBid.bucket(v2, v3, v4)));
            Double f1 = 1.0;
            Double roi1 = 1.177;
            Double roi2 = 1.2;
            Double suc1 = 0.8;
            Double suc2 = 0.8;
            System.out.println("getFactorUpdate:" + JSON.toJSONString((Object)AdxRoiFactor.getFactorUpdate(f1, roi1, roi2, suc1, suc2)));
            String str = "{\"adxRoiFactorDo\":{\"advertConsumeDay\":0.0,\"advertConsumeMs\":0.0,\"adxConsumeDay\":0.0,\"adxConsumeMs\":0.7,\"adxRoiFactor\":0.98,\"bidCntDay\":0,\"bidCntMs\":227,\"lastRealRoi\":1.38089,\"roiDay\":1.400002,\"roiMs\":1.38089,\"sucBidCntDay\":0,\"sucBidCntMs\":1,\"sucDay\":0.0,\"sucMs\":0.004406},\"defaultPrice\":701,\"feeType\":2,\"ideaIndexMap\":{\"bidSuc\":2,\"advertConsume\":0,\"adxConsume\":13770000,\"bid\":965,\"exp\":2,\"click\":0},\"lastMinRoi\":1.4,\"maxPrice\":1000,\"minPrice\":10,\"minRoi\":1.4,\"resourceIndexMap\":{\"bidSuc\":41,\"advertConsume\":21,\"adxConsume\":254320000,\"bid\":20475,\"exp\":41,\"click\":2},\"strategyDayDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":1,\"advertConsume\":0,\"adxConsume\":6920000,\"bid\":305,\"exp\":1,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":1,\"advertConsume\":0,\"adxConsume\":6850000,\"bid\":324,\"exp\":1,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"3\"}],\"strategyMsDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":1,\"advertConsume\":0,\"adxConsume\":6920000,\"bid\":305,\"exp\":1,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":1,\"advertConsume\":0,\"adxConsume\":6850000,\"bid\":324,\"exp\":1,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"3\"}]}\n";
            AdxRoiControlDo adxRoiControlDoInfo2 = (AdxRoiControlDo)JSONObject.parseObject((String)str, AdxRoiControlDo.class);
            System.out.println("lastPriceExplorationDo:" + JSON.toJSONString((Object)adxRoiControlDoInfo2.getLastAdxRoiFactorDo()));
            AdxRoiFactorDo ret2 = AdxRoiFactor.getAdxRoiFactor(adxRoiControlDoInfo2);
            System.out.println("ret2:" + JSON.toJSONString((Object)ret2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

