/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.api.model.AdxLocalTFModel;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Model {
    private static final Logger logger = LoggerFactory.getLogger(Model.class);
    private IModel ctrModel;
    private IModel launchPvCoder;
    private IModel ARPUCoder;
    private LocalTFModel launchPvTFModel;
    private LocalTFModel arpuTFModel;
    private AdxLocalTFModel esmmTFModel;

    public <T> Map<T, Double> predictCtr(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map ret = this.ctrModel.predictsNew(featureMap);
            return ret;
        }
        catch (Exception e) {
            logger.error("Model.predictCtr error{} ctrModel{}", (Object)e, (Object)this.ctrModel);
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictLaunchPv(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map ret = this.launchPvCoder.predictWithLocalTFNew(featureMap, this.launchPvTFModel);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictLaunchPv error{}, launchPvCoder{}, launchPvTFModel{}", new Object[]{e, this.launchPvCoder, this.launchPvTFModel});
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictARPU(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map ret = this.ARPUCoder.predictWithLocalTFNew(featureMap, this.arpuTFModel);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictARPU error{}, ARPUCoder{}, arpuTFModel{}", new Object[]{e, this.ARPUCoder, this.arpuTFModel});
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictCtr2(Map<T, FeatureMapDo> featureMap) {
        try {
            HashMap ret = new HashMap();
            HashMap<T, Map> modelInput = new HashMap<T, Map>();
            for (Map.Entry<T, FeatureMapDo> entry : featureMap.entrySet()) {
                modelInput.put(entry.getKey(), entry.getValue().getFeatureMap());
            }
            Map modelOutput = this.esmmTFModel.predict(modelInput);
            for (Object key : modelOutput.keySet()) {
                Float ctr = ((Float[])((Map)modelOutput.get(key)).get("ctr"))[0];
                Double roundCtr = new BigDecimal(ctr.toString()).setScale(5, 4).doubleValue();
                ret.put(key, roundCtr);
            }
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictCtr2 error{}, TFModel{}", (Object)e, (Object)this.esmmTFModel);
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictCvr(Map<T, FeatureMapDo> featureMap) {
        try {
            HashMap ret = new HashMap();
            HashMap<T, Map> modelInput = new HashMap<T, Map>();
            for (Map.Entry<T, FeatureMapDo> entry : featureMap.entrySet()) {
                modelInput.put(entry.getKey(), entry.getValue().getFeatureMap());
            }
            Map modelOutput = this.esmmTFModel.predict(modelInput);
            for (Object key : modelOutput.keySet()) {
                BigDecimal ctcvr = new BigDecimal(((Float[])((Map)modelOutput.get(key)).get("ctcvr"))[0].toString());
                BigDecimal ctr = new BigDecimal(((Float[])((Map)modelOutput.get(key)).get("ctr"))[0].toString());
                Double cvr = ctcvr.divide(ctr, 5, 4).doubleValue();
                ret.put(key, cvr);
            }
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictCVR error TFModel{}", (Object)this.esmmTFModel, (Object)e);
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Map<String, Double>> predictCtrCvr(Map<T, FeatureMapDo> featureMap) {
        try {
            HashMap ret = new HashMap();
            HashMap<T, Map> modelInput = new HashMap<T, Map>();
            for (Map.Entry<T, FeatureMapDo> entry : featureMap.entrySet()) {
                modelInput.put(entry.getKey(), entry.getValue().getFeatureMap());
            }
            Map modelOutput = this.esmmTFModel.predict(modelInput);
            for (Object key : modelOutput.keySet()) {
                BigDecimal ctcvrBD = new BigDecimal(((Float[])((Map)modelOutput.get(key)).get("ctcvr"))[0].toString());
                BigDecimal ctrBD = new BigDecimal(((Float[])((Map)modelOutput.get(key)).get("ctr"))[0].toString());
                Double cvr = Objects.equals(ctrBD.doubleValue(), 0.0) ? 0.0 : ctcvrBD.divide(ctrBD, 5, RoundingMode.HALF_UP).doubleValue();
                HashMap<String, Double> perSampleMap = new HashMap<String, Double>(5);
                perSampleMap.put("ctr", ctrBD.setScale(5, RoundingMode.HALF_UP).doubleValue());
                perSampleMap.put("cvr", cvr);
                ret.put(key, perSampleMap);
            }
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictESMM error TFModel {}", (Object)this.esmmTFModel, (Object)e);
            return Collections.emptyMap();
        }
    }

    public IModel getCtrModel() {
        return this.ctrModel;
    }

    public IModel getLaunchPvCoder() {
        return this.launchPvCoder;
    }

    public IModel getARPUCoder() {
        return this.ARPUCoder;
    }

    public LocalTFModel getLaunchPvTFModel() {
        return this.launchPvTFModel;
    }

    public LocalTFModel getArpuTFModel() {
        return this.arpuTFModel;
    }

    public AdxLocalTFModel getEsmmTFModel() {
        return this.esmmTFModel;
    }

    public void setCtrModel(IModel ctrModel) {
        this.ctrModel = ctrModel;
    }

    public void setLaunchPvCoder(IModel launchPvCoder) {
        this.launchPvCoder = launchPvCoder;
    }

    public void setARPUCoder(IModel ARPUCoder) {
        this.ARPUCoder = ARPUCoder;
    }

    public void setLaunchPvTFModel(LocalTFModel launchPvTFModel) {
        this.launchPvTFModel = launchPvTFModel;
    }

    public void setArpuTFModel(LocalTFModel arpuTFModel) {
        this.arpuTFModel = arpuTFModel;
    }

    public void setEsmmTFModel(AdxLocalTFModel esmmTFModel) {
        this.esmmTFModel = esmmTFModel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Model)) {
            return false;
        }
        Model other = (Model)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IModel this$ctrModel = this.getCtrModel();
        IModel other$ctrModel = other.getCtrModel();
        if (this$ctrModel == null ? other$ctrModel != null : !this$ctrModel.equals(other$ctrModel)) {
            return false;
        }
        IModel this$launchPvCoder = this.getLaunchPvCoder();
        IModel other$launchPvCoder = other.getLaunchPvCoder();
        if (this$launchPvCoder == null ? other$launchPvCoder != null : !this$launchPvCoder.equals(other$launchPvCoder)) {
            return false;
        }
        IModel this$ARPUCoder = this.getARPUCoder();
        IModel other$ARPUCoder = other.getARPUCoder();
        if (this$ARPUCoder == null ? other$ARPUCoder != null : !this$ARPUCoder.equals(other$ARPUCoder)) {
            return false;
        }
        LocalTFModel this$launchPvTFModel = this.getLaunchPvTFModel();
        LocalTFModel other$launchPvTFModel = other.getLaunchPvTFModel();
        if (this$launchPvTFModel == null ? other$launchPvTFModel != null : !this$launchPvTFModel.equals(other$launchPvTFModel)) {
            return false;
        }
        LocalTFModel this$arpuTFModel = this.getArpuTFModel();
        LocalTFModel other$arpuTFModel = other.getArpuTFModel();
        if (this$arpuTFModel == null ? other$arpuTFModel != null : !this$arpuTFModel.equals(other$arpuTFModel)) {
            return false;
        }
        AdxLocalTFModel this$esmmTFModel = this.getEsmmTFModel();
        AdxLocalTFModel other$esmmTFModel = other.getEsmmTFModel();
        return !(this$esmmTFModel == null ? other$esmmTFModel != null : !this$esmmTFModel.equals(other$esmmTFModel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Model;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IModel $ctrModel = this.getCtrModel();
        result = result * 59 + ($ctrModel == null ? 43 : $ctrModel.hashCode());
        IModel $launchPvCoder = this.getLaunchPvCoder();
        result = result * 59 + ($launchPvCoder == null ? 43 : $launchPvCoder.hashCode());
        IModel $ARPUCoder = this.getARPUCoder();
        result = result * 59 + ($ARPUCoder == null ? 43 : $ARPUCoder.hashCode());
        LocalTFModel $launchPvTFModel = this.getLaunchPvTFModel();
        result = result * 59 + ($launchPvTFModel == null ? 43 : $launchPvTFModel.hashCode());
        LocalTFModel $arpuTFModel = this.getArpuTFModel();
        result = result * 59 + ($arpuTFModel == null ? 43 : $arpuTFModel.hashCode());
        AdxLocalTFModel $esmmTFModel = this.getEsmmTFModel();
        result = result * 59 + ($esmmTFModel == null ? 43 : $esmmTFModel.hashCode());
        return result;
    }

    public String toString() {
        return "Model(ctrModel=" + this.getCtrModel() + ", launchPvCoder=" + this.getLaunchPvCoder() + ", ARPUCoder=" + this.getARPUCoder() + ", launchPvTFModel=" + this.getLaunchPvTFModel() + ", arpuTFModel=" + this.getArpuTFModel() + ", esmmTFModel=" + this.getEsmmTFModel() + ")";
    }
}

