package cn.com.duiba.nezha.alg.alg.advert;

import cn.com.duiba.nezha.alg.alg.correct.IsotonicCalibrator;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;

/**
 * cvr校准
 */
public class CvrCalibrator {

    /**
     * 校准的方法
     * @param adBidParamsDo 跟着每个参竞配置的算法对象
     * @param calibrator 校准所用的模型
     * @param preCvr 预估cvr
     * 并不返回任何值，但是会给adBidParamsDo的一些属性赋值
     */
    public static void calibrate(AdBidParamsDo adBidParamsDo, IsotonicCalibrator calibrator, Double preCvr) {
        if (AssertUtil.isAnyEmpty(adBidParamsDo, calibrator, preCvr)) {
            return;
        }

        Double lowerBound = calibrator.getLowerBound();
        Double upperBound = calibrator.getUpperBound();

        if (AssertUtil.isAnyEmpty(lowerBound, upperBound)) {
            return;
        }

        double rawCaliFactor = calibrator.calibrate(preCvr);
        double caliFactor = MathUtil.stdwithBoundary(rawCaliFactor, lowerBound, upperBound);
        Long fee = adBidParamsDo.getFee();
        Long feeNew = Math.round(fee * caliFactor);

        adBidParamsDo.setFee(feeNew);
        adBidParamsDo.setCaliFee(feeNew);
        adBidParamsDo.setRawCaliFactor(MathUtil.formatDouble(rawCaliFactor, 5));
        adBidParamsDo.setCaliFactor(MathUtil.formatDouble(caliFactor, 5));
        adBidParamsDo.setFactor(MathUtil.formatDouble(caliFactor * adBidParamsDo.getFactor(), 5)); //存储各个乘在出价上的因子
        adBidParamsDo.setCaliDim(calibrator.getDim());
        adBidParamsDo.setCaliTime(calibrator.getUpdateTime());

    }
}
