package cn.com.duiba.nezha.alg.alg.activity;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.DateUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.feature.vo.v2.ContextFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.UserFeatureDoV2;
import cn.com.duiba.nezha.alg.model.DeepModelV2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import org.joda.time.DateTime;

import javax.xml.crypto.Data;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 活动推荐接口，工程系统推荐调用，只和该对象交互
 */
public class ActivityAlg {


    /**
     * 活动推荐接口
     *
     * @param activityRcmdReqList 活动列表
     * @param contextFeatureDoV2  上下文特征
     * @param userFeatureDoV2     用户特征
     * @param deepModelV2         编码器模型
     * @param localTFModelV2      TF预估模型
     * @param activityParams      算法控制参数,广告位
     * @return
     * @throws Exception
     */
    public static ActivityRcmdRet rcmd(List<ActivityRcmdReq> activityRcmdReqList,

                                       ContextFeatureDoV2 contextFeatureDoV2,
                                       UserFeatureDoV2 userFeatureDoV2,
                                       DeepModelV2 deepModelV2,
                                       LocalTFModelV2 localTFModelV2,


                                       ActivityParams activityParams) throws Exception {

        /**
         * 基础信息获取
         */

        Long slotId = contextFeatureDoV2.getSlotId();
        String abTestId = contextFeatureDoV2.getAbTestId();
        Integer rcmdType = contextFeatureDoV2.getRcmdType();


        /**
         * 特征解析
         */
        Map<Long, FeatureMapDo> featureMapDoMap = ActivityRcmder.getFeatureMap(activityRcmdReqList, contextFeatureDoV2, userFeatureDoV2);

        /**
         * 模型预估
         */
        Map<Long, Double> preEcpmMap = ActivityRcmder.predict(featureMapDoMap, deepModelV2, localTFModelV2);


        /**
         * 推荐
         */
        ActivityRcmdRet ret = ActivityRcmder.rcmd(activityRcmdReqList, activityParams, preEcpmMap, slotId);


        if (ret != null) {
            ret.setAbTestId(abTestId);
            ret.setRcmdType(rcmdType);
            ret.setFeatureMap(featureMapDoMap.get(ret.getActivityId()).getFeatureMap());
        }


        return ret;
    }

    public static void main(String[] args) {

        try {
            run();
        }catch (Exception e){
            e.printStackTrace();
        }

    }

    public static void run() throws Exception {

        List<ActivityRcmdReq> activityRcmdReqList = new ArrayList<>();

        for (int i = 0; i < 50; i++) {
            ActivityRcmdReq activityRcmdReq = new ActivityRcmdReq();
            activityRcmdReq.setActivityId(1001L);
        }
        UserFeatureDoV2 userFeatureDoV2 = new UserFeatureDoV2();
        ContextFeatureDoV2 contextFeatureDoV2 = new ContextFeatureDoV2();


        System.out.println("time start="+ LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));

        long d1=System.currentTimeMillis();
        for (int j = 0; j < 1000; j++) {

            ActivityAlg.rcmd(activityRcmdReqList, contextFeatureDoV2, userFeatureDoV2,
                    null,
                    null,
                    null);
        }
        long d2=System.currentTimeMillis();

        System.out.println("time end="+ LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));
        System.out.println("耗时："+(d2-d1)+" ms");
    }

}
