package cn.com.duiba.nezha.alg.alg.activity;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.v2.ActivityFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.feature.vo.v2.ActFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.ContextFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.UserFeatureDoV2;
import cn.com.duiba.nezha.alg.model.DeepModelV2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;


public class ActivityRcmder {
    private static final Logger logger = LoggerFactory.getLogger(ActivityRcmder.class);

    private static String LOG_PRIFIX = "ActivityRcmder";

    private static Random random = new Random();

    /**
     * 活动特征解析
     *
     * @return
     */
    public static Map<Long, FeatureMapDo> getFeatureMap(List<ActivityRcmdReq> activityRcmdReqList,
                                                        ContextFeatureDoV2 contextFeatureDoV2,
                                                        UserFeatureDoV2 userFeatureDoV2) throws Exception {

        Map<Long, FeatureMapDo> featureMap = new HashMap<>();

        //1 非计划特征：静态特征解析
        Map<String, String> staticFeatureMap = ActivityFeatureParse.generateFeatureMapStatic(contextFeatureDoV2, userFeatureDoV2);


        //2 计划特征：动态特征解析
        if (AssertUtil.isEmpty(activityRcmdReqList)) {
            logger.warn(LOG_PRIFIX + ".getFeatureMap activityRcmdReqList is null");
            return featureMap;
        }

        for (ActivityRcmdReq activityRcmdReq : activityRcmdReqList) {

            Long activityId = activityRcmdReq.getActivityId();

            String str = JSON.toJSONString(activityRcmdReq);
            ActFeatureDoV2 actFeatureDoV2 = JSON.parseObject(str, ActFeatureDoV2.class);

            Map<String, String> dynamicFeatureMap = ActivityFeatureParse.generateFeatureMapDynamic(actFeatureDoV2, userFeatureDoV2);

            //3 封装计划特征集合
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMap.put(activityId, featureMapDo);

        }

        return featureMap;


    }

    /**
     * 模型预估
     */
    public static Map<Long, Double> predict(Map<Long, FeatureMapDo> featureMapDoMap,
                                            DeepModelV2 deepModelV2,
                                            LocalTFModelV2 localTFModelV2) throws Exception {

        if (AssertUtil.isAllNotEmpty(deepModelV2, localTFModelV2)) {
            return deepModelV2.predictWithLocalTFV2(featureMapDoMap, localTFModelV2);
        } else {
            return new HashMap<>();
        }
    }


    /**
     * 推荐接口
     *
     * @param activityRcmdReqList
     * @param activityParams
     * @param preEcpmMap
     * @return
     * @throws Exception
     */
    public static ActivityRcmdRet rcmd(List<ActivityRcmdReq> activityRcmdReqList,
                                       ActivityParams activityParams,
                                       Map<Long, Double> preEcpmMap, Long slotId) throws Exception {


        /**
         * 计算排序分
         */
        List<ActivityRcmdRet> activityRcmdRetList = getScore(activityRcmdReqList, activityParams, preEcpmMap, slotId);

        /**
         * 推荐
         */
        ActivityRcmdRet ret = select(activityRcmdRetList);

        return ret;
    }

    /**
     * 计算排序分
     */
    private static ActivityRcmdRet select(List<ActivityRcmdRet> activityRcmdRetList) throws Exception {
        ActivityRcmdRet ret = null;

        if (AssertUtil.isEmpty(activityRcmdRetList)) {
            logger.warn(LOG_PRIFIX + ".rank activityRcmdRetList is Empty,invaild");
            return ret;
        }

        if (Math.random() < 0.9) {
            //90%概率，推荐类型1，score最大胜出
            activityRcmdRetList = activityRcmdRetList.stream()
                    .sorted(Comparator.comparing(ActivityRcmdRet::getScore).reversed())
                    .collect(Collectors.toList());

            ret = activityRcmdRetList.get(0);
            ret.setAlgRcmdType(1);

        } else {
            //10%概率，推荐类型2，按score分权重胜出
            int n = random.nextInt(activityRcmdRetList.size());

            ret = activityRcmdRetList.get(n);
            ret.setAlgRcmdType(2);
        }

        return ret;

    }

    /**
     * 计算排序分
     */
    private static List<ActivityRcmdRet> getScore(List<ActivityRcmdReq> activityRcmdReqList,
                                                  ActivityParams activityParams,
                                                  Map<Long, Double> preEcpmMap, Long slotId) throws Exception {
        List<ActivityRcmdRet> ret = new ArrayList<>();

        if (AssertUtil.isEmpty(activityRcmdReqList)) {
            logger.warn(LOG_PRIFIX + ".getScore  activityRcmdReqList is Empty,invaild");

            return ret;
        }


        for (ActivityRcmdReq activityRcmdReq : activityRcmdReqList) {

            Long activityId = activityRcmdReq.getActivityId();
            String activitySourceType = activityRcmdReq.getActivitySourceType();
//            Long slotId = activityRcmdReq.getSlotId();

            // 1、数据准备
            Double preEcpm = preEcpmMap.get(activityId);
            if (preEcpm == null) {
                preEcpm = 0.0011;
            }


            // 2、计算排序分

            ActivitySubParams activitySubParams = null;
            if (activityParams != null) {
                activitySubParams = activityParams.getFactor(activityId, activitySourceType, slotId);
            }
            Double score = getScore(preEcpm, activitySubParams);


            // 3、结果封装
            ActivityRcmdRet activityRcmdRet = new ActivityRcmdRet();
            activityRcmdRet.setActivityId(activityId);
            activityRcmdRet.setActivitySubParams(activitySubParams);
            activityRcmdRet.setScore(score);

            ret.add(activityRcmdRet);
        }

        return ret;
    }


    /**
     * 计算排序分
     *
     * @param preEcpm
     * @param activitySubParams
     * @return
     */
    private static Double getScore(double preEcpm, ActivitySubParams activitySubParams) {
        double ret = preEcpm;

        /**
         * 1、概率1-p，score=（1-w）* preEcpm + w * statEcpm
         * 2、概率p，score= statEcpm
         */

        if (activitySubParams != null) {
            Double statEcpm = activitySubParams.getEcpm();
            Double statRatio = activitySubParams.getStatRatio();

            Double factor = activitySubParams.getFactor();

            if (statEcpm != null) {


                if (Math.random() > statRatio) {
                    // 概率1-p，score=（1-w）* preEcpm + w * statEcpm
                    ret = preEcpm * 0.7 + statEcpm * 0.3;

                } else {
                    // 概率p，score= statEcpm
                    ret = statEcpm;
                }
            }


            /**
             * 扶持因子
             * 1、新活动、冷启动控制
             * 2、扶持活动【统计表现好、拿量衰减、等】
             */
            ret = ret * factor;
        }

        return ret;
    }

}
