/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxAppReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxBidPrint;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxBidReq;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxBidRet;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.ColdStartFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.EsModel;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.IdeaUnitDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.SlotFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorBaseDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxBid {
    private static final Logger logger = LoggerFactory.getLogger(AdxBid.class);

    public static AdxBidRet bid(AdxBidReq adxBidReq) {
        AdxBidRet ret = new AdxBidRet();
        try {
            if (!AdxBid.valid(adxBidReq)) {
                AdxBid.printBidReq(adxBidReq);
            }
            Integer bidMode = adxBidReq.getBidMode();
            int priceType = Optional.ofNullable(adxBidReq.getPriceType()).orElse(1);
            Integer pmpType = adxBidReq.getPmpType();
            Double pmpPrice = DataUtil.toDouble((Long)adxBidReq.getPmpPrice());
            AdxFactorBaseDo factorBaseDo = Optional.ofNullable(adxBidReq.getAdxFactorBaseDo()).orElse(new AdxFactorBaseDo());
            double factor = factorBaseDo.getFactor();
            Double cpm = factorBaseDo.getCpm();
            cpm = Optional.ofNullable(cpm).orElse(200.0);
            Double preCtr = adxBidReq.getPreCtr();
            Double statCtr = Optional.ofNullable(adxBidReq.getStatCtr()).orElse(factorBaseDo.getStatCtr());
            Double ctr = MathUtil.mean((Double)preCtr, (Double)statCtr, (Double)0.9);
            ctr = Optional.ofNullable(ctr).orElse(0.01);
            Double preLaunchPv = adxBidReq.getPreLaunchPv();
            Double statLaunchPv = Optional.ofNullable(adxBidReq.getStatLaunchPv()).orElse(factorBaseDo.getLaunchPv());
            Double launchPv = MathUtil.mean((Double)preLaunchPv, (Double)statLaunchPv, (Double)0.7);
            launchPv = Optional.ofNullable(launchPv).orElse(0.1);
            Double preArpu = adxBidReq.getPreArpu();
            Double arpuRectifyFactor = Optional.ofNullable(adxBidReq.getArpuRectifyFactor()).orElse(1.0);
            Double preArpu2 = preArpu == null ? null : Double.valueOf(preArpu * arpuRectifyFactor);
            Double arpu = Optional.ofNullable(adxBidReq.getStatArpu()).orElse(factorBaseDo.getArpu());
            Double mixArpu = MathUtil.mean((Double)preArpu2, (Double)arpu, (Double)0.7);
            mixArpu = Optional.ofNullable(mixArpu).orElse(10.0);
            arpu = Optional.ofNullable(arpu).orElse(10.0);
            Double cpc = priceType == 1 ? adxBidReq.getCpc() : adxBidReq.getDirectCpc();
            Double roi = MathUtil.division((Double)adxBidReq.getRoi(), (Long)100L, (int)3);
            Integer expTag = adxBidReq.getAdxExploreDo().getExpTag();
            boolean expSwitch = adxBidReq.getAdxExploreDo().isExpSwitch();
            if (expTag == null) {
                expTag = 99;
            }
            ret.setArpu(arpu);
            ret.setMixArpu(mixArpu);
            ret.setPreArpu(preArpu);
            ret.setCtr(ctr);
            ret.setPreCtr(preCtr);
            ret.setStatCtr(statCtr);
            ret.setLaunchPv(launchPv);
            ret.setPreLaunchPv(preLaunchPv);
            ret.setStatLaunchPv(statLaunchPv);
            ret.setFactor(factor);
            Integer isGiveUp = 0;
            Double price = AdxBid.getPrice(adxBidReq, ret, cpc, roi, factor);
            if (pmpType != null && pmpType == 1) {
                isGiveUp = AdxBid.getPdDecision(price, pmpPrice, adxBidReq.isConfidence());
            }
            if (expTag >= 1 && Math.random() <= 0.005) {
                logger.info("priceExploreExpTag{} ,level{}, price{}, appId{}, slotId{}, priceType{}, bidMode{}", new Object[]{expTag, ret.getLevel(), price, adxBidReq.getAppId(), adxBidReq.getSlotId(), priceType, bidMode});
            }
            price = price == null ? null : Double.valueOf(Math.min(price, 50.0 * cpm));
            Double rankScore = AdxBid.getRankScore(price, adxBidReq.getStatEcpm(), adxBidReq.isConfidence());
            if (pmpType != null && pmpType != 0) {
                price = pmpPrice;
            }
            ret.setAdxAlgoPrice(Math.round(price));
            ret.setIdeaId(adxBidReq.getIdeaId());
            ret.setIdeaUnitId(adxBidReq.getIdeaUnitId());
            ret.setRankScore(rankScore);
            ret.setIsGiveUp(isGiveUp);
        }
        catch (Exception e) {
            logger.error("AdxBid.bid error", (Throwable)e);
        }
        return ret;
    }

    public static AdxBidRet getBid(AdxBidReq adxBidReq) {
        AdxBidRet ret = new AdxBidRet();
        if (!AdxBid.validReq(adxBidReq)) {
            AdxBid.printBidReq(adxBidReq);
            return ret;
        }
        try {
            if (!AdxBid.valid(adxBidReq)) {
                AdxBid.printBidReq(adxBidReq);
            }
            int priceType = Optional.ofNullable(adxBidReq.getPriceType()).orElse(1);
            Integer pmpType = adxBidReq.getPmpType();
            Double pmpPrice = DataUtil.toDouble((Long)adxBidReq.getPmpPrice());
            Integer billType = adxBidReq.getBillType();
            Integer groupTag = adxBidReq.getGroupTag();
            Long groupId = adxBidReq.getGroupId();
            double factor = adxBidReq.getFactor();
            Integer isGiveUp = 0;
            Double preCtr = adxBidReq.getPreCtr();
            Double statCtr = adxBidReq.getStatCtr();
            Double mergeCtr = AdxBid.getMergeRatio(preCtr, statCtr, 0.9, 0.1, 4.0, 0.01);
            Double preLaunchPv = adxBidReq.getPreLaunchPv();
            Double statLaunchPv = adxBidReq.getStatLaunchPv();
            Double mergeLaunchPv = AdxBid.getMerge(preLaunchPv, statLaunchPv, 0.7, 0.8, 1.6, 0.1);
            Double preArpu = adxBidReq.getPreArpu();
            Double statArpu = adxBidReq.getStatArpu();
            Double mergeArpu = AdxBid.getMerge(preArpu, statArpu, 0.7, 0.8, 1.6, 10.0);
            Double preClickPv = adxBidReq.getPreClickPv();
            Double statClickPv = adxBidReq.getStatClickPv();
            Double mergeClickPv = AdxBid.getMergeRatio(preClickPv, statClickPv, 0.8, 0.2, 2.5, 0.03);
            Double preAdCpc = adxBidReq.getPreAdCpc();
            Double statAdCpc = adxBidReq.getStatAdCpc();
            Double mergeAdCpc = AdxBid.getMergeRatio(preAdCpc, statAdCpc, 0.8, 0.2, 2.5, 30.0);
            Double preCvr = adxBidReq.getPreCvr();
            Double preEcpm = AdxBid.getPreEcpm(preCtr, preClickPv, preAdCpc);
            Double preEcpc = AdxBid.getPreEcpc(preClickPv, preAdCpc);
            int preInterval = 0;
            Double launchOrClickPv = mergeClickPv;
            Double arpuOrAdCpc = mergeAdCpc;
            if (groupTag != null && groupTag == 1) {
                mergeCtr = Optional.ofNullable(preCtr).orElse(0.01);
                launchOrClickPv = Optional.ofNullable(preClickPv).orElse(0.03);
                arpuOrAdCpc = Optional.ofNullable(statAdCpc).orElse(30.0);
            }
            if (groupTag != null && groupTag == 2) {
                mergeCtr = Optional.ofNullable(preCtr).orElse(0.01);
                launchOrClickPv = Optional.ofNullable(preClickPv).orElse(0.03);
                arpuOrAdCpc = Optional.ofNullable(statAdCpc).orElse(30.0);
            }
            if (groupTag != null && (groupTag == 4 || groupTag == 7)) {
                mergeCtr = Optional.ofNullable(preCtr).orElse(0.01);
                launchOrClickPv = Optional.ofNullable(preClickPv).orElse(0.03);
                arpuOrAdCpc = Optional.ofNullable(statAdCpc).orElse(30.0);
            }
            if (groupTag != null && (groupTag == 3 || groupTag == 8)) {
                launchOrClickPv = mergeClickPv;
                arpuOrAdCpc = mergeAdCpc;
            }
            double userScore = MathUtil.stdwithBoundary((double)Optional.ofNullable(adxBidReq.getUserScore()).orElse(1.0), (double)0.8, (double)1.5);
            double userScoreV2 = Optional.ofNullable(adxBidReq.getUserScoreV2()).orElse(1.0);
            Map userScoreDefaultMap = Optional.ofNullable(adxBidReq.getUserScoreDefaultMap()).orElse(new HashMap());
            double userScoreDefault = Optional.ofNullable(userScoreDefaultMap.get(groupId)).orElse(1.0);
            userScoreV2 = MathUtil.stdwithBoundary((double)DataUtil.division((Double)userScoreV2, (Double)userScoreDefault, (int)5), (double)0.8, (double)1.2);
            double cvr_factor = Optional.ofNullable(preCvr).orElse(1.0);
            if (groupTag != null && groupTag == 5) {
                factor *= userScore;
            }
            if (groupTag != null && groupTag == 6 && groupId != null && (groupId == 129L || groupId == 183L)) {
                factor *= userScoreV2;
            }
            ret.setCtr(mergeCtr);
            ret.setPreCtr(preCtr);
            ret.setStatCtr(statCtr);
            ret.setLaunchPv(mergeLaunchPv);
            ret.setPreLaunchPv(preLaunchPv);
            ret.setStatLaunchPv(statLaunchPv);
            ret.setMixArpu(mergeArpu);
            ret.setArpu(statArpu);
            ret.setPreArpu(preArpu);
            ret.setFactor(factor);
            ret.setPreClickPv(preClickPv);
            ret.setStatClickPv(statClickPv);
            ret.setMergeClickPv(mergeClickPv);
            ret.setPreAdCpc(preAdCpc);
            ret.setStatAdCpc(statAdCpc);
            ret.setMergeAdCpc(mergeAdCpc);
            ret.setLaunchOrClickPv(launchOrClickPv);
            ret.setArpuOrAdCpc(arpuOrAdCpc);
            ret.setUserScore(userScore);
            ret.setUserScoreV2(userScoreV2);
            ret.setPreEcpm(preEcpm);
            ret.setPreEcpc(preEcpc);
            ret.setPreInterval(preInterval);
            ret.setBidEcpmThreadhold(adxBidReq.getBidEcpmThreadhold());
            ret.setResId(adxBidReq.getResId());
            AdxBidPrint adxBidPrint = new AdxBidPrint();
            adxBidPrint.setTargetRoi(adxBidReq.getRoi());
            adxBidPrint.setEsAbId(adxBidReq.getEsAbId());
            EsModel esModel = adxBidReq.getEsModel();
            if (esModel != null) {
                adxBidPrint.setEsDim(esModel.getDim());
                adxBidPrint.setEsFactor(esModel.getFactor());
                adxBidPrint.setEsUpdateTime(esModel.getUpdateTime());
            }
            ret.setAdxBidPrint(adxBidPrint);
            Double roi = MathUtil.division((Double)adxBidReq.getRoi(), (Long)100L, (int)3);
            double cpmPrice = 0.0;
            double outPrice = 0.0;
            if (pmpType != null && pmpType == 0) {
                if (billType != null && billType == 0) {
                    if (priceType == 0) {
                        cpmPrice = adxBidReq.getPrice() * mergeCtr;
                        outPrice = adxBidReq.getPrice();
                    }
                    if (priceType == 1) {
                        cpmPrice = AdxBid.getRoiPrice(mergeCtr, launchOrClickPv, arpuOrAdCpc, roi, factor);
                        outPrice = launchOrClickPv * arpuOrAdCpc * factor / roi;
                    }
                    if (priceType == 2) {
                        cpmPrice = AdxBid.getDirectPrice(mergeCtr, adxBidReq.getDirectCpc(), roi, factor);
                        outPrice = adxBidReq.getDirectCpc() * factor / roi;
                    }
                    if (priceType == 3) {
                        cpmPrice = adxBidReq.getPrice() * mergeCtr * 1000.0;
                        outPrice = adxBidReq.getPrice();
                    }
                }
                if (billType != null && billType == 1) {
                    if (priceType == 0 || priceType == 3) {
                        outPrice = cpmPrice = adxBidReq.getPrice().doubleValue();
                    }
                    if (priceType == 1) {
                        outPrice = cpmPrice = (adxBidReq.getBidMode() == 1 ? AdxBid.getRoiPricev2(mergeCtr, launchOrClickPv, arpuOrAdCpc, roi, factor, cvr_factor) : AdxBid.getCpcPrice(mergeCtr, adxBidReq.getCpc(), 1.0)).doubleValue();
                    }
                    if (priceType == 2) {
                        outPrice = cpmPrice = AdxBid.getDirectPrice(mergeCtr, adxBidReq.getDirectCpc(), roi, factor).doubleValue();
                    }
                }
                if ((priceType == 0 || priceType == 1) && adxBidReq.getBidEcpmThreadhold() != null) {
                    if (adxBidReq.getBasePrice() != null && adxBidReq.getBasePrice() >= 2000.0) {
                        isGiveUp = 1;
                    }
                    if (preEcpm == null || preEcpm < adxBidReq.getBidEcpmThreadhold()) {
                        isGiveUp = 1;
                    }
                }
            }
            if (pmpType != null && pmpType == 1) {
                if (priceType == 0) {
                    cpmPrice = adxBidReq.getPrice();
                    outPrice = pmpPrice;
                }
                if (priceType == 1) {
                    cpmPrice = AdxBid.getRoiPrice(mergeCtr, launchOrClickPv, arpuOrAdCpc, roi, factor);
                    outPrice = pmpPrice;
                }
                isGiveUp = AdxBid.getPdDecision(cpmPrice, pmpPrice, adxBidReq.isConfidence());
            }
            if (pmpType != null && pmpType == 2) {
                cpmPrice = AdxBid.getEcpm(mergeCtr, launchOrClickPv, arpuOrAdCpc);
                outPrice = pmpPrice;
            }
            Double rankScore = cpmPrice;
            ret.setAdxAlgoPrice(Math.round(outPrice));
            ret.setRankScore(rankScore);
            ret.setIsGiveUp(isGiveUp);
            ret.setExploreType(adxBidReq.getExploreType());
            ret.setBasePrice(adxBidReq.getBasePrice());
            ret.setIdeaId(adxBidReq.getIdeaId());
            ret.setIdeaUnitId(adxBidReq.getIdeaUnitId());
            ret.setIsNew(adxBidReq.getIsNew());
            ret.setIsColdStart(adxBidReq.getIsColdStart());
            ret.setLevel(adxBidReq.getLevel());
            ret.setIsGiveUp(isGiveUp);
        }
        catch (Exception e) {
            logger.error("AdxBid.getBid error", (Throwable)e);
        }
        return ret;
    }

    public static Double getPrice(AdxBidReq adxBidReq, AdxBidRet adxBidRet, Double cpc, Double roi, Double factor) {
        block24: {
            Double arpuOrAdCpc;
            Double launchOrClickPv;
            Double ctr;
            Integer priceType;
            Integer pmpType;
            block22: {
                Double preCvr;
                Integer adxLaunchType;
                Integer billType;
                block23: {
                    pmpType = adxBidReq.getPmpType();
                    billType = adxBidReq.getBillType();
                    priceType = adxBidReq.getPriceType();
                    adxLaunchType = adxBidReq.getAdxLaunchType();
                    Double launchPv = adxBidRet.getLaunchPv();
                    ctr = adxBidRet.getCtr();
                    Double arpu = adxBidRet.getMixArpu();
                    preCvr = adxBidReq.getPreCvr();
                    launchOrClickPv = adxBidRet.getLaunchOrClickPv();
                    arpuOrAdCpc = adxBidRet.getArpuOrAdCpc();
                    if (pmpType == null || pmpType != 0) break block22;
                    if (billType != 0) break block23;
                    switch (priceType) {
                        case 0: {
                            return adxBidReq.getPrice() * ctr;
                        }
                        case 1: {
                            if (Objects.equals(adxLaunchType, 1)) {
                                return ((double)adxBidReq.getCpa().longValue() * preCvr * ctr + adxBidReq.getArpm()) * factor * 1000.0 / roi;
                            }
                            if (Objects.equals(adxLaunchType, 0)) {
                                return AdxBid.getRoiPrice(ctr, launchOrClickPv, arpuOrAdCpc, roi, factor);
                            }
                            break block24;
                        }
                        case 2: {
                            return AdxBid.getDirectPrice(ctr, cpc, roi, factor);
                        }
                        case 3: {
                            return adxBidReq.getPrice() * ctr * 1000.0;
                        }
                    }
                    break block24;
                }
                if (billType == 1) {
                    switch (priceType) {
                        case 0: 
                        case 3: {
                            return adxBidReq.getPrice();
                        }
                        case 1: {
                            if (adxLaunchType != null && adxLaunchType == 1) {
                                return ((double)adxBidReq.getCpa().longValue() * preCvr * ctr + adxBidReq.getArpm()) * factor * 1000.0 / roi;
                            }
                            return adxBidReq.getBidMode() == 1 ? AdxBid.getRoiPrice(ctr, launchOrClickPv, arpuOrAdCpc, roi, factor) : AdxBid.getCpcPrice(ctr, cpc, factor);
                        }
                        case 2: {
                            return AdxBid.getDirectPrice(ctr, cpc, roi, factor);
                        }
                    }
                }
                break block24;
            }
            if (pmpType != null && pmpType == 1) {
                switch (priceType) {
                    case 0: {
                        return adxBidReq.getPrice();
                    }
                    case 1: {
                        return adxBidReq.getBidMode() == 1 ? AdxBid.getRoiPrice(ctr, launchOrClickPv, arpuOrAdCpc, roi, factor) : AdxBid.getCpcPrice(ctr, cpc, factor);
                    }
                }
            } else if (pmpType != null && pmpType == 2) {
                return AdxBid.getEcpm(ctr, launchOrClickPv, arpuOrAdCpc);
            }
        }
        return adxBidReq.getPrice();
    }

    public static List<AdxBidReq> buildAdxBidReq(AdIdeaDo adIdeaDo, AdxFactorBaseDo factorBaseDo, AdxAppReqDo adxAppReqDo) {
        ArrayList<AdxBidReq> adxBidReqs = new ArrayList<AdxBidReq>();
        List<IdeaUnitDo> ideaUnitDos = adIdeaDo.getIdeaUnitDos();
        for (IdeaUnitDo ideaUnitDo : ideaUnitDos) {
            AdxBidReq adxBidReq = new AdxBidReq();
            adxBidReq.setAdxFactorBaseDo(factorBaseDo);
            BeanUtils.copy((Object)adxAppReqDo, (Object)adxBidReq);
            BeanUtils.copy((Object)adIdeaDo, (Object)adxBidReq);
            BeanUtils.copy((Object)ideaUnitDo, (Object)adxBidReq);
            adxBidReq.setArpuRectifyFactor(adxAppReqDo.getArpuRectifyFactor());
            adxBidReq.setPrice(adIdeaDo.getPrice());
            if (adxAppReqDo != null && adxAppReqDo.getPmpType() != null) {
                adxBidReq.setPmpType(adxAppReqDo.getPmpType());
                if (adxAppReqDo.getPmpType() != 0) {
                    adxBidReq.setPrice(DataUtil.toDouble((Long)adxAppReqDo.getPmpPrice()));
                    adxBidReq.setPmpPrice(adxAppReqDo.getPmpPrice());
                }
            }
            if (ideaUnitDo.getAdxStatsDo() != null) {
                AdxStatsDo adxStatsDo = ideaUnitDo.getAdxStatsDo();
                AdxIndexStatDo adxIndexStatDo = adxStatsDo.getLast1DayStat();
                adxBidReq.setStatCtr(AdxIndexStatDo.getStatCtr(adxIndexStatDo));
                adxBidReq.setStatLaunchPv(AdxIndexStatDo.getStatLaunchPv(adxIndexStatDo));
                adxBidReq.setStatArpu(AdxIndexStatDo.getStatArpu(adxIndexStatDo));
                adxBidReq.setStatEcpm(AdxIndexStatDo.getStatEcpm(adxIndexStatDo));
                adxBidReq.setConfidence(AdxIndexStatDo.isCostConfidence(adxIndexStatDo));
            }
            adxBidReqs.add(adxBidReq);
        }
        return adxBidReqs;
    }

    public static AdxBidReq buildAdxBidReq(AdIdeaDo adIdeaDo, AdxFactorDo adxFactorDo, AdxAppReqDo adxAppReqDo) {
        AdxBidReq adxBidReq = new AdxBidReq();
        AdxBid.getFactorDo(adxBidReq, adIdeaDo, adxFactorDo, adxAppReqDo);
        adxBidReq.setPreCtr(adIdeaDo.getPreCtr());
        adxBidReq.setPreLaunchPv(adIdeaDo.getPreLaunchPv());
        adxBidReq.setPreArpu(adIdeaDo.getPreArpu());
        adxBidReq.setPreClickPv(adIdeaDo.getPreClickPv());
        adxBidReq.setPreAdCpc(adIdeaDo.getPreAdCpc());
        adxBidReq.setUserScore(adIdeaDo.getUserScore());
        adxBidReq.setUserScoreV2(adIdeaDo.getUserScoreV2());
        adxBidReq.setResId(adIdeaDo.getResId());
        adxBidReq.setGroupId(adIdeaDo.getGroupId());
        adxBidReq.setIdeaId(adIdeaDo.getIdeaId());
        adxBidReq.setBidMode(adIdeaDo.getBidMode());
        adxBidReq.setRoi(adIdeaDo.getRoi());
        adxBidReq.setCpc(adIdeaDo.getCpc());
        adxBidReq.setDirectCpc(adIdeaDo.getDirectCpc());
        adxBidReq.setPriceType(adIdeaDo.getPriceType());
        adxBidReq.setBillType(adIdeaDo.getBillType());
        adxBidReq.setPrice(adIdeaDo.getPrice());
        adxBidReq.setAdxLaunchType(adIdeaDo.getAdxLaunchType());
        adxBidReq.setFlcAdvertId(adIdeaDo.getFlcAdvertId());
        adxBidReq.setPreCvr(adIdeaDo.getPreCvr());
        adxBidReq.setCpa(adIdeaDo.getCpa());
        if (adxAppReqDo != null) {
            adxBidReq.setAppId(adxAppReqDo.getAppId());
            adxBidReq.setSlotId(adxAppReqDo.getSlotId());
            adxBidReq.setPmpType(adxAppReqDo.getPmpType());
            adxBidReq.setPmpPrice(adxAppReqDo.getPmpPrice());
            adxBidReq.setBasePrice(adxAppReqDo.getBasePrice());
            adxBidReq.setGroupTag(adxAppReqDo.getGroupTag());
            adxBidReq.setArpuRectifyFactor(adxAppReqDo.getArpuRectifyFactor());
            adxBidReq.setBidEcpmThreadhold(adxAppReqDo.getBidEcpmThreadhold());
        }
        AdxStatsDo adxStatsDo = Optional.ofNullable(adIdeaDo.getAdxStatsDo()).orElse(new AdxStatsDo());
        AdxIndexStatDo adIdea2dStat = Optional.ofNullable(adxStatsDo.getLast2DayStat()).orElse(new AdxIndexStatDo());
        if (!AssertUtil.isAnyEmpty((Object[])new Object[]{adIdea2dStat.getAdvertConsume(), adIdea2dStat.getFlcFee()})) {
            long flcConsume = adIdea2dStat.getAdvertConsume() - adIdea2dStat.getFlcFee();
            Double arpc = MathUtil.division((Long)flcConsume, (Long)adIdea2dStat.getClick(), (int)5);
            Double arpm = MathUtil.division((Long)flcConsume, (Long)adIdea2dStat.getExp(), (int)5);
            adxBidReq.setArpc(Optional.ofNullable(arpc).orElse(0.0));
            adxBidReq.setArpm(Optional.ofNullable(arpm).orElse(0.0));
        } else {
            adxBidReq.setArpm(0.0);
            adxBidReq.setArpc(0.0);
        }
        return adxBidReq;
    }

    public static void getFactorDo(AdxBidReq ret, AdIdeaDo adIdeaDo, AdxFactorDo adxFactorDo, AdxAppReqDo adxAppReqDo) {
        double factor = 1.0;
        Integer exploreType = 1;
        AdxFactorBaseDo adFactorBaseDo = Optional.ofNullable(adxFactorDo.getAdFactorBaseDo()).orElse(new AdxFactorBaseDo());
        AdxFactorBaseDo tradeFactorBaseDo = Optional.ofNullable(adxFactorDo.getTradeFactorBaseDo()).orElse(new AdxFactorBaseDo());
        AdxFactorBaseDo appFactorBaseDo = Optional.ofNullable(adxFactorDo.getAppFactorBaseDo()).orElse(new AdxFactorBaseDo());
        factor = adFactorBaseDo.getFactor();
        if (appFactorBaseDo.conf) {
            factor = appFactorBaseDo.getFactor();
        } else if (tradeFactorBaseDo.conf) {
            factor = tradeFactorBaseDo.getFactor();
        }
        SlotFactorDo slotFactorDo = Optional.ofNullable(adxFactorDo.getSlotFactorDo()).orElse(new SlotFactorDo());
        boolean isSlotExplore = slotFactorDo.isExplore();
        double flowRatio = slotFactorDo.getFlowRatio();
        double slotFactor = slotFactorDo.getFactor();
        Boolean isColdStart = adIdeaDo.getIsColdStart();
        ColdStartFactorDo coldStartFactorDo = Optional.ofNullable(adxFactorDo.getColdStartFactorDo()).orElse(new ColdStartFactorDo());
        boolean isAdColdExplore = coldStartFactorDo.isExplore();
        double adColdFactor = coldStartFactorDo.getFactor();
        int level = 0;
        adxAppReqDo = Optional.ofNullable(adxAppReqDo).orElse(new AdxAppReqDo());
        Integer expGroupTag = adxAppReqDo.getExpGroupTag();
        AdxFactorBaseDo adBaseFactorBaseDo = Optional.ofNullable(adxFactorDo.getAdBaseLevelFactorDo()).orElse(new AdxFactorBaseDo());
        AdxFactorBaseDo adExpFactorBaseDo = Optional.ofNullable(adxFactorDo.getAdExpLevelFactorDo()).orElse(new AdxFactorBaseDo());
        AdxFactorBaseDo adConFactorBaseDo = Optional.ofNullable(adxFactorDo.getAdConLevelFactorDo()).orElse(new AdxFactorBaseDo());
        if (expGroupTag != null && expGroupTag.equals(2)) {
            factor = adBaseFactorBaseDo.getFactor();
        } else if (expGroupTag != null && expGroupTag.equals(1)) {
            double expFlowRate = adExpFactorBaseDo.getExpFlowRate();
            double random = Math.random();
            level = random < expFlowRate ? 1 : 2;
            factor = random < expFlowRate ? adExpFactorBaseDo.getFactor() : adConFactorBaseDo.getFactor();
        }
        ret.setEsAbId(adIdeaDo.getEsAbId());
        EsModel esModel = adIdeaDo.getEsModel();
        if (esModel != null) {
            ret.setEsModel(esModel);
            factor = esModel.calcFactor(factor);
        }
        ret.setStatCtr(adFactorBaseDo.getStatCtr());
        ret.setStatLaunchPv(adFactorBaseDo.getLaunchPv());
        ret.setStatArpu(adFactorBaseDo.getArpu());
        ret.setStatEcpm(adFactorBaseDo.getStatEcpm());
        ret.setCpm(adFactorBaseDo.getCpm());
        ret.setStatClickPv(adFactorBaseDo.getStatClickPv());
        ret.setStatAdCpc(adFactorBaseDo.getStatAdCpc());
        if (appFactorBaseDo.dataConf) {
            ret.setStatCtr(appFactorBaseDo.getStatCtr());
            ret.setStatLaunchPv(appFactorBaseDo.getLaunchPv());
            ret.setStatArpu(appFactorBaseDo.getArpu());
            ret.setStatEcpm(appFactorBaseDo.getStatEcpm());
            ret.setCpm(appFactorBaseDo.getCpm());
            ret.setStatClickPv(appFactorBaseDo.getStatClickPv());
            ret.setStatAdCpc(appFactorBaseDo.getStatAdCpc());
        } else if (tradeFactorBaseDo.dataConf) {
            ret.setStatCtr(tradeFactorBaseDo.getStatCtr());
            ret.setStatLaunchPv(tradeFactorBaseDo.getLaunchPv());
            ret.setStatArpu(tradeFactorBaseDo.getArpu());
            ret.setStatEcpm(tradeFactorBaseDo.getStatEcpm());
            ret.setCpm(tradeFactorBaseDo.getCpm());
            ret.setStatClickPv(tradeFactorBaseDo.getStatClickPv());
            ret.setStatAdCpc(tradeFactorBaseDo.getStatAdCpc());
        }
        ret.setFactor(factor);
        ret.setExploreType(exploreType);
        ret.setIsColdStart(isColdStart);
        ret.setLevel(level);
        ret.setUserScoreDefaultMap(adxFactorDo.getUserScoreDefaultMap());
    }

    public static String doubleMap(Map<String, Double> map, double rand) {
        if (AssertUtil.isEmpty(map)) {
            logger.warn("priceExploreExp mapSample param is invalid, params invalid");
            return null;
        }
        double w = 0.0;
        try {
            for (Map.Entry<String, Double> entry : map.entrySet()) {
                if (!(rand <= (w += entry.getValue().doubleValue()))) continue;
                return entry.getKey();
            }
        }
        catch (Exception e) {
            logger.error("priceExploreExp mapSample happened error: ", (Throwable)e);
        }
        return null;
    }

    public static Double getCpcPrice(Double ctr, Double cpc, double factor, Integer expTag, double exploreFactor, boolean expSwitch) {
        if (expTag >= 2 && !expSwitch) {
            return ctr * cpc * exploreFactor * 1000.0 * 100.0;
        }
        return ctr * cpc * factor * 1000.0 * 100.0;
    }

    public static Double getDirectPrice(Double ctr, Double algoCpcPrice, double factor, Double roi, Integer expTag, double exploreFactor, boolean expSwitch) {
        if (expTag >= 2 && !expSwitch) {
            return DataUtil.division((Double)(ctr * algoCpcPrice * exploreFactor * 1000.0), (Double)roi, (int)3);
        }
        return DataUtil.division((Double)(ctr * algoCpcPrice * factor * 1000.0), (Double)roi, (int)3);
    }

    public static Double getRoiPrice(Double ctr, double factor, Double launchPv, Double arpu, Double mixArpu, Double roi, Integer expTag, double exploreFactor, boolean expSwitch, Integer groupTag) {
        if (expTag >= 2 && !expSwitch) {
            if (groupTag == 1) {
                return ctr * launchPv * mixArpu * exploreFactor / roi * 1000.0;
            }
            return ctr * launchPv * arpu * exploreFactor / roi * 1000.0;
        }
        if (groupTag == 1) {
            return ctr * launchPv * mixArpu * factor / roi * 1000.0;
        }
        return ctr * launchPv * arpu * factor / roi * 1000.0;
    }

    public static Double getEcpm(Double ctr, Double launchPv, Double arpu, Double mixArpu, Integer groupTag) {
        if (groupTag == 1) {
            return ctr * launchPv * mixArpu * 1000.0;
        }
        return ctr * launchPv * arpu * 1000.0;
    }

    public static Double getEcpm(Double ctr, Double launchPv, Double arpu) {
        return ctr * launchPv * arpu * 1000.0;
    }

    public static Double getRoiPrice(Double ctr, Double launchPv, Double arpu, Double roi, double factor) {
        return ctr * launchPv * arpu * factor * 1000.0;
    }

    public static Double getRoiPricev2(Double ctr, Double clickPv, Double StatCpc, Double roi, double factor, double cvr_factor) {
        return ctr * clickPv * StatCpc * factor * cvr_factor * 1000.0;
    }

    public static Double getCpcPrice(Double ctr, Double cpc, double factor) {
        return ctr * cpc * factor * 1000.0 * 100.0;
    }

    public static Double getDirectPrice(Double ctr, Double algoCpcPrice, Double roi, double factor) {
        return ctr * algoCpcPrice * factor * 1000.0 / roi;
    }

    public static Double getDirectRoiPrice(Double algoCpcPrice, Double roi, double factor) {
        return algoCpcPrice * factor / roi;
    }

    public static Double getDirectCpcRoiPrice(Double algoCpcPrice, Double ctr, Double roi, double factor) {
        return algoCpcPrice * ctr * factor / roi;
    }

    public static boolean validReq(AdxBidReq adxBidReq) {
        boolean ret = true;
        if (Objects.equals(adxBidReq.getPriceType(), 1) && Objects.equals(adxBidReq.getAdxLaunchType(), 1) && AssertUtil.isAnyEmpty((Object[])new Object[]{adxBidReq.getPreCtr(), adxBidReq.getPreCvr(), adxBidReq.getCpa()})) {
            return false;
        }
        return ret;
    }

    public static boolean valid(AdxBidReq adxBidReq) {
        boolean ret = true;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{adxBidReq, adxBidReq.getPreCtr(), adxBidReq.getPriceType()})) {
            return false;
        }
        if (adxBidReq.getPriceType() == 1) {
            if (adxBidReq.getBidMode() == null) {
                return false;
            }
            ret = adxBidReq.getBidMode() == 1 ? adxBidReq.getRoi() != null : adxBidReq.getCpc() != null;
        } else if (adxBidReq.getPriceType() == 2) {
            boolean bl = ret = adxBidReq.getDirectCpc() != null && adxBidReq.getRoi() != null;
        }
        if (adxBidReq.getPmpType() == 0) {
            if (adxBidReq.getBillType() == 0 && adxBidReq.getPriceType() == 1 && adxBidReq.getAdxLaunchType() == null && adxBidReq.getAdxLaunchType() != 1) {
                return false;
            }
        } else if (adxBidReq.getPmpType() == 1) {
            if (adxBidReq.getBillType() == 0) {
                return false;
            }
            if (adxBidReq.getBillType() == 1 && (adxBidReq.getPriceType() == 2 || adxBidReq.getPriceType() == 3)) {
                return false;
            }
        } else if (adxBidReq.getPmpType() == 2) {
            if (adxBidReq.getBillType() == 0) {
                return false;
            }
            if (adxBidReq.getBillType() == 1 && (adxBidReq.getPriceType() == 1 || adxBidReq.getPriceType() == 2 || adxBidReq.getPriceType() == 3)) {
                return false;
            }
        }
        return ret;
    }

    public static void printBidReq(AdxBidReq adxBidReq) {
        if (Math.random() < 0.001) {
            logger.warn("bidRequestDo2 is not valid, groupId:{}, resourceId:{}, ideaId:{}, appId:{}, priceType:{}, bidMode:{}, preCtr:{}, roi:{}, preLaunchPv:{}, cpc:{}, directCpc:{}, pmpType:{}, billType:{}\uff0ccpa:{}", new Object[]{adxBidReq.getGroupId(), adxBidReq.getResId(), adxBidReq.getIdeaId(), adxBidReq.getAppId(), adxBidReq.getPriceType(), adxBidReq.getBidMode(), adxBidReq.getPreCtr(), adxBidReq.getRoi(), adxBidReq.getPreLaunchPv(), adxBidReq.getCpc(), adxBidReq.getDirectCpc(), adxBidReq.getPmpType(), adxBidReq.getBillType(), adxBidReq.getCpa()});
        }
    }

    public static Double getRankScore(Double price, Double statEcpm, boolean isConfidence) {
        Double rankScore = null;
        if (AssertUtil.isNotEmpty((Object)price)) {
            rankScore = !isConfidence ? price * (1.0 + 2.0 * Math.random()) : price;
        }
        rankScore = MathUtil.mean(rankScore, (Double)statEcpm, (Double)0.7);
        return rankScore;
    }

    public static Double getMixRankScore(Double price, Double statEcpm, boolean isConfidence) {
        Double rankScore = null;
        if (AssertUtil.isNotEmpty((Object)price)) {
            rankScore = !isConfidence ? price * (1.0 + 1.0 * Math.random()) : price;
        }
        rankScore = MathUtil.mean(rankScore, (Double)statEcpm, (Double)0.8);
        return rankScore;
    }

    public static Integer getPdDecision(Double price, Double pmpPrice, boolean isConfidence) {
        double random;
        double p = 0.0;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{price, pmpPrice})) {
            if (price < pmpPrice * 0.5) {
                p = 0.8;
                if (isConfidence) {
                    p = 0.95;
                }
            } else if (price < pmpPrice * 0.7) {
                p = 0.7;
                if (isConfidence) {
                    p = 0.9;
                }
            } else if (price < pmpPrice) {
                p = 0.6;
                if (isConfidence) {
                    p = 0.85;
                }
            }
        }
        return (random = Math.random()) < p ? 1 : 0;
    }

    public static Double getMerge(Double pre, Double stat, double weight, double limitLow, double limitUp, double defaultValue) {
        Double ret = null;
        if (pre != null && stat != null) {
            pre = AdxBid.getLimit(pre, stat, limitLow, limitUp);
            ret = pre * weight + stat * (1.0 - weight);
        } else {
            ret = pre != null ? AdxBid.getLimit(pre, defaultValue, limitLow, limitUp) : stat;
        }
        ret = Optional.ofNullable(ret).orElse(defaultValue);
        return DataUtil.formatDouble((Double)ret, (int)6);
    }

    public static Double getMergeRatio(Double pre, Double stat, double weight, double limitLow, double limitUp, double defaultValue) {
        Double ret = null;
        if (stat == null || stat < 1.0E-6) {
            stat = defaultValue;
        }
        if (pre != null) {
            pre = AdxBid.getLimit(pre, stat, limitLow, limitUp);
            ret = pre * weight + stat * (1.0 - weight);
        }
        if (ret == null) {
            ret = stat;
        }
        return DataUtil.formatDouble((Double)ret, (int)6);
    }

    public static Double getLimit(double value, double base, double limitLow, double limitUp) {
        Double ret = value;
        if (value > base * limitUp) {
            ret = base * limitUp;
        } else if (value < base * limitLow) {
            ret = base * limitLow;
        }
        return DataUtil.formatDouble((Double)ret, (int)6);
    }

    public static Double getPreEcpm(Double ctr, Double clickPv, Double adCpc) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{ctr, clickPv, adCpc})) {
            ret = ctr * clickPv * adCpc;
        }
        return DataUtil.formatDouble(ret, (int)6);
    }

    public static Double getPreEcpc(Double clickPv, Double adCpc) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{clickPv, adCpc})) {
            ret = clickPv * adCpc;
        }
        return DataUtil.formatDouble(ret, (int)6);
    }

    public static void main(String[] args) {
        double ret1 = AdxBid.getMergeRatio(0.1, 0.2, 0.8, 0.2, 3.0, 0.15);
        System.out.println("ret1=" + ret1);
        double ret2 = AdxBid.getMergeRatio(0.4, 0.2, 0.8, 0.2, 3.0, 0.15);
        System.out.println("ret2=" + ret2);
        double ret3 = AdxBid.getMergeRatio(0.4, null, 0.8, 0.2, 3.0, 0.15);
        System.out.println("ret3=" + ret3);
    }
}

