/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.directly;

import cn.com.duiba.nezha.alg.alg.adx.rcmd2.priceExploreLevelEnum;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.ExplorePriceDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeiTuanExplorePrice {
    private static final Logger logger = LoggerFactory.getLogger(MeiTuanExplorePrice.class);

    public static Map<String, Double> updatePriceExploreList(List<ExplorePriceDo> priceExploreDoList, Map<String, Double> lastPriceExploreMap, Double liftFactor, Double realFloorPrice) {
        int profitEnd;
        int profitStart;
        Map<String, Double> consumeResultMap;
        if (lastPriceExploreMap == null) {
            lastPriceExploreMap = new HashMap<String, Double>();
        }
        if (liftFactor == null) {
            liftFactor = 1.0;
        }
        if (realFloorPrice == null) {
            realFloorPrice = 1.0;
        }
        if (AssertUtil.isEmpty(consumeResultMap = MeiTuanExplorePrice.getResultMap(priceExploreDoList, lastPriceExploreMap, liftFactor, realFloorPrice, profitStart = priceExploreLevelEnum.profitLevelStart.getIndex(), profitEnd = priceExploreLevelEnum.profitLevelEnd.getIndex()))) {
            MeiTuanExplorePrice.defaultResultMap(consumeResultMap, profitStart, profitEnd);
        }
        return consumeResultMap;
    }

    public static void defaultResultMap(Map<String, Double> resultMap, int start, int end) {
        for (int i = start; i <= end; ++i) {
            double defaultValue = i == end ? 2.0 : (double)(i + 1) * 0.5;
            resultMap.put(i + "", defaultValue);
        }
    }

    public static Map<String, Double> getResultMap(List<ExplorePriceDo> priceExploreDoList, Map<String, Double> lastPriceExploreMap, Double liftFactor, Double realFloorPrice, int start, int end) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        if (priceExploreDoList.size() != end) {
            logger.info("updatePriceExploreList input data error {}", priceExploreDoList);
            return retMap;
        }
        String bestKey = MeiTuanExplorePrice.getBestKey(priceExploreDoList, liftFactor);
        Map<String, Double> factorMap = MeiTuanExplorePrice.getFactorMap(bestKey, lastPriceExploreMap);
        double bestFactor = factorMap.getOrDefault("bestFactor", 2.0);
        double stepSize = factorMap.getOrDefault("stepSize", 0.5);
        double idx = factorMap.getOrDefault("idx", 0.0);
        for (int level = start; level <= end; ++level) {
            double factor = level == end ? bestFactor : bestFactor + (double)(level - 3) * stepSize;
            retMap.put(level + "", factor);
        }
        retMap.put("idx", idx);
        logger.info("updatePriceExploreList, curPriceMap {}, lastPriceMap{}, priceDoList{}, bestKey{}, liftFactor{}", new Object[]{retMap, lastPriceExploreMap, priceExploreDoList, bestKey, liftFactor});
        return retMap;
    }

    public static String getBestKey(List<ExplorePriceDo> priceExploreDoList, Double liftFactor) {
        double bestEffect = Double.NEGATIVE_INFINITY;
        String bestKey = "-1";
        for (ExplorePriceDo levelDo : priceExploreDoList.subList(0, 4)) {
            if (!AssertUtil.isNotEmpty((Object)levelDo)) continue;
            String key = levelDo.getLevel();
            Double effect = ExplorePriceDo.getEffect(levelDo, liftFactor);
            if (!AssertUtil.isNotEmpty((Object)effect) || !(effect > bestEffect)) continue;
            bestEffect = effect;
            bestKey = key;
        }
        return bestKey;
    }

    public static Map<String, Double> getFactorMap(String bestKey, Map<String, Double> lastPriceExploreMap) {
        double stepSize;
        HashMap<String, Double> tmpMap = new HashMap<String, Double>();
        double upper = 3.0;
        double lower = 1.0;
        double minStepSize = 0.05;
        double bestFactor = MathUtil.stdwithBoundary((double)lastPriceExploreMap.getOrDefault(bestKey, 2.0), (double)lower, (double)upper);
        double oldBase = lastPriceExploreMap.getOrDefault("3", 2.0);
        double idx = lastPriceExploreMap.getOrDefault("idx", 0.0);
        idx = bestFactor == oldBase ? (idx += 1.0) : 0.0;
        if (idx >= 6.0) {
            stepSize = 0.1;
            bestFactor = 1.2;
        } else if (idx >= 4.0) {
            bestFactor = bestFactor >= 2.0 ? 1.4 : bestFactor;
            stepSize = idx * minStepSize;
        } else {
            double stepSizeU = bestFactor - oldBase > 0.0 ? Math.min((upper - bestFactor) / 2.0, 0.5) : Math.min((bestFactor - lower) / 2.0, 0.5);
            stepSize = MathUtil.stdwithBoundary((double)(Math.abs(bestFactor - oldBase) / 1.5), (double)minStepSize, (double)stepSizeU);
        }
        tmpMap.put("bestFactor", bestFactor);
        tmpMap.put("stepSize", stepSize);
        tmpMap.put("idx", idx);
        return tmpMap;
    }
}

