/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.api.model.AdxLocalTFModel;
import cn.com.duiba.nezha.alg.api.model.E2ELocalTFModel;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Model {
    private static final Logger logger = LoggerFactory.getLogger(Model.class);
    private IModel ctrModel;
    private IModel launchPvCoder;
    private IModel ARPUCoder;
    private LocalTFModel launchPvTFModel;
    private LocalTFModel arpuTFModel;
    private AdxLocalTFModel esmmTFModel;
    private AdxLocalTFModel esmmTFModelV2;
    private IModel clickPvCoder;
    private IModel adCpcCoder;
    private LocalTFModelV2 clickPvTFModel;
    private LocalTFModelV2 adCpcTFModel;
    private IModel launchPvCoderV2;
    private LocalTFModelV2 launchPvTFModelV2;
    private IModel ARPUCoderV2;
    private LocalTFModelV2 arpuTFModelV2;
    private E2ELocalTFModel userScoreModel;
    private IModel userScoreCoderV2;
    private LocalTFModelV2 userScoreTFModelV2;
    private IModel adCpcCoderV2;
    private LocalTFModelV2 adCpcTFModelV2;
    private IModel ClickPvCoderV2;
    private LocalTFModelV2 ClickPvTFModelV2;
    private IModel CtrCoderV2;
    private LocalTFModelV2 CtrTFModelV2;
    private E2ELocalTFModel CvrModel;
    private E2ELocalTFModel CpcModel;
    private IModel allBaiduCoderV2;
    private LocalTFModelV2 ctrBaiduTFModelV2;
    private LocalTFModelV2 clickPvBaiduTFModelV2;
    private LocalTFModelV2 adCpcBaiduTFModelV2;

    public <T> Map<T, Double> predictCtr(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map ret = this.ctrModel.predictsNew(featureMap);
            return ret;
        }
        catch (Exception e) {
            logger.error("Model.predictCtr error{} ctrModel{}", (Object)e, (Object)this.ctrModel);
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictLaunchPv(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map ret = this.launchPvCoder.predictWithLocalTFNew(featureMap, this.launchPvTFModel);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictLaunchPv error{}, launchPvCoder{}, launchPvTFModel{}", new Object[]{e, this.launchPvCoder, this.launchPvTFModel});
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictLaunchPvV2(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map ret = this.launchPvCoderV2.predictWithLocalTFV2(featureMap, this.launchPvTFModelV2);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictLaunchPv error{}, launchPvCoder{}, launchPvTFModel{}", new Object[]{e, this.launchPvCoderV2, this.launchPvTFModelV2});
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictARPU(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map ret = this.ARPUCoder.predictWithLocalTFNew(featureMap, this.arpuTFModel);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictARPU error{}, ARPUCoder{}, arpuTFModel{}", new Object[]{e, this.ARPUCoder, this.arpuTFModel});
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictARPUV2(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map ret = this.ARPUCoderV2.predictWithLocalTFV2(featureMap, this.arpuTFModelV2);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictARPU error{}, ARPUCoder{}, arpuTFModel{}", new Object[]{e, this.ARPUCoderV2, this.arpuTFModelV2});
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictClickPv(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map ret = this.clickPvCoder.predictWithLocalTFV2(featureMap, this.clickPvTFModel);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictClickPv error{}, clickPvCoder{}, clickPvTFModel{}", new Object[]{e, this.clickPvCoder, this.clickPvTFModel});
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictAdCpc(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map ret = this.adCpcCoder.predictWithLocalTFV2(featureMap, this.adCpcTFModel);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictAdCpc error{}, adCpcCoder{}, adCpcTFModel{}", new Object[]{e, this.adCpcCoder, this.adCpcTFModel});
            return Collections.emptyMap();
        }
    }

    public <T> Map<String, Map<T, Double>> predictCtrClick(Map<T, FeatureMapDo> featureMap) {
        try {
            HashMap<String, Map<T, Double>> ret = new HashMap<String, Map<T, Double>>();
            HashMap<T, Map> modelInput = new HashMap<T, Map>();
            for (Map.Entry<T, FeatureMapDo> entry : featureMap.entrySet()) {
                modelInput.put(entry.getKey(), entry.getValue().getFeatureMap());
            }
            Map modelOutput = this.esmmTFModel.predict(modelInput);
            for (String key : modelOutput.keySet()) {
                HashMap midRet = new HashMap();
                for (Map.Entry tEntry : ((Map)modelOutput.get(key)).entrySet()) {
                    double v = MathUtil.formatDouble((double)((Float[])tEntry.getValue())[0].doubleValue(), (int)8);
                    midRet.put(tEntry.getKey(), v);
                }
                ret.put(key, midRet);
            }
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictESMM error TFModel {}", (Object)this.esmmTFModel, (Object)e);
            return Collections.emptyMap();
        }
    }

    public <T> Map<String, Map<T, Double>> predictCtrClickV2(Map<T, FeatureMapDo> featureMap) {
        Random random = new Random();
        try {
            if (random.nextInt(1000000) < 1) {
                logger.info("predictCtrClickV2 featuremap: {}", featureMap);
            }
            HashMap<String, Map<T, Double>> ret = new HashMap<String, Map<T, Double>>();
            HashMap<T, Map> modelInput = new HashMap<T, Map>();
            for (Map.Entry<T, FeatureMapDo> entry : featureMap.entrySet()) {
                modelInput.put(entry.getKey(), entry.getValue().getFeatureMap());
            }
            Map modelOutput = this.esmmTFModelV2.predict(modelInput);
            for (String key : modelOutput.keySet()) {
                HashMap midRet = new HashMap();
                for (Map.Entry tEntry : ((Map)modelOutput.get(key)).entrySet()) {
                    double v = MathUtil.formatDouble((double)((Float[])tEntry.getValue())[0].doubleValue(), (int)8);
                    midRet.put(tEntry.getKey(), v);
                }
                ret.put(key, midRet);
            }
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictESMMv2 error featureMap {}", featureMap, (Object)e);
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictCvr(Map<T, FeatureMapDo> featureMap) {
        try {
            HashMap<T, Map> modelInput = new HashMap<T, Map>();
            for (Map.Entry<T, FeatureMapDo> entry : featureMap.entrySet()) {
                modelInput.put(entry.getKey(), entry.getValue().getFeatureMap());
            }
            Map ret = this.CvrModel.predict(modelInput);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictCvr error{}, CvrModel{}", (Object)e, (Object)this.CvrModel);
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictCpc(Map<T, FeatureMapDo> featureMap) {
        try {
            HashMap<T, Map> modelInput = new HashMap<T, Map>();
            for (Map.Entry<T, FeatureMapDo> entry : featureMap.entrySet()) {
                modelInput.put(entry.getKey(), entry.getValue().getFeatureMap());
            }
            Map ret = this.CpcModel.predict(modelInput);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictCpc error{}, CpcModel{}", (Object)e, (Object)this.CpcModel);
            return Collections.emptyMap();
        }
    }

    public static void main(String[] args) throws Exception {
        Model model = new Model();
        AdxLocalTFModel adxLocalTFModel = new AdxLocalTFModel();
        adxLocalTFModel.loadLatestModel("C:\\Users\\aaa\\Desktop\\adx\\model\\test");
        model.setEsmmTFModel(adxLocalTFModel);
        HashMap<String, String> featureMap = new HashMap<String, String>();
        featureMap.put("ft1", "aaa");
        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setDynamicFeatureMap(featureMap);
        featureMapDo.setStaticFeatureMap(new HashMap());
        HashMap<Long, FeatureMapDo> sample = new HashMap<Long, FeatureMapDo>();
        sample.put(123L, featureMapDo);
        sample.put(124L, featureMapDo);
        Map result = model.predictCtrClick(sample);
        System.out.println(result);
    }

    public <T> Map<T, Double> predictUserScore(Map<T, FeatureMapDo> featureMap) {
        try {
            HashMap<T, Map> modelInput = new HashMap<T, Map>();
            for (Map.Entry<T, FeatureMapDo> entry : featureMap.entrySet()) {
                modelInput.put(entry.getKey(), entry.getValue().getFeatureMap());
            }
            Map ret = this.userScoreModel.predict(modelInput);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictUserScore error{}, userScoreModel{}", (Object)e, (Object)this.userScoreModel);
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictUserScoreV2(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map ret = this.userScoreCoderV2.predictWithLocalTFV2(featureMap, this.userScoreTFModelV2);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictUserScoreV2 error{}, userScoreCoderV2{}, userScoreTFModelV2{}", new Object[]{e, this.userScoreCoderV2, this.userScoreTFModelV2});
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictAdCpcV2(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map ret = this.adCpcCoderV2.predictWithLocalTFV2(featureMap, this.adCpcTFModelV2);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictAdCpcV2 error{}, adCpcCoderV2{}, adCpcTFModelV2{}", new Object[]{e, this.adCpcCoderV2, this.adCpcTFModelV2});
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictCtr_V2(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map ret = this.CtrCoderV2.predictWithLocalTFV2(featureMap, this.CtrTFModelV2);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictCtr_V2 error{}, CtrCoderV2{}, CtrTFModelV2{}", new Object[]{e, this.CtrCoderV2, this.CtrTFModelV2});
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictClickPv_V2(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map ret = this.ClickPvCoderV2.predictWithLocalTFV2(featureMap, this.ClickPvTFModelV2);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictClickPv_V2 error{}, ClickPvCoderV2{}, ClickPvTFModelV2{}", new Object[]{e, this.ClickPvCoderV2, this.ClickPvTFModelV2});
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictCtrBaidu(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map ret = this.allBaiduCoderV2.predictWithLocalTFV2(featureMap, this.ctrBaiduTFModelV2);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictCtrBaidu error{}, CtrCoderV2{}, CtrTFModelV2{}", new Object[]{e, this.allBaiduCoderV2, this.ctrBaiduTFModelV2});
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictClickPvBaidu(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map ret = this.allBaiduCoderV2.predictWithLocalTFV2(featureMap, this.clickPvBaiduTFModelV2);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictClickPv_V2 error{}, ClickPvCoderV2{}, ClickPvTFModelV2{}", new Object[]{e, this.allBaiduCoderV2, this.clickPvBaiduTFModelV2});
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictAdCpcBaidu(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map ret = this.allBaiduCoderV2.predictWithLocalTFV2(featureMap, this.adCpcBaiduTFModelV2);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictAdCpcV2 error{}, adCpcCoderV2{}, adCpcTFModelV2{}", new Object[]{e, this.allBaiduCoderV2, this.adCpcBaiduTFModelV2});
            return Collections.emptyMap();
        }
    }

    public IModel getCtrModel() {
        return this.ctrModel;
    }

    public IModel getLaunchPvCoder() {
        return this.launchPvCoder;
    }

    public IModel getARPUCoder() {
        return this.ARPUCoder;
    }

    public LocalTFModel getLaunchPvTFModel() {
        return this.launchPvTFModel;
    }

    public LocalTFModel getArpuTFModel() {
        return this.arpuTFModel;
    }

    public AdxLocalTFModel getEsmmTFModel() {
        return this.esmmTFModel;
    }

    public AdxLocalTFModel getEsmmTFModelV2() {
        return this.esmmTFModelV2;
    }

    public IModel getClickPvCoder() {
        return this.clickPvCoder;
    }

    public IModel getAdCpcCoder() {
        return this.adCpcCoder;
    }

    public LocalTFModelV2 getClickPvTFModel() {
        return this.clickPvTFModel;
    }

    public LocalTFModelV2 getAdCpcTFModel() {
        return this.adCpcTFModel;
    }

    public IModel getLaunchPvCoderV2() {
        return this.launchPvCoderV2;
    }

    public LocalTFModelV2 getLaunchPvTFModelV2() {
        return this.launchPvTFModelV2;
    }

    public IModel getARPUCoderV2() {
        return this.ARPUCoderV2;
    }

    public LocalTFModelV2 getArpuTFModelV2() {
        return this.arpuTFModelV2;
    }

    public E2ELocalTFModel getUserScoreModel() {
        return this.userScoreModel;
    }

    public IModel getUserScoreCoderV2() {
        return this.userScoreCoderV2;
    }

    public LocalTFModelV2 getUserScoreTFModelV2() {
        return this.userScoreTFModelV2;
    }

    public IModel getAdCpcCoderV2() {
        return this.adCpcCoderV2;
    }

    public LocalTFModelV2 getAdCpcTFModelV2() {
        return this.adCpcTFModelV2;
    }

    public IModel getClickPvCoderV2() {
        return this.ClickPvCoderV2;
    }

    public LocalTFModelV2 getClickPvTFModelV2() {
        return this.ClickPvTFModelV2;
    }

    public IModel getCtrCoderV2() {
        return this.CtrCoderV2;
    }

    public LocalTFModelV2 getCtrTFModelV2() {
        return this.CtrTFModelV2;
    }

    public E2ELocalTFModel getCvrModel() {
        return this.CvrModel;
    }

    public E2ELocalTFModel getCpcModel() {
        return this.CpcModel;
    }

    public IModel getAllBaiduCoderV2() {
        return this.allBaiduCoderV2;
    }

    public LocalTFModelV2 getCtrBaiduTFModelV2() {
        return this.ctrBaiduTFModelV2;
    }

    public LocalTFModelV2 getClickPvBaiduTFModelV2() {
        return this.clickPvBaiduTFModelV2;
    }

    public LocalTFModelV2 getAdCpcBaiduTFModelV2() {
        return this.adCpcBaiduTFModelV2;
    }

    public void setCtrModel(IModel ctrModel) {
        this.ctrModel = ctrModel;
    }

    public void setLaunchPvCoder(IModel launchPvCoder) {
        this.launchPvCoder = launchPvCoder;
    }

    public void setARPUCoder(IModel ARPUCoder) {
        this.ARPUCoder = ARPUCoder;
    }

    public void setLaunchPvTFModel(LocalTFModel launchPvTFModel) {
        this.launchPvTFModel = launchPvTFModel;
    }

    public void setArpuTFModel(LocalTFModel arpuTFModel) {
        this.arpuTFModel = arpuTFModel;
    }

    public void setEsmmTFModel(AdxLocalTFModel esmmTFModel) {
        this.esmmTFModel = esmmTFModel;
    }

    public void setEsmmTFModelV2(AdxLocalTFModel esmmTFModelV2) {
        this.esmmTFModelV2 = esmmTFModelV2;
    }

    public void setClickPvCoder(IModel clickPvCoder) {
        this.clickPvCoder = clickPvCoder;
    }

    public void setAdCpcCoder(IModel adCpcCoder) {
        this.adCpcCoder = adCpcCoder;
    }

    public void setClickPvTFModel(LocalTFModelV2 clickPvTFModel) {
        this.clickPvTFModel = clickPvTFModel;
    }

    public void setAdCpcTFModel(LocalTFModelV2 adCpcTFModel) {
        this.adCpcTFModel = adCpcTFModel;
    }

    public void setLaunchPvCoderV2(IModel launchPvCoderV2) {
        this.launchPvCoderV2 = launchPvCoderV2;
    }

    public void setLaunchPvTFModelV2(LocalTFModelV2 launchPvTFModelV2) {
        this.launchPvTFModelV2 = launchPvTFModelV2;
    }

    public void setARPUCoderV2(IModel ARPUCoderV2) {
        this.ARPUCoderV2 = ARPUCoderV2;
    }

    public void setArpuTFModelV2(LocalTFModelV2 arpuTFModelV2) {
        this.arpuTFModelV2 = arpuTFModelV2;
    }

    public void setUserScoreModel(E2ELocalTFModel userScoreModel) {
        this.userScoreModel = userScoreModel;
    }

    public void setUserScoreCoderV2(IModel userScoreCoderV2) {
        this.userScoreCoderV2 = userScoreCoderV2;
    }

    public void setUserScoreTFModelV2(LocalTFModelV2 userScoreTFModelV2) {
        this.userScoreTFModelV2 = userScoreTFModelV2;
    }

    public void setAdCpcCoderV2(IModel adCpcCoderV2) {
        this.adCpcCoderV2 = adCpcCoderV2;
    }

    public void setAdCpcTFModelV2(LocalTFModelV2 adCpcTFModelV2) {
        this.adCpcTFModelV2 = adCpcTFModelV2;
    }

    public void setClickPvCoderV2(IModel ClickPvCoderV2) {
        this.ClickPvCoderV2 = ClickPvCoderV2;
    }

    public void setClickPvTFModelV2(LocalTFModelV2 ClickPvTFModelV2) {
        this.ClickPvTFModelV2 = ClickPvTFModelV2;
    }

    public void setCtrCoderV2(IModel CtrCoderV2) {
        this.CtrCoderV2 = CtrCoderV2;
    }

    public void setCtrTFModelV2(LocalTFModelV2 CtrTFModelV2) {
        this.CtrTFModelV2 = CtrTFModelV2;
    }

    public void setCvrModel(E2ELocalTFModel CvrModel) {
        this.CvrModel = CvrModel;
    }

    public void setCpcModel(E2ELocalTFModel CpcModel) {
        this.CpcModel = CpcModel;
    }

    public void setAllBaiduCoderV2(IModel allBaiduCoderV2) {
        this.allBaiduCoderV2 = allBaiduCoderV2;
    }

    public void setCtrBaiduTFModelV2(LocalTFModelV2 ctrBaiduTFModelV2) {
        this.ctrBaiduTFModelV2 = ctrBaiduTFModelV2;
    }

    public void setClickPvBaiduTFModelV2(LocalTFModelV2 clickPvBaiduTFModelV2) {
        this.clickPvBaiduTFModelV2 = clickPvBaiduTFModelV2;
    }

    public void setAdCpcBaiduTFModelV2(LocalTFModelV2 adCpcBaiduTFModelV2) {
        this.adCpcBaiduTFModelV2 = adCpcBaiduTFModelV2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Model)) {
            return false;
        }
        Model other = (Model)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IModel this$ctrModel = this.getCtrModel();
        IModel other$ctrModel = other.getCtrModel();
        if (this$ctrModel == null ? other$ctrModel != null : !this$ctrModel.equals(other$ctrModel)) {
            return false;
        }
        IModel this$launchPvCoder = this.getLaunchPvCoder();
        IModel other$launchPvCoder = other.getLaunchPvCoder();
        if (this$launchPvCoder == null ? other$launchPvCoder != null : !this$launchPvCoder.equals(other$launchPvCoder)) {
            return false;
        }
        IModel this$ARPUCoder = this.getARPUCoder();
        IModel other$ARPUCoder = other.getARPUCoder();
        if (this$ARPUCoder == null ? other$ARPUCoder != null : !this$ARPUCoder.equals(other$ARPUCoder)) {
            return false;
        }
        LocalTFModel this$launchPvTFModel = this.getLaunchPvTFModel();
        LocalTFModel other$launchPvTFModel = other.getLaunchPvTFModel();
        if (this$launchPvTFModel == null ? other$launchPvTFModel != null : !this$launchPvTFModel.equals(other$launchPvTFModel)) {
            return false;
        }
        LocalTFModel this$arpuTFModel = this.getArpuTFModel();
        LocalTFModel other$arpuTFModel = other.getArpuTFModel();
        if (this$arpuTFModel == null ? other$arpuTFModel != null : !this$arpuTFModel.equals(other$arpuTFModel)) {
            return false;
        }
        AdxLocalTFModel this$esmmTFModel = this.getEsmmTFModel();
        AdxLocalTFModel other$esmmTFModel = other.getEsmmTFModel();
        if (this$esmmTFModel == null ? other$esmmTFModel != null : !this$esmmTFModel.equals(other$esmmTFModel)) {
            return false;
        }
        AdxLocalTFModel this$esmmTFModelV2 = this.getEsmmTFModelV2();
        AdxLocalTFModel other$esmmTFModelV2 = other.getEsmmTFModelV2();
        if (this$esmmTFModelV2 == null ? other$esmmTFModelV2 != null : !this$esmmTFModelV2.equals(other$esmmTFModelV2)) {
            return false;
        }
        IModel this$clickPvCoder = this.getClickPvCoder();
        IModel other$clickPvCoder = other.getClickPvCoder();
        if (this$clickPvCoder == null ? other$clickPvCoder != null : !this$clickPvCoder.equals(other$clickPvCoder)) {
            return false;
        }
        IModel this$adCpcCoder = this.getAdCpcCoder();
        IModel other$adCpcCoder = other.getAdCpcCoder();
        if (this$adCpcCoder == null ? other$adCpcCoder != null : !this$adCpcCoder.equals(other$adCpcCoder)) {
            return false;
        }
        LocalTFModelV2 this$clickPvTFModel = this.getClickPvTFModel();
        LocalTFModelV2 other$clickPvTFModel = other.getClickPvTFModel();
        if (this$clickPvTFModel == null ? other$clickPvTFModel != null : !this$clickPvTFModel.equals(other$clickPvTFModel)) {
            return false;
        }
        LocalTFModelV2 this$adCpcTFModel = this.getAdCpcTFModel();
        LocalTFModelV2 other$adCpcTFModel = other.getAdCpcTFModel();
        if (this$adCpcTFModel == null ? other$adCpcTFModel != null : !this$adCpcTFModel.equals(other$adCpcTFModel)) {
            return false;
        }
        IModel this$launchPvCoderV2 = this.getLaunchPvCoderV2();
        IModel other$launchPvCoderV2 = other.getLaunchPvCoderV2();
        if (this$launchPvCoderV2 == null ? other$launchPvCoderV2 != null : !this$launchPvCoderV2.equals(other$launchPvCoderV2)) {
            return false;
        }
        LocalTFModelV2 this$launchPvTFModelV2 = this.getLaunchPvTFModelV2();
        LocalTFModelV2 other$launchPvTFModelV2 = other.getLaunchPvTFModelV2();
        if (this$launchPvTFModelV2 == null ? other$launchPvTFModelV2 != null : !this$launchPvTFModelV2.equals(other$launchPvTFModelV2)) {
            return false;
        }
        IModel this$ARPUCoderV2 = this.getARPUCoderV2();
        IModel other$ARPUCoderV2 = other.getARPUCoderV2();
        if (this$ARPUCoderV2 == null ? other$ARPUCoderV2 != null : !this$ARPUCoderV2.equals(other$ARPUCoderV2)) {
            return false;
        }
        LocalTFModelV2 this$arpuTFModelV2 = this.getArpuTFModelV2();
        LocalTFModelV2 other$arpuTFModelV2 = other.getArpuTFModelV2();
        if (this$arpuTFModelV2 == null ? other$arpuTFModelV2 != null : !this$arpuTFModelV2.equals(other$arpuTFModelV2)) {
            return false;
        }
        E2ELocalTFModel this$userScoreModel = this.getUserScoreModel();
        E2ELocalTFModel other$userScoreModel = other.getUserScoreModel();
        if (this$userScoreModel == null ? other$userScoreModel != null : !this$userScoreModel.equals(other$userScoreModel)) {
            return false;
        }
        IModel this$userScoreCoderV2 = this.getUserScoreCoderV2();
        IModel other$userScoreCoderV2 = other.getUserScoreCoderV2();
        if (this$userScoreCoderV2 == null ? other$userScoreCoderV2 != null : !this$userScoreCoderV2.equals(other$userScoreCoderV2)) {
            return false;
        }
        LocalTFModelV2 this$userScoreTFModelV2 = this.getUserScoreTFModelV2();
        LocalTFModelV2 other$userScoreTFModelV2 = other.getUserScoreTFModelV2();
        if (this$userScoreTFModelV2 == null ? other$userScoreTFModelV2 != null : !this$userScoreTFModelV2.equals(other$userScoreTFModelV2)) {
            return false;
        }
        IModel this$adCpcCoderV2 = this.getAdCpcCoderV2();
        IModel other$adCpcCoderV2 = other.getAdCpcCoderV2();
        if (this$adCpcCoderV2 == null ? other$adCpcCoderV2 != null : !this$adCpcCoderV2.equals(other$adCpcCoderV2)) {
            return false;
        }
        LocalTFModelV2 this$adCpcTFModelV2 = this.getAdCpcTFModelV2();
        LocalTFModelV2 other$adCpcTFModelV2 = other.getAdCpcTFModelV2();
        if (this$adCpcTFModelV2 == null ? other$adCpcTFModelV2 != null : !this$adCpcTFModelV2.equals(other$adCpcTFModelV2)) {
            return false;
        }
        IModel this$ClickPvCoderV2 = this.getClickPvCoderV2();
        IModel other$ClickPvCoderV2 = other.getClickPvCoderV2();
        if (this$ClickPvCoderV2 == null ? other$ClickPvCoderV2 != null : !this$ClickPvCoderV2.equals(other$ClickPvCoderV2)) {
            return false;
        }
        LocalTFModelV2 this$ClickPvTFModelV2 = this.getClickPvTFModelV2();
        LocalTFModelV2 other$ClickPvTFModelV2 = other.getClickPvTFModelV2();
        if (this$ClickPvTFModelV2 == null ? other$ClickPvTFModelV2 != null : !this$ClickPvTFModelV2.equals(other$ClickPvTFModelV2)) {
            return false;
        }
        IModel this$CtrCoderV2 = this.getCtrCoderV2();
        IModel other$CtrCoderV2 = other.getCtrCoderV2();
        if (this$CtrCoderV2 == null ? other$CtrCoderV2 != null : !this$CtrCoderV2.equals(other$CtrCoderV2)) {
            return false;
        }
        LocalTFModelV2 this$CtrTFModelV2 = this.getCtrTFModelV2();
        LocalTFModelV2 other$CtrTFModelV2 = other.getCtrTFModelV2();
        if (this$CtrTFModelV2 == null ? other$CtrTFModelV2 != null : !this$CtrTFModelV2.equals(other$CtrTFModelV2)) {
            return false;
        }
        E2ELocalTFModel this$CvrModel = this.getCvrModel();
        E2ELocalTFModel other$CvrModel = other.getCvrModel();
        if (this$CvrModel == null ? other$CvrModel != null : !this$CvrModel.equals(other$CvrModel)) {
            return false;
        }
        E2ELocalTFModel this$CpcModel = this.getCpcModel();
        E2ELocalTFModel other$CpcModel = other.getCpcModel();
        if (this$CpcModel == null ? other$CpcModel != null : !this$CpcModel.equals(other$CpcModel)) {
            return false;
        }
        IModel this$allBaiduCoderV2 = this.getAllBaiduCoderV2();
        IModel other$allBaiduCoderV2 = other.getAllBaiduCoderV2();
        if (this$allBaiduCoderV2 == null ? other$allBaiduCoderV2 != null : !this$allBaiduCoderV2.equals(other$allBaiduCoderV2)) {
            return false;
        }
        LocalTFModelV2 this$ctrBaiduTFModelV2 = this.getCtrBaiduTFModelV2();
        LocalTFModelV2 other$ctrBaiduTFModelV2 = other.getCtrBaiduTFModelV2();
        if (this$ctrBaiduTFModelV2 == null ? other$ctrBaiduTFModelV2 != null : !this$ctrBaiduTFModelV2.equals(other$ctrBaiduTFModelV2)) {
            return false;
        }
        LocalTFModelV2 this$clickPvBaiduTFModelV2 = this.getClickPvBaiduTFModelV2();
        LocalTFModelV2 other$clickPvBaiduTFModelV2 = other.getClickPvBaiduTFModelV2();
        if (this$clickPvBaiduTFModelV2 == null ? other$clickPvBaiduTFModelV2 != null : !this$clickPvBaiduTFModelV2.equals(other$clickPvBaiduTFModelV2)) {
            return false;
        }
        LocalTFModelV2 this$adCpcBaiduTFModelV2 = this.getAdCpcBaiduTFModelV2();
        LocalTFModelV2 other$adCpcBaiduTFModelV2 = other.getAdCpcBaiduTFModelV2();
        return !(this$adCpcBaiduTFModelV2 == null ? other$adCpcBaiduTFModelV2 != null : !this$adCpcBaiduTFModelV2.equals(other$adCpcBaiduTFModelV2));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Model;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IModel $ctrModel = this.getCtrModel();
        result = result * 59 + ($ctrModel == null ? 43 : $ctrModel.hashCode());
        IModel $launchPvCoder = this.getLaunchPvCoder();
        result = result * 59 + ($launchPvCoder == null ? 43 : $launchPvCoder.hashCode());
        IModel $ARPUCoder = this.getARPUCoder();
        result = result * 59 + ($ARPUCoder == null ? 43 : $ARPUCoder.hashCode());
        LocalTFModel $launchPvTFModel = this.getLaunchPvTFModel();
        result = result * 59 + ($launchPvTFModel == null ? 43 : $launchPvTFModel.hashCode());
        LocalTFModel $arpuTFModel = this.getArpuTFModel();
        result = result * 59 + ($arpuTFModel == null ? 43 : $arpuTFModel.hashCode());
        AdxLocalTFModel $esmmTFModel = this.getEsmmTFModel();
        result = result * 59 + ($esmmTFModel == null ? 43 : $esmmTFModel.hashCode());
        AdxLocalTFModel $esmmTFModelV2 = this.getEsmmTFModelV2();
        result = result * 59 + ($esmmTFModelV2 == null ? 43 : $esmmTFModelV2.hashCode());
        IModel $clickPvCoder = this.getClickPvCoder();
        result = result * 59 + ($clickPvCoder == null ? 43 : $clickPvCoder.hashCode());
        IModel $adCpcCoder = this.getAdCpcCoder();
        result = result * 59 + ($adCpcCoder == null ? 43 : $adCpcCoder.hashCode());
        LocalTFModelV2 $clickPvTFModel = this.getClickPvTFModel();
        result = result * 59 + ($clickPvTFModel == null ? 43 : $clickPvTFModel.hashCode());
        LocalTFModelV2 $adCpcTFModel = this.getAdCpcTFModel();
        result = result * 59 + ($adCpcTFModel == null ? 43 : $adCpcTFModel.hashCode());
        IModel $launchPvCoderV2 = this.getLaunchPvCoderV2();
        result = result * 59 + ($launchPvCoderV2 == null ? 43 : $launchPvCoderV2.hashCode());
        LocalTFModelV2 $launchPvTFModelV2 = this.getLaunchPvTFModelV2();
        result = result * 59 + ($launchPvTFModelV2 == null ? 43 : $launchPvTFModelV2.hashCode());
        IModel $ARPUCoderV2 = this.getARPUCoderV2();
        result = result * 59 + ($ARPUCoderV2 == null ? 43 : $ARPUCoderV2.hashCode());
        LocalTFModelV2 $arpuTFModelV2 = this.getArpuTFModelV2();
        result = result * 59 + ($arpuTFModelV2 == null ? 43 : $arpuTFModelV2.hashCode());
        E2ELocalTFModel $userScoreModel = this.getUserScoreModel();
        result = result * 59 + ($userScoreModel == null ? 43 : $userScoreModel.hashCode());
        IModel $userScoreCoderV2 = this.getUserScoreCoderV2();
        result = result * 59 + ($userScoreCoderV2 == null ? 43 : $userScoreCoderV2.hashCode());
        LocalTFModelV2 $userScoreTFModelV2 = this.getUserScoreTFModelV2();
        result = result * 59 + ($userScoreTFModelV2 == null ? 43 : $userScoreTFModelV2.hashCode());
        IModel $adCpcCoderV2 = this.getAdCpcCoderV2();
        result = result * 59 + ($adCpcCoderV2 == null ? 43 : $adCpcCoderV2.hashCode());
        LocalTFModelV2 $adCpcTFModelV2 = this.getAdCpcTFModelV2();
        result = result * 59 + ($adCpcTFModelV2 == null ? 43 : $adCpcTFModelV2.hashCode());
        IModel $ClickPvCoderV2 = this.getClickPvCoderV2();
        result = result * 59 + ($ClickPvCoderV2 == null ? 43 : $ClickPvCoderV2.hashCode());
        LocalTFModelV2 $ClickPvTFModelV2 = this.getClickPvTFModelV2();
        result = result * 59 + ($ClickPvTFModelV2 == null ? 43 : $ClickPvTFModelV2.hashCode());
        IModel $CtrCoderV2 = this.getCtrCoderV2();
        result = result * 59 + ($CtrCoderV2 == null ? 43 : $CtrCoderV2.hashCode());
        LocalTFModelV2 $CtrTFModelV2 = this.getCtrTFModelV2();
        result = result * 59 + ($CtrTFModelV2 == null ? 43 : $CtrTFModelV2.hashCode());
        E2ELocalTFModel $CvrModel = this.getCvrModel();
        result = result * 59 + ($CvrModel == null ? 43 : $CvrModel.hashCode());
        E2ELocalTFModel $CpcModel = this.getCpcModel();
        result = result * 59 + ($CpcModel == null ? 43 : $CpcModel.hashCode());
        IModel $allBaiduCoderV2 = this.getAllBaiduCoderV2();
        result = result * 59 + ($allBaiduCoderV2 == null ? 43 : $allBaiduCoderV2.hashCode());
        LocalTFModelV2 $ctrBaiduTFModelV2 = this.getCtrBaiduTFModelV2();
        result = result * 59 + ($ctrBaiduTFModelV2 == null ? 43 : $ctrBaiduTFModelV2.hashCode());
        LocalTFModelV2 $clickPvBaiduTFModelV2 = this.getClickPvBaiduTFModelV2();
        result = result * 59 + ($clickPvBaiduTFModelV2 == null ? 43 : $clickPvBaiduTFModelV2.hashCode());
        LocalTFModelV2 $adCpcBaiduTFModelV2 = this.getAdCpcBaiduTFModelV2();
        result = result * 59 + ($adCpcBaiduTFModelV2 == null ? 43 : $adCpcBaiduTFModelV2.hashCode());
        return result;
    }

    public String toString() {
        return "Model(ctrModel=" + this.getCtrModel() + ", launchPvCoder=" + this.getLaunchPvCoder() + ", ARPUCoder=" + this.getARPUCoder() + ", launchPvTFModel=" + this.getLaunchPvTFModel() + ", arpuTFModel=" + this.getArpuTFModel() + ", esmmTFModel=" + this.getEsmmTFModel() + ", esmmTFModelV2=" + this.getEsmmTFModelV2() + ", clickPvCoder=" + this.getClickPvCoder() + ", adCpcCoder=" + this.getAdCpcCoder() + ", clickPvTFModel=" + this.getClickPvTFModel() + ", adCpcTFModel=" + this.getAdCpcTFModel() + ", launchPvCoderV2=" + this.getLaunchPvCoderV2() + ", launchPvTFModelV2=" + this.getLaunchPvTFModelV2() + ", ARPUCoderV2=" + this.getARPUCoderV2() + ", arpuTFModelV2=" + this.getArpuTFModelV2() + ", userScoreModel=" + this.getUserScoreModel() + ", userScoreCoderV2=" + this.getUserScoreCoderV2() + ", userScoreTFModelV2=" + this.getUserScoreTFModelV2() + ", adCpcCoderV2=" + this.getAdCpcCoderV2() + ", adCpcTFModelV2=" + this.getAdCpcTFModelV2() + ", ClickPvCoderV2=" + this.getClickPvCoderV2() + ", ClickPvTFModelV2=" + this.getClickPvTFModelV2() + ", CtrCoderV2=" + this.getCtrCoderV2() + ", CtrTFModelV2=" + this.getCtrTFModelV2() + ", CvrModel=" + this.getCvrModel() + ", CpcModel=" + this.getCpcModel() + ", allBaiduCoderV2=" + this.getAllBaiduCoderV2() + ", ctrBaiduTFModelV2=" + this.getCtrBaiduTFModelV2() + ", clickPvBaiduTFModelV2=" + this.getClickPvBaiduTFModelV2() + ", adCpcBaiduTFModelV2=" + this.getAdCpcBaiduTFModelV2() + ")";
    }
}

