/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.io.Serializable;

public class AdxIndexStatDo
implements Serializable {
    private static final long serialVersionUID = 4481088624505592801L;
    private Long bid;
    private Long bidSuc;
    private Long exp;
    private Long click;
    private Long adxConsume;
    private Long advertConsume;
    private Long advertLaunch;
    private Long activityRequest;
    private Long activiyJoin;
    private Long advertExposure;
    private Long advertClick;
    private Double preClickValue;
    private Double factor;
    private Long targetFee;
    private Long flcFee;
    private Long flcActClick;
    private Long adxCost;
    private Long adCost;
    private Long adTargetFee;
    private Long adCost2;
    private Long adCost3;
    private Boolean isConfident;
    private Double ctr;
    private Double pvLaunch;
    private Double adArpu;
    private Double avgfactor;
    private Double cpm;
    public Double adEcpm;
    private Double clickValue;
    public Double sucRate;
    public Double sucExpRate;
    public double bias;
    public double actRoi;
    public double actCpc;
    public double actValue;
    public static Long[] cost_bucket = new Long[]{1000L, 2000L, 5000L, 10000L};
    public static double[] rate_bucket = new double[]{1.5, 1.4, 1.2, 1.05};

    public static Double getStatCtr(AdxIndexStatDo adxIndexStatDo) {
        Double ret = null;
        if (adxIndexStatDo != null && adxIndexStatDo.getExp() != null && adxIndexStatDo.getExp() > 100L) {
            ret = DataUtil.division((Long)adxIndexStatDo.getClick(), (Long)adxIndexStatDo.getExp(), (int)3);
        }
        return ret;
    }

    public static Double getStatLaunchPv(AdxIndexStatDo adxIndexStatDo) {
        Double ret = null;
        if (adxIndexStatDo != null && adxIndexStatDo.getClick() != null && adxIndexStatDo.getClick() > 10L) {
            ret = DataUtil.division((Long)adxIndexStatDo.getAdvertLaunch(), (Long)adxIndexStatDo.getClick(), (int)3);
        }
        return ret;
    }

    public static Double getStatEcpm(AdxIndexStatDo adxIndexStatDo) {
        Double ret = null;
        if (adxIndexStatDo != null && adxIndexStatDo.getExp() != null && adxIndexStatDo.getExp() > 1000L && adxIndexStatDo.getAdvertConsume() != null) {
            ret = DataUtil.division((Long)(adxIndexStatDo.getAdvertConsume() * 1000L), (Long)adxIndexStatDo.getExp(), (int)3);
        }
        return ret;
    }

    public static double getCostWeigh(AdxIndexStatDo adxStatBaseDoMin, AdxIndexStatDo adxStatBaseDoDay) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{adxStatBaseDoMin, adxStatBaseDoDay})) {
            ret = MathUtil.division((Double)adxStatBaseDoDay.getAdxConsume3(), (Double)adxStatBaseDoMin.getAdxConsume3(), (int)3);
            ret = MathUtil.log((Double)ret);
        }
        if (ret == null) {
            ret = 1.0;
        }
        ret = MathUtil.stdwithBoundary((double)ret, (double)1.0, (double)10.0);
        return ret;
    }

    public static boolean isCostConfidence(AdxIndexStatDo adxStatBaseDo) {
        boolean ret = false;
        if (adxStatBaseDo != null && adxStatBaseDo.getAdxConsume() != null && adxStatBaseDo.getAdxConsume2() > 3000.0) {
            ret = true;
        }
        return ret;
    }

    public static boolean isImpConfidence(AdxIndexStatDo adxStatBaseDo) {
        boolean ret = false;
        if (adxStatBaseDo != null && adxStatBaseDo.getExp() != null && adxStatBaseDo.getExp() > 1000L) {
            ret = true;
        }
        return ret;
    }

    public static Double getWinRate(AdxIndexStatDo adxStatBaseDo) {
        Double ret = null;
        if (adxStatBaseDo != null) {
            ret = DataUtil.division((Long)adxStatBaseDo.getExp(), (Long)adxStatBaseDo.getBid(), (int)3);
        }
        return ret;
    }

    public static boolean getWinRateStatus(AdxIndexStatDo adxStatBaseDoMin, AdxIndexStatDo adxStatBaseDoDay) {
        Double winRateDay;
        boolean ret = false;
        Double winRate = AdxIndexStatDo.getWinRate(adxStatBaseDoMin);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{winRate, winRateDay = AdxIndexStatDo.getWinRate(adxStatBaseDoDay)}) && winRate < winRateDay * 0.5 && Math.random() < 0.2) {
            ret = true;
        }
        return ret;
    }

    public Double getAdxConsume2() {
        return MathUtil.division((Long)this.adxConsume, (Double)1.0E7, (int)3);
    }

    public Double getAdxConsume3() {
        return MathUtil.division((Long)this.adxConsume, (Double)10000.0, (int)3);
    }

    public static Double getStatArpu(AdxIndexStatDo adxStatBaseDo) {
        Double ret = null;
        if (AdxIndexStatDo.isCostConfidence(adxStatBaseDo)) {
            ret = MathUtil.division((Long)adxStatBaseDo.getAdvertConsume(), (Long)adxStatBaseDo.getAdvertLaunch(), (int)3);
        }
        return ret;
    }

    public static Double getStatCpm(AdxIndexStatDo adxStatBaseDo) {
        Double ret = null;
        if (AdxIndexStatDo.isCostConfidence(adxStatBaseDo)) {
            ret = MathUtil.division((Double)adxStatBaseDo.getAdxConsume3(), (Long)adxStatBaseDo.getExp(), (int)3);
        }
        return ret;
    }

    public static Double getLaunchPv(Double launchPv, AdxIndexStatDo adxStatBaseDo, AdxIndexStatDo statBaseDoDay) {
        Double launchPv1 = AdxIndexStatDo.getStatLaunchPv(adxStatBaseDo);
        Double launchPv2 = AdxIndexStatDo.getStatLaunchPv(statBaseDoDay);
        Double statlaunchPv = MathUtil.mean((Double)launchPv1, (Double)launchPv2, (Double)0.8);
        launchPv = MathUtil.mean((Double)launchPv, (Double)statlaunchPv, (Double)0.8);
        return launchPv;
    }

    public static Double getStatCtr(Double ctr, AdxIndexStatDo adxStatBaseDo, AdxIndexStatDo statBaseDoDay) {
        Double ctr2;
        Double ctr1 = AdxIndexStatDo.getStatCtr(adxStatBaseDo);
        Double statCtr = MathUtil.mean((Double)ctr1, (Double)(ctr2 = AdxIndexStatDo.getStatCtr(statBaseDoDay)), (Double)0.8);
        if ((ctr = MathUtil.mean((Double)ctr, (Double)statCtr, (Double)0.8)) != null) {
            ctr = MathUtil.stdwithBoundary((double)ctr, (double)0.0, (double)0.2);
        }
        return ctr;
    }

    public static Double getStatCpm(Double cpm, AdxIndexStatDo adxStatBaseDo, AdxIndexStatDo statBaseDoDay) {
        Double cpm1 = AdxIndexStatDo.getStatCpm(adxStatBaseDo);
        Double cpm2 = AdxIndexStatDo.getStatCpm(statBaseDoDay);
        Double statCpm = MathUtil.mean((Double)cpm1, (Double)cpm2, (Double)0.8);
        cpm = MathUtil.mean((Double)cpm, (Double)statCpm, (Double)0.2);
        cpm = MathUtil.stdwithBoundary((double)cpm, (double)30.0, (double)3000.0);
        return cpm;
    }

    public static Double getArpu(Double arpu, AdxIndexStatDo adxStatBaseDo, AdxIndexStatDo statBaseDoDay) {
        Double arpu1 = AdxIndexStatDo.getStatArpu(adxStatBaseDo);
        Double arpu2 = AdxIndexStatDo.getStatArpu(statBaseDoDay);
        Double statArpu = MathUtil.mean((Double)arpu1, (Double)arpu2, (Double)0.8);
        arpu = MathUtil.mean((Double)arpu, (Double)statArpu, (Double)0.8);
        return arpu;
    }

    public static Double getStatClickValue(Double clickValue, AdxIndexStatDo adxStatBaseDo, AdxIndexStatDo statBaseDoDay) {
        Double cv1 = AdxIndexStatDo.getStatClickValue(adxStatBaseDo);
        Double cv2 = AdxIndexStatDo.getStatClickValue(statBaseDoDay);
        Double statCv = MathUtil.mean((Double)cv1, (Double)cv2, (Double)0.8);
        clickValue = MathUtil.mean((Double)clickValue, (Double)statCv, (Double)0.8);
        return clickValue;
    }

    public static Double getStatClickValue(AdxIndexStatDo adxStatBaseDo) {
        Double ret = null;
        if (AdxIndexStatDo.isCostConfidence(adxStatBaseDo)) {
            ret = MathUtil.division((Long)adxStatBaseDo.getAdvertConsume(), (Long)adxStatBaseDo.getClick(), (int)3);
        }
        return ret;
    }

    public static Double getCpc(AdxIndexStatDo adxStatBaseDo) {
        Double ret = null;
        if (adxStatBaseDo != null) {
            Long click = adxStatBaseDo.getClick();
            Double adxConsume = adxStatBaseDo.getAdxConsume2();
            if (AdxIndexStatDo.isCostConfidence(adxStatBaseDo)) {
                ret = DataUtil.division((Double)adxConsume, (Long)click, (int)3);
            }
        }
        return ret;
    }

    public static Double getRoi(AdxIndexStatDo adxStatBaseDo) {
        Double ret = null;
        if (adxStatBaseDo != null) {
            Long advertConsume = adxStatBaseDo.getAdvertConsume();
            Double adxConsume = adxStatBaseDo.getAdxConsume2();
            if (AdxIndexStatDo.isCostConfidence(adxStatBaseDo)) {
                ret = DataUtil.division((Double)adxConsume, (Long)advertConsume, (int)3);
            }
        }
        return ret;
    }

    public static Long getAdCost(AdxIndexStatDo adxIndexStatDo) {
        Long ret = 0L;
        if (adxIndexStatDo != null && adxIndexStatDo.getAdvertConsume() != null) {
            ret = adxIndexStatDo.getAdvertConsume();
        }
        return ret;
    }

    public static Long getTargetFee(AdxIndexStatDo adxIndexStatDo) {
        Long ret = 0L;
        if (adxIndexStatDo != null && adxIndexStatDo.getTargetFee() != null) {
            ret = adxIndexStatDo.getTargetFee();
        }
        return ret;
    }

    public static Long getAdCost2(AdxIndexStatDo adxIndexStatDo) {
        Long ret = AdxIndexStatDo.getAdCost(adxIndexStatDo);
        if (AdxIndexStatDo.getTargetFee(adxIndexStatDo) > 0L) {
            ret = Math.max(ret, AdxIndexStatDo.getTargetFee(adxIndexStatDo));
        }
        return ret;
    }

    public static Long getAdCost3(AdxIndexStatDo adxIndexStatDo) {
        Long adcost = AdxIndexStatDo.getAdCost(adxIndexStatDo);
        Long targetfee = AdxIndexStatDo.getTargetFee(adxIndexStatDo);
        Long res = adcost;
        double rate = 0.0;
        if (adcost <= cost_bucket[0]) {
            res = Math.min(adcost, new Double(rate_bucket[0] * (double)targetfee.longValue()).longValue());
            return res;
        }
        if (adcost >= cost_bucket[3]) {
            res = Math.min(adcost, new Double(rate_bucket[3] * (double)targetfee.longValue()).longValue());
            return res;
        }
        for (int i = 1; i < cost_bucket.length; ++i) {
            if (adcost > cost_bucket[i]) continue;
            rate = rate_bucket[i - 1] - 1.0 * (double)(adcost - cost_bucket[i - 1]) / (double)(cost_bucket[i] - cost_bucket[i - 1]) * (rate_bucket[i - 1] - rate_bucket[i]);
            res = Math.min(adcost, new Double(rate * (double)targetfee.longValue()).longValue());
            break;
        }
        return res;
    }

    public static Long getAdxCost(AdxIndexStatDo adxIndexStatDo) {
        Long ret = 0L;
        if (adxIndexStatDo != null && adxIndexStatDo.getAdxConsume() != null) {
            ret = DataUtil.double2Long((Double)adxIndexStatDo.getAdxConsume2());
        }
        return ret;
    }

    public static Long getBidCnt(AdxIndexStatDo adxIndexStatDo) {
        Long ret = 0L;
        if (adxIndexStatDo != null && adxIndexStatDo.getBid() != null) {
            ret = adxIndexStatDo.getBid();
        }
        return ret;
    }

    public static Long getBidSucCnt(AdxIndexStatDo adxIndexStatDo) {
        Long ret = 0L;
        if (adxIndexStatDo != null && adxIndexStatDo.getBidSuc() != null) {
            ret = adxIndexStatDo.getBidSuc();
        }
        return ret;
    }

    public static Long getExpCnt(AdxIndexStatDo adxIndexStatDo) {
        Long ret = 0L;
        if (adxIndexStatDo != null && adxIndexStatDo.getExp() != null) {
            ret = adxIndexStatDo.getExp();
        }
        return ret;
    }

    public static Long getClickCnt(AdxIndexStatDo adxIndexStatDo) {
        Long ret = 0L;
        if (adxIndexStatDo != null && adxIndexStatDo.getClick() != null) {
            ret = adxIndexStatDo.getClick();
        }
        return ret;
    }

    public static Long getLaunchCnt(AdxIndexStatDo adxIndexStatDo) {
        Long ret = 0L;
        if (adxIndexStatDo != null && adxIndexStatDo.getAdvertLaunch() != null) {
            ret = adxIndexStatDo.getAdvertLaunch();
        }
        return ret;
    }

    public static Long getAdClickCnt(AdxIndexStatDo adxIndexStatDo) {
        Long ret = 0L;
        if (adxIndexStatDo != null && adxIndexStatDo.getAdvertClick() != null) {
            ret = adxIndexStatDo.getAdvertClick();
        }
        return ret;
    }

    public static Long getCostLoss(AdxIndexStatDo adxIndexStatDo) {
        return AdxIndexStatDo.getAdCost(adxIndexStatDo) - AdxIndexStatDo.getAdxCost(adxIndexStatDo);
    }

    public static Double getEcpm(AdxIndexStatDo adxIndexStatDo) {
        Double ret = 0.0;
        if (adxIndexStatDo != null && adxIndexStatDo.getExp() != null && adxIndexStatDo.getAdvertConsume() != null) {
            ret = DataUtil.division((Long)(adxIndexStatDo.getAdvertConsume() * 1000L), (Long)(adxIndexStatDo.getExp() + 10L), (int)3);
        }
        return ret;
    }

    public String getString() {
        return "{adxCost=" + this.adxCost + ",adCost=" + this.adCost + ",adCost2=" + this.adCost2 + ",adCost3=" + this.adCost3 + ",adFee=" + this.adTargetFee + ",actRoi=" + this.actRoi + ",actCpc=" + this.actCpc + ",actValue=" + this.actValue + ",bias=" + this.bias + ",bid=" + this.bid + ",bidSuc=" + this.bidSuc + ",exp=" + this.exp + ",click=" + this.click + ",launch=" + this.advertLaunch + ",adClick=" + this.advertClick + ",avgFactor=" + this.avgfactor + ",conf=" + this.isConfident + ",suc=" + this.sucRate + ",sucExp=" + this.sucExpRate + ",adEcpm=" + this.adEcpm + "}";
    }

    public Long getBid() {
        return this.bid;
    }

    public Long getBidSuc() {
        return this.bidSuc;
    }

    public Long getExp() {
        return this.exp;
    }

    public Long getClick() {
        return this.click;
    }

    public Long getAdxConsume() {
        return this.adxConsume;
    }

    public Long getAdvertConsume() {
        return this.advertConsume;
    }

    public Long getAdvertLaunch() {
        return this.advertLaunch;
    }

    public Long getActivityRequest() {
        return this.activityRequest;
    }

    public Long getActiviyJoin() {
        return this.activiyJoin;
    }

    public Long getAdvertExposure() {
        return this.advertExposure;
    }

    public Long getAdvertClick() {
        return this.advertClick;
    }

    public Double getPreClickValue() {
        return this.preClickValue;
    }

    public Double getFactor() {
        return this.factor;
    }

    public Long getTargetFee() {
        return this.targetFee;
    }

    public Long getFlcFee() {
        return this.flcFee;
    }

    public Long getFlcActClick() {
        return this.flcActClick;
    }

    public Long getAdxCost() {
        return this.adxCost;
    }

    public Long getAdCost() {
        return this.adCost;
    }

    public Long getAdTargetFee() {
        return this.adTargetFee;
    }

    public Long getAdCost2() {
        return this.adCost2;
    }

    public Long getAdCost3() {
        return this.adCost3;
    }

    public Boolean getIsConfident() {
        return this.isConfident;
    }

    public Double getCtr() {
        return this.ctr;
    }

    public Double getPvLaunch() {
        return this.pvLaunch;
    }

    public Double getAdArpu() {
        return this.adArpu;
    }

    public Double getAvgfactor() {
        return this.avgfactor;
    }

    public Double getCpm() {
        return this.cpm;
    }

    public Double getAdEcpm() {
        return this.adEcpm;
    }

    public Double getClickValue() {
        return this.clickValue;
    }

    public Double getSucRate() {
        return this.sucRate;
    }

    public Double getSucExpRate() {
        return this.sucExpRate;
    }

    public double getBias() {
        return this.bias;
    }

    public double getActRoi() {
        return this.actRoi;
    }

    public double getActCpc() {
        return this.actCpc;
    }

    public double getActValue() {
        return this.actValue;
    }

    public void setBid(Long bid) {
        this.bid = bid;
    }

    public void setBidSuc(Long bidSuc) {
        this.bidSuc = bidSuc;
    }

    public void setExp(Long exp) {
        this.exp = exp;
    }

    public void setClick(Long click) {
        this.click = click;
    }

    public void setAdxConsume(Long adxConsume) {
        this.adxConsume = adxConsume;
    }

    public void setAdvertConsume(Long advertConsume) {
        this.advertConsume = advertConsume;
    }

    public void setAdvertLaunch(Long advertLaunch) {
        this.advertLaunch = advertLaunch;
    }

    public void setActivityRequest(Long activityRequest) {
        this.activityRequest = activityRequest;
    }

    public void setActiviyJoin(Long activiyJoin) {
        this.activiyJoin = activiyJoin;
    }

    public void setAdvertExposure(Long advertExposure) {
        this.advertExposure = advertExposure;
    }

    public void setAdvertClick(Long advertClick) {
        this.advertClick = advertClick;
    }

    public void setPreClickValue(Double preClickValue) {
        this.preClickValue = preClickValue;
    }

    public void setFactor(Double factor) {
        this.factor = factor;
    }

    public void setTargetFee(Long targetFee) {
        this.targetFee = targetFee;
    }

    public void setFlcFee(Long flcFee) {
        this.flcFee = flcFee;
    }

    public void setFlcActClick(Long flcActClick) {
        this.flcActClick = flcActClick;
    }

    public void setAdxCost(Long adxCost) {
        this.adxCost = adxCost;
    }

    public void setAdCost(Long adCost) {
        this.adCost = adCost;
    }

    public void setAdTargetFee(Long adTargetFee) {
        this.adTargetFee = adTargetFee;
    }

    public void setAdCost2(Long adCost2) {
        this.adCost2 = adCost2;
    }

    public void setAdCost3(Long adCost3) {
        this.adCost3 = adCost3;
    }

    public void setIsConfident(Boolean isConfident) {
        this.isConfident = isConfident;
    }

    public void setCtr(Double ctr) {
        this.ctr = ctr;
    }

    public void setPvLaunch(Double pvLaunch) {
        this.pvLaunch = pvLaunch;
    }

    public void setAdArpu(Double adArpu) {
        this.adArpu = adArpu;
    }

    public void setAvgfactor(Double avgfactor) {
        this.avgfactor = avgfactor;
    }

    public void setCpm(Double cpm) {
        this.cpm = cpm;
    }

    public void setAdEcpm(Double adEcpm) {
        this.adEcpm = adEcpm;
    }

    public void setClickValue(Double clickValue) {
        this.clickValue = clickValue;
    }

    public void setSucRate(Double sucRate) {
        this.sucRate = sucRate;
    }

    public void setSucExpRate(Double sucExpRate) {
        this.sucExpRate = sucExpRate;
    }

    public void setBias(double bias) {
        this.bias = bias;
    }

    public void setActRoi(double actRoi) {
        this.actRoi = actRoi;
    }

    public void setActCpc(double actCpc) {
        this.actCpc = actCpc;
    }

    public void setActValue(double actValue) {
        this.actValue = actValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdxIndexStatDo)) {
            return false;
        }
        AdxIndexStatDo other = (AdxIndexStatDo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$bid = this.getBid();
        Long other$bid = other.getBid();
        if (this$bid == null ? other$bid != null : !((Object)this$bid).equals(other$bid)) {
            return false;
        }
        Long this$bidSuc = this.getBidSuc();
        Long other$bidSuc = other.getBidSuc();
        if (this$bidSuc == null ? other$bidSuc != null : !((Object)this$bidSuc).equals(other$bidSuc)) {
            return false;
        }
        Long this$exp = this.getExp();
        Long other$exp = other.getExp();
        if (this$exp == null ? other$exp != null : !((Object)this$exp).equals(other$exp)) {
            return false;
        }
        Long this$click = this.getClick();
        Long other$click = other.getClick();
        if (this$click == null ? other$click != null : !((Object)this$click).equals(other$click)) {
            return false;
        }
        Long this$adxConsume = this.getAdxConsume();
        Long other$adxConsume = other.getAdxConsume();
        if (this$adxConsume == null ? other$adxConsume != null : !((Object)this$adxConsume).equals(other$adxConsume)) {
            return false;
        }
        Long this$advertConsume = this.getAdvertConsume();
        Long other$advertConsume = other.getAdvertConsume();
        if (this$advertConsume == null ? other$advertConsume != null : !((Object)this$advertConsume).equals(other$advertConsume)) {
            return false;
        }
        Long this$advertLaunch = this.getAdvertLaunch();
        Long other$advertLaunch = other.getAdvertLaunch();
        if (this$advertLaunch == null ? other$advertLaunch != null : !((Object)this$advertLaunch).equals(other$advertLaunch)) {
            return false;
        }
        Long this$activityRequest = this.getActivityRequest();
        Long other$activityRequest = other.getActivityRequest();
        if (this$activityRequest == null ? other$activityRequest != null : !((Object)this$activityRequest).equals(other$activityRequest)) {
            return false;
        }
        Long this$activiyJoin = this.getActiviyJoin();
        Long other$activiyJoin = other.getActiviyJoin();
        if (this$activiyJoin == null ? other$activiyJoin != null : !((Object)this$activiyJoin).equals(other$activiyJoin)) {
            return false;
        }
        Long this$advertExposure = this.getAdvertExposure();
        Long other$advertExposure = other.getAdvertExposure();
        if (this$advertExposure == null ? other$advertExposure != null : !((Object)this$advertExposure).equals(other$advertExposure)) {
            return false;
        }
        Long this$advertClick = this.getAdvertClick();
        Long other$advertClick = other.getAdvertClick();
        if (this$advertClick == null ? other$advertClick != null : !((Object)this$advertClick).equals(other$advertClick)) {
            return false;
        }
        Double this$preClickValue = this.getPreClickValue();
        Double other$preClickValue = other.getPreClickValue();
        if (this$preClickValue == null ? other$preClickValue != null : !((Object)this$preClickValue).equals(other$preClickValue)) {
            return false;
        }
        Double this$factor = this.getFactor();
        Double other$factor = other.getFactor();
        if (this$factor == null ? other$factor != null : !((Object)this$factor).equals(other$factor)) {
            return false;
        }
        Long this$targetFee = this.getTargetFee();
        Long other$targetFee = other.getTargetFee();
        if (this$targetFee == null ? other$targetFee != null : !((Object)this$targetFee).equals(other$targetFee)) {
            return false;
        }
        Long this$flcFee = this.getFlcFee();
        Long other$flcFee = other.getFlcFee();
        if (this$flcFee == null ? other$flcFee != null : !((Object)this$flcFee).equals(other$flcFee)) {
            return false;
        }
        Long this$flcActClick = this.getFlcActClick();
        Long other$flcActClick = other.getFlcActClick();
        if (this$flcActClick == null ? other$flcActClick != null : !((Object)this$flcActClick).equals(other$flcActClick)) {
            return false;
        }
        Long this$adxCost = this.getAdxCost();
        Long other$adxCost = other.getAdxCost();
        if (this$adxCost == null ? other$adxCost != null : !((Object)this$adxCost).equals(other$adxCost)) {
            return false;
        }
        Long this$adCost = this.getAdCost();
        Long other$adCost = other.getAdCost();
        if (this$adCost == null ? other$adCost != null : !((Object)this$adCost).equals(other$adCost)) {
            return false;
        }
        Long this$adTargetFee = this.getAdTargetFee();
        Long other$adTargetFee = other.getAdTargetFee();
        if (this$adTargetFee == null ? other$adTargetFee != null : !((Object)this$adTargetFee).equals(other$adTargetFee)) {
            return false;
        }
        Long this$adCost2 = this.getAdCost2();
        Long other$adCost2 = other.getAdCost2();
        if (this$adCost2 == null ? other$adCost2 != null : !((Object)this$adCost2).equals(other$adCost2)) {
            return false;
        }
        Long this$adCost3 = this.getAdCost3();
        Long other$adCost3 = other.getAdCost3();
        if (this$adCost3 == null ? other$adCost3 != null : !((Object)this$adCost3).equals(other$adCost3)) {
            return false;
        }
        Boolean this$isConfident = this.getIsConfident();
        Boolean other$isConfident = other.getIsConfident();
        if (this$isConfident == null ? other$isConfident != null : !((Object)this$isConfident).equals(other$isConfident)) {
            return false;
        }
        Double this$ctr = this.getCtr();
        Double other$ctr = other.getCtr();
        if (this$ctr == null ? other$ctr != null : !((Object)this$ctr).equals(other$ctr)) {
            return false;
        }
        Double this$pvLaunch = this.getPvLaunch();
        Double other$pvLaunch = other.getPvLaunch();
        if (this$pvLaunch == null ? other$pvLaunch != null : !((Object)this$pvLaunch).equals(other$pvLaunch)) {
            return false;
        }
        Double this$adArpu = this.getAdArpu();
        Double other$adArpu = other.getAdArpu();
        if (this$adArpu == null ? other$adArpu != null : !((Object)this$adArpu).equals(other$adArpu)) {
            return false;
        }
        Double this$avgfactor = this.getAvgfactor();
        Double other$avgfactor = other.getAvgfactor();
        if (this$avgfactor == null ? other$avgfactor != null : !((Object)this$avgfactor).equals(other$avgfactor)) {
            return false;
        }
        Double this$cpm = this.getCpm();
        Double other$cpm = other.getCpm();
        if (this$cpm == null ? other$cpm != null : !((Object)this$cpm).equals(other$cpm)) {
            return false;
        }
        Double this$adEcpm = this.getAdEcpm();
        Double other$adEcpm = other.getAdEcpm();
        if (this$adEcpm == null ? other$adEcpm != null : !((Object)this$adEcpm).equals(other$adEcpm)) {
            return false;
        }
        Double this$clickValue = this.getClickValue();
        Double other$clickValue = other.getClickValue();
        if (this$clickValue == null ? other$clickValue != null : !((Object)this$clickValue).equals(other$clickValue)) {
            return false;
        }
        Double this$sucRate = this.getSucRate();
        Double other$sucRate = other.getSucRate();
        if (this$sucRate == null ? other$sucRate != null : !((Object)this$sucRate).equals(other$sucRate)) {
            return false;
        }
        Double this$sucExpRate = this.getSucExpRate();
        Double other$sucExpRate = other.getSucExpRate();
        if (this$sucExpRate == null ? other$sucExpRate != null : !((Object)this$sucExpRate).equals(other$sucExpRate)) {
            return false;
        }
        if (Double.compare(this.getBias(), other.getBias()) != 0) {
            return false;
        }
        if (Double.compare(this.getActRoi(), other.getActRoi()) != 0) {
            return false;
        }
        if (Double.compare(this.getActCpc(), other.getActCpc()) != 0) {
            return false;
        }
        return Double.compare(this.getActValue(), other.getActValue()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdxIndexStatDo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $bid = this.getBid();
        result = result * 59 + ($bid == null ? 43 : ((Object)$bid).hashCode());
        Long $bidSuc = this.getBidSuc();
        result = result * 59 + ($bidSuc == null ? 43 : ((Object)$bidSuc).hashCode());
        Long $exp = this.getExp();
        result = result * 59 + ($exp == null ? 43 : ((Object)$exp).hashCode());
        Long $click = this.getClick();
        result = result * 59 + ($click == null ? 43 : ((Object)$click).hashCode());
        Long $adxConsume = this.getAdxConsume();
        result = result * 59 + ($adxConsume == null ? 43 : ((Object)$adxConsume).hashCode());
        Long $advertConsume = this.getAdvertConsume();
        result = result * 59 + ($advertConsume == null ? 43 : ((Object)$advertConsume).hashCode());
        Long $advertLaunch = this.getAdvertLaunch();
        result = result * 59 + ($advertLaunch == null ? 43 : ((Object)$advertLaunch).hashCode());
        Long $activityRequest = this.getActivityRequest();
        result = result * 59 + ($activityRequest == null ? 43 : ((Object)$activityRequest).hashCode());
        Long $activiyJoin = this.getActiviyJoin();
        result = result * 59 + ($activiyJoin == null ? 43 : ((Object)$activiyJoin).hashCode());
        Long $advertExposure = this.getAdvertExposure();
        result = result * 59 + ($advertExposure == null ? 43 : ((Object)$advertExposure).hashCode());
        Long $advertClick = this.getAdvertClick();
        result = result * 59 + ($advertClick == null ? 43 : ((Object)$advertClick).hashCode());
        Double $preClickValue = this.getPreClickValue();
        result = result * 59 + ($preClickValue == null ? 43 : ((Object)$preClickValue).hashCode());
        Double $factor = this.getFactor();
        result = result * 59 + ($factor == null ? 43 : ((Object)$factor).hashCode());
        Long $targetFee = this.getTargetFee();
        result = result * 59 + ($targetFee == null ? 43 : ((Object)$targetFee).hashCode());
        Long $flcFee = this.getFlcFee();
        result = result * 59 + ($flcFee == null ? 43 : ((Object)$flcFee).hashCode());
        Long $flcActClick = this.getFlcActClick();
        result = result * 59 + ($flcActClick == null ? 43 : ((Object)$flcActClick).hashCode());
        Long $adxCost = this.getAdxCost();
        result = result * 59 + ($adxCost == null ? 43 : ((Object)$adxCost).hashCode());
        Long $adCost = this.getAdCost();
        result = result * 59 + ($adCost == null ? 43 : ((Object)$adCost).hashCode());
        Long $adTargetFee = this.getAdTargetFee();
        result = result * 59 + ($adTargetFee == null ? 43 : ((Object)$adTargetFee).hashCode());
        Long $adCost2 = this.getAdCost2();
        result = result * 59 + ($adCost2 == null ? 43 : ((Object)$adCost2).hashCode());
        Long $adCost3 = this.getAdCost3();
        result = result * 59 + ($adCost3 == null ? 43 : ((Object)$adCost3).hashCode());
        Boolean $isConfident = this.getIsConfident();
        result = result * 59 + ($isConfident == null ? 43 : ((Object)$isConfident).hashCode());
        Double $ctr = this.getCtr();
        result = result * 59 + ($ctr == null ? 43 : ((Object)$ctr).hashCode());
        Double $pvLaunch = this.getPvLaunch();
        result = result * 59 + ($pvLaunch == null ? 43 : ((Object)$pvLaunch).hashCode());
        Double $adArpu = this.getAdArpu();
        result = result * 59 + ($adArpu == null ? 43 : ((Object)$adArpu).hashCode());
        Double $avgfactor = this.getAvgfactor();
        result = result * 59 + ($avgfactor == null ? 43 : ((Object)$avgfactor).hashCode());
        Double $cpm = this.getCpm();
        result = result * 59 + ($cpm == null ? 43 : ((Object)$cpm).hashCode());
        Double $adEcpm = this.getAdEcpm();
        result = result * 59 + ($adEcpm == null ? 43 : ((Object)$adEcpm).hashCode());
        Double $clickValue = this.getClickValue();
        result = result * 59 + ($clickValue == null ? 43 : ((Object)$clickValue).hashCode());
        Double $sucRate = this.getSucRate();
        result = result * 59 + ($sucRate == null ? 43 : ((Object)$sucRate).hashCode());
        Double $sucExpRate = this.getSucExpRate();
        result = result * 59 + ($sucExpRate == null ? 43 : ((Object)$sucExpRate).hashCode());
        long $bias = Double.doubleToLongBits(this.getBias());
        result = result * 59 + (int)($bias >>> 32 ^ $bias);
        long $actRoi = Double.doubleToLongBits(this.getActRoi());
        result = result * 59 + (int)($actRoi >>> 32 ^ $actRoi);
        long $actCpc = Double.doubleToLongBits(this.getActCpc());
        result = result * 59 + (int)($actCpc >>> 32 ^ $actCpc);
        long $actValue = Double.doubleToLongBits(this.getActValue());
        result = result * 59 + (int)($actValue >>> 32 ^ $actValue);
        return result;
    }

    public String toString() {
        return "AdxIndexStatDo(bid=" + this.getBid() + ", bidSuc=" + this.getBidSuc() + ", exp=" + this.getExp() + ", click=" + this.getClick() + ", adxConsume=" + this.getAdxConsume() + ", advertConsume=" + this.getAdvertConsume() + ", advertLaunch=" + this.getAdvertLaunch() + ", activityRequest=" + this.getActivityRequest() + ", activiyJoin=" + this.getActiviyJoin() + ", advertExposure=" + this.getAdvertExposure() + ", advertClick=" + this.getAdvertClick() + ", preClickValue=" + this.getPreClickValue() + ", factor=" + this.getFactor() + ", targetFee=" + this.getTargetFee() + ", flcFee=" + this.getFlcFee() + ", flcActClick=" + this.getFlcActClick() + ", adxCost=" + this.getAdxCost() + ", adCost=" + this.getAdCost() + ", adTargetFee=" + this.getAdTargetFee() + ", adCost2=" + this.getAdCost2() + ", adCost3=" + this.getAdCost3() + ", isConfident=" + this.getIsConfident() + ", ctr=" + this.getCtr() + ", pvLaunch=" + this.getPvLaunch() + ", adArpu=" + this.getAdArpu() + ", avgfactor=" + this.getAvgfactor() + ", cpm=" + this.getCpm() + ", adEcpm=" + this.getAdEcpm() + ", clickValue=" + this.getClickValue() + ", sucRate=" + this.getSucRate() + ", sucExpRate=" + this.getSucExpRate() + ", bias=" + this.getBias() + ", actRoi=" + this.getActRoi() + ", actCpc=" + this.getActCpc() + ", actValue=" + this.getActValue() + ")";
    }
}

