/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.landpage;

import cn.com.duiba.nezha.alg.alg.landpage.LandpageParams;
import cn.com.duiba.nezha.alg.alg.landpage.LandpageRcmdReq;
import cn.com.duiba.nezha.alg.alg.landpage.LandpageRcmdRet;
import cn.com.duiba.nezha.alg.alg.landpage.LandpageRcmder;
import cn.com.duiba.nezha.alg.alg.landpage.LandpgModel;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidResultDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.DeepModelV2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class LandpageAlg {
    public static AdBidResultDo rcmd(List<LandpageRcmdReq> landpageRcmdReqList, AdBidResultDo Top1Advert, LandpgModel landpgmodel, LandpageParams landpageParams, LandpageParams allParams) throws Exception {
        FeatureMapDo featuremap = Top1Advert.getFeaturemap();
        String appPkgTrade2 = null;
        if (featuremap.getStaticFeatureMap() != null) {
            appPkgTrade2 = (String)featuremap.getStaticFeatureMap().get("ft300111");
        }
        Long slotId = Top1Advert.getSlotId();
        DeepModelV2 deepModelV2 = landpgmodel.getDeepModelV2();
        LocalTFModelV2 localTFModelV2 = landpgmodel.getLocalTFModelV2();
        HashMap<Long, FeatureMapDo> featureMapDoMap = new HashMap<Long, FeatureMapDo>();
        Map<Long, Double> preEcpmMap = null;
        for (LandpageRcmdReq landpgreq : landpageRcmdReqList) {
            Long landpgid = landpgreq.getLandpageId();
            Long frontpageid = landpgreq.getFrontpageId();
            Long paypageid = landpgreq.getPaypageId();
            Long formpageid = landpgreq.getFormpageId();
            Long modelid = landpgreq.getModelId();
            FeatureMapDo featuremapdo = new FeatureMapDo();
            HashMap<String, String> dynamicfeaturemap = new HashMap<String, String>(featuremap.getDynamicFeatureMap());
            dynamicfeaturemap.put("ft200301", Optional.ofNullable(landpgid).map(Object::toString).orElse(""));
            dynamicfeaturemap.put("ft200302", Optional.ofNullable(frontpageid).map(Object::toString).orElse(""));
            dynamicfeaturemap.put("ft200303", Optional.ofNullable(paypageid).map(Object::toString).orElse(""));
            dynamicfeaturemap.put("ft200304", Optional.ofNullable(formpageid).map(Object::toString).orElse(""));
            dynamicfeaturemap.put("ft200305", Optional.ofNullable(modelid).map(Object::toString).orElse(""));
            featuremapdo.setDynamicFeatureMap(dynamicfeaturemap);
            featuremapdo.setStaticFeatureMap(featuremap.getStaticFeatureMap());
            featureMapDoMap.put(landpgid, featuremapdo);
        }
        preEcpmMap = LandpageRcmder.predict(featureMapDoMap, deepModelV2, localTFModelV2);
        AdBidResultDo ret = LandpageRcmder.rcmd(landpageRcmdReqList, landpageParams, allParams, preEcpmMap, Top1Advert, appPkgTrade2, featureMapDoMap);
        return ret;
    }

    public static void main(String[] args) {
        try {
            LandpageAlg.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void run() throws Exception {
        ArrayList<LandpageRcmdReq> landpageRcmdReqList = new ArrayList<LandpageRcmdReq>();
        for (int i = 1; i < 10; ++i) {
            LandpageRcmdReq landpageRcmdReq = new LandpageRcmdReq();
            landpageRcmdReq.setLandpageId(100L + (long)i);
            landpageRcmdReq.setFrontpageId(null);
            landpageRcmdReq.setPaypageId(10000L + (long)i);
            landpageRcmdReq.setFormpageId(100000L + (long)i);
            landpageRcmdReq.setModelId(200L + (long)i);
            landpageRcmdReqList.add(landpageRcmdReq);
        }
        FeatureMapDo f3 = new FeatureMapDo();
        HashMap<String, String> dyn3 = new HashMap<String, String>();
        HashMap<String, String> sta3 = new HashMap<String, String>();
        sta3.put("langpageid", "33333L");
        sta3.put("ft00009", "1");
        dyn3.put("ft00010", "2");
        dyn3.put("frontpage_id", "32333L");
        f3.setDynamicFeatureMap(dyn3);
        f3.setStaticFeatureMap(sta3);
        AdBidResultDo top1 = new AdBidResultDo();
        top1.setFeaturemap(f3);
        top1.setAdvertId(12345L);
        top1.setSlotId(2345L);
        System.out.println("time start=" + LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));
        long d1 = System.currentTimeMillis();
        for (int j = 0; j < 1000; ++j) {
            LandpageAlg.rcmd(landpageRcmdReqList, top1, null, null, null);
        }
        long d2 = System.currentTimeMillis();
        System.out.println("time end=" + LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));
        System.out.println("\u8017\u65f6\uff1a" + (d2 - d1) + " ms");
    }

    public static void run3() throws Exception {
        List<LandpageRcmdRet> landpageRcmdRetList = new ArrayList<LandpageRcmdRet>();
        LandpageRcmdRet r1 = new LandpageRcmdRet();
        r1.setLandpageId(1L);
        r1.setScore(1.0);
        landpageRcmdRetList.add(r1);
        LandpageRcmdRet r2 = new LandpageRcmdRet();
        r2.setLandpageId(0L);
        r2.setScore(2.0);
        landpageRcmdRetList.add(r2);
        landpageRcmdRetList = landpageRcmdRetList.stream().sorted(Comparator.comparing(LandpageRcmdRet::getScore).reversed()).collect(Collectors.toList());
        System.out.println("activityRcmdRetList=" + JSON.toJSONString(landpageRcmdRetList));
    }
}

