/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsModel {
    private static final Logger log = LoggerFactory.getLogger(EsModel.class);
    private static final String redisKeyPrefix = "NZ_XuXu";
    private static final double lowerBound = 0.01;
    private static final double upperBound = 100.0;
    private String dim;
    private String redisKey;
    private String updateTime;
    private double factor;

    public static String getModelRedisKey(Long ideaId, Long abId) {
        String ideaIdStr = ideaId == null ? "" : ideaId.toString();
        String abIdStr = abId == null ? "" : abId.toString();
        return "NZ_XuXu_" + ideaIdStr + "_" + abIdStr;
    }

    public double calcFactor(double lastFactor) {
        if (this.factor > 0.01 && this.factor < 100.0) {
            return this.factor;
        }
        log.error("The model which redis key is " + this.redisKey + " has illegal factor. ");
        return 1.0;
    }

    public String getDim() {
        return this.dim;
    }

    public String getRedisKey() {
        return this.redisKey;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public double getFactor() {
        return this.factor;
    }

    public void setDim(String dim) {
        this.dim = dim;
    }

    public void setRedisKey(String redisKey) {
        this.redisKey = redisKey;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public void setFactor(double factor) {
        this.factor = factor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EsModel)) {
            return false;
        }
        EsModel other = (EsModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$dim = this.getDim();
        String other$dim = other.getDim();
        if (this$dim == null ? other$dim != null : !this$dim.equals(other$dim)) {
            return false;
        }
        String this$redisKey = this.getRedisKey();
        String other$redisKey = other.getRedisKey();
        if (this$redisKey == null ? other$redisKey != null : !this$redisKey.equals(other$redisKey)) {
            return false;
        }
        String this$updateTime = this.getUpdateTime();
        String other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime)) {
            return false;
        }
        return Double.compare(this.getFactor(), other.getFactor()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof EsModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dim = this.getDim();
        result = result * 59 + ($dim == null ? 43 : $dim.hashCode());
        String $redisKey = this.getRedisKey();
        result = result * 59 + ($redisKey == null ? 43 : $redisKey.hashCode());
        String $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : $updateTime.hashCode());
        long $factor = Double.doubleToLongBits(this.getFactor());
        result = result * 59 + (int)($factor >>> 32 ^ $factor);
        return result;
    }

    public String toString() {
        return "EsModel(dim=" + this.getDim() + ", redisKey=" + this.getRedisKey() + ", updateTime=" + this.getUpdateTime() + ", factor=" + this.getFactor() + ")";
    }
}

